<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSystemID
     * Meta information extracted from the WSDL
     * - documentation: Return a string containing the system identifier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSystemID $parameters
     * @return \StructType\GetSystemIDResponse|bool
     */
    public function GetSystemID(\StructType\GetSystemID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSystemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentPageCountRange
     * Meta information extracted from the WSDL
     * - documentation: Returns the minimum and maximum number of pages for a given document type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDocumentPageCountRange $parameters
     * @return \StructType\GetDocumentPageCountRangeResponse|bool
     */
    public function GetDocumentPageCountRange(\StructType\GetDocumentPageCountRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentPageCountRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryInserts
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's available inserts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryInserts $parameters
     * @return \StructType\GetLibraryInsertsResponse|bool
     */
    public function GetLibraryInserts(\StructType\GetLibraryInserts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryInserts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCostCentres
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the cost centres defined for this user/customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCostCentres $parameters
     * @return \StructType\GetCostCentresResponse|bool
     */
    public function GetCostCentres(\StructType\GetCostCentres $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCostCentres($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExcludedAddresses
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of your excluded address which are currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExcludedAddresses $parameters
     * @return \StructType\GetExcludedAddressesResponse|bool
     */
    public function GetExcludedAddresses(\StructType\GetExcludedAddresses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExcludedAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailPacks
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to get a list of available MailPacks. The list is returned as a pipe-delimited string with the newest MailPacks first.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailPacks $parameters
     * @return \StructType\GetMailPacksResponse|bool
     */
    public function GetMailPacks(\StructType\GetMailPacks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailPacks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryMailPacks
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of available MailPacks. An array of MailPack objects is returned with the newest MailPacks first.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryMailPacks $parameters
     * @return \StructType\GetLibraryMailPacksResponse|bool
     */
    public function GetLibraryMailPacks(\StructType\GetLibraryMailPacks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryMailPacks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryPostcards
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's postcards that have been uploaded via the portal or the CreatePostcard API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryPostcards $parameters
     * @return \StructType\GetLibraryPostcardsResponse|bool
     */
    public function GetLibraryPostcards(\StructType\GetLibraryPostcards $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryPostcards($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryLetterheads
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's letterheads that have been uploaded via the portal or the CreateLetterhead API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryLetterheads $parameters
     * @return \StructType\GetLibraryLetterheadsResponse|bool
     */
    public function GetLibraryLetterheads(\StructType\GetLibraryLetterheads $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryLetterheads($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryAttachments
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's attachments that have been uploaded via the portal or the CreateAttachment API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryAttachments $parameters
     * @return \StructType\GetLibraryAttachmentsResponse|bool
     */
    public function GetLibraryAttachments(\StructType\GetLibraryAttachments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryAttachments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryMappings
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's address list mappings that have been uploaded via the portal or the various GenerateMapping API methods.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryMappings $parameters
     * @return \StructType\GetLibraryMappingsResponse|bool
     */
    public function GetLibraryMappings(\StructType\GetLibraryMappings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataListUrl
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve the URL of a specified data list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataListUrl $parameters
     * @return \StructType\GetDataListUrlResponse|bool
     */
    public function GetDataListUrl(\StructType\GetDataListUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataListUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataLists
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's data lists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataLists $parameters
     * @return \StructType\GetDataListsResponse|bool
     */
    public function GetDataLists(\StructType\GetDataLists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserVariables
     * Meta information extracted from the WSDL
     * - documentation: This method returns a list of variables, similar to the functionality of the Merge Fields page within the Portal. The variable name and value are returned.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserVariables $parameters
     * @return \StructType\GetUserVariablesResponse|bool
     */
    public function GetUserVariables(\StructType\GetUserVariables $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserVariables($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentation
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of documentation urls such as the letter guidance template. A description and url is returned for each url.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDocumentation $parameters
     * @return \StructType\GetDocumentationResponse|bool
     */
    public function GetDocumentation(\StructType\GetDocumentation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailHistoryJobs
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of jobs. The method returns similar data to the Mail History page within the Portal.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailHistoryJobs $parameters
     * @return \StructType\GetMailHistoryJobsResponse|bool
     */
    public function GetMailHistoryJobs(\StructType\GetMailHistoryJobs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailHistoryJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailHistoryDocumentsByJobId
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of documents for a particular job. The method returns similar data to the page that is displayed within the Portal when you click on a particular job and it lists the documents.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailHistoryDocumentsByJobId $parameters
     * @return \StructType\GetMailHistoryDocumentsByJobIdResponse|bool
     */
    public function GetMailHistoryDocumentsByJobId(\StructType\GetMailHistoryDocumentsByJobId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailHistoryDocumentsByJobId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddressesForPostcode
     * Meta information extracted from the WSDL
     * - documentation: Return a list of addresses belonging to the specified postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressesForPostcode $parameters
     * @return \StructType\GetAddressesForPostcodeResponse|bool
     */
    public function GetAddressesForPostcode(\StructType\GetAddressesForPostcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAddressesForPostcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentStickerArea
     * Meta information extracted from the WSDL
     * - documentation: Get the dimensions of the address sticker in pixels. Can be used for letters or postcards.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDocumentStickerArea $parameters
     * @return \StructType\GetDocumentStickerAreaResponse|bool
     */
    public function GetDocumentStickerArea(\StructType\GetDocumentStickerArea $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentStickerArea($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentReservedAreas
     * Meta information extracted from the WSDL
     * - documentation: Get the reserved areas for a particular document type. Can be used for letters or postcards.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDocumentReservedAreas $parameters
     * @return \StructType\GetDocumentReservedAreasResponse|bool
     */
    public function GetDocumentReservedAreas(\StructType\GetDocumentReservedAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentReservedAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserDetails
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get Baisc User Deta, User Pricing and VatRate.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserDetails $parameters
     * @return \StructType\GetUserDetailsResponse|bool
     */
    public function GetUserDetails(\StructType\GetUserDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLatestVersionDetails
     * Meta information extracted from the WSDL
     * - documentation: Gets the latest version of a specifed client application.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLatestVersionDetails $parameters
     * @return \StructType\GetLatestVersionDetailsResponse|bool
     */
    public function GetLatestVersionDetails(\StructType\GetLatestVersionDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLatestVersionDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountUrl
     * Meta information extracted from the WSDL
     * - documentation: Gets a url to the users account page in the portal.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountUrl $parameters
     * @return \StructType\GetAccountUrlResponse|bool
     */
    public function GetAccountUrl(\StructType\GetAccountUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPortalUrl
     * Meta information extracted from the WSDL
     * - documentation: Gets a url to the specified portal page.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPortalUrl $parameters
     * @return \StructType\GetPortalUrlResponse|bool
     */
    public function GetPortalUrl(\StructType\GetPortalUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPortalUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBalance
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve your account balance. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. Your account balance
     * is returned in the AccountBalance parameter. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBalance $parameters
     * @return \StructType\GetBalanceResponse|bool
     */
    public function GetBalance(\StructType\GetBalance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableFunds
     * Meta information extracted from the WSDL
     * - documentation: Use this method to determine the available funds on your account, including any possible credit limit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableFunds $parameters
     * @return \StructType\GetAvailableFundsResponse|bool
     */
    public function GetAvailableFunds(\StructType\GetAvailableFunds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableFunds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a letter using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The LetterID text you supply will be identify your letter. This method returns
     * True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The returnLetter returns a CustomerAPILetter object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLetterByID $parameters
     * @return \StructType\GetLetterByIDResponse|bool
     */
    public function GetLetterByID(\StructType\GetLetterByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetters
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a letter list. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The SearchDocumentName text you supply will be used to find your letter by its uploaded title. The
     * SearchDocumentName can be a partial string, in which case the first matching letter is returned. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The
     * returnLetters returns an arrayList of CustomerAPILetter objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLetters $parameters
     * @return \StructType\GetLettersResponse|bool
     */
    public function GetLetters(\StructType\GetLetters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryLetters
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's letters that have been uploaded via the portal or the CreateLetter API method. Letters uploaded via the UploadDocument or UploadConsolidatedPDF API methods are not supported.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryLetters $parameters
     * @return \StructType\GetLibraryLettersResponse|bool
     */
    public function GetLibraryLetters(\StructType\GetLibraryLetters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryLetters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingLists
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of mailing lists. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The SearchMailingListTitle text you supply will be used to find your mailing list by its
     * uploaded title. The SearchMailingListTitle can be a partial string, in which case the first matching mailing list is returned. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the
     * event of a failure. The returnMailinglists returns an ArrayList of CustomerAPIMailingList objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailingLists $parameters
     * @return \StructType\GetMailingListsResponse|bool
     */
    public function GetMailingLists(\StructType\GetMailingLists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailingLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingListByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a mailing list using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The MailingListID you supply will be used to locate your mailing list. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The returnMailinglist returns a CustomerAPIMailingList object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailingListByID $parameters
     * @return \StructType\GetMailingListByIDResponse|bool
     */
    public function GetMailingListByID(\StructType\GetMailingListByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailingListByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterStatusByLetterID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to check the status of a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by an ID must belong to you. This method returns True if successful
     * or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLetterStatusByLetterID $parameters
     * @return \StructType\GetLetterStatusByLetterIDResponse|bool
     */
    public function GetLetterStatusByLetterID(\StructType\GetLetterStatusByLetterID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterStatusByLetterID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterStatusByCustomerAPILetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to check the status of a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by a CustomerAPILetter object must belong to you. This method
     * returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLetterStatusByCustomerAPILetter $parameters
     * @return \StructType\GetLetterStatusByCustomerAPILetterResponse|bool
     */
    public function GetLetterStatusByCustomerAPILetter(\StructType\GetLetterStatusByCustomerAPILetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterStatusByCustomerAPILetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPriceBands
     * Meta information extracted from the WSDL
     * - documentation: Use this method to return a delimited string containing the details of all price bands associated with your GUID. You must supply a valid GUID to use this method. This method returns True if successful or False if a problem occured.
     * The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPriceBands $parameters
     * @return \StructType\GetPriceBandsResponse|bool
     */
    public function GetPriceBands(\StructType\GetPriceBands $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPriceBands($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountries
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of all of the countries and their associated IDs. You need an ID to pass into the CreateAccount or AddUserToAccount methods if you wish to specify a non-UK address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCountries $parameters
     * @return \StructType\GetCountriesResponse|bool
     */
    public function GetCountries(\StructType\GetCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessage
     * Meta information extracted from the WSDL
     * - documentation: Get the return message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMessage $parameters
     * @return \StructType\GetMessageResponse|bool
     */
    public function GetMessage(\StructType\GetMessage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountUrlResponse|\StructType\GetAddressesForPostcodeResponse|\StructType\GetAvailableFundsResponse|\StructType\GetBalanceResponse|\StructType\GetCostCentresResponse|\StructType\GetCountriesResponse|\StructType\GetDataListsResponse|\StructType\GetDataListUrlResponse|\StructType\GetDocumentationResponse|\StructType\GetDocumentPageCountRangeResponse|\StructType\GetDocumentReservedAreasResponse|\StructType\GetDocumentStickerAreaResponse|\StructType\GetExcludedAddressesResponse|\StructType\GetLatestVersionDetailsResponse|\StructType\GetLetterByIDResponse|\StructType\GetLettersResponse|\StructType\GetLetterStatusByCustomerAPILetterResponse|\StructType\GetLetterStatusByLetterIDResponse|\StructType\GetLibraryAttachmentsResponse|\StructType\GetLibraryInsertsResponse|\StructType\GetLibraryLetterheadsResponse|\StructType\GetLibraryLettersResponse|\StructType\GetLibraryMailPacksResponse|\StructType\GetLibraryMappingsResponse|\StructType\GetLibraryPostcardsResponse|\StructType\GetMailHistoryDocumentsByJobIdResponse|\StructType\GetMailHistoryJobsResponse|\StructType\GetMailingListByIDResponse|\StructType\GetMailingListsResponse|\StructType\GetMailPacksResponse|\StructType\GetMessageResponse|\StructType\GetPortalUrlResponse|\StructType\GetPriceBandsResponse|\StructType\GetSystemIDResponse|\StructType\GetUserDetailsResponse|\StructType\GetUserVariablesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
