<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameAndMergeFields
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and merge fields.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateMappingWithDefaultNameAndMergeFields $parameters
     * @return \StructType\GenerateMappingWithDefaultNameAndMergeFieldsResponse|bool
     */
    public function GenerateMappingWithDefaultNameAndMergeFields(\StructType\GenerateMappingWithDefaultNameAndMergeFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameAndMergeFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMappingWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateMappingWithID $parameters
     * @return \StructType\GenerateMappingWithIDResponse|bool
     */
    public function GenerateMappingWithID(\StructType\GenerateMappingWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateMappingWithDefaultNameWithID $parameters
     * @return \StructType\GenerateMappingWithDefaultNameWithIDResponse|bool
     */
    public function GenerateMappingWithDefaultNameWithID(\StructType\GenerateMappingWithDefaultNameWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameAndMergeFieldsWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and merge fields and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithID $parameters
     * @return \StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithIDResponse|bool
     */
    public function GenerateMappingWithDefaultNameAndMergeFieldsWithID(\StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameAndMergeFieldsWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMapping
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateMapping $parameters
     * @return \StructType\GenerateMappingResponse|bool
     */
    public function GenerateMapping(\StructType\GenerateMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMappingWithDefaultName
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateMappingWithDefaultName $parameters
     * @return \StructType\GenerateMappingWithDefaultNameResponse|bool
     */
    public function GenerateMappingWithDefaultName(\StructType\GenerateMappingWithDefaultName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GenerateMappingResponse|\StructType\GenerateMappingWithDefaultNameAndMergeFieldsResponse|\StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithIDResponse|\StructType\GenerateMappingWithDefaultNameResponse|\StructType\GenerateMappingWithDefaultNameWithIDResponse|\StructType\GenerateMappingWithIDResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
