<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FindNearestQueryAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to query a FindNearest search. This method will not create a Find Nearest list but will return the cost of the list including how many addresses were found. Use the FindNearestExecuteSearch method to create a mailing
     * list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindNearestQueryAddress $parameters
     * @return \StructType\FindNearestQueryAddressResponse|bool
     */
    public function FindNearestQueryAddress(\StructType\FindNearestQueryAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindNearestQueryAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindNearestExecuteSearch
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a FindNearest List. The resulting list will contain all addresses within a radius or range surrounding the search address provided. This list can then be used when sending Simple Mailings or Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindNearestExecuteSearch $parameters
     * @return \StructType\FindNearestExecuteSearchResponse|bool
     */
    public function FindNearestExecuteSearch(\StructType\FindNearestExecuteSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindNearestExecuteSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FindNearestExecuteSearchResponse|\StructType\FindNearestQueryAddressResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
