<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Download ServiceType
 * @subpackage Services
 */
class Download extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DownloadDataList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to download a specified data list as a CSV file. Note that not all data lists are permitted to be downloaded.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DownloadDataList $parameters
     * @return \StructType\DownloadDataListResponse|bool
     */
    public function DownloadDataList(\StructType\DownloadDataList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DownloadDataListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
