<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Disable ServiceType
 * @subpackage Services
 */
class Disable extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DisableUser
     * Meta information extracted from the WSDL
     * - documentation: Use this method to disable a user account. You need to specify the username of the account that you wish to disable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DisableUser $parameters
     * @return \StructType\DisableUserResponse|bool
     */
    public function DisableUser(\StructType\DisableUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DisableUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DisableUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
