<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a Mail Pack using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The mailPackID you supply will be used to delete your Mail Pack. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMailPack $parameters
     * @return \StructType\DeleteMailPackResponse|bool
     */
    public function DeleteMailPack(\StructType\DeleteMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteExcludedAddressByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a delete an excluded address - you can get the ID by using the GetExcludedAddresses method
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteExcludedAddressByID $parameters
     * @return \StructType\DeleteExcludedAddressByIDResponse|bool
     */
    public function DeleteExcludedAddressByID(\StructType\DeleteExcludedAddressByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteExcludedAddressByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailingList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a mailing list using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The MailingListID you supply will be used to delete your mailing list. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMailingList $parameters
     * @return \StructType\DeleteMailingListResponse|bool
     */
    public function DeleteMailingList(\StructType\DeleteMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMapping
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a mapping using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The mappingID you supply will be used to delete your mapping. This method returns
     * True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMapping $parameters
     * @return \StructType\DeleteMappingResponse|bool
     */
    public function DeleteMapping(\StructType\DeleteMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteUserVariable
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a user variable using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The variableID you supply will be used to delete your user variable. This
     * method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteUserVariable $parameters
     * @return \StructType\DeleteUserVariableResponse|bool
     */
    public function DeleteUserVariable(\StructType\DeleteUserVariable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteUserVariable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letterhead using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The letterheadID you supply will be used to delete your letterhead. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLetterhead $parameters
     * @return \StructType\DeleteLetterheadResponse|bool
     */
    public function DeleteLetterhead(\StructType\DeleteLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letter using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The letterID you supply will be used to delete the letter. This method returns True
     * if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLetter $parameters
     * @return \StructType\DeleteLetterResponse|bool
     */
    public function DeleteLetter(\StructType\DeleteLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAttachment
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete an attachment using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The attachmentID you supply will be used to delete your attachment. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAttachment $parameters
     * @return \StructType\DeleteAttachmentResponse|bool
     */
    public function DeleteAttachment(\StructType\DeleteAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a postcard using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The postcardID you supply will be used to delete your postcard. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeletePostcard $parameters
     * @return \StructType\DeletePostcardResponse|bool
     */
    public function DeletePostcard(\StructType\DeletePostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterByLetterID
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to delete a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by an ID must belong to you. This method returns True if successful
     * or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLetterByLetterID $parameters
     * @return \StructType\DeleteLetterByLetterIDResponse|bool
     */
    public function DeleteLetterByLetterID(\StructType\DeleteLetterByLetterID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterByLetterID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterByCustomerAPILetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by a CustomerAPILetter object must belong to you. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteLetterByCustomerAPILetter $parameters
     * @return \StructType\DeleteLetterByCustomerAPILetterResponse|bool
     */
    public function DeleteLetterByCustomerAPILetter(\StructType\DeleteLetterByCustomerAPILetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterByCustomerAPILetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a price band. You must supply a valid GUID to use this method as well as the ID of the price band which you wish to delete. You can only delete a price band if no customers are currently using it. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeletePriceBand $parameters
     * @return \StructType\DeletePriceBandResponse|bool
     */
    public function DeletePriceBand(\StructType\DeletePriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteAttachmentResponse|\StructType\DeleteExcludedAddressByIDResponse|\StructType\DeleteLetterByCustomerAPILetterResponse|\StructType\DeleteLetterByLetterIDResponse|\StructType\DeleteLetterheadResponse|\StructType\DeleteLetterResponse|\StructType\DeleteMailingListResponse|\StructType\DeleteMailPackResponse|\StructType\DeleteMappingResponse|\StructType\DeletePostcardResponse|\StructType\DeletePriceBandResponse|\StructType\DeleteUserVariableResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
