<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateLetterFromXPS
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letter in XPS format. Letters can be used either in a Mail Pack or in a Simple Mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLetterFromXPS $parameters
     * @return \StructType\CreateLetterFromXPSResponse|bool
     */
    public function CreateLetterFromXPS(\StructType\CreateLetterFromXPS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetterFromXPS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAttachment
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a PDF attachment which can be attached to a letter when creating a Mail Pack. A number of attachments can be added to a Mail Pack. The attachmentID can be referenced for use with Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAttachment $parameters
     * @return \StructType\CreateAttachmentResponse|bool
     */
    public function CreateAttachment(\StructType\CreateAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letterhead in PDF format. Letterheads can be used in Mail Packs either on the first page or every page in the Pack. The letterheadID can be referenced for use with Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLetterhead $parameters
     * @return \StructType\CreateLetterheadResponse|bool
     */
    public function CreateLetterhead(\StructType\CreateLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letter in either PDF or Word XML (.xml) format. Letters can be used either in a Mail Pack or in a Simple Mailing. Document's uploaded in Word XML (.xml) format can contain Merge Fields which will be
     * replaced when the Mailing is run. The letterID can be referenced for use with Mail Packs or Simple Mailings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLetter $parameters
     * @return \StructType\CreateLetterResponse|bool
     */
    public function CreateLetter(\StructType\CreateLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to Create a Mail Pack, a letterID must be supplied while both attachmentIDs and letterheadID are optional. A Mail Pack will be created which can then be sent to a single address or an address list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateMailPack $parameters
     * @return \StructType\CreateMailPackResponse|bool
     */
    public function CreateMailPack(\StructType\CreateMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Mailing List. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendMailPack $parameters
     * @return \StructType\CreateAndSendMailPackResponse|bool
     */
    public function CreateAndSendMailPack(\StructType\CreateAndSendMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendMailPackToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Single Address. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendMailPackToSingleAddress $parameters
     * @return \StructType\CreateAndSendMailPackToSingleAddressResponse|bool
     */
    public function CreateAndSendMailPackToSingleAddress(\StructType\CreateAndSendMailPackToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPackToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendSimpleMailingToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a Mailing list created from Find Nearest. A letter in either PDF or Word XML (.xml) must be supplied with addess details for the Find Nearest search.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendSimpleMailingToFindNearest $parameters
     * @return \StructType\CreateAndSendSimpleMailingToFindNearestResponse|bool
     */
    public function CreateAndSendSimpleMailingToFindNearest(\StructType\CreateAndSendSimpleMailingToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailingToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendSimpleMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing. A letter in either PDF or Word XML (.xml) must be supplied with a mailinglistID from a previously uploaded mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendSimpleMailing $parameters
     * @return \StructType\CreateAndSendSimpleMailingResponse|bool
     */
    public function CreateAndSendSimpleMailing(\StructType\CreateAndSendSimpleMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendSimpleMailingToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a single address. A letter in either PDF or Word XML (.xml) must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendSimpleMailingToSingleAddress $parameters
     * @return \StructType\CreateAndSendSimpleMailingToSingleAddressResponse|bool
     */
    public function CreateAndSendSimpleMailingToSingleAddress(\StructType\CreateAndSendSimpleMailingToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailingToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendMailPackToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Mailing list created from Find Nearest. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendMailPackToFindNearest $parameters
     * @return \StructType\CreateAndSendMailPackToFindNearestResponse|bool
     */
    public function CreateAndSendMailPackToFindNearest(\StructType\CreateAndSendMailPackToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPackToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new A5 landscape postcard in PDF format. A postcard can be defined by two pages in a single PDF or the first page of two PDFs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePostcard $parameters
     * @return \StructType\CreatePostcardResponse|bool
     */
    public function CreatePostcard(\StructType\CreatePostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendPostcardToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a single address. An A5 landscape postcard in PDF format must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendPostcardToSingleAddress $parameters
     * @return \StructType\CreateAndSendPostcardToSingleAddressResponse|bool
     */
    public function CreateAndSendPostcardToSingleAddress(\StructType\CreateAndSendPostcardToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcardToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendPostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a mailing list. An A5 landscape postcard in PDF format must be supplied with the mailing list ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendPostcard $parameters
     * @return \StructType\CreateAndSendPostcardResponse|bool
     */
    public function CreateAndSendPostcard(\StructType\CreateAndSendPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendPostcardToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a mailing list created from a find nearest request. An A5 landscape postcard in PDF format must be supplied with the find nearest request details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAndSendPostcardToFindNearest $parameters
     * @return \StructType\CreateAndSendPostcardToFindNearestResponse|bool
     */
    public function CreateAndSendPostcardToFindNearest(\StructType\CreateAndSendPostcardToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcardToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateJobRunRecord
     * Meta information extracted from the WSDL
     * - documentation: Internal use only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateJobRunRecord $parameters
     * @return \StructType\CreateJobRunRecordResponse|bool
     */
    public function CreateJobRunRecord(\StructType\CreateJobRunRecord $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateJobRunRecord($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccount
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a customer account. The method also adds a user to the customer account who is specified as the account admin. Refer to Documentation for information on which fields are required. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAccount $parameters
     * @return \StructType\CreateAccountResponse|bool
     */
    public function CreateAccount(\StructType\CreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccountNonUK
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a customer account. The method also adds a user to the customer account who is specified as the account admin. Refer to Documentation for information on which fields are required. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAccountNonUK $parameters
     * @return \StructType\CreateAccountNonUKResponse|bool
     */
    public function CreateAccountNonUK(\StructType\CreateAccountNonUK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccountNonUK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a new price band. You must supply a valid GUID to use this method as well as a unique description string to identify the price band. This method returns True if successful or False if a problem occured. It
     * also provides the PriceBandID for your use. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePriceBand $parameters
     * @return \StructType\CreatePriceBandResponse|bool
     */
    public function CreatePriceBand(\StructType\CreatePriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateAccountNonUKResponse|\StructType\CreateAccountResponse|\StructType\CreateAndSendMailPackResponse|\StructType\CreateAndSendMailPackToFindNearestResponse|\StructType\CreateAndSendMailPackToSingleAddressResponse|\StructType\CreateAndSendPostcardResponse|\StructType\CreateAndSendPostcardToFindNearestResponse|\StructType\CreateAndSendPostcardToSingleAddressResponse|\StructType\CreateAndSendSimpleMailingResponse|\StructType\CreateAndSendSimpleMailingToFindNearestResponse|\StructType\CreateAndSendSimpleMailingToSingleAddressResponse|\StructType\CreateAttachmentResponse|\StructType\CreateJobRunRecordResponse|\StructType\CreateLetterFromXPSResponse|\StructType\CreateLetterheadResponse|\StructType\CreateLetterResponse|\StructType\CreateMailPackResponse|\StructType\CreatePostcardResponse|\StructType\CreatePriceBandResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
