<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calculate ServiceType
 * @subpackage Services
 */
class Calculate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * CalculateCostOfSingleAddressMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateCostOfSingleAddressMailing $parameters
     * @return \StructType\CalculateCostOfSingleAddressMailingResponse|bool
     */
    public function CalculateCostOfSingleAddressMailing(\StructType\CalculateCostOfSingleAddressMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfSingleAddressMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateCostOfMailing $parameters
     * @return \StructType\CalculateCostOfMailingResponse|bool
     */
    public function CalculateCostOfMailing(\StructType\CalculateCostOfMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfFindNearestMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateCostOfFindNearestMailing $parameters
     * @return \StructType\CalculateCostOfFindNearestMailingResponse|bool
     */
    public function CalculateCostOfFindNearestMailing(\StructType\CalculateCostOfFindNearestMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfFindNearestMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfDataList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of purchasing a data list containing a given number of items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateCostOfDataList $parameters
     * @return \StructType\CalculateCostOfDataListResponse|bool
     */
    public function CalculateCostOfDataList(\StructType\CalculateCostOfDataList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfNewMailing
     * Meta information extracted from the WSDL
     * - documentation: Calculate the cost of sending a letter or postcard not yet uploaded on the system to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateCostOfNewMailing $parameters
     * @return \StructType\CalculateCostOfNewMailingResponse|bool
     */
    public function CalculateCostOfNewMailing(\StructType\CalculateCostOfNewMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfNewMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateLetterCostComplexBatchWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a complex batch (one containing letters with different numbers of pages) that requires validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). You must also create a MailBatch Object which stores the details about the letters being sent in the batch. The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateLetterCostComplexBatchWithExceptions $parameters
     * @return \StructType\CalculateLetterCostComplexBatchWithExceptionsResponse|bool
     */
    public function CalculateLetterCostComplexBatchWithExceptions(\StructType\CalculateLetterCostComplexBatchWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostComplexBatchWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateLetterCostSimpleBatch
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a simple batch(one contaning letters with the same number of pages) that does not require validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateLetterCostSimpleBatch $parameters
     * @return \StructType\CalculateLetterCostSimpleBatchResponse|bool
     */
    public function CalculateLetterCostSimpleBatch(\StructType\CalculateLetterCostSimpleBatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostSimpleBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateLetterCostSimpleBatchWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a complex batch(one contaning letters with the same number of pages) that requires validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateLetterCostSimpleBatchWithExceptions $parameters
     * @return \StructType\CalculateLetterCostSimpleBatchWithExceptionsResponse|bool
     */
    public function CalculateLetterCostSimpleBatchWithExceptions(\StructType\CalculateLetterCostSimpleBatchWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostSimpleBatchWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateLetterCostComplexBatch
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The method returns true on success and will also pass out the total Net
     * Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateLetterCostComplexBatch $parameters
     * @return \StructType\CalculateLetterCostComplexBatchResponse|bool
     */
    public function CalculateLetterCostComplexBatch(\StructType\CalculateLetterCostComplexBatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostComplexBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateMailMergeCost
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occurred. The
     * ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateMailMergeCost $parameters
     * @return \StructType\CalculateMailMergeCostResponse|bool
     */
    public function CalculateMailMergeCost(\StructType\CalculateMailMergeCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateMailMergeCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateEstimatedDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the estimated delivery date of a letter based on the time passed in. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn to acquire a
     * LoginToken). This method returns True if successful or False if a problem occured. The SendDateTime variable is the date and time when you wish to send letters out and the DeliveryDate is the estimated Royal Mail delivery date. The ReturnMessage
     * provides an explanation of the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateEstimatedDeliveryDate $parameters
     * @return \StructType\CalculateEstimatedDeliveryDateResponse|bool
     */
    public function CalculateEstimatedDeliveryDate(\StructType\CalculateEstimatedDeliveryDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateEstimatedDeliveryDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateEstimatedDeliveryDateNow
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the estimated delivery date of a letter based on the current time. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn to acquire a
     * LoginToken). This method returns True if successful or False if a problem occured. The DeliveryDate is the estimated Royal Mail delivery date. The ReturnMessage provides an explanation of the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateEstimatedDeliveryDateNow $parameters
     * @return \StructType\CalculateEstimatedDeliveryDateNowResponse|bool
     */
    public function CalculateEstimatedDeliveryDateNow(\StructType\CalculateEstimatedDeliveryDateNow $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateEstimatedDeliveryDateNow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateSendDateForDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the date on which you should send a letter for it to arrive on a specified date. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn
     * to acquire a LoginToken). This method returns True if successful or False if a problem occured. The earliest and latest SendDate are the estimated send dates based on our batching and Royal Mail delivery. The ReturnMessage provides an explanation of
     * the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculateSendDateForDeliveryDate $parameters
     * @return \StructType\CalculateSendDateForDeliveryDateResponse|bool
     */
    public function CalculateSendDateForDeliveryDate(\StructType\CalculateSendDateForDeliveryDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateSendDateForDeliveryDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CalculateCostOfDataListResponse|\StructType\CalculateCostOfFindNearestMailingResponse|\StructType\CalculateCostOfMailingResponse|\StructType\CalculateCostOfNewMailingResponse|\StructType\CalculateCostOfSingleAddressMailingResponse|\StructType\CalculateEstimatedDeliveryDateNowResponse|\StructType\CalculateEstimatedDeliveryDateResponse|\StructType\CalculateLetterCostComplexBatchResponse|\StructType\CalculateLetterCostComplexBatchWithExceptionsResponse|\StructType\CalculateLetterCostSimpleBatchResponse|\StructType\CalculateLetterCostSimpleBatchWithExceptionsResponse|\StructType\CalculateMailMergeCostResponse|\StructType\CalculateSendDateForDeliveryDateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
