<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Assign ServiceType
 * @subpackage Services
 */
class Assign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AssignPriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to assign a price band to a customer. You must supply a valid GUID to use this method as well as a username associated with the customer account and the ID of the price band that you wish to apply. The customer and
     * price band must be associated with your GUID. This method returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AssignPriceBand $parameters
     * @return \StructType\AssignPriceBandResponse|bool
     */
    public function AssignPriceBand(\StructType\AssignPriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AssignPriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AssignPriceBandResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
