<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddExcludedAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add an excluded address at either a list, user or company level. For lists you should enter the mailinglistID. Otherwise this should be 0.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddExcludedAddress $parameters
     * @return \StructType\AddExcludedAddressResponse|bool
     */
    public function AddExcludedAddress(\StructType\AddExcludedAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddExcludedAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccount
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserToAccount $parameters
     * @return \StructType\AddUserToAccountResponse|bool
     */
    public function AddUserToAccount(\StructType\AddUserToAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountPermissions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserToAccountPermissions $parameters
     * @return \StructType\AddUserToAccountPermissionsResponse|bool
     */
    public function AddUserToAccountPermissions(\StructType\AddUserToAccountPermissions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountPermissions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountNonUK
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserToAccountNonUK $parameters
     * @return \StructType\AddUserToAccountNonUKResponse|bool
     */
    public function AddUserToAccountNonUK(\StructType\AddUserToAccountNonUK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountNonUK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountNonUKPermissions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserToAccountNonUKPermissions $parameters
     * @return \StructType\AddUserToAccountNonUKPermissionsResponse|bool
     */
    public function AddUserToAccountNonUKPermissions(\StructType\AddUserToAccountNonUKPermissions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountNonUKPermissions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddExcludedAddressResponse|\StructType\AddUserToAccountNonUKPermissionsResponse|\StructType\AddUserToAccountNonUKResponse|\StructType\AddUserToAccountPermissionsResponse|\StructType\AddUserToAccountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
