<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Zugmaschine StructType
 * Meta information extracted from the WSDL
 * - documentation: WKZ 4xx
 * @subpackage Structs
 */
class CT_Zugmaschine extends CT_Fahrzeug
{
    /**
     * The ZulaessigesGesamtgewicht
     * Meta information extracted from the WSDL
     * - documentation: Zulässiges Gesamtgewicht in kg.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ZulaessigesGesamtgewicht;
    /**
     * The Nutzlast
     * Meta information extracted from the WSDL
     * - documentation: Nutzlast in kg.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Nutzlast;
    /**
     * The Aufbauten
     * Meta information extracted from the WSDL
     * - documentation: Schlüssel gemäß "Verzeichnis zur Systematisierung von Kraftfahrzeugen und ihren Anhängern" des Kraftfahrtbundesamts (das jeweils aktuelle Verzeichnis findet sich auf der Website des Kraftfahrtbundesamts unter nachfolgendem Link
     * im Abschnitt "Bekanntmachungen zur Fahrzeugsystematik": https://www.kba.de/DE/Statistik/statistik_node.html)
     * - base: xsd:string
     * - length: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aufbauten;
    /**
     * The AufbautenText
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Aufbauten als Text, falls im Attribut Aufbauten der Wert "99" geschlüsselt ist.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AufbautenText;
    /**
     * The AnhaengerBetrieb
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnhaengerBetrieb;
    /**
     * The LKWNutzung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_LKWNutzung
     */
    public $LKWNutzung;
    /**
     * The IstSattelzugmaschine
     * Meta information extracted from the WSDL
     * - documentation: Ja = Die Zugmaschine verfügt über eine Sattelkupplung, mit der Sattelauflieger gezogen werden können.Nein = Die Zugmaschine verfügt über keine Sattelkupplung, mit der Sattelauflieger gezogen werden können.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $IstSattelzugmaschine;
    /**
     * Constructor method for CT_Zugmaschine
     * @uses CT_Zugmaschine::setZulaessigesGesamtgewicht()
     * @uses CT_Zugmaschine::setNutzlast()
     * @uses CT_Zugmaschine::setAufbauten()
     * @uses CT_Zugmaschine::setAufbautenText()
     * @uses CT_Zugmaschine::setAnhaengerBetrieb()
     * @uses CT_Zugmaschine::setLKWNutzung()
     * @uses CT_Zugmaschine::setIstSattelzugmaschine()
     * @param float $zulaessigesGesamtgewicht
     * @param float $nutzlast
     * @param string $aufbauten
     * @param string $aufbautenText
     * @param string $anhaengerBetrieb
     * @param \BiPRO\StructType\CT_LKWNutzung $lKWNutzung
     * @param bool $istSattelzugmaschine
     */
    public function __construct($zulaessigesGesamtgewicht = null, $nutzlast = null, $aufbauten = null, $aufbautenText = null, $anhaengerBetrieb = null, \BiPRO\StructType\CT_LKWNutzung $lKWNutzung = null, $istSattelzugmaschine = null)
    {
        $this
            ->setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht)
            ->setNutzlast($nutzlast)
            ->setAufbauten($aufbauten)
            ->setAufbautenText($aufbautenText)
            ->setAnhaengerBetrieb($anhaengerBetrieb)
            ->setLKWNutzung($lKWNutzung)
            ->setIstSattelzugmaschine($istSattelzugmaschine);
    }
    /**
     * Get ZulaessigesGesamtgewicht value
     * @return float|null
     */
    public function getZulaessigesGesamtgewicht()
    {
        return $this->ZulaessigesGesamtgewicht;
    }
    /**
     * Set ZulaessigesGesamtgewicht value
     * @param float $zulaessigesGesamtgewicht
     * @return \BiPRO\StructType\CT_Zugmaschine
     */
    public function setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht = null)
    {
        // validation for constraint: float
        if (!is_null($zulaessigesGesamtgewicht) && !(is_float($zulaessigesGesamtgewicht) || is_numeric($zulaessigesGesamtgewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zulaessigesGesamtgewicht, true), gettype($zulaessigesGesamtgewicht)), __LINE__);
        }
        $this->ZulaessigesGesamtgewicht = $zulaessigesGesamtgewicht;
        return $this;
    }
    /**
     * Get Nutzlast value
     * @return float|null
     */
    public function getNutzlast()
    {
        return $this->Nutzlast;
    }
    /**
     * Set Nutzlast value
     * @param float $nutzlast
     * @return \BiPRO\StructType\CT_Zugmaschine
     */
    public function setNutzlast($nutzlast = null)
    {
        // validation for constraint: float
        if (!is_null($nutzlast) && !(is_float($nutzlast) || is_numeric($nutzlast))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nutzlast, true), gettype($nutzlast)), __LINE__);
        }
        $this->Nutzlast = $nutzlast;
        return $this;
    }
    /**
     * Get Aufbauten value
     * @return string|null
     */
    public function getAufbauten()
    {
        return $this->Aufbauten;
    }
    /**
     * Set Aufbauten value
     * @param string $aufbauten
     * @return \BiPRO\StructType\CT_Zugmaschine
     */
    public function setAufbauten($aufbauten = null)
    {
        // validation for constraint: string
        if (!is_null($aufbauten) && !is_string($aufbauten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aufbauten, true), gettype($aufbauten)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($aufbauten) && mb_strlen($aufbauten) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($aufbauten)), __LINE__);
        }
        $this->Aufbauten = $aufbauten;
        return $this;
    }
    /**
     * Get AufbautenText value
     * @return string|null
     */
    public function getAufbautenText()
    {
        return $this->AufbautenText;
    }
    /**
     * Set AufbautenText value
     * @param string $aufbautenText
     * @return \BiPRO\StructType\CT_Zugmaschine
     */
    public function setAufbautenText($aufbautenText = null)
    {
        // validation for constraint: string
        if (!is_null($aufbautenText) && !is_string($aufbautenText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aufbautenText, true), gettype($aufbautenText)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aufbautenText) && mb_strlen($aufbautenText) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aufbautenText)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aufbautenText) && mb_strlen($aufbautenText) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aufbautenText)), __LINE__);
        }
        $this->AufbautenText = $aufbautenText;
        return $this;
    }
    /**
     * Get AnhaengerBetrieb value
     * @return string|null
     */
    public function getAnhaengerBetrieb()
    {
        return $this->AnhaengerBetrieb;
    }
    /**
     * Set AnhaengerBetrieb value
     * @uses \BiPRO\EnumType\ST_JaNeinKeineAntwort::valueIsValid()
     * @uses \BiPRO\EnumType\ST_JaNeinKeineAntwort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anhaengerBetrieb
     * @return \BiPRO\StructType\CT_Zugmaschine
     */
    public function setAnhaengerBetrieb($anhaengerBetrieb = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_JaNeinKeineAntwort::valueIsValid($anhaengerBetrieb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_JaNeinKeineAntwort', is_array($anhaengerBetrieb) ? implode(', ', $anhaengerBetrieb) : var_export($anhaengerBetrieb, true), implode(', ', \BiPRO\EnumType\ST_JaNeinKeineAntwort::getValidValues())), __LINE__);
        }
        $this->AnhaengerBetrieb = $anhaengerBetrieb;
        return $this;
    }
    /**
     * Get LKWNutzung value
     * @return \BiPRO\StructType\CT_LKWNutzung|null
     */
    public function getLKWNutzung()
    {
        return $this->LKWNutzung;
    }
    /**
     * Set LKWNutzung value
     * @param \BiPRO\StructType\CT_LKWNutzung $lKWNutzung
     * @return \BiPRO\StructType\CT_Zugmaschine
     */
    public function setLKWNutzung(\BiPRO\StructType\CT_LKWNutzung $lKWNutzung = null)
    {
        $this->LKWNutzung = $lKWNutzung;
        return $this;
    }
    /**
     * Get IstSattelzugmaschine value
     * @return bool|null
     */
    public function getIstSattelzugmaschine()
    {
        return $this->IstSattelzugmaschine;
    }
    /**
     * Set IstSattelzugmaschine value
     * @param bool $istSattelzugmaschine
     * @return \BiPRO\StructType\CT_Zugmaschine
     */
    public function setIstSattelzugmaschine($istSattelzugmaschine = null)
    {
        // validation for constraint: boolean
        if (!is_null($istSattelzugmaschine) && !is_bool($istSattelzugmaschine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($istSattelzugmaschine, true), gettype($istSattelzugmaschine)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($istSattelzugmaschine) && !preg_match('/true|false/', $istSattelzugmaschine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($istSattelzugmaschine, true)), __LINE__);
        }
        $this->IstSattelzugmaschine = $istSattelzugmaschine;
        return $this;
    }
}
