<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Werbeerlaubnis StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Klasse spezifiziert Werbeerlaubnisse und Werbeverbote generell oder in Abhängigkeit von Kommunikationsverbindungen und Sparten, eventuell auch für bestimmte Zeiträume.
 * @subpackage Structs
 */
class CT_Werbeerlaubnis extends CT_Objekt
{
    /**
     * The Erlaubnis
     * Meta information extracted from the WSDL
     * - documentation: Ja = Werbeerlaubnis erteiltNein = Werbeerlaubnis nicht erteilt (Werbeverbot)Unbekannt = Information zur Werbeerlaubnis unbekannt
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Erlaubnis;
    /**
     * The Sparte
     * Meta information extracted from the WSDL
     * - documentation: Sparte(n), für die Werbeerlaubnis bzw. -verbot gilt.Keine Angabe bedeutet: Gilt für alle Sparten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Sparte;
    /**
     * The Basis
     * Meta information extracted from the WSDL
     * - documentation: Basis für Werbeerlaubnis bzw. Werbeverbot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Basis;
    /**
     * The Bestaetigungsart
     * Meta information extracted from the WSDL
     * - documentation: Art der Bestätigung für Werbeerlaubnis bzw. Werbeverbot.Wird keine Bestätigung versandt, MUSS der Wert 999 verwendet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bestaetigungsart;
    /**
     * The Bestaetigungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Bestätigung für Werbeerlaubnis bzw. Werbeverbot. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Bestaetigungsdatum;
    /**
     * The Gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gültigkeit für Werbeerlaubnis bzw. Werbeverbot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Gueltigkeit;
    /**
     * The Kommunikationsverbindung
     * Meta information extracted from the WSDL
     * - documentation: Kommunikationsverbindung, für die Werbeerlaubnis bzw. Werbeverbot gilt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kommunikationsverbindung[]
     */
    public $Kommunikationsverbindung;
    /**
     * The EinwilligungserklaerungErlaeutert
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob dem Partner die Werbeeinwilligungserklärung erläutert wurde.Ja = Die Werbeeinwilligungserklärung wurde dem Partner erläutert.Nein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EinwilligungserklaerungErlaeutert;
    /**
     * Constructor method for CT_Werbeerlaubnis
     * @uses CT_Werbeerlaubnis::setErlaubnis()
     * @uses CT_Werbeerlaubnis::setSparte()
     * @uses CT_Werbeerlaubnis::setBasis()
     * @uses CT_Werbeerlaubnis::setBestaetigungsart()
     * @uses CT_Werbeerlaubnis::setBestaetigungsdatum()
     * @uses CT_Werbeerlaubnis::setGueltigkeit()
     * @uses CT_Werbeerlaubnis::setKommunikationsverbindung()
     * @uses CT_Werbeerlaubnis::setEinwilligungserklaerungErlaeutert()
     * @param string $erlaubnis
     * @param string[] $sparte
     * @param string $basis
     * @param string $bestaetigungsart
     * @param string $bestaetigungsdatum
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung[] $kommunikationsverbindung
     * @param bool $einwilligungserklaerungErlaeutert
     */
    public function __construct($erlaubnis = null, array $sparte = array(), $basis = null, $bestaetigungsart = null, $bestaetigungsdatum = null, \BiPRO\StructType\CT_Zeitraum $gueltigkeit = null, array $kommunikationsverbindung = array(), $einwilligungserklaerungErlaeutert = null)
    {
        $this
            ->setErlaubnis($erlaubnis)
            ->setSparte($sparte)
            ->setBasis($basis)
            ->setBestaetigungsart($bestaetigungsart)
            ->setBestaetigungsdatum($bestaetigungsdatum)
            ->setGueltigkeit($gueltigkeit)
            ->setKommunikationsverbindung($kommunikationsverbindung)
            ->setEinwilligungserklaerungErlaeutert($einwilligungserklaerungErlaeutert);
    }
    /**
     * Get Erlaubnis value
     * @return string
     */
    public function getErlaubnis()
    {
        return $this->Erlaubnis;
    }
    /**
     * Set Erlaubnis value
     * @uses \BiPRO\EnumType\ST_JaNeinKeineAntwort::valueIsValid()
     * @uses \BiPRO\EnumType\ST_JaNeinKeineAntwort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $erlaubnis
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setErlaubnis($erlaubnis = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_JaNeinKeineAntwort::valueIsValid($erlaubnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_JaNeinKeineAntwort', is_array($erlaubnis) ? implode(', ', $erlaubnis) : var_export($erlaubnis, true), implode(', ', \BiPRO\EnumType\ST_JaNeinKeineAntwort::getValidValues())), __LINE__);
        }
        $this->Erlaubnis = $erlaubnis;
        return $this;
    }
    /**
     * Get Sparte value
     * @return string[]|null
     */
    public function getSparte()
    {
        return $this->Sparte;
    }
    /**
     * This method is responsible for validating the values passed to the setSparte method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSparte method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSparteForArrayConstraintsFromSetSparte(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_WerbeerlaubnisSparteItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($cT_WerbeerlaubnisSparteItem)) {
                $invalidValues[] = is_object($cT_WerbeerlaubnisSparteItem) ? get_class($cT_WerbeerlaubnisSparteItem) : sprintf('%s(%s)', gettype($cT_WerbeerlaubnisSparteItem), var_export($cT_WerbeerlaubnisSparteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $sparte
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setSparte(array $sparte = array())
    {
        // validation for constraint: array
        if ('' !== ($sparteArrayErrorMessage = self::validateSparteForArrayConstraintsFromSetSparte($sparte))) {
            throw new \InvalidArgumentException($sparteArrayErrorMessage, __LINE__);
        }
        $this->Sparte = $sparte;
        return $this;
    }
    /**
     * Add item to Sparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function addToSparte($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues())), __LINE__);
        }
        $this->Sparte[] = $item;
        return $this;
    }
    /**
     * Get Basis value
     * @return string|null
     */
    public function getBasis()
    {
        return $this->Basis;
    }
    /**
     * Set Basis value
     * @uses \BiPRO\EnumType\ST_BasisDerWerbeerlaubnis::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BasisDerWerbeerlaubnis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $basis
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setBasis($basis = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BasisDerWerbeerlaubnis::valueIsValid($basis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BasisDerWerbeerlaubnis', is_array($basis) ? implode(', ', $basis) : var_export($basis, true), implode(', ', \BiPRO\EnumType\ST_BasisDerWerbeerlaubnis::getValidValues())), __LINE__);
        }
        $this->Basis = $basis;
        return $this;
    }
    /**
     * Get Bestaetigungsart value
     * @return string|null
     */
    public function getBestaetigungsart()
    {
        return $this->Bestaetigungsart;
    }
    /**
     * Set Bestaetigungsart value
     * @uses \BiPRO\EnumType\ST_Versandart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Versandart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bestaetigungsart
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setBestaetigungsart($bestaetigungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Versandart::valueIsValid($bestaetigungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Versandart', is_array($bestaetigungsart) ? implode(', ', $bestaetigungsart) : var_export($bestaetigungsart, true), implode(', ', \BiPRO\EnumType\ST_Versandart::getValidValues())), __LINE__);
        }
        $this->Bestaetigungsart = $bestaetigungsart;
        return $this;
    }
    /**
     * Get Bestaetigungsdatum value
     * @return string|null
     */
    public function getBestaetigungsdatum()
    {
        return $this->Bestaetigungsdatum;
    }
    /**
     * Set Bestaetigungsdatum value
     * @param string $bestaetigungsdatum
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setBestaetigungsdatum($bestaetigungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($bestaetigungsdatum) && !is_string($bestaetigungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestaetigungsdatum, true), gettype($bestaetigungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($bestaetigungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $bestaetigungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($bestaetigungsdatum, true)), __LINE__);
        }
        $this->Bestaetigungsdatum = $bestaetigungsdatum;
        return $this;
    }
    /**
     * Get Gueltigkeit value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getGueltigkeit()
    {
        return $this->Gueltigkeit;
    }
    /**
     * Set Gueltigkeit value
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setGueltigkeit(\BiPRO\StructType\CT_Zeitraum $gueltigkeit = null)
    {
        $this->Gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Get Kommunikationsverbindung value
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung[]|null
     */
    public function getKommunikationsverbindung()
    {
        return $this->Kommunikationsverbindung;
    }
    /**
     * This method is responsible for validating the values passed to the setKommunikationsverbindung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKommunikationsverbindung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKommunikationsverbindungForArrayConstraintsFromSetKommunikationsverbindung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_WerbeerlaubnisKommunikationsverbindungItem) {
            // validation for constraint: itemType
            if (!$cT_WerbeerlaubnisKommunikationsverbindungItem instanceof \BiPRO\StructType\CT_Kommunikationsverbindung) {
                $invalidValues[] = is_object($cT_WerbeerlaubnisKommunikationsverbindungItem) ? get_class($cT_WerbeerlaubnisKommunikationsverbindungItem) : sprintf('%s(%s)', gettype($cT_WerbeerlaubnisKommunikationsverbindungItem), var_export($cT_WerbeerlaubnisKommunikationsverbindungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kommunikationsverbindung property can only contain items of type \BiPRO\StructType\CT_Kommunikationsverbindung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kommunikationsverbindung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung[] $kommunikationsverbindung
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setKommunikationsverbindung(array $kommunikationsverbindung = array())
    {
        // validation for constraint: array
        if ('' !== ($kommunikationsverbindungArrayErrorMessage = self::validateKommunikationsverbindungForArrayConstraintsFromSetKommunikationsverbindung($kommunikationsverbindung))) {
            throw new \InvalidArgumentException($kommunikationsverbindungArrayErrorMessage, __LINE__);
        }
        $this->Kommunikationsverbindung = $kommunikationsverbindung;
        return $this;
    }
    /**
     * Add item to Kommunikationsverbindung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung $item
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function addToKommunikationsverbindung(\BiPRO\StructType\CT_Kommunikationsverbindung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Kommunikationsverbindung) {
            throw new \InvalidArgumentException(sprintf('The Kommunikationsverbindung property can only contain items of type \BiPRO\StructType\CT_Kommunikationsverbindung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Kommunikationsverbindung[] = $item;
        return $this;
    }
    /**
     * Get EinwilligungserklaerungErlaeutert value
     * @return bool|null
     */
    public function getEinwilligungserklaerungErlaeutert()
    {
        return $this->EinwilligungserklaerungErlaeutert;
    }
    /**
     * Set EinwilligungserklaerungErlaeutert value
     * @param bool $einwilligungserklaerungErlaeutert
     * @return \BiPRO\StructType\CT_Werbeerlaubnis
     */
    public function setEinwilligungserklaerungErlaeutert($einwilligungserklaerungErlaeutert = null)
    {
        // validation for constraint: boolean
        if (!is_null($einwilligungserklaerungErlaeutert) && !is_bool($einwilligungserklaerungErlaeutert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($einwilligungserklaerungErlaeutert, true), gettype($einwilligungserklaerungErlaeutert)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($einwilligungserklaerungErlaeutert) && !preg_match('/true|false/', $einwilligungserklaerungErlaeutert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($einwilligungserklaerungErlaeutert, true)), __LINE__);
        }
        $this->EinwilligungserklaerungErlaeutert = $einwilligungserklaerungErlaeutert;
        return $this;
    }
}
