<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vorschaeden StructType
 * @subpackage Structs
 */
class CT_Vorschaeden extends CT_ZusaetzlichePartnerdaten
{
    /**
     * The Sparte
     * Meta information extracted from the WSDL
     * - documentation: Sparte gemäß GDV-Satz Anlage 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sparte;
    /**
     * The AnzSchaedenLaufendesJahr
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzSchaedenLaufendesJahr;
    /**
     * The AnzSchaedenVorjahr
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzSchaedenVorjahr;
    /**
     * The Fragen
     * Meta information extracted from the WSDL
     * - documentation: Abbildung von Fragen zu Vorschäden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Fragenkomplex[]
     */
    public $Fragen;
    /**
     * Constructor method for CT_Vorschaeden
     * @uses CT_Vorschaeden::setSparte()
     * @uses CT_Vorschaeden::setAnzSchaedenLaufendesJahr()
     * @uses CT_Vorschaeden::setAnzSchaedenVorjahr()
     * @uses CT_Vorschaeden::setFragen()
     * @param string $sparte
     * @param int $anzSchaedenLaufendesJahr
     * @param int $anzSchaedenVorjahr
     * @param \BiPRO\StructType\CT_Fragenkomplex[] $fragen
     */
    public function __construct($sparte = null, $anzSchaedenLaufendesJahr = null, $anzSchaedenVorjahr = null, array $fragen = array())
    {
        $this
            ->setSparte($sparte)
            ->setAnzSchaedenLaufendesJahr($anzSchaedenLaufendesJahr)
            ->setAnzSchaedenVorjahr($anzSchaedenVorjahr)
            ->setFragen($fragen);
    }
    /**
     * Get Sparte value
     * @return string|null
     */
    public function getSparte()
    {
        return $this->Sparte;
    }
    /**
     * Set Sparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sparte
     * @return \BiPRO\StructType\CT_Vorschaeden
     */
    public function setSparte($sparte = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($sparte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($sparte) ? implode(', ', $sparte) : var_export($sparte, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues())), __LINE__);
        }
        $this->Sparte = $sparte;
        return $this;
    }
    /**
     * Get AnzSchaedenLaufendesJahr value
     * @return int|null
     */
    public function getAnzSchaedenLaufendesJahr()
    {
        return $this->AnzSchaedenLaufendesJahr;
    }
    /**
     * Set AnzSchaedenLaufendesJahr value
     * @param int $anzSchaedenLaufendesJahr
     * @return \BiPRO\StructType\CT_Vorschaeden
     */
    public function setAnzSchaedenLaufendesJahr($anzSchaedenLaufendesJahr = null)
    {
        // validation for constraint: int
        if (!is_null($anzSchaedenLaufendesJahr) && !(is_int($anzSchaedenLaufendesJahr) || ctype_digit($anzSchaedenLaufendesJahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzSchaedenLaufendesJahr, true), gettype($anzSchaedenLaufendesJahr)), __LINE__);
        }
        $this->AnzSchaedenLaufendesJahr = $anzSchaedenLaufendesJahr;
        return $this;
    }
    /**
     * Get AnzSchaedenVorjahr value
     * @return int|null
     */
    public function getAnzSchaedenVorjahr()
    {
        return $this->AnzSchaedenVorjahr;
    }
    /**
     * Set AnzSchaedenVorjahr value
     * @param int $anzSchaedenVorjahr
     * @return \BiPRO\StructType\CT_Vorschaeden
     */
    public function setAnzSchaedenVorjahr($anzSchaedenVorjahr = null)
    {
        // validation for constraint: int
        if (!is_null($anzSchaedenVorjahr) && !(is_int($anzSchaedenVorjahr) || ctype_digit($anzSchaedenVorjahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzSchaedenVorjahr, true), gettype($anzSchaedenVorjahr)), __LINE__);
        }
        $this->AnzSchaedenVorjahr = $anzSchaedenVorjahr;
        return $this;
    }
    /**
     * Get Fragen value
     * @return \BiPRO\StructType\CT_Fragenkomplex[]|null
     */
    public function getFragen()
    {
        return $this->Fragen;
    }
    /**
     * This method is responsible for validating the values passed to the setFragen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFragen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFragenForArrayConstraintsFromSetFragen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VorschaedenFragenItem) {
            // validation for constraint: itemType
            if (!$cT_VorschaedenFragenItem instanceof \BiPRO\StructType\CT_Fragenkomplex) {
                $invalidValues[] = is_object($cT_VorschaedenFragenItem) ? get_class($cT_VorschaedenFragenItem) : sprintf('%s(%s)', gettype($cT_VorschaedenFragenItem), var_export($cT_VorschaedenFragenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fragen property can only contain items of type \BiPRO\StructType\CT_Fragenkomplex, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fragen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fragenkomplex[] $fragen
     * @return \BiPRO\StructType\CT_Vorschaeden
     */
    public function setFragen(array $fragen = array())
    {
        // validation for constraint: array
        if ('' !== ($fragenArrayErrorMessage = self::validateFragenForArrayConstraintsFromSetFragen($fragen))) {
            throw new \InvalidArgumentException($fragenArrayErrorMessage, __LINE__);
        }
        $this->Fragen = $fragen;
        return $this;
    }
    /**
     * Add item to Fragen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fragenkomplex $item
     * @return \BiPRO\StructType\CT_Vorschaeden
     */
    public function addToFragen(\BiPRO\StructType\CT_Fragenkomplex $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Fragenkomplex) {
            throw new \InvalidArgumentException(sprintf('The Fragen property can only contain items of type \BiPRO\StructType\CT_Fragenkomplex, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fragen[] = $item;
        return $this;
    }
}
