<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vorschaden StructType
 * @subpackage Structs
 */
class CT_Vorschaden extends CT_Objekt
{
    /**
     * The Vorschaden
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Vorschaden;
    /**
     * The AnzahlVorschaeden
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlVorschaeden;
    /**
     * The Sparte
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sparte;
    /**
     * The Schadenursache
     * Meta information extracted from the WSDL
     * - documentation: Ausprägungen gemäß GDV-Satz Anlage 132.Die gültigen Werte der Schadenursache MÜSSEN dem Katalog ST_KatalogSchadenursache entnommen werden.
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: unbounded
     * - minLength: 4
     * - minOccurs: 0
     * @var string[]
     */
    public $Schadenursache;
    /**
     * The Schadendatum
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Schadendatum;
    /**
     * The Beschreibung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschreibung;
    /**
     * The VorschadenNachbarschaft
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VorschadenNachbarschaft;
    /**
     * The DeckungID
     * Meta information extracted from the WSDL
     * - documentation: Betroffene Deckungsart des Vorschadens. Ergänzend zum Feld Sparte.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Deckung
     */
    public $DeckungID;
    /**
     * The Gefahr
     * Meta information extracted from the WSDL
     * - documentation: Gefahr, auf die sich der Vorschaden bezieht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Gefahr
     */
    public $Gefahr;
    /**
     * The Fragenkomplex
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Fragenkomplex[]
     */
    public $Fragenkomplex;
    /**
     * The Schadenhoehe
     * Meta information extracted from the WSDL
     * - documentation: Höhe des Schadens.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Betrag
     */
    public $Schadenhoehe;
    /**
     * The VersichertDurch
     * Meta information extracted from the WSDL
     * - documentation: Gibt die VorNebenversicherung an, bei der der Vorschaden versichert war.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VorNebenVertrag
     */
    public $VersichertDurch;
    /**
     * Constructor method for CT_Vorschaden
     * @uses CT_Vorschaden::setVorschaden()
     * @uses CT_Vorschaden::setAnzahlVorschaeden()
     * @uses CT_Vorschaden::setSparte()
     * @uses CT_Vorschaden::setSchadenursache()
     * @uses CT_Vorschaden::setSchadendatum()
     * @uses CT_Vorschaden::setBeschreibung()
     * @uses CT_Vorschaden::setVorschadenNachbarschaft()
     * @uses CT_Vorschaden::setDeckungID()
     * @uses CT_Vorschaden::setGefahr()
     * @uses CT_Vorschaden::setFragenkomplex()
     * @uses CT_Vorschaden::setSchadenhoehe()
     * @uses CT_Vorschaden::setVersichertDurch()
     * @param bool $vorschaden
     * @param int $anzahlVorschaeden
     * @param string $sparte
     * @param string[] $schadenursache
     * @param string $schadendatum
     * @param string $beschreibung
     * @param bool $vorschadenNachbarschaft
     * @param \BiPRO\StructType\STE_Deckung $deckungID
     * @param \BiPRO\StructType\STE_Gefahr $gefahr
     * @param \BiPRO\StructType\CT_Fragenkomplex[] $fragenkomplex
     * @param \BiPRO\StructType\CT_Betrag $schadenhoehe
     * @param \BiPRO\StructType\CT_VorNebenVertrag $versichertDurch
     */
    public function __construct($vorschaden = null, $anzahlVorschaeden = null, $sparte = null, array $schadenursache = array(), $schadendatum = null, $beschreibung = null, $vorschadenNachbarschaft = null, \BiPRO\StructType\STE_Deckung $deckungID = null, \BiPRO\StructType\STE_Gefahr $gefahr = null, array $fragenkomplex = array(), \BiPRO\StructType\CT_Betrag $schadenhoehe = null, \BiPRO\StructType\CT_VorNebenVertrag $versichertDurch = null)
    {
        $this
            ->setVorschaden($vorschaden)
            ->setAnzahlVorschaeden($anzahlVorschaeden)
            ->setSparte($sparte)
            ->setSchadenursache($schadenursache)
            ->setSchadendatum($schadendatum)
            ->setBeschreibung($beschreibung)
            ->setVorschadenNachbarschaft($vorschadenNachbarschaft)
            ->setDeckungID($deckungID)
            ->setGefahr($gefahr)
            ->setFragenkomplex($fragenkomplex)
            ->setSchadenhoehe($schadenhoehe)
            ->setVersichertDurch($versichertDurch);
    }
    /**
     * Get Vorschaden value
     * @return bool|null
     */
    public function getVorschaden()
    {
        return $this->Vorschaden;
    }
    /**
     * Set Vorschaden value
     * @param bool $vorschaden
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setVorschaden($vorschaden = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorschaden) && !is_bool($vorschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorschaden, true), gettype($vorschaden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorschaden) && !preg_match('/true|false/', $vorschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorschaden, true)), __LINE__);
        }
        $this->Vorschaden = $vorschaden;
        return $this;
    }
    /**
     * Get AnzahlVorschaeden value
     * @return int|null
     */
    public function getAnzahlVorschaeden()
    {
        return $this->AnzahlVorschaeden;
    }
    /**
     * Set AnzahlVorschaeden value
     * @param int $anzahlVorschaeden
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setAnzahlVorschaeden($anzahlVorschaeden = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlVorschaeden) && !(is_int($anzahlVorschaeden) || ctype_digit($anzahlVorschaeden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlVorschaeden, true), gettype($anzahlVorschaeden)), __LINE__);
        }
        $this->AnzahlVorschaeden = $anzahlVorschaeden;
        return $this;
    }
    /**
     * Get Sparte value
     * @return string|null
     */
    public function getSparte()
    {
        return $this->Sparte;
    }
    /**
     * Set Sparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sparte
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setSparte($sparte = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($sparte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($sparte) ? implode(', ', $sparte) : var_export($sparte, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues())), __LINE__);
        }
        $this->Sparte = $sparte;
        return $this;
    }
    /**
     * Get Schadenursache value
     * @return string[]|null
     */
    public function getSchadenursache()
    {
        return $this->Schadenursache;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenursache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenursache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenursacheForArrayConstraintsFromSetSchadenursache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VorschadenSchadenursacheItem) {
            // validation for constraint: itemType
            if (!is_string($cT_VorschadenSchadenursacheItem)) {
                $invalidValues[] = is_object($cT_VorschadenSchadenursacheItem) ? get_class($cT_VorschadenSchadenursacheItem) : sprintf('%s(%s)', gettype($cT_VorschadenSchadenursacheItem), var_export($cT_VorschadenSchadenursacheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schadenursache property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSchadenursache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenursache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenursacheForMaxLengthConstraintFromSetSchadenursache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VorschadenSchadenursacheItem) {
            // validation for constraint: maxLength(4)
            if (mb_strlen($cT_VorschadenSchadenursacheItem) > 4) {
                $invalidValues[] = var_export($cT_VorschadenSchadenursacheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 4', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSchadenursache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenursache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenursacheForMinLengthConstraintFromSetSchadenursache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VorschadenSchadenursacheItem) {
            // validation for constraint: minLength(4)
            if (mb_strlen($cT_VorschadenSchadenursacheItem) < 4) {
                $invalidValues[] = var_export($cT_VorschadenSchadenursacheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 4', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schadenursache value
     * @throws \InvalidArgumentException
     * @param string[] $schadenursache
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setSchadenursache(array $schadenursache = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenursacheArrayErrorMessage = self::validateSchadenursacheForArrayConstraintsFromSetSchadenursache($schadenursache))) {
            throw new \InvalidArgumentException($schadenursacheArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(4)
        if ('' !== ($schadenursacheMaxLengthErrorMessage = self::validateSchadenursacheForMaxLengthConstraintFromSetSchadenursache($schadenursache))) {
            throw new \InvalidArgumentException($schadenursacheMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(4)
        if ('' !== ($schadenursacheMinLengthErrorMessage = self::validateSchadenursacheForMinLengthConstraintFromSetSchadenursache($schadenursache))) {
            throw new \InvalidArgumentException($schadenursacheMinLengthErrorMessage, __LINE__);
        }
        $this->Schadenursache = $schadenursache;
        return $this;
    }
    /**
     * Add item to Schadenursache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function addToSchadenursache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Schadenursache property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (mb_strlen($item) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(4)
        if (mb_strlen($item) < 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 4', mb_strlen($item)), __LINE__);
        }
        $this->Schadenursache[] = $item;
        return $this;
    }
    /**
     * Get Schadendatum value
     * @return string|null
     */
    public function getSchadendatum()
    {
        return $this->Schadendatum;
    }
    /**
     * Set Schadendatum value
     * @param string $schadendatum
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setSchadendatum($schadendatum = null)
    {
        // validation for constraint: string
        if (!is_null($schadendatum) && !is_string($schadendatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schadendatum, true), gettype($schadendatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($schadendatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $schadendatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($schadendatum, true)), __LINE__);
        }
        $this->Schadendatum = $schadendatum;
        return $this;
    }
    /**
     * Get Beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->Beschreibung;
    }
    /**
     * Set Beschreibung value
     * @param string $beschreibung
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibung)), __LINE__);
        }
        $this->Beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get VorschadenNachbarschaft value
     * @return bool|null
     */
    public function getVorschadenNachbarschaft()
    {
        return $this->VorschadenNachbarschaft;
    }
    /**
     * Set VorschadenNachbarschaft value
     * @param bool $vorschadenNachbarschaft
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setVorschadenNachbarschaft($vorschadenNachbarschaft = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorschadenNachbarschaft) && !is_bool($vorschadenNachbarschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorschadenNachbarschaft, true), gettype($vorschadenNachbarschaft)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorschadenNachbarschaft) && !preg_match('/true|false/', $vorschadenNachbarschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorschadenNachbarschaft, true)), __LINE__);
        }
        $this->VorschadenNachbarschaft = $vorschadenNachbarschaft;
        return $this;
    }
    /**
     * Get DeckungID value
     * @return \BiPRO\StructType\STE_Deckung|null
     */
    public function getDeckungID()
    {
        return $this->DeckungID;
    }
    /**
     * Set DeckungID value
     * @param \BiPRO\StructType\STE_Deckung $deckungID
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setDeckungID(\BiPRO\StructType\STE_Deckung $deckungID = null)
    {
        $this->DeckungID = $deckungID;
        return $this;
    }
    /**
     * Get Gefahr value
     * @return \BiPRO\StructType\STE_Gefahr|null
     */
    public function getGefahr()
    {
        return $this->Gefahr;
    }
    /**
     * Set Gefahr value
     * @param \BiPRO\StructType\STE_Gefahr $gefahr
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setGefahr(\BiPRO\StructType\STE_Gefahr $gefahr = null)
    {
        $this->Gefahr = $gefahr;
        return $this;
    }
    /**
     * Get Fragenkomplex value
     * @return \BiPRO\StructType\CT_Fragenkomplex[]|null
     */
    public function getFragenkomplex()
    {
        return $this->Fragenkomplex;
    }
    /**
     * This method is responsible for validating the values passed to the setFragenkomplex method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFragenkomplex method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFragenkomplexForArrayConstraintsFromSetFragenkomplex(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VorschadenFragenkomplexItem) {
            // validation for constraint: itemType
            if (!$cT_VorschadenFragenkomplexItem instanceof \BiPRO\StructType\CT_Fragenkomplex) {
                $invalidValues[] = is_object($cT_VorschadenFragenkomplexItem) ? get_class($cT_VorschadenFragenkomplexItem) : sprintf('%s(%s)', gettype($cT_VorschadenFragenkomplexItem), var_export($cT_VorschadenFragenkomplexItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fragenkomplex property can only contain items of type \BiPRO\StructType\CT_Fragenkomplex, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fragenkomplex value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fragenkomplex[] $fragenkomplex
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setFragenkomplex(array $fragenkomplex = array())
    {
        // validation for constraint: array
        if ('' !== ($fragenkomplexArrayErrorMessage = self::validateFragenkomplexForArrayConstraintsFromSetFragenkomplex($fragenkomplex))) {
            throw new \InvalidArgumentException($fragenkomplexArrayErrorMessage, __LINE__);
        }
        $this->Fragenkomplex = $fragenkomplex;
        return $this;
    }
    /**
     * Add item to Fragenkomplex value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fragenkomplex $item
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function addToFragenkomplex(\BiPRO\StructType\CT_Fragenkomplex $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Fragenkomplex) {
            throw new \InvalidArgumentException(sprintf('The Fragenkomplex property can only contain items of type \BiPRO\StructType\CT_Fragenkomplex, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fragenkomplex[] = $item;
        return $this;
    }
    /**
     * Get Schadenhoehe value
     * @return \BiPRO\StructType\CT_Betrag|null
     */
    public function getSchadenhoehe()
    {
        return $this->Schadenhoehe;
    }
    /**
     * Set Schadenhoehe value
     * @param \BiPRO\StructType\CT_Betrag $schadenhoehe
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setSchadenhoehe(\BiPRO\StructType\CT_Betrag $schadenhoehe = null)
    {
        $this->Schadenhoehe = $schadenhoehe;
        return $this;
    }
    /**
     * Get VersichertDurch value
     * @return \BiPRO\StructType\CT_VorNebenVertrag|null
     */
    public function getVersichertDurch()
    {
        return $this->VersichertDurch;
    }
    /**
     * Set VersichertDurch value
     * @param \BiPRO\StructType\CT_VorNebenVertrag $versichertDurch
     * @return \BiPRO\StructType\CT_Vorschaden
     */
    public function setVersichertDurch(\BiPRO\StructType\CT_VorNebenVertrag $versichertDurch = null)
    {
        $this->VersichertDurch = $versichertDurch;
        return $this;
    }
}
