<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_VorlaeufigeDeckungKfz StructType
 * @subpackage Structs
 */
class CT_VorlaeufigeDeckungKfz extends CT_ZusaetzlicheAntragsdaten
{
    /**
     * The VorlaeufigeDeckungGewaehrt
     * Meta information extracted from the WSDL
     * - documentation: Der Versicherer gewährt einen vorläufigen Deckungsschutz für die im Attribut Sparte bezeichnete Deckung.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $VorlaeufigeDeckungGewaehrt;
    /**
     * The Sparte
     * Meta information extracted from the WSDL
     * - documentation: Sparte gemäß GDV-Satz Anlage 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sparte;
    /**
     * The AbTagDerZulassung
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AbTagDerZulassung;
    /**
     * The Beginn
     * Meta information extracted from the WSDL
     * - documentation: Beginn der vorläufigen Deckung. | wie ST_Datum, ergänzt um Stunden und Minuten
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]
     * @var string
     */
    public $Beginn;
    /**
     * Constructor method for CT_VorlaeufigeDeckungKfz
     * @uses CT_VorlaeufigeDeckungKfz::setVorlaeufigeDeckungGewaehrt()
     * @uses CT_VorlaeufigeDeckungKfz::setSparte()
     * @uses CT_VorlaeufigeDeckungKfz::setAbTagDerZulassung()
     * @uses CT_VorlaeufigeDeckungKfz::setBeginn()
     * @param bool $vorlaeufigeDeckungGewaehrt
     * @param string $sparte
     * @param bool $abTagDerZulassung
     * @param string $beginn
     */
    public function __construct($vorlaeufigeDeckungGewaehrt = null, $sparte = null, $abTagDerZulassung = null, $beginn = null)
    {
        $this
            ->setVorlaeufigeDeckungGewaehrt($vorlaeufigeDeckungGewaehrt)
            ->setSparte($sparte)
            ->setAbTagDerZulassung($abTagDerZulassung)
            ->setBeginn($beginn);
    }
    /**
     * Get VorlaeufigeDeckungGewaehrt value
     * @return bool
     */
    public function getVorlaeufigeDeckungGewaehrt()
    {
        return $this->VorlaeufigeDeckungGewaehrt;
    }
    /**
     * Set VorlaeufigeDeckungGewaehrt value
     * @param bool $vorlaeufigeDeckungGewaehrt
     * @return \BiPRO\StructType\CT_VorlaeufigeDeckungKfz
     */
    public function setVorlaeufigeDeckungGewaehrt($vorlaeufigeDeckungGewaehrt = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorlaeufigeDeckungGewaehrt) && !is_bool($vorlaeufigeDeckungGewaehrt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorlaeufigeDeckungGewaehrt, true), gettype($vorlaeufigeDeckungGewaehrt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorlaeufigeDeckungGewaehrt) && !preg_match('/true|false/', $vorlaeufigeDeckungGewaehrt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorlaeufigeDeckungGewaehrt, true)), __LINE__);
        }
        $this->VorlaeufigeDeckungGewaehrt = $vorlaeufigeDeckungGewaehrt;
        return $this;
    }
    /**
     * Get Sparte value
     * @return string|null
     */
    public function getSparte()
    {
        return $this->Sparte;
    }
    /**
     * Set Sparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sparte
     * @return \BiPRO\StructType\CT_VorlaeufigeDeckungKfz
     */
    public function setSparte($sparte = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($sparte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($sparte) ? implode(', ', $sparte) : var_export($sparte, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues())), __LINE__);
        }
        $this->Sparte = $sparte;
        return $this;
    }
    /**
     * Get AbTagDerZulassung value
     * @return bool|null
     */
    public function getAbTagDerZulassung()
    {
        return $this->AbTagDerZulassung;
    }
    /**
     * Set AbTagDerZulassung value
     * @param bool $abTagDerZulassung
     * @return \BiPRO\StructType\CT_VorlaeufigeDeckungKfz
     */
    public function setAbTagDerZulassung($abTagDerZulassung = null)
    {
        // validation for constraint: boolean
        if (!is_null($abTagDerZulassung) && !is_bool($abTagDerZulassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abTagDerZulassung, true), gettype($abTagDerZulassung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($abTagDerZulassung) && !preg_match('/true|false/', $abTagDerZulassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($abTagDerZulassung, true)), __LINE__);
        }
        $this->AbTagDerZulassung = $abTagDerZulassung;
        return $this;
    }
    /**
     * Get Beginn value
     * @return string|null
     */
    public function getBeginn()
    {
        return $this->Beginn;
    }
    /**
     * Set Beginn value
     * @param string $beginn
     * @return \BiPRO\StructType\CT_VorlaeufigeDeckungKfz
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9])
        if (!is_null($beginn) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]/', $beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]', var_export($beginn, true)), __LINE__);
        }
        $this->Beginn = $beginn;
        return $this;
    }
}
