<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vorhaben StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Beschreibung eines Bau- oder Montagevorhabens.
 * @subpackage Structs
 */
class CT_Vorhaben extends CT_Gegenstand
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Vorhabens.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ArtID;
    /**
     * The Auftraggeberrisiko
     * Meta information extracted from the WSDL
     * - documentation: Wer haftet für die Bauleistung
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Auftraggeberrisiko;
    /**
     * The Montagezeit
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum der Baumaßnahme bzw Montage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Montagezeit;
    /**
     * The Probebetrieb
     * Meta information extracted from the WSDL
     * - documentation: Dauer des Probebetriebes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Probebetrieb;
    /**
     * The Objektanschrift
     * Meta information extracted from the WSDL
     * - documentation: Anschrift des Bau- Montagevorhabens.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Objektanschrift
     */
    public $Objektanschrift;
    /**
     * The Fertigstellung
     * Meta information extracted from the WSDL
     * - documentation: Datum der Fertigstellung des Vorhabens. Auch geplante Fertigstellung. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Fertigstellung;
    /**
     * The Abnahme
     * Meta information extracted from the WSDL
     * - documentation: Datum der Abnahme des Vorhabens. Auch geplante Abnahme. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Abnahme;
    /**
     * The TeilweiseBenutzung
     * Meta information extracted from the WSDL
     * - documentation: Datum, ab wann eine teilweise Benutzung geplant ist / möglich war. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $TeilweiseBenutzung;
    /**
     * The VollstaendigeBenutzung
     * Meta information extracted from the WSDL
     * - documentation: Datum, ab wann eine vollständige Benutzung geplant ist / möglich war. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $VollstaendigeBenutzung;
    /**
     * The Inbetriebnahme
     * Meta information extracted from the WSDL
     * - documentation: Datum der Inbetriebnahme des Vorhabens. Auch geplante Inberiebnahme. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Inbetriebnahme;
    /**
     * The Garantiezeit
     * Meta information extracted from the WSDL
     * - documentation: Dauer der Garantiezeit.Der Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und Ende MÜSSEN mit einem vollständigen Datum definiert sein. Die Angabe einer Zeit oder einer Zeitzone DARF NICHT erfolgen..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $Garantiezeit;
    /**
     * Constructor method for CT_Vorhaben
     * @uses CT_Vorhaben::setArtID()
     * @uses CT_Vorhaben::setAuftraggeberrisiko()
     * @uses CT_Vorhaben::setMontagezeit()
     * @uses CT_Vorhaben::setProbebetrieb()
     * @uses CT_Vorhaben::setObjektanschrift()
     * @uses CT_Vorhaben::setFertigstellung()
     * @uses CT_Vorhaben::setAbnahme()
     * @uses CT_Vorhaben::setTeilweiseBenutzung()
     * @uses CT_Vorhaben::setVollstaendigeBenutzung()
     * @uses CT_Vorhaben::setInbetriebnahme()
     * @uses CT_Vorhaben::setGarantiezeit()
     * @param string[] $artID
     * @param string[] $auftraggeberrisiko
     * @param \BiPRO\StructType\CT_Zeitraum $montagezeit
     * @param \BiPRO\StructType\CT_Zeitraum $probebetrieb
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @param string $fertigstellung
     * @param string $abnahme
     * @param string $teilweiseBenutzung
     * @param string $vollstaendigeBenutzung
     * @param string $inbetriebnahme
     * @param \BiPRO\StructType\CT_Zeitraum2 $garantiezeit
     */
    public function __construct(array $artID = array(), array $auftraggeberrisiko = array(), \BiPRO\StructType\CT_Zeitraum $montagezeit = null, \BiPRO\StructType\CT_Zeitraum $probebetrieb = null, \BiPRO\StructType\CT_Objektanschrift $objektanschrift = null, $fertigstellung = null, $abnahme = null, $teilweiseBenutzung = null, $vollstaendigeBenutzung = null, $inbetriebnahme = null, \BiPRO\StructType\CT_Zeitraum2 $garantiezeit = null)
    {
        $this
            ->setArtID($artID)
            ->setAuftraggeberrisiko($auftraggeberrisiko)
            ->setMontagezeit($montagezeit)
            ->setProbebetrieb($probebetrieb)
            ->setObjektanschrift($objektanschrift)
            ->setFertigstellung($fertigstellung)
            ->setAbnahme($abnahme)
            ->setTeilweiseBenutzung($teilweiseBenutzung)
            ->setVollstaendigeBenutzung($vollstaendigeBenutzung)
            ->setInbetriebnahme($inbetriebnahme)
            ->setGarantiezeit($garantiezeit);
    }
    /**
     * Get ArtID value
     * @return string[]|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * This method is responsible for validating the values passed to the setArtID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArtIDForArrayConstraintsFromSetArtID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VorhabenArtIDItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_ArtDesVorhabens::valueIsValid($cT_VorhabenArtIDItem)) {
                $invalidValues[] = is_object($cT_VorhabenArtIDItem) ? get_class($cT_VorhabenArtIDItem) : sprintf('%s(%s)', gettype($cT_VorhabenArtIDItem), var_export($cT_VorhabenArtIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDesVorhabens', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_ArtDesVorhabens::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_ArtDesVorhabens::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDesVorhabens::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $artID
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setArtID(array $artID = array())
    {
        // validation for constraint: array
        if ('' !== ($artIDArrayErrorMessage = self::validateArtIDForArrayConstraintsFromSetArtID($artID))) {
            throw new \InvalidArgumentException($artIDArrayErrorMessage, __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Add item to ArtID value
     * @uses \BiPRO\EnumType\ST_ArtDesVorhabens::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDesVorhabens::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function addToArtID($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDesVorhabens::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDesVorhabens', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_ArtDesVorhabens::getValidValues())), __LINE__);
        }
        $this->ArtID[] = $item;
        return $this;
    }
    /**
     * Get Auftraggeberrisiko value
     * @return string[]|null
     */
    public function getAuftraggeberrisiko()
    {
        return $this->Auftraggeberrisiko;
    }
    /**
     * This method is responsible for validating the values passed to the setAuftraggeberrisiko method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuftraggeberrisiko method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuftraggeberrisikoForArrayConstraintsFromSetAuftraggeberrisiko(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VorhabenAuftraggeberrisikoItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_Auftraggeber::valueIsValid($cT_VorhabenAuftraggeberrisikoItem)) {
                $invalidValues[] = is_object($cT_VorhabenAuftraggeberrisikoItem) ? get_class($cT_VorhabenAuftraggeberrisikoItem) : sprintf('%s(%s)', gettype($cT_VorhabenAuftraggeberrisikoItem), var_export($cT_VorhabenAuftraggeberrisikoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Auftraggeber', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_Auftraggeber::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Auftraggeberrisiko value
     * @uses \BiPRO\EnumType\ST_Auftraggeber::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Auftraggeber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $auftraggeberrisiko
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setAuftraggeberrisiko(array $auftraggeberrisiko = array())
    {
        // validation for constraint: array
        if ('' !== ($auftraggeberrisikoArrayErrorMessage = self::validateAuftraggeberrisikoForArrayConstraintsFromSetAuftraggeberrisiko($auftraggeberrisiko))) {
            throw new \InvalidArgumentException($auftraggeberrisikoArrayErrorMessage, __LINE__);
        }
        $this->Auftraggeberrisiko = $auftraggeberrisiko;
        return $this;
    }
    /**
     * Add item to Auftraggeberrisiko value
     * @uses \BiPRO\EnumType\ST_Auftraggeber::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Auftraggeber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function addToAuftraggeberrisiko($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Auftraggeber::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Auftraggeber', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_Auftraggeber::getValidValues())), __LINE__);
        }
        $this->Auftraggeberrisiko[] = $item;
        return $this;
    }
    /**
     * Get Montagezeit value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getMontagezeit()
    {
        return $this->Montagezeit;
    }
    /**
     * Set Montagezeit value
     * @param \BiPRO\StructType\CT_Zeitraum $montagezeit
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setMontagezeit(\BiPRO\StructType\CT_Zeitraum $montagezeit = null)
    {
        $this->Montagezeit = $montagezeit;
        return $this;
    }
    /**
     * Get Probebetrieb value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getProbebetrieb()
    {
        return $this->Probebetrieb;
    }
    /**
     * Set Probebetrieb value
     * @param \BiPRO\StructType\CT_Zeitraum $probebetrieb
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setProbebetrieb(\BiPRO\StructType\CT_Zeitraum $probebetrieb = null)
    {
        $this->Probebetrieb = $probebetrieb;
        return $this;
    }
    /**
     * Get Objektanschrift value
     * @return \BiPRO\StructType\CT_Objektanschrift|null
     */
    public function getObjektanschrift()
    {
        return $this->Objektanschrift;
    }
    /**
     * Set Objektanschrift value
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setObjektanschrift(\BiPRO\StructType\CT_Objektanschrift $objektanschrift = null)
    {
        $this->Objektanschrift = $objektanschrift;
        return $this;
    }
    /**
     * Get Fertigstellung value
     * @return string|null
     */
    public function getFertigstellung()
    {
        return $this->Fertigstellung;
    }
    /**
     * Set Fertigstellung value
     * @param string $fertigstellung
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setFertigstellung($fertigstellung = null)
    {
        // validation for constraint: string
        if (!is_null($fertigstellung) && !is_string($fertigstellung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fertigstellung, true), gettype($fertigstellung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($fertigstellung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $fertigstellung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($fertigstellung, true)), __LINE__);
        }
        $this->Fertigstellung = $fertigstellung;
        return $this;
    }
    /**
     * Get Abnahme value
     * @return string|null
     */
    public function getAbnahme()
    {
        return $this->Abnahme;
    }
    /**
     * Set Abnahme value
     * @param string $abnahme
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setAbnahme($abnahme = null)
    {
        // validation for constraint: string
        if (!is_null($abnahme) && !is_string($abnahme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abnahme, true), gettype($abnahme)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($abnahme) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $abnahme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($abnahme, true)), __LINE__);
        }
        $this->Abnahme = $abnahme;
        return $this;
    }
    /**
     * Get TeilweiseBenutzung value
     * @return string|null
     */
    public function getTeilweiseBenutzung()
    {
        return $this->TeilweiseBenutzung;
    }
    /**
     * Set TeilweiseBenutzung value
     * @param string $teilweiseBenutzung
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setTeilweiseBenutzung($teilweiseBenutzung = null)
    {
        // validation for constraint: string
        if (!is_null($teilweiseBenutzung) && !is_string($teilweiseBenutzung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teilweiseBenutzung, true), gettype($teilweiseBenutzung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($teilweiseBenutzung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $teilweiseBenutzung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($teilweiseBenutzung, true)), __LINE__);
        }
        $this->TeilweiseBenutzung = $teilweiseBenutzung;
        return $this;
    }
    /**
     * Get VollstaendigeBenutzung value
     * @return string|null
     */
    public function getVollstaendigeBenutzung()
    {
        return $this->VollstaendigeBenutzung;
    }
    /**
     * Set VollstaendigeBenutzung value
     * @param string $vollstaendigeBenutzung
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setVollstaendigeBenutzung($vollstaendigeBenutzung = null)
    {
        // validation for constraint: string
        if (!is_null($vollstaendigeBenutzung) && !is_string($vollstaendigeBenutzung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vollstaendigeBenutzung, true), gettype($vollstaendigeBenutzung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($vollstaendigeBenutzung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $vollstaendigeBenutzung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($vollstaendigeBenutzung, true)), __LINE__);
        }
        $this->VollstaendigeBenutzung = $vollstaendigeBenutzung;
        return $this;
    }
    /**
     * Get Inbetriebnahme value
     * @return string|null
     */
    public function getInbetriebnahme()
    {
        return $this->Inbetriebnahme;
    }
    /**
     * Set Inbetriebnahme value
     * @param string $inbetriebnahme
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setInbetriebnahme($inbetriebnahme = null)
    {
        // validation for constraint: string
        if (!is_null($inbetriebnahme) && !is_string($inbetriebnahme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inbetriebnahme, true), gettype($inbetriebnahme)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($inbetriebnahme) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $inbetriebnahme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($inbetriebnahme, true)), __LINE__);
        }
        $this->Inbetriebnahme = $inbetriebnahme;
        return $this;
    }
    /**
     * Get Garantiezeit value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getGarantiezeit()
    {
        return $this->Garantiezeit;
    }
    /**
     * Set Garantiezeit value
     * @param \BiPRO\StructType\CT_Zeitraum2 $garantiezeit
     * @return \BiPRO\StructType\CT_Vorhaben
     */
    public function setGarantiezeit(\BiPRO\StructType\CT_Zeitraum2 $garantiezeit = null)
    {
        $this->Garantiezeit = $garantiezeit;
        return $this;
    }
}
