<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vertragsnummer StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifizierende Nummer für einen Vertrag (z.B. Versicherungsscheinnummer, Kontonummer, Depotnummer).
 * @subpackage Structs
 */
class CT_Vertragsnummer extends CT_Objekt
{
    /**
     * The Versicherungsscheinnummer
     * Meta information extracted from the WSDL
     * - documentation: Ordnungsbegriff eines Versicherers zur Verwaltung von Versicherungsveträgen. | Auspraegungen gemaess GDV-Satzart 0200, Teildatensatz 1, Nr. 5;Leerstellen linksbündig auffüllen.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Versicherungsscheinnummer;
    /**
     * The Vorgangsnummer
     * Meta information extracted from the WSDL
     * - documentation: Ist noch keine Vertragsnummer zugewiesen worden, dient die Vorgangsnummer, die vom produktgebenden Unternehmen bei der Einreichung eines Antrags vergeben wurde, zur Identifizierung. | Datentyp zur Identifizierung von
     * Geschäftsvorgängen.Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen; ab da erfolgt eine Anpassung auf 35 Stellen.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vorgangsnummer;
    /**
     * The Kontonummer
     * Meta information extracted from the WSDL
     * - documentation: Identifizierung eines Anlagekontos. Bei Investmentdepots auch die Nummer des Abwicklungskontos. | Abweichend vom GDV (dort sind 12 Stellen definiert).
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kontonummer;
    /**
     * The Depotnummer
     * Meta information extracted from the WSDL
     * - documentation: Identifizierung eines Depots
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Depotnummer;
    /**
     * The DruckaufbereiteteVertragsnummer
     * Meta information extracted from the WSDL
     * - documentation: Druckaufbereitete Vertragsnummer wie sie auf einem Dokument (z.B. Police) inklusive aller Alpha- und Sonderzeichen angegeben wird. Es ist zu empfehlen dieses Attribut zu füllen, wenn die systemtechnische Vertragsnummer von der
     * druckaufbereiteten Vertragsnummer abweicht.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $DruckaufbereiteteVertragsnummer;
    /**
     * The VertragsverbindungsnummerGDV
     * Meta information extracted from the WSDL
     * - documentation: Ordnungsmerkmal zur Kennzeichnung fachlich zusammengehöriger Verträge (z.B. innerhalb eines Verkaufsproduktes). Entspricht der Vertragsverbindungsnummer beim GDV.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: unbounded
     * - minLength: 0
     * - minOccurs: 0
     * @var string[]
     */
    public $VertragsverbindungsnummerGDV;
    /**
     * Constructor method for CT_Vertragsnummer
     * @uses CT_Vertragsnummer::setVersicherungsscheinnummer()
     * @uses CT_Vertragsnummer::setVorgangsnummer()
     * @uses CT_Vertragsnummer::setKontonummer()
     * @uses CT_Vertragsnummer::setDepotnummer()
     * @uses CT_Vertragsnummer::setDruckaufbereiteteVertragsnummer()
     * @uses CT_Vertragsnummer::setVertragsverbindungsnummerGDV()
     * @param string $versicherungsscheinnummer
     * @param string $vorgangsnummer
     * @param string $kontonummer
     * @param string $depotnummer
     * @param string $druckaufbereiteteVertragsnummer
     * @param string[] $vertragsverbindungsnummerGDV
     */
    public function __construct($versicherungsscheinnummer = null, $vorgangsnummer = null, $kontonummer = null, $depotnummer = null, $druckaufbereiteteVertragsnummer = null, array $vertragsverbindungsnummerGDV = array())
    {
        $this
            ->setVersicherungsscheinnummer($versicherungsscheinnummer)
            ->setVorgangsnummer($vorgangsnummer)
            ->setKontonummer($kontonummer)
            ->setDepotnummer($depotnummer)
            ->setDruckaufbereiteteVertragsnummer($druckaufbereiteteVertragsnummer)
            ->setVertragsverbindungsnummerGDV($vertragsverbindungsnummerGDV);
    }
    /**
     * Get Versicherungsscheinnummer value
     * @return string|null
     */
    public function getVersicherungsscheinnummer()
    {
        return $this->Versicherungsscheinnummer;
    }
    /**
     * Set Versicherungsscheinnummer value
     * @param string $versicherungsscheinnummer
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function setVersicherungsscheinnummer($versicherungsscheinnummer = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsscheinnummer) && !is_string($versicherungsscheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsscheinnummer, true), gettype($versicherungsscheinnummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($versicherungsscheinnummer) && mb_strlen($versicherungsscheinnummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($versicherungsscheinnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($versicherungsscheinnummer) && mb_strlen($versicherungsscheinnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($versicherungsscheinnummer)), __LINE__);
        }
        $this->Versicherungsscheinnummer = $versicherungsscheinnummer;
        return $this;
    }
    /**
     * Get Vorgangsnummer value
     * @return string|null
     */
    public function getVorgangsnummer()
    {
        return $this->Vorgangsnummer;
    }
    /**
     * Set Vorgangsnummer value
     * @param string $vorgangsnummer
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function setVorgangsnummer($vorgangsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($vorgangsnummer) && !is_string($vorgangsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorgangsnummer, true), gettype($vorgangsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($vorgangsnummer) && mb_strlen($vorgangsnummer) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($vorgangsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorgangsnummer) && mb_strlen($vorgangsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorgangsnummer)), __LINE__);
        }
        $this->Vorgangsnummer = $vorgangsnummer;
        return $this;
    }
    /**
     * Get Kontonummer value
     * @return string|null
     */
    public function getKontonummer()
    {
        return $this->Kontonummer;
    }
    /**
     * Set Kontonummer value
     * @param string $kontonummer
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function setKontonummer($kontonummer = null)
    {
        // validation for constraint: string
        if (!is_null($kontonummer) && !is_string($kontonummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontonummer, true), gettype($kontonummer)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kontonummer) && mb_strlen($kontonummer) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kontonummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kontonummer) && mb_strlen($kontonummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kontonummer)), __LINE__);
        }
        $this->Kontonummer = $kontonummer;
        return $this;
    }
    /**
     * Get Depotnummer value
     * @return string|null
     */
    public function getDepotnummer()
    {
        return $this->Depotnummer;
    }
    /**
     * Set Depotnummer value
     * @param string $depotnummer
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function setDepotnummer($depotnummer = null)
    {
        // validation for constraint: string
        if (!is_null($depotnummer) && !is_string($depotnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depotnummer, true), gettype($depotnummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($depotnummer) && mb_strlen($depotnummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($depotnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($depotnummer) && mb_strlen($depotnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($depotnummer)), __LINE__);
        }
        $this->Depotnummer = $depotnummer;
        return $this;
    }
    /**
     * Get DruckaufbereiteteVertragsnummer value
     * @return string|null
     */
    public function getDruckaufbereiteteVertragsnummer()
    {
        return $this->DruckaufbereiteteVertragsnummer;
    }
    /**
     * Set DruckaufbereiteteVertragsnummer value
     * @param string $druckaufbereiteteVertragsnummer
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function setDruckaufbereiteteVertragsnummer($druckaufbereiteteVertragsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($druckaufbereiteteVertragsnummer) && !is_string($druckaufbereiteteVertragsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($druckaufbereiteteVertragsnummer, true), gettype($druckaufbereiteteVertragsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($druckaufbereiteteVertragsnummer) && mb_strlen($druckaufbereiteteVertragsnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($druckaufbereiteteVertragsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($druckaufbereiteteVertragsnummer) && mb_strlen($druckaufbereiteteVertragsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($druckaufbereiteteVertragsnummer)), __LINE__);
        }
        $this->DruckaufbereiteteVertragsnummer = $druckaufbereiteteVertragsnummer;
        return $this;
    }
    /**
     * Get VertragsverbindungsnummerGDV value
     * @return string[]|null
     */
    public function getVertragsverbindungsnummerGDV()
    {
        return $this->VertragsverbindungsnummerGDV;
    }
    /**
     * This method is responsible for validating the values passed to the setVertragsverbindungsnummerGDV method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVertragsverbindungsnummerGDV method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVertragsverbindungsnummerGDVForArrayConstraintsFromSetVertragsverbindungsnummerGDV(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragsnummerVertragsverbindungsnummerGDVItem) {
            // validation for constraint: itemType
            if (!is_string($cT_VertragsnummerVertragsverbindungsnummerGDVItem)) {
                $invalidValues[] = is_object($cT_VertragsnummerVertragsverbindungsnummerGDVItem) ? get_class($cT_VertragsnummerVertragsverbindungsnummerGDVItem) : sprintf('%s(%s)', gettype($cT_VertragsnummerVertragsverbindungsnummerGDVItem), var_export($cT_VertragsnummerVertragsverbindungsnummerGDVItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VertragsverbindungsnummerGDV property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setVertragsverbindungsnummerGDV method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVertragsverbindungsnummerGDV method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVertragsverbindungsnummerGDVForMaxLengthConstraintFromSetVertragsverbindungsnummerGDV($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragsnummerVertragsverbindungsnummerGDVItem) {
            // validation for constraint: maxLength(35)
            if (mb_strlen($cT_VertragsnummerVertragsverbindungsnummerGDVItem) > 35) {
                $invalidValues[] = var_export($cT_VertragsnummerVertragsverbindungsnummerGDVItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 35', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setVertragsverbindungsnummerGDV method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVertragsverbindungsnummerGDV method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVertragsverbindungsnummerGDVForMinLengthConstraintFromSetVertragsverbindungsnummerGDV($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragsnummerVertragsverbindungsnummerGDVItem) {
            // validation for constraint: minLength
            if (mb_strlen($cT_VertragsnummerVertragsverbindungsnummerGDVItem) < 0) {
                $invalidValues[] = var_export($cT_VertragsnummerVertragsverbindungsnummerGDVItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 0', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VertragsverbindungsnummerGDV value
     * @throws \InvalidArgumentException
     * @param string[] $vertragsverbindungsnummerGDV
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function setVertragsverbindungsnummerGDV(array $vertragsverbindungsnummerGDV = array())
    {
        // validation for constraint: array
        if ('' !== ($vertragsverbindungsnummerGDVArrayErrorMessage = self::validateVertragsverbindungsnummerGDVForArrayConstraintsFromSetVertragsverbindungsnummerGDV($vertragsverbindungsnummerGDV))) {
            throw new \InvalidArgumentException($vertragsverbindungsnummerGDVArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(35)
        if ('' !== ($vertragsverbindungsnummerGDVMaxLengthErrorMessage = self::validateVertragsverbindungsnummerGDVForMaxLengthConstraintFromSetVertragsverbindungsnummerGDV($vertragsverbindungsnummerGDV))) {
            throw new \InvalidArgumentException($vertragsverbindungsnummerGDVMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength
        if ('' !== ($vertragsverbindungsnummerGDVMinLengthErrorMessage = self::validateVertragsverbindungsnummerGDVForMinLengthConstraintFromSetVertragsverbindungsnummerGDV($vertragsverbindungsnummerGDV))) {
            throw new \InvalidArgumentException($vertragsverbindungsnummerGDVMinLengthErrorMessage, __LINE__);
        }
        $this->VertragsverbindungsnummerGDV = $vertragsverbindungsnummerGDV;
        return $this;
    }
    /**
     * Add item to VertragsverbindungsnummerGDV value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function addToVertragsverbindungsnummerGDV($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VertragsverbindungsnummerGDV property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (mb_strlen($item) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength
        if (mb_strlen($item) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($item)), __LINE__);
        }
        $this->VertragsverbindungsnummerGDV[] = $item;
        return $this;
    }
}
