<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vertrag StructType
 * @subpackage Structs
 */
class CT_Vertrag extends CT_Objekt
{
    /**
     * The Verkaufsprodukt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Verkaufsprodukt[]
     */
    public $Verkaufsprodukt;
    /**
     * The Vertragsnummer
     * Meta information extracted from the WSDL
     * - documentation: Zu einem bestehenden Vertrag kann sich aufgrund der Übernahme durch einen anderen Produktanbieter oder durch interne Reorganisationen oder Systemwechsel die Vertragsnummer ändern.Grundsätzlich MUSS ein Vertrag mit aktueller
     * Vertragsnummer (Referenz Vertragsnummer) und Hinweis auf die alte (abweichende) Vertragsnummer (Referenz AlteVertragsnummer) zumindest bei der ersten Lieferung nach der Nummernänderung geliefert werden. Dabei MUSS die Gevo-Art 130019002 (Änderung
     * der Vertragsnummer) verwendet werden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Vertragsnummer
     */
    public $Vertragsnummer;
    /**
     * The Abgangsdatum
     * Meta information extracted from the WSDL
     * - documentation: Stornodatum des Vertrags. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Abgangsdatum;
    /**
     * The Abgangsgrund
     * Meta information extracted from the WSDL
     * - documentation: Grund für den Abgang des Vertrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Abgangsgrund;
    /**
     * The AktenzeichenVM
     * Meta information extracted from the WSDL
     * - documentation: Zuordnungsmerkmal des Vermittlers, z. B. Niederlassung/Büro des Vermittlers, Sachbearbeiter des Vermittlers, Vertragsnummer des Vermittlers. Das im Antrag übermittelte AktenzeichenVM MUSS vom Versicherer bei der Policierung zum
     * Vertrag gespeichert und bei vertragsbezogenen Geschäftsvorgängen im Objekt Vertrag ausgegeben werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AktenzeichenVM;
    /**
     * The Antragsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Antragsaufnahme des Vertrags.Gilt auch für Änderungsanträge. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Antragsdatum;
    /**
     * The Antragsstatus
     * Meta information extracted from the WSDL
     * - documentation: Status des Antrags
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Antragsstatus;
    /**
     * The GueltigAbDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, zu dem dieser Vertragsstand gültig wurde/wird. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $GueltigAbDatum;
    /**
     * The GueltigBisDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, zu bis zu dem dieser Vertragsstand gültig war/ist. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $GueltigBisDatum;
    /**
     * The Hauptfaelligkeit
     * Meta information extracted from the WSDL
     * - documentation: Das jeweils folgende Hauptfälligkeitsdatum des Vertrags. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Hauptfaelligkeit;
    /**
     * The Inkassoart
     * Meta information extracted from the WSDL
     * - documentation: Inkassoart des Vertrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Inkassoart;
    /**
     * The Kuendigungsklausel
     * Meta information extracted from the WSDL
     * - documentation: Bei kurzfristigen Verträgen sowie bei Verträgen, die nicht automatisch verlängert werden: "Nein".Sonst: "Ja".
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Kuendigungsklausel;
    /**
     * The Vertragsbeginn
     * Meta information extracted from the WSDL
     * - documentation: Erstbeginn des Vertrags. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Vertragsbeginn;
    /**
     * The Vertragsstatus
     * Meta information extracted from the WSDL
     * - documentation: Der Status des Vertrags, z.B. lebend, storniert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vertragsstatus;
    /**
     * The Zahlungsart
     * Meta information extracted from the WSDL
     * - documentation: Zahlungsart bzw. -weg des Vertrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungsart;
    /**
     * The Zahlungsweise
     * Meta information extracted from the WSDL
     * - documentation: Die Zahlungsweise des Vertrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungsweise;
    /**
     * The Vermittler
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vermittler[]
     */
    public $Vermittler;
    /**
     * The Partner
     * Meta information extracted from the WSDL
     * - documentation: Partnerliste. Diese Verknüpfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Partner in Form einer Liste innerhalb des konkreten Vertrages. Referenziert werden diese Partner mit Hilfe der von
     * Partnerrolle abgeleiteten Rollen.Im Kontext einer Vertragsübermittlung (z. B. ÜvB) MUSS eine Partnerliste angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partner[]
     */
    public $Partner;
    /**
     * The Gegenstand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Gegenstand[]
     */
    public $Gegenstand;
    /**
     * The Beitragszahler
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitragszahler
     */
    public $Beitragszahler;
    /**
     * The Aktivitaet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Aktivitaet[]
     */
    public $Aktivitaet;
    /**
     * The AktenzeichenVertragspartner
     * Meta information extracted from the WSDL
     * - documentation: Zuordnungsmerkmal des Vertragspartners (Versicherungsnehmers - VN), z. B. Niederlassung, Betriebsstätte, Abteilung, Kostenstelle des VN. Das im Antrag übermittelte AktenzeichenVertragspartner MUSS vom Provider bei der Policierung
     * zum Vertrag gespeichert und bei vertragsbezogenen Geschäftsvorgängen im Objekt Vertrag ausgegeben werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AktenzeichenVertragspartner;
    /**
     * The Aenderungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem die Änderung erfolgt ist (Bearbeitungsdatum). | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Aenderungsdatum;
    /**
     * The Aenderungsgrund
     * Meta information extracted from the WSDL
     * - documentation: Grund der Änderung, die zu dem Vertragszustand geführt hat. | Art des Geschäftsvorgang. Konkrete Werte und deren Bedeutung im Kontext der BiPRO-Normen sind in BiPRO allg. Anlage 1 Gesamtliste GeVo-Arten.xlsx definiert.
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: \d{9}
     * @var string[]
     */
    public $Aenderungsgrund;
    /**
     * The AntragsnummerVM
     * Meta information extracted from the WSDL
     * - documentation: Antragsnummer, die vom Vermittler vergeben wird. Gilt auch für Änderungsanträge. | Datentyp zur Identifizierung von Geschäftsvorgängen.Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen;
     * ab da erfolgt eine Anpassung auf 35 Stellen.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AntragsnummerVM;
    /**
     * The Antragseingangsdatum
     * Meta information extracted from the WSDL
     * - documentation: Eingangsdatum des Antrags beim Unternehmen. Gilt auch für Änderungsanträge. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Antragseingangsdatum;
    /**
     * The Policierungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem der Antrag dokumentiert wurde. Gilt auch für Änderungsanträge. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Policierungsdatum;
    /**
     * The Vertragsentstehung
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, wie der Vertrag zu Stande gekommen ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vertragsentstehung;
    /**
     * The ArtDerBeratung
     * Meta information extracted from the WSDL
     * - documentation: Art der Kundenberatung vor dem Verkauf.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDerBeratung;
    /**
     * The Antragsnummer
     * Meta information extracted from the WSDL
     * - documentation: Antragsnummer, die vom produktgebenden Unternehmen vergeben wird. Gilt auch für Änderungsanträge. | Datentyp zur Identifizierung von Geschäftsvorgängen.Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp
     * nur 17 Stellen; ab da erfolgt eine Anpassung auf 35 Stellen.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Antragsnummer;
    /**
     * The AlteVertragsnummer
     * Meta information extracted from the WSDL
     * - documentation: Alte Nummer des Vertrags oder Nummer des alten Vertrags, aus dem dieser Vertrag entstanden ist (z.B. durch Vertragsänderung).Hintergrund: Zu einem bestehenden Vertrag kann sich aufgrund der Übernahme durch einen anderen
     * Produktanbieter oder durch interne Reorganisationen oder Systemwechsel die Vertragsnummer ändern. Auch können bestimmte Änderungen an einem bestehenden Vertrag dazu führen, dass im Ergebnis ein neuer Vertrag entsteht.Bei Nummernänderung gilt:
     * Grundsätzlich MUSS ein Vertrag mit aktueller Vertragsnummer (Referenz Vertragsnummer) und Hinweis auf die alte (abweichende) Vertragsnummer (Referenz AlteVertragsnummer) zumindest bei der ersten Lieferung nach der Nummernänderung geliefert werden.
     * Dabei MUSS die Gevo-Art 130019002 (Änderung der Vertragsnummer) verwendet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer
     */
    public $AlteVertragsnummer;
    /**
     * The Personengruppe
     * Meta information extracted from the WSDL
     * - documentation: Personengruppenliste.Diese Verknuepfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Personengruppen in Form einer Liste innerhalb des konkreten Vertrags. Referenziert werden diese Personengruppen mit
     * Hilfe der von Personengruppenrolle abgeleiteten Rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Personengruppe[]
     */
    public $Personengruppe;
    /**
     * The BearbeitendeStelle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_BearbeitendeStelle
     */
    public $BearbeitendeStelle;
    /**
     * The VertragsnummerVM
     * Meta information extracted from the WSDL
     * - documentation: Vertragsnummer, die vom Vermittler vergeben wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer
     */
    public $VertragsnummerVM;
    /**
     * The Vertragsverbindungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Referenz eines Vertrages auf einen anderen Vertrag (z.B. Rahmenvertrag, Gruppenvertrag), um beispielsweise auf die Standardvereinbarungen und Konditionen des referenzierten Vertrages zu verweisen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer[]
     */
    public $Vertragsverbindungsnummer;
    /**
     * The Vertragspartner
     * Meta information extracted from the WSDL
     * - documentation: Im Kontext einer Vertragsübermittlung (z. B. ÜvB) MUSS ein Vertragspartner angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragspartner
     */
    public $Vertragspartner;
    /**
     * The Leistungsstoerung
     * Meta information extracted from the WSDL
     * - documentation: JA = Die Leistungsgewährung zu diesem Vertrag ist gestört (z. B. Vertrag befindet sich im Mahnverfahren).NEIN = Die Leistungsgewährung zu diesem Vertrag ist nicht gestört.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Leistungsstoerung;
    /**
     * The Zahltermin
     * Meta information extracted from the WSDL
     * - documentation: Kalendertag an dem die Zahlung des Beitrags fällig ist. | Zur Abbildung von Kalendertagen.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-3][0-9]
     * @var string
     */
    public $Zahltermin;
    /**
     * The ZusaetzlicheVertragsdaten
     * Meta information extracted from the WSDL
     * - documentation: Zusätzliche, z.B. spartenspezifische, Daten zum Vertrag.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten[]
     */
    public $ZusaetzlicheVertragsdaten;
    /**
     * Constructor method for CT_Vertrag
     * @uses CT_Vertrag::setVerkaufsprodukt()
     * @uses CT_Vertrag::setVertragsnummer()
     * @uses CT_Vertrag::setAbgangsdatum()
     * @uses CT_Vertrag::setAbgangsgrund()
     * @uses CT_Vertrag::setAktenzeichenVM()
     * @uses CT_Vertrag::setAntragsdatum()
     * @uses CT_Vertrag::setAntragsstatus()
     * @uses CT_Vertrag::setGueltigAbDatum()
     * @uses CT_Vertrag::setGueltigBisDatum()
     * @uses CT_Vertrag::setHauptfaelligkeit()
     * @uses CT_Vertrag::setInkassoart()
     * @uses CT_Vertrag::setKuendigungsklausel()
     * @uses CT_Vertrag::setVertragsbeginn()
     * @uses CT_Vertrag::setVertragsstatus()
     * @uses CT_Vertrag::setZahlungsart()
     * @uses CT_Vertrag::setZahlungsweise()
     * @uses CT_Vertrag::setVermittler()
     * @uses CT_Vertrag::setPartner()
     * @uses CT_Vertrag::setGegenstand()
     * @uses CT_Vertrag::setBeitragszahler()
     * @uses CT_Vertrag::setAktivitaet()
     * @uses CT_Vertrag::setAktenzeichenVertragspartner()
     * @uses CT_Vertrag::setAenderungsdatum()
     * @uses CT_Vertrag::setAenderungsgrund()
     * @uses CT_Vertrag::setAntragsnummerVM()
     * @uses CT_Vertrag::setAntragseingangsdatum()
     * @uses CT_Vertrag::setPolicierungsdatum()
     * @uses CT_Vertrag::setVertragsentstehung()
     * @uses CT_Vertrag::setArtDerBeratung()
     * @uses CT_Vertrag::setAntragsnummer()
     * @uses CT_Vertrag::setAlteVertragsnummer()
     * @uses CT_Vertrag::setPersonengruppe()
     * @uses CT_Vertrag::setBearbeitendeStelle()
     * @uses CT_Vertrag::setVertragsnummerVM()
     * @uses CT_Vertrag::setVertragsverbindungsnummer()
     * @uses CT_Vertrag::setVertragspartner()
     * @uses CT_Vertrag::setLeistungsstoerung()
     * @uses CT_Vertrag::setZahltermin()
     * @uses CT_Vertrag::setZusaetzlicheVertragsdaten()
     * @param \BiPRO\StructType\CT_Verkaufsprodukt[] $verkaufsprodukt
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     * @param string $abgangsdatum
     * @param string $abgangsgrund
     * @param string $aktenzeichenVM
     * @param string $antragsdatum
     * @param string $antragsstatus
     * @param string $gueltigAbDatum
     * @param string $gueltigBisDatum
     * @param string $hauptfaelligkeit
     * @param string $inkassoart
     * @param bool $kuendigungsklausel
     * @param string $vertragsbeginn
     * @param string $vertragsstatus
     * @param string $zahlungsart
     * @param string $zahlungsweise
     * @param \BiPRO\StructType\CT_Vermittler[] $vermittler
     * @param \BiPRO\StructType\CT_Partner[] $partner
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     * @param \BiPRO\StructType\CT_Beitragszahler $beitragszahler
     * @param \BiPRO\StructType\CT_Aktivitaet[] $aktivitaet
     * @param string $aktenzeichenVertragspartner
     * @param string $aenderungsdatum
     * @param string[] $aenderungsgrund
     * @param string $antragsnummerVM
     * @param string $antragseingangsdatum
     * @param string $policierungsdatum
     * @param string $vertragsentstehung
     * @param string $artDerBeratung
     * @param string $antragsnummer
     * @param \BiPRO\StructType\CT_Vertragsnummer $alteVertragsnummer
     * @param \BiPRO\StructType\CT_Personengruppe[] $personengruppe
     * @param \BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummerVM
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $vertragsverbindungsnummer
     * @param \BiPRO\StructType\CT_Vertragspartner $vertragspartner
     * @param bool $leistungsstoerung
     * @param string $zahltermin
     * @param \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten[] $zusaetzlicheVertragsdaten
     */
    public function __construct(array $verkaufsprodukt = array(), \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null, $abgangsdatum = null, $abgangsgrund = null, $aktenzeichenVM = null, $antragsdatum = null, $antragsstatus = null, $gueltigAbDatum = null, $gueltigBisDatum = null, $hauptfaelligkeit = null, $inkassoart = null, $kuendigungsklausel = null, $vertragsbeginn = null, $vertragsstatus = null, $zahlungsart = null, $zahlungsweise = null, array $vermittler = array(), array $partner = array(), array $gegenstand = array(), \BiPRO\StructType\CT_Beitragszahler $beitragszahler = null, array $aktivitaet = array(), $aktenzeichenVertragspartner = null, $aenderungsdatum = null, array $aenderungsgrund = array(), $antragsnummerVM = null, $antragseingangsdatum = null, $policierungsdatum = null, $vertragsentstehung = null, $artDerBeratung = null, $antragsnummer = null, \BiPRO\StructType\CT_Vertragsnummer $alteVertragsnummer = null, array $personengruppe = array(), \BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle = null, \BiPRO\StructType\CT_Vertragsnummer $vertragsnummerVM = null, array $vertragsverbindungsnummer = array(), \BiPRO\StructType\CT_Vertragspartner $vertragspartner = null, $leistungsstoerung = null, $zahltermin = null, array $zusaetzlicheVertragsdaten = array())
    {
        $this
            ->setVerkaufsprodukt($verkaufsprodukt)
            ->setVertragsnummer($vertragsnummer)
            ->setAbgangsdatum($abgangsdatum)
            ->setAbgangsgrund($abgangsgrund)
            ->setAktenzeichenVM($aktenzeichenVM)
            ->setAntragsdatum($antragsdatum)
            ->setAntragsstatus($antragsstatus)
            ->setGueltigAbDatum($gueltigAbDatum)
            ->setGueltigBisDatum($gueltigBisDatum)
            ->setHauptfaelligkeit($hauptfaelligkeit)
            ->setInkassoart($inkassoart)
            ->setKuendigungsklausel($kuendigungsklausel)
            ->setVertragsbeginn($vertragsbeginn)
            ->setVertragsstatus($vertragsstatus)
            ->setZahlungsart($zahlungsart)
            ->setZahlungsweise($zahlungsweise)
            ->setVermittler($vermittler)
            ->setPartner($partner)
            ->setGegenstand($gegenstand)
            ->setBeitragszahler($beitragszahler)
            ->setAktivitaet($aktivitaet)
            ->setAktenzeichenVertragspartner($aktenzeichenVertragspartner)
            ->setAenderungsdatum($aenderungsdatum)
            ->setAenderungsgrund($aenderungsgrund)
            ->setAntragsnummerVM($antragsnummerVM)
            ->setAntragseingangsdatum($antragseingangsdatum)
            ->setPolicierungsdatum($policierungsdatum)
            ->setVertragsentstehung($vertragsentstehung)
            ->setArtDerBeratung($artDerBeratung)
            ->setAntragsnummer($antragsnummer)
            ->setAlteVertragsnummer($alteVertragsnummer)
            ->setPersonengruppe($personengruppe)
            ->setBearbeitendeStelle($bearbeitendeStelle)
            ->setVertragsnummerVM($vertragsnummerVM)
            ->setVertragsverbindungsnummer($vertragsverbindungsnummer)
            ->setVertragspartner($vertragspartner)
            ->setLeistungsstoerung($leistungsstoerung)
            ->setZahltermin($zahltermin)
            ->setZusaetzlicheVertragsdaten($zusaetzlicheVertragsdaten);
    }
    /**
     * Get Verkaufsprodukt value
     * @return \BiPRO\StructType\CT_Verkaufsprodukt[]
     */
    public function getVerkaufsprodukt()
    {
        return $this->Verkaufsprodukt;
    }
    /**
     * This method is responsible for validating the values passed to the setVerkaufsprodukt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerkaufsprodukt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerkaufsproduktForArrayConstraintsFromSetVerkaufsprodukt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragVerkaufsproduktItem) {
            // validation for constraint: itemType
            if (!$cT_VertragVerkaufsproduktItem instanceof \BiPRO\StructType\CT_Verkaufsprodukt) {
                $invalidValues[] = is_object($cT_VertragVerkaufsproduktItem) ? get_class($cT_VertragVerkaufsproduktItem) : sprintf('%s(%s)', gettype($cT_VertragVerkaufsproduktItem), var_export($cT_VertragVerkaufsproduktItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Verkaufsprodukt property can only contain items of type \BiPRO\StructType\CT_Verkaufsprodukt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Verkaufsprodukt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verkaufsprodukt[] $verkaufsprodukt
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVerkaufsprodukt(array $verkaufsprodukt = array())
    {
        // validation for constraint: array
        if ('' !== ($verkaufsproduktArrayErrorMessage = self::validateVerkaufsproduktForArrayConstraintsFromSetVerkaufsprodukt($verkaufsprodukt))) {
            throw new \InvalidArgumentException($verkaufsproduktArrayErrorMessage, __LINE__);
        }
        $this->Verkaufsprodukt = $verkaufsprodukt;
        return $this;
    }
    /**
     * Add item to Verkaufsprodukt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verkaufsprodukt $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToVerkaufsprodukt(\BiPRO\StructType\CT_Verkaufsprodukt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Verkaufsprodukt) {
            throw new \InvalidArgumentException(sprintf('The Verkaufsprodukt property can only contain items of type \BiPRO\StructType\CT_Verkaufsprodukt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Verkaufsprodukt[] = $item;
        return $this;
    }
    /**
     * Get Vertragsnummer value
     * @return \BiPRO\StructType\CT_Vertragsnummer
     */
    public function getVertragsnummer()
    {
        return $this->Vertragsnummer;
    }
    /**
     * Set Vertragsnummer value
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVertragsnummer(\BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null)
    {
        $this->Vertragsnummer = $vertragsnummer;
        return $this;
    }
    /**
     * Get Abgangsdatum value
     * @return string|null
     */
    public function getAbgangsdatum()
    {
        return $this->Abgangsdatum;
    }
    /**
     * Set Abgangsdatum value
     * @param string $abgangsdatum
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAbgangsdatum($abgangsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($abgangsdatum) && !is_string($abgangsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abgangsdatum, true), gettype($abgangsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($abgangsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $abgangsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($abgangsdatum, true)), __LINE__);
        }
        $this->Abgangsdatum = $abgangsdatum;
        return $this;
    }
    /**
     * Get Abgangsgrund value
     * @return string|null
     */
    public function getAbgangsgrund()
    {
        return $this->Abgangsgrund;
    }
    /**
     * Set Abgangsgrund value
     * @uses \BiPRO\EnumType\ST_Abgangsgrund::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Abgangsgrund::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abgangsgrund
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAbgangsgrund($abgangsgrund = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Abgangsgrund::valueIsValid($abgangsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Abgangsgrund', is_array($abgangsgrund) ? implode(', ', $abgangsgrund) : var_export($abgangsgrund, true), implode(', ', \BiPRO\EnumType\ST_Abgangsgrund::getValidValues())), __LINE__);
        }
        $this->Abgangsgrund = $abgangsgrund;
        return $this;
    }
    /**
     * Get AktenzeichenVM value
     * @return string|null
     */
    public function getAktenzeichenVM()
    {
        return $this->AktenzeichenVM;
    }
    /**
     * Set AktenzeichenVM value
     * @param string $aktenzeichenVM
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAktenzeichenVM($aktenzeichenVM = null)
    {
        // validation for constraint: string
        if (!is_null($aktenzeichenVM) && !is_string($aktenzeichenVM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktenzeichenVM, true), gettype($aktenzeichenVM)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aktenzeichenVM) && mb_strlen($aktenzeichenVM) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aktenzeichenVM)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aktenzeichenVM) && mb_strlen($aktenzeichenVM) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aktenzeichenVM)), __LINE__);
        }
        $this->AktenzeichenVM = $aktenzeichenVM;
        return $this;
    }
    /**
     * Get Antragsdatum value
     * @return string|null
     */
    public function getAntragsdatum()
    {
        return $this->Antragsdatum;
    }
    /**
     * Set Antragsdatum value
     * @param string $antragsdatum
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAntragsdatum($antragsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($antragsdatum) && !is_string($antragsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antragsdatum, true), gettype($antragsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($antragsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $antragsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($antragsdatum, true)), __LINE__);
        }
        $this->Antragsdatum = $antragsdatum;
        return $this;
    }
    /**
     * Get Antragsstatus value
     * @return string|null
     */
    public function getAntragsstatus()
    {
        return $this->Antragsstatus;
    }
    /**
     * Set Antragsstatus value
     * @uses \BiPRO\EnumType\ST_Antragsstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Antragsstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $antragsstatus
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAntragsstatus($antragsstatus = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Antragsstatus::valueIsValid($antragsstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Antragsstatus', is_array($antragsstatus) ? implode(', ', $antragsstatus) : var_export($antragsstatus, true), implode(', ', \BiPRO\EnumType\ST_Antragsstatus::getValidValues())), __LINE__);
        }
        $this->Antragsstatus = $antragsstatus;
        return $this;
    }
    /**
     * Get GueltigAbDatum value
     * @return string|null
     */
    public function getGueltigAbDatum()
    {
        return $this->GueltigAbDatum;
    }
    /**
     * Set GueltigAbDatum value
     * @param string $gueltigAbDatum
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setGueltigAbDatum($gueltigAbDatum = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigAbDatum) && !is_string($gueltigAbDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigAbDatum, true), gettype($gueltigAbDatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($gueltigAbDatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $gueltigAbDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($gueltigAbDatum, true)), __LINE__);
        }
        $this->GueltigAbDatum = $gueltigAbDatum;
        return $this;
    }
    /**
     * Get GueltigBisDatum value
     * @return string|null
     */
    public function getGueltigBisDatum()
    {
        return $this->GueltigBisDatum;
    }
    /**
     * Set GueltigBisDatum value
     * @param string $gueltigBisDatum
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setGueltigBisDatum($gueltigBisDatum = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigBisDatum) && !is_string($gueltigBisDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigBisDatum, true), gettype($gueltigBisDatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($gueltigBisDatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $gueltigBisDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($gueltigBisDatum, true)), __LINE__);
        }
        $this->GueltigBisDatum = $gueltigBisDatum;
        return $this;
    }
    /**
     * Get Hauptfaelligkeit value
     * @return string|null
     */
    public function getHauptfaelligkeit()
    {
        return $this->Hauptfaelligkeit;
    }
    /**
     * Set Hauptfaelligkeit value
     * @param string $hauptfaelligkeit
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setHauptfaelligkeit($hauptfaelligkeit = null)
    {
        // validation for constraint: string
        if (!is_null($hauptfaelligkeit) && !is_string($hauptfaelligkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hauptfaelligkeit, true), gettype($hauptfaelligkeit)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($hauptfaelligkeit) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $hauptfaelligkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($hauptfaelligkeit, true)), __LINE__);
        }
        $this->Hauptfaelligkeit = $hauptfaelligkeit;
        return $this;
    }
    /**
     * Get Inkassoart value
     * @return string|null
     */
    public function getInkassoart()
    {
        return $this->Inkassoart;
    }
    /**
     * Set Inkassoart value
     * @uses \BiPRO\EnumType\ST_Inkassoart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Inkassoart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inkassoart
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setInkassoart($inkassoart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Inkassoart::valueIsValid($inkassoart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Inkassoart', is_array($inkassoart) ? implode(', ', $inkassoart) : var_export($inkassoart, true), implode(', ', \BiPRO\EnumType\ST_Inkassoart::getValidValues())), __LINE__);
        }
        $this->Inkassoart = $inkassoart;
        return $this;
    }
    /**
     * Get Kuendigungsklausel value
     * @return bool|null
     */
    public function getKuendigungsklausel()
    {
        return $this->Kuendigungsklausel;
    }
    /**
     * Set Kuendigungsklausel value
     * @param bool $kuendigungsklausel
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setKuendigungsklausel($kuendigungsklausel = null)
    {
        // validation for constraint: boolean
        if (!is_null($kuendigungsklausel) && !is_bool($kuendigungsklausel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kuendigungsklausel, true), gettype($kuendigungsklausel)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($kuendigungsklausel) && !preg_match('/true|false/', $kuendigungsklausel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($kuendigungsklausel, true)), __LINE__);
        }
        $this->Kuendigungsklausel = $kuendigungsklausel;
        return $this;
    }
    /**
     * Get Vertragsbeginn value
     * @return string|null
     */
    public function getVertragsbeginn()
    {
        return $this->Vertragsbeginn;
    }
    /**
     * Set Vertragsbeginn value
     * @param string $vertragsbeginn
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVertragsbeginn($vertragsbeginn = null)
    {
        // validation for constraint: string
        if (!is_null($vertragsbeginn) && !is_string($vertragsbeginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vertragsbeginn, true), gettype($vertragsbeginn)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($vertragsbeginn) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $vertragsbeginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($vertragsbeginn, true)), __LINE__);
        }
        $this->Vertragsbeginn = $vertragsbeginn;
        return $this;
    }
    /**
     * Get Vertragsstatus value
     * @return string|null
     */
    public function getVertragsstatus()
    {
        return $this->Vertragsstatus;
    }
    /**
     * Set Vertragsstatus value
     * @uses \BiPRO\EnumType\ST_Vertragsstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vertragsstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vertragsstatus
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVertragsstatus($vertragsstatus = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vertragsstatus::valueIsValid($vertragsstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vertragsstatus', is_array($vertragsstatus) ? implode(', ', $vertragsstatus) : var_export($vertragsstatus, true), implode(', ', \BiPRO\EnumType\ST_Vertragsstatus::getValidValues())), __LINE__);
        }
        $this->Vertragsstatus = $vertragsstatus;
        return $this;
    }
    /**
     * Get Zahlungsart value
     * @return string|null
     */
    public function getZahlungsart()
    {
        return $this->Zahlungsart;
    }
    /**
     * Set Zahlungsart value
     * @uses \BiPRO\EnumType\ST_Zahlungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsart
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setZahlungsart($zahlungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsart::valueIsValid($zahlungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsart', is_array($zahlungsart) ? implode(', ', $zahlungsart) : var_export($zahlungsart, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsart::getValidValues())), __LINE__);
        }
        $this->Zahlungsart = $zahlungsart;
        return $this;
    }
    /**
     * Get Zahlungsweise value
     * @return string|null
     */
    public function getZahlungsweise()
    {
        return $this->Zahlungsweise;
    }
    /**
     * Set Zahlungsweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsweise
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setZahlungsweise($zahlungsweise = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($zahlungsweise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($zahlungsweise) ? implode(', ', $zahlungsweise) : var_export($zahlungsweise, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues())), __LINE__);
        }
        $this->Zahlungsweise = $zahlungsweise;
        return $this;
    }
    /**
     * Get Vermittler value
     * @return \BiPRO\StructType\CT_Vermittler[]|null
     */
    public function getVermittler()
    {
        return $this->Vermittler;
    }
    /**
     * This method is responsible for validating the values passed to the setVermittler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermittler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermittlerForArrayConstraintsFromSetVermittler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragVermittlerItem) {
            // validation for constraint: itemType
            if (!$cT_VertragVermittlerItem instanceof \BiPRO\StructType\CT_Vermittler) {
                $invalidValues[] = is_object($cT_VertragVermittlerItem) ? get_class($cT_VertragVermittlerItem) : sprintf('%s(%s)', gettype($cT_VertragVermittlerItem), var_export($cT_VertragVermittlerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vermittler property can only contain items of type \BiPRO\StructType\CT_Vermittler, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vermittler value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittler[] $vermittler
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVermittler(array $vermittler = array())
    {
        // validation for constraint: array
        if ('' !== ($vermittlerArrayErrorMessage = self::validateVermittlerForArrayConstraintsFromSetVermittler($vermittler))) {
            throw new \InvalidArgumentException($vermittlerArrayErrorMessage, __LINE__);
        }
        $this->Vermittler = $vermittler;
        return $this;
    }
    /**
     * Add item to Vermittler value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittler $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToVermittler(\BiPRO\StructType\CT_Vermittler $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vermittler) {
            throw new \InvalidArgumentException(sprintf('The Vermittler property can only contain items of type \BiPRO\StructType\CT_Vermittler, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vermittler[] = $item;
        return $this;
    }
    /**
     * Get Partner value
     * @return \BiPRO\StructType\CT_Partner[]|null
     */
    public function getPartner()
    {
        return $this->Partner;
    }
    /**
     * This method is responsible for validating the values passed to the setPartner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerForArrayConstraintsFromSetPartner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragPartnerItem) {
            // validation for constraint: itemType
            if (!$cT_VertragPartnerItem instanceof \BiPRO\StructType\CT_Partner) {
                $invalidValues[] = is_object($cT_VertragPartnerItem) ? get_class($cT_VertragPartnerItem) : sprintf('%s(%s)', gettype($cT_VertragPartnerItem), var_export($cT_VertragPartnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner[] $partner
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setPartner(array $partner = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerArrayErrorMessage = self::validatePartnerForArrayConstraintsFromSetPartner($partner))) {
            throw new \InvalidArgumentException($partnerArrayErrorMessage, __LINE__);
        }
        $this->Partner = $partner;
        return $this;
    }
    /**
     * Add item to Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToPartner(\BiPRO\StructType\CT_Partner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Partner) {
            throw new \InvalidArgumentException(sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Partner[] = $item;
        return $this;
    }
    /**
     * Get Gegenstand value
     * @return \BiPRO\StructType\CT_Gegenstand[]|null
     */
    public function getGegenstand()
    {
        return $this->Gegenstand;
    }
    /**
     * This method is responsible for validating the values passed to the setGegenstand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGegenstand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGegenstandForArrayConstraintsFromSetGegenstand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragGegenstandItem) {
            // validation for constraint: itemType
            if (!$cT_VertragGegenstandItem instanceof \BiPRO\StructType\CT_Gegenstand) {
                $invalidValues[] = is_object($cT_VertragGegenstandItem) ? get_class($cT_VertragGegenstandItem) : sprintf('%s(%s)', gettype($cT_VertragGegenstandItem), var_export($cT_VertragGegenstandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setGegenstand(array $gegenstand = array())
    {
        // validation for constraint: array
        if ('' !== ($gegenstandArrayErrorMessage = self::validateGegenstandForArrayConstraintsFromSetGegenstand($gegenstand))) {
            throw new \InvalidArgumentException($gegenstandArrayErrorMessage, __LINE__);
        }
        $this->Gegenstand = $gegenstand;
        return $this;
    }
    /**
     * Add item to Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToGegenstand(\BiPRO\StructType\CT_Gegenstand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Gegenstand) {
            throw new \InvalidArgumentException(sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Gegenstand[] = $item;
        return $this;
    }
    /**
     * Get Beitragszahler value
     * @return \BiPRO\StructType\CT_Beitragszahler|null
     */
    public function getBeitragszahler()
    {
        return $this->Beitragszahler;
    }
    /**
     * Set Beitragszahler value
     * @param \BiPRO\StructType\CT_Beitragszahler $beitragszahler
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setBeitragszahler(\BiPRO\StructType\CT_Beitragszahler $beitragszahler = null)
    {
        $this->Beitragszahler = $beitragszahler;
        return $this;
    }
    /**
     * Get Aktivitaet value
     * @return \BiPRO\StructType\CT_Aktivitaet[]|null
     */
    public function getAktivitaet()
    {
        return $this->Aktivitaet;
    }
    /**
     * This method is responsible for validating the values passed to the setAktivitaet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAktivitaet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAktivitaetForArrayConstraintsFromSetAktivitaet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragAktivitaetItem) {
            // validation for constraint: itemType
            if (!$cT_VertragAktivitaetItem instanceof \BiPRO\StructType\CT_Aktivitaet) {
                $invalidValues[] = is_object($cT_VertragAktivitaetItem) ? get_class($cT_VertragAktivitaetItem) : sprintf('%s(%s)', gettype($cT_VertragAktivitaetItem), var_export($cT_VertragAktivitaetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Aktivitaet property can only contain items of type \BiPRO\StructType\CT_Aktivitaet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Aktivitaet value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Aktivitaet[] $aktivitaet
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAktivitaet(array $aktivitaet = array())
    {
        // validation for constraint: array
        if ('' !== ($aktivitaetArrayErrorMessage = self::validateAktivitaetForArrayConstraintsFromSetAktivitaet($aktivitaet))) {
            throw new \InvalidArgumentException($aktivitaetArrayErrorMessage, __LINE__);
        }
        $this->Aktivitaet = $aktivitaet;
        return $this;
    }
    /**
     * Add item to Aktivitaet value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Aktivitaet $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToAktivitaet(\BiPRO\StructType\CT_Aktivitaet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Aktivitaet) {
            throw new \InvalidArgumentException(sprintf('The Aktivitaet property can only contain items of type \BiPRO\StructType\CT_Aktivitaet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Aktivitaet[] = $item;
        return $this;
    }
    /**
     * Get AktenzeichenVertragspartner value
     * @return string|null
     */
    public function getAktenzeichenVertragspartner()
    {
        return $this->AktenzeichenVertragspartner;
    }
    /**
     * Set AktenzeichenVertragspartner value
     * @param string $aktenzeichenVertragspartner
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAktenzeichenVertragspartner($aktenzeichenVertragspartner = null)
    {
        // validation for constraint: string
        if (!is_null($aktenzeichenVertragspartner) && !is_string($aktenzeichenVertragspartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktenzeichenVertragspartner, true), gettype($aktenzeichenVertragspartner)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aktenzeichenVertragspartner) && mb_strlen($aktenzeichenVertragspartner) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aktenzeichenVertragspartner)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aktenzeichenVertragspartner) && mb_strlen($aktenzeichenVertragspartner) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aktenzeichenVertragspartner)), __LINE__);
        }
        $this->AktenzeichenVertragspartner = $aktenzeichenVertragspartner;
        return $this;
    }
    /**
     * Get Aenderungsdatum value
     * @return string|null
     */
    public function getAenderungsdatum()
    {
        return $this->Aenderungsdatum;
    }
    /**
     * Set Aenderungsdatum value
     * @param string $aenderungsdatum
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAenderungsdatum($aenderungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($aenderungsdatum) && !is_string($aenderungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aenderungsdatum, true), gettype($aenderungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($aenderungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $aenderungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($aenderungsdatum, true)), __LINE__);
        }
        $this->Aenderungsdatum = $aenderungsdatum;
        return $this;
    }
    /**
     * Get Aenderungsgrund value
     * @return string[]|null
     */
    public function getAenderungsgrund()
    {
        return $this->Aenderungsgrund;
    }
    /**
     * This method is responsible for validating the values passed to the setAenderungsgrund method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAenderungsgrund method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAenderungsgrundForArrayConstraintsFromSetAenderungsgrund(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragAenderungsgrundItem) {
            // validation for constraint: itemType
            if (!is_string($cT_VertragAenderungsgrundItem)) {
                $invalidValues[] = is_object($cT_VertragAenderungsgrundItem) ? get_class($cT_VertragAenderungsgrundItem) : sprintf('%s(%s)', gettype($cT_VertragAenderungsgrundItem), var_export($cT_VertragAenderungsgrundItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Aenderungsgrund property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Aenderungsgrund value
     * @throws \InvalidArgumentException
     * @param string[] $aenderungsgrund
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAenderungsgrund(array $aenderungsgrund = array())
    {
        // validation for constraint: array
        if ('' !== ($aenderungsgrundArrayErrorMessage = self::validateAenderungsgrundForArrayConstraintsFromSetAenderungsgrund($aenderungsgrund))) {
            throw new \InvalidArgumentException($aenderungsgrundArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\d{9})
        if (!is_null($aenderungsgrund) && !preg_match('/\\d{9}/', $aenderungsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}', var_export($aenderungsgrund, true)), __LINE__);
        }
        $this->Aenderungsgrund = $aenderungsgrund;
        return $this;
    }
    /**
     * Add item to Aenderungsgrund value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToAenderungsgrund($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Aenderungsgrund property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: pattern(\d{9})
        if (!preg_match('/\\d{9}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}', var_export($item, true)), __LINE__);
        }
        $this->Aenderungsgrund[] = $item;
        return $this;
    }
    /**
     * Get AntragsnummerVM value
     * @return string|null
     */
    public function getAntragsnummerVM()
    {
        return $this->AntragsnummerVM;
    }
    /**
     * Set AntragsnummerVM value
     * @param string $antragsnummerVM
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAntragsnummerVM($antragsnummerVM = null)
    {
        // validation for constraint: string
        if (!is_null($antragsnummerVM) && !is_string($antragsnummerVM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antragsnummerVM, true), gettype($antragsnummerVM)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($antragsnummerVM) && mb_strlen($antragsnummerVM) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($antragsnummerVM)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($antragsnummerVM) && mb_strlen($antragsnummerVM) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($antragsnummerVM)), __LINE__);
        }
        $this->AntragsnummerVM = $antragsnummerVM;
        return $this;
    }
    /**
     * Get Antragseingangsdatum value
     * @return string|null
     */
    public function getAntragseingangsdatum()
    {
        return $this->Antragseingangsdatum;
    }
    /**
     * Set Antragseingangsdatum value
     * @param string $antragseingangsdatum
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAntragseingangsdatum($antragseingangsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($antragseingangsdatum) && !is_string($antragseingangsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antragseingangsdatum, true), gettype($antragseingangsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($antragseingangsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $antragseingangsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($antragseingangsdatum, true)), __LINE__);
        }
        $this->Antragseingangsdatum = $antragseingangsdatum;
        return $this;
    }
    /**
     * Get Policierungsdatum value
     * @return string|null
     */
    public function getPolicierungsdatum()
    {
        return $this->Policierungsdatum;
    }
    /**
     * Set Policierungsdatum value
     * @param string $policierungsdatum
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setPolicierungsdatum($policierungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($policierungsdatum) && !is_string($policierungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policierungsdatum, true), gettype($policierungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($policierungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $policierungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($policierungsdatum, true)), __LINE__);
        }
        $this->Policierungsdatum = $policierungsdatum;
        return $this;
    }
    /**
     * Get Vertragsentstehung value
     * @return string|null
     */
    public function getVertragsentstehung()
    {
        return $this->Vertragsentstehung;
    }
    /**
     * Set Vertragsentstehung value
     * @uses \BiPRO\EnumType\ST_Vertragsentstehung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vertragsentstehung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vertragsentstehung
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVertragsentstehung($vertragsentstehung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vertragsentstehung::valueIsValid($vertragsentstehung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vertragsentstehung', is_array($vertragsentstehung) ? implode(', ', $vertragsentstehung) : var_export($vertragsentstehung, true), implode(', ', \BiPRO\EnumType\ST_Vertragsentstehung::getValidValues())), __LINE__);
        }
        $this->Vertragsentstehung = $vertragsentstehung;
        return $this;
    }
    /**
     * Get ArtDerBeratung value
     * @return string|null
     */
    public function getArtDerBeratung()
    {
        return $this->ArtDerBeratung;
    }
    /**
     * Set ArtDerBeratung value
     * @uses \BiPRO\EnumType\ST_ArtDerBeratung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDerBeratung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDerBeratung
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setArtDerBeratung($artDerBeratung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDerBeratung::valueIsValid($artDerBeratung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDerBeratung', is_array($artDerBeratung) ? implode(', ', $artDerBeratung) : var_export($artDerBeratung, true), implode(', ', \BiPRO\EnumType\ST_ArtDerBeratung::getValidValues())), __LINE__);
        }
        $this->ArtDerBeratung = $artDerBeratung;
        return $this;
    }
    /**
     * Get Antragsnummer value
     * @return string|null
     */
    public function getAntragsnummer()
    {
        return $this->Antragsnummer;
    }
    /**
     * Set Antragsnummer value
     * @param string $antragsnummer
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAntragsnummer($antragsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($antragsnummer) && !is_string($antragsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antragsnummer, true), gettype($antragsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($antragsnummer) && mb_strlen($antragsnummer) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($antragsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($antragsnummer) && mb_strlen($antragsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($antragsnummer)), __LINE__);
        }
        $this->Antragsnummer = $antragsnummer;
        return $this;
    }
    /**
     * Get AlteVertragsnummer value
     * @return \BiPRO\StructType\CT_Vertragsnummer|null
     */
    public function getAlteVertragsnummer()
    {
        return $this->AlteVertragsnummer;
    }
    /**
     * Set AlteVertragsnummer value
     * @param \BiPRO\StructType\CT_Vertragsnummer $alteVertragsnummer
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setAlteVertragsnummer(\BiPRO\StructType\CT_Vertragsnummer $alteVertragsnummer = null)
    {
        $this->AlteVertragsnummer = $alteVertragsnummer;
        return $this;
    }
    /**
     * Get Personengruppe value
     * @return \BiPRO\StructType\CT_Personengruppe[]|null
     */
    public function getPersonengruppe()
    {
        return $this->Personengruppe;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonengruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonengruppe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonengruppeForArrayConstraintsFromSetPersonengruppe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragPersonengruppeItem) {
            // validation for constraint: itemType
            if (!$cT_VertragPersonengruppeItem instanceof \BiPRO\StructType\CT_Personengruppe) {
                $invalidValues[] = is_object($cT_VertragPersonengruppeItem) ? get_class($cT_VertragPersonengruppeItem) : sprintf('%s(%s)', gettype($cT_VertragPersonengruppeItem), var_export($cT_VertragPersonengruppeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Personengruppe property can only contain items of type \BiPRO\StructType\CT_Personengruppe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Personengruppe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Personengruppe[] $personengruppe
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setPersonengruppe(array $personengruppe = array())
    {
        // validation for constraint: array
        if ('' !== ($personengruppeArrayErrorMessage = self::validatePersonengruppeForArrayConstraintsFromSetPersonengruppe($personengruppe))) {
            throw new \InvalidArgumentException($personengruppeArrayErrorMessage, __LINE__);
        }
        $this->Personengruppe = $personengruppe;
        return $this;
    }
    /**
     * Add item to Personengruppe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Personengruppe $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToPersonengruppe(\BiPRO\StructType\CT_Personengruppe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Personengruppe) {
            throw new \InvalidArgumentException(sprintf('The Personengruppe property can only contain items of type \BiPRO\StructType\CT_Personengruppe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Personengruppe[] = $item;
        return $this;
    }
    /**
     * Get BearbeitendeStelle value
     * @return \BiPRO\StructType\CT_BearbeitendeStelle|null
     */
    public function getBearbeitendeStelle()
    {
        return $this->BearbeitendeStelle;
    }
    /**
     * Set BearbeitendeStelle value
     * @param \BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setBearbeitendeStelle(\BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle = null)
    {
        $this->BearbeitendeStelle = $bearbeitendeStelle;
        return $this;
    }
    /**
     * Get VertragsnummerVM value
     * @return \BiPRO\StructType\CT_Vertragsnummer|null
     */
    public function getVertragsnummerVM()
    {
        return $this->VertragsnummerVM;
    }
    /**
     * Set VertragsnummerVM value
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummerVM
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVertragsnummerVM(\BiPRO\StructType\CT_Vertragsnummer $vertragsnummerVM = null)
    {
        $this->VertragsnummerVM = $vertragsnummerVM;
        return $this;
    }
    /**
     * Get Vertragsverbindungsnummer value
     * @return \BiPRO\StructType\CT_Vertragsnummer[]|null
     */
    public function getVertragsverbindungsnummer()
    {
        return $this->Vertragsverbindungsnummer;
    }
    /**
     * This method is responsible for validating the values passed to the setVertragsverbindungsnummer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVertragsverbindungsnummer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVertragsverbindungsnummerForArrayConstraintsFromSetVertragsverbindungsnummer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragVertragsverbindungsnummerItem) {
            // validation for constraint: itemType
            if (!$cT_VertragVertragsverbindungsnummerItem instanceof \BiPRO\StructType\CT_Vertragsnummer) {
                $invalidValues[] = is_object($cT_VertragVertragsverbindungsnummerItem) ? get_class($cT_VertragVertragsverbindungsnummerItem) : sprintf('%s(%s)', gettype($cT_VertragVertragsverbindungsnummerItem), var_export($cT_VertragVertragsverbindungsnummerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vertragsverbindungsnummer property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vertragsverbindungsnummer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $vertragsverbindungsnummer
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVertragsverbindungsnummer(array $vertragsverbindungsnummer = array())
    {
        // validation for constraint: array
        if ('' !== ($vertragsverbindungsnummerArrayErrorMessage = self::validateVertragsverbindungsnummerForArrayConstraintsFromSetVertragsverbindungsnummer($vertragsverbindungsnummer))) {
            throw new \InvalidArgumentException($vertragsverbindungsnummerArrayErrorMessage, __LINE__);
        }
        $this->Vertragsverbindungsnummer = $vertragsverbindungsnummer;
        return $this;
    }
    /**
     * Add item to Vertragsverbindungsnummer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToVertragsverbindungsnummer(\BiPRO\StructType\CT_Vertragsnummer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vertragsnummer) {
            throw new \InvalidArgumentException(sprintf('The Vertragsverbindungsnummer property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vertragsverbindungsnummer[] = $item;
        return $this;
    }
    /**
     * Get Vertragspartner value
     * @return \BiPRO\StructType\CT_Vertragspartner|null
     */
    public function getVertragspartner()
    {
        return $this->Vertragspartner;
    }
    /**
     * Set Vertragspartner value
     * @param \BiPRO\StructType\CT_Vertragspartner $vertragspartner
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setVertragspartner(\BiPRO\StructType\CT_Vertragspartner $vertragspartner = null)
    {
        $this->Vertragspartner = $vertragspartner;
        return $this;
    }
    /**
     * Get Leistungsstoerung value
     * @return bool|null
     */
    public function getLeistungsstoerung()
    {
        return $this->Leistungsstoerung;
    }
    /**
     * Set Leistungsstoerung value
     * @param bool $leistungsstoerung
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setLeistungsstoerung($leistungsstoerung = null)
    {
        // validation for constraint: boolean
        if (!is_null($leistungsstoerung) && !is_bool($leistungsstoerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leistungsstoerung, true), gettype($leistungsstoerung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($leistungsstoerung) && !preg_match('/true|false/', $leistungsstoerung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($leistungsstoerung, true)), __LINE__);
        }
        $this->Leistungsstoerung = $leistungsstoerung;
        return $this;
    }
    /**
     * Get Zahltermin value
     * @return string|null
     */
    public function getZahltermin()
    {
        return $this->Zahltermin;
    }
    /**
     * Set Zahltermin value
     * @param string $zahltermin
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setZahltermin($zahltermin = null)
    {
        // validation for constraint: string
        if (!is_null($zahltermin) && !is_string($zahltermin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zahltermin, true), gettype($zahltermin)), __LINE__);
        }
        // validation for constraint: pattern([0-3][0-9])
        if (!is_null($zahltermin) && !preg_match('/[0-3][0-9]/', $zahltermin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-3][0-9]', var_export($zahltermin, true)), __LINE__);
        }
        $this->Zahltermin = $zahltermin;
        return $this;
    }
    /**
     * Get ZusaetzlicheVertragsdaten value
     * @return \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten[]|null
     */
    public function getZusaetzlicheVertragsdaten()
    {
        return $this->ZusaetzlicheVertragsdaten;
    }
    /**
     * This method is responsible for validating the values passed to the setZusaetzlicheVertragsdaten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusaetzlicheVertragsdaten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusaetzlicheVertragsdatenForArrayConstraintsFromSetZusaetzlicheVertragsdaten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VertragZusaetzlicheVertragsdatenItem) {
            // validation for constraint: itemType
            if (!$cT_VertragZusaetzlicheVertragsdatenItem instanceof \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten) {
                $invalidValues[] = is_object($cT_VertragZusaetzlicheVertragsdatenItem) ? get_class($cT_VertragZusaetzlicheVertragsdatenItem) : sprintf('%s(%s)', gettype($cT_VertragZusaetzlicheVertragsdatenItem), var_export($cT_VertragZusaetzlicheVertragsdatenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZusaetzlicheVertragsdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZusaetzlicheVertragsdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten[] $zusaetzlicheVertragsdaten
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function setZusaetzlicheVertragsdaten(array $zusaetzlicheVertragsdaten = array())
    {
        // validation for constraint: array
        if ('' !== ($zusaetzlicheVertragsdatenArrayErrorMessage = self::validateZusaetzlicheVertragsdatenForArrayConstraintsFromSetZusaetzlicheVertragsdaten($zusaetzlicheVertragsdaten))) {
            throw new \InvalidArgumentException($zusaetzlicheVertragsdatenArrayErrorMessage, __LINE__);
        }
        $this->ZusaetzlicheVertragsdaten = $zusaetzlicheVertragsdaten;
        return $this;
    }
    /**
     * Add item to ZusaetzlicheVertragsdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten $item
     * @return \BiPRO\StructType\CT_Vertrag
     */
    public function addToZusaetzlicheVertragsdaten(\BiPRO\StructType\CT_ZusaetzlicheVertragsdaten $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten) {
            throw new \InvalidArgumentException(sprintf('The ZusaetzlicheVertragsdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheVertragsdaten, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZusaetzlicheVertragsdaten[] = $item;
        return $this;
    }
}
