<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_VersicherungssummeOderLeistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Da sich herausgestellt hat, dass es zwischen Versicherungssummen (Komposit) und Leistungen (Leben) abgesehen vom Namen keine modellierungsrelevanten Unterschiede gibt, sind beide synonym durch diesen Datentypen repraesentiert.
 * @subpackage Structs
 */
class CT_VersicherungssummeOderLeistung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_VersicherungssummeOderLeistung
     */
    public $ArtID;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Wert;
    /**
     * The Wertschluessel
     * Meta information extracted from the WSDL
     * - documentation: Versicherungssumme oder Leistung, die sich nicht als Zahl darstellen lässt (z.B. unbegrenzte Deckungssumme).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_LeistungSchluessel
     */
    public $Wertschluessel;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * The Waehrung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Waehrung;
    /**
     * The Auszahlungsweise
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Auszahlungsweise;
    /**
     * The Basisjahr
     * Meta information extracted from the WSDL
     * - documentation: Basisjahr der Versicherungssumme (z.B. 1914, 1980, 2000…). Auch bei "Mark 1914" MUSS Basisjahr "1914" belegt werden.Für Gewebe Sach gilt: Bei indizierten Versicherungssummen in Euro MUSS hier das Basisjahr angegeben werden (z.B.
     * Wert 1970 = 1970 oder Wert 2000 = 2000).
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Basisjahr;
    /**
     * The Preisindex
     * Meta information extracted from the WSDL
     * - documentation: Preisindex, mit dem die aktuelle Versicherungssumme aus der Versicherungssumme gemäß Basisjahr ermittelt wurde.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Preisindex;
    /**
     * The InklusiveUmsatzsteuer
     * Meta information extracted from the WSDL
     * - documentation: Ist der Versicherungsnehmer vorsteuerabzugsberechtigt wird Versicherungssumme um die Umsatzsteuer reduziert. Wenn das Attribut nicht geliefert wird, MUSS es als mit JA belegt interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $InklusiveUmsatzsteuer;
    /**
     * The Jahresmaximierung
     * Meta information extracted from the WSDL
     * - documentation: Aus der Versicherungssumme multipliziert mit der Jahresmaximierung ergibt sich die Jahreshöchstersatzleistung.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Jahresmaximierung;
    /**
     * The Leistungserbringung
     * Meta information extracted from the WSDL
     * - documentation: Art der Leistungserbringung
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Leistungserbringung;
    /**
     * The Zeitraum
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum der Leistung.Die Bezugszeitpunkte dieses Zeitraums MÜSSEN konkret angegeben werden. WENN eine konkrete Angabe fachlich nicht möglich ist, DARF darauf verzichtet werden (z.B. Beginn/Ende = Ereignis)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Zeitraum;
    /**
     * The GarantierteErhoehung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Dynamik[]
     */
    public $GarantierteErhoehung;
    /**
     * The Selbstbeteiligung
     * Meta information extracted from the WSDL
     * - documentation: Zur Abbildung von Selbstbehalten zu Versicherungssummen oder Leistungen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Selbstbeteiligung[]
     */
    public $Selbstbeteiligung;
    /**
     * The Karenzzeit
     * Meta information extracted from the WSDL
     * - documentation: Gibt die Karenzzeit ab Eintritt des Leistungsfalls an, während der noch keine Leistungen gezahlt werden.Sie MUSS als Zeitraum.AnzahlTage, Zeitraum.AnzahlMonate oder Zeitraum.AnzahlJahre angegeben werden.DARF NICHT für die Sparte
     * Unfall benutzt werden.Anmerkung: Es gilt: [Eintritt des Leistungsfalls] + [Karenzzeit] = [Beginn der Leistungszahlung]
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Karenzzeit;
    /**
     * Constructor method for CT_VersicherungssummeOderLeistung
     * @uses CT_VersicherungssummeOderLeistung::setArtID()
     * @uses CT_VersicherungssummeOderLeistung::setWert()
     * @uses CT_VersicherungssummeOderLeistung::setWertschluessel()
     * @uses CT_VersicherungssummeOderLeistung::setWerteinheit()
     * @uses CT_VersicherungssummeOderLeistung::setWaehrung()
     * @uses CT_VersicherungssummeOderLeistung::setAuszahlungsweise()
     * @uses CT_VersicherungssummeOderLeistung::setBasisjahr()
     * @uses CT_VersicherungssummeOderLeistung::setPreisindex()
     * @uses CT_VersicherungssummeOderLeistung::setInklusiveUmsatzsteuer()
     * @uses CT_VersicherungssummeOderLeistung::setJahresmaximierung()
     * @uses CT_VersicherungssummeOderLeistung::setLeistungserbringung()
     * @uses CT_VersicherungssummeOderLeistung::setZeitraum()
     * @uses CT_VersicherungssummeOderLeistung::setGarantierteErhoehung()
     * @uses CT_VersicherungssummeOderLeistung::setSelbstbeteiligung()
     * @uses CT_VersicherungssummeOderLeistung::setKarenzzeit()
     * @param \BiPRO\StructType\STE_VersicherungssummeOderLeistung $artID
     * @param float $wert
     * @param \BiPRO\StructType\STE_LeistungSchluessel $wertschluessel
     * @param string $werteinheit
     * @param string $waehrung
     * @param string $auszahlungsweise
     * @param int $basisjahr
     * @param float $preisindex
     * @param bool $inklusiveUmsatzsteuer
     * @param float $jahresmaximierung
     * @param string $leistungserbringung
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @param \BiPRO\StructType\CT_Dynamik[] $garantierteErhoehung
     * @param \BiPRO\StructType\CT_Selbstbeteiligung[] $selbstbeteiligung
     * @param \BiPRO\StructType\CT_Zeitraum $karenzzeit
     */
    public function __construct(\BiPRO\StructType\STE_VersicherungssummeOderLeistung $artID = null, $wert = null, \BiPRO\StructType\STE_LeistungSchluessel $wertschluessel = null, $werteinheit = null, $waehrung = null, $auszahlungsweise = null, $basisjahr = null, $preisindex = null, $inklusiveUmsatzsteuer = null, $jahresmaximierung = null, $leistungserbringung = null, \BiPRO\StructType\CT_Zeitraum $zeitraum = null, array $garantierteErhoehung = array(), array $selbstbeteiligung = array(), \BiPRO\StructType\CT_Zeitraum $karenzzeit = null)
    {
        $this
            ->setArtID($artID)
            ->setWert($wert)
            ->setWertschluessel($wertschluessel)
            ->setWerteinheit($werteinheit)
            ->setWaehrung($waehrung)
            ->setAuszahlungsweise($auszahlungsweise)
            ->setBasisjahr($basisjahr)
            ->setPreisindex($preisindex)
            ->setInklusiveUmsatzsteuer($inklusiveUmsatzsteuer)
            ->setJahresmaximierung($jahresmaximierung)
            ->setLeistungserbringung($leistungserbringung)
            ->setZeitraum($zeitraum)
            ->setGarantierteErhoehung($garantierteErhoehung)
            ->setSelbstbeteiligung($selbstbeteiligung)
            ->setKarenzzeit($karenzzeit);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_VersicherungssummeOderLeistung|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_VersicherungssummeOderLeistung $artID
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setArtID(\BiPRO\StructType\STE_VersicherungssummeOderLeistung $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Wert value
     * @return float|null
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get Wertschluessel value
     * @return \BiPRO\StructType\STE_LeistungSchluessel|null
     */
    public function getWertschluessel()
    {
        return $this->Wertschluessel;
    }
    /**
     * Set Wertschluessel value
     * @param \BiPRO\StructType\STE_LeistungSchluessel $wertschluessel
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setWertschluessel(\BiPRO\StructType\STE_LeistungSchluessel $wertschluessel = null)
    {
        $this->Wertschluessel = $wertschluessel;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waehrung
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($waehrung) ? implode(', ', $waehrung) : var_export($waehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get Auszahlungsweise value
     * @return string|null
     */
    public function getAuszahlungsweise()
    {
        return $this->Auszahlungsweise;
    }
    /**
     * Set Auszahlungsweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $auszahlungsweise
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setAuszahlungsweise($auszahlungsweise = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($auszahlungsweise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($auszahlungsweise) ? implode(', ', $auszahlungsweise) : var_export($auszahlungsweise, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues())), __LINE__);
        }
        $this->Auszahlungsweise = $auszahlungsweise;
        return $this;
    }
    /**
     * Get Basisjahr value
     * @return int|null
     */
    public function getBasisjahr()
    {
        return $this->Basisjahr;
    }
    /**
     * Set Basisjahr value
     * @param int $basisjahr
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setBasisjahr($basisjahr = null)
    {
        // validation for constraint: int
        if (!is_null($basisjahr) && !(is_int($basisjahr) || ctype_digit($basisjahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($basisjahr, true), gettype($basisjahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($basisjahr) && mb_strlen(preg_replace('/(\D)/', '', $basisjahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($basisjahr, true), mb_strlen(preg_replace('/(\D)/', '', $basisjahr))), __LINE__);
        }
        $this->Basisjahr = $basisjahr;
        return $this;
    }
    /**
     * Get Preisindex value
     * @return float|null
     */
    public function getPreisindex()
    {
        return $this->Preisindex;
    }
    /**
     * Set Preisindex value
     * @param float $preisindex
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setPreisindex($preisindex = null)
    {
        // validation for constraint: float
        if (!is_null($preisindex) && !(is_float($preisindex) || is_numeric($preisindex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preisindex, true), gettype($preisindex)), __LINE__);
        }
        $this->Preisindex = $preisindex;
        return $this;
    }
    /**
     * Get InklusiveUmsatzsteuer value
     * @return bool|null
     */
    public function getInklusiveUmsatzsteuer()
    {
        return $this->InklusiveUmsatzsteuer;
    }
    /**
     * Set InklusiveUmsatzsteuer value
     * @param bool $inklusiveUmsatzsteuer
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setInklusiveUmsatzsteuer($inklusiveUmsatzsteuer = null)
    {
        // validation for constraint: boolean
        if (!is_null($inklusiveUmsatzsteuer) && !is_bool($inklusiveUmsatzsteuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inklusiveUmsatzsteuer, true), gettype($inklusiveUmsatzsteuer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($inklusiveUmsatzsteuer) && !preg_match('/true|false/', $inklusiveUmsatzsteuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($inklusiveUmsatzsteuer, true)), __LINE__);
        }
        $this->InklusiveUmsatzsteuer = $inklusiveUmsatzsteuer;
        return $this;
    }
    /**
     * Get Jahresmaximierung value
     * @return float|null
     */
    public function getJahresmaximierung()
    {
        return $this->Jahresmaximierung;
    }
    /**
     * Set Jahresmaximierung value
     * @param float $jahresmaximierung
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setJahresmaximierung($jahresmaximierung = null)
    {
        // validation for constraint: float
        if (!is_null($jahresmaximierung) && !(is_float($jahresmaximierung) || is_numeric($jahresmaximierung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($jahresmaximierung, true), gettype($jahresmaximierung)), __LINE__);
        }
        $this->Jahresmaximierung = $jahresmaximierung;
        return $this;
    }
    /**
     * Get Leistungserbringung value
     * @return string|null
     */
    public function getLeistungserbringung()
    {
        return $this->Leistungserbringung;
    }
    /**
     * Set Leistungserbringung value
     * @uses \BiPRO\EnumType\ST_Leistungserbringung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Leistungserbringung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $leistungserbringung
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setLeistungserbringung($leistungserbringung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Leistungserbringung::valueIsValid($leistungserbringung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Leistungserbringung', is_array($leistungserbringung) ? implode(', ', $leistungserbringung) : var_export($leistungserbringung, true), implode(', ', \BiPRO\EnumType\ST_Leistungserbringung::getValidValues())), __LINE__);
        }
        $this->Leistungserbringung = $leistungserbringung;
        return $this;
    }
    /**
     * Get Zeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getZeitraum()
    {
        return $this->Zeitraum;
    }
    /**
     * Set Zeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setZeitraum(\BiPRO\StructType\CT_Zeitraum $zeitraum = null)
    {
        $this->Zeitraum = $zeitraum;
        return $this;
    }
    /**
     * Get GarantierteErhoehung value
     * @return \BiPRO\StructType\CT_Dynamik[]|null
     */
    public function getGarantierteErhoehung()
    {
        return $this->GarantierteErhoehung;
    }
    /**
     * This method is responsible for validating the values passed to the setGarantierteErhoehung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGarantierteErhoehung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGarantierteErhoehungForArrayConstraintsFromSetGarantierteErhoehung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VersicherungssummeOderLeistungGarantierteErhoehungItem) {
            // validation for constraint: itemType
            if (!$cT_VersicherungssummeOderLeistungGarantierteErhoehungItem instanceof \BiPRO\StructType\CT_Dynamik) {
                $invalidValues[] = is_object($cT_VersicherungssummeOderLeistungGarantierteErhoehungItem) ? get_class($cT_VersicherungssummeOderLeistungGarantierteErhoehungItem) : sprintf('%s(%s)', gettype($cT_VersicherungssummeOderLeistungGarantierteErhoehungItem), var_export($cT_VersicherungssummeOderLeistungGarantierteErhoehungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GarantierteErhoehung property can only contain items of type \BiPRO\StructType\CT_Dynamik, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GarantierteErhoehung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dynamik[] $garantierteErhoehung
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setGarantierteErhoehung(array $garantierteErhoehung = array())
    {
        // validation for constraint: array
        if ('' !== ($garantierteErhoehungArrayErrorMessage = self::validateGarantierteErhoehungForArrayConstraintsFromSetGarantierteErhoehung($garantierteErhoehung))) {
            throw new \InvalidArgumentException($garantierteErhoehungArrayErrorMessage, __LINE__);
        }
        $this->GarantierteErhoehung = $garantierteErhoehung;
        return $this;
    }
    /**
     * Add item to GarantierteErhoehung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Dynamik $item
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function addToGarantierteErhoehung(\BiPRO\StructType\CT_Dynamik $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Dynamik) {
            throw new \InvalidArgumentException(sprintf('The GarantierteErhoehung property can only contain items of type \BiPRO\StructType\CT_Dynamik, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GarantierteErhoehung[] = $item;
        return $this;
    }
    /**
     * Get Selbstbeteiligung value
     * @return \BiPRO\StructType\CT_Selbstbeteiligung[]|null
     */
    public function getSelbstbeteiligung()
    {
        return $this->Selbstbeteiligung;
    }
    /**
     * This method is responsible for validating the values passed to the setSelbstbeteiligung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelbstbeteiligung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelbstbeteiligungForArrayConstraintsFromSetSelbstbeteiligung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VersicherungssummeOderLeistungSelbstbeteiligungItem) {
            // validation for constraint: itemType
            if (!$cT_VersicherungssummeOderLeistungSelbstbeteiligungItem instanceof \BiPRO\StructType\CT_Selbstbeteiligung) {
                $invalidValues[] = is_object($cT_VersicherungssummeOderLeistungSelbstbeteiligungItem) ? get_class($cT_VersicherungssummeOderLeistungSelbstbeteiligungItem) : sprintf('%s(%s)', gettype($cT_VersicherungssummeOderLeistungSelbstbeteiligungItem), var_export($cT_VersicherungssummeOderLeistungSelbstbeteiligungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Selbstbeteiligung property can only contain items of type \BiPRO\StructType\CT_Selbstbeteiligung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Selbstbeteiligung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Selbstbeteiligung[] $selbstbeteiligung
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setSelbstbeteiligung(array $selbstbeteiligung = array())
    {
        // validation for constraint: array
        if ('' !== ($selbstbeteiligungArrayErrorMessage = self::validateSelbstbeteiligungForArrayConstraintsFromSetSelbstbeteiligung($selbstbeteiligung))) {
            throw new \InvalidArgumentException($selbstbeteiligungArrayErrorMessage, __LINE__);
        }
        $this->Selbstbeteiligung = $selbstbeteiligung;
        return $this;
    }
    /**
     * Add item to Selbstbeteiligung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Selbstbeteiligung $item
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function addToSelbstbeteiligung(\BiPRO\StructType\CT_Selbstbeteiligung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Selbstbeteiligung) {
            throw new \InvalidArgumentException(sprintf('The Selbstbeteiligung property can only contain items of type \BiPRO\StructType\CT_Selbstbeteiligung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Selbstbeteiligung[] = $item;
        return $this;
    }
    /**
     * Get Karenzzeit value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getKarenzzeit()
    {
        return $this->Karenzzeit;
    }
    /**
     * Set Karenzzeit value
     * @param \BiPRO\StructType\CT_Zeitraum $karenzzeit
     * @return \BiPRO\StructType\CT_VersicherungssummeOderLeistung
     */
    public function setKarenzzeit(\BiPRO\StructType\CT_Zeitraum $karenzzeit = null)
    {
        $this->Karenzzeit = $karenzzeit;
        return $this;
    }
}
