<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_VermoegenswirksameLeistung StructType
 * @subpackage Structs
 */
class CT_VermoegenswirksameLeistung extends CT_Objekt
{
    /**
     * The Arbeitgeberanteil
     * Meta information extracted from the WSDL
     * - documentation: Anteil des Arbeitgebers
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Arbeitgeberanteil
     */
    public $Arbeitgeberanteil;
    /**
     * The Arbeitnehmeranteil
     * Meta information extracted from the WSDL
     * - documentation: Anteil des Arbeitsnehmers
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Arbeitnehmeranteil
     */
    public $Arbeitnehmeranteil;
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der vermögenswirksamen Leistung (VWL, AVWL).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * Constructor method for CT_VermoegenswirksameLeistung
     * @uses CT_VermoegenswirksameLeistung::setArbeitgeberanteil()
     * @uses CT_VermoegenswirksameLeistung::setArbeitnehmeranteil()
     * @uses CT_VermoegenswirksameLeistung::setArtID()
     * @param \BiPRO\StructType\CT_Arbeitgeberanteil $arbeitgeberanteil
     * @param \BiPRO\StructType\CT_Arbeitnehmeranteil $arbeitnehmeranteil
     * @param string $artID
     */
    public function __construct(\BiPRO\StructType\CT_Arbeitgeberanteil $arbeitgeberanteil = null, \BiPRO\StructType\CT_Arbeitnehmeranteil $arbeitnehmeranteil = null, $artID = null)
    {
        $this
            ->setArbeitgeberanteil($arbeitgeberanteil)
            ->setArbeitnehmeranteil($arbeitnehmeranteil)
            ->setArtID($artID);
    }
    /**
     * Get Arbeitgeberanteil value
     * @return \BiPRO\StructType\CT_Arbeitgeberanteil|null
     */
    public function getArbeitgeberanteil()
    {
        return $this->Arbeitgeberanteil;
    }
    /**
     * Set Arbeitgeberanteil value
     * @param \BiPRO\StructType\CT_Arbeitgeberanteil $arbeitgeberanteil
     * @return \BiPRO\StructType\CT_VermoegenswirksameLeistung
     */
    public function setArbeitgeberanteil(\BiPRO\StructType\CT_Arbeitgeberanteil $arbeitgeberanteil = null)
    {
        $this->Arbeitgeberanteil = $arbeitgeberanteil;
        return $this;
    }
    /**
     * Get Arbeitnehmeranteil value
     * @return \BiPRO\StructType\CT_Arbeitnehmeranteil|null
     */
    public function getArbeitnehmeranteil()
    {
        return $this->Arbeitnehmeranteil;
    }
    /**
     * Set Arbeitnehmeranteil value
     * @param \BiPRO\StructType\CT_Arbeitnehmeranteil $arbeitnehmeranteil
     * @return \BiPRO\StructType\CT_VermoegenswirksameLeistung
     */
    public function setArbeitnehmeranteil(\BiPRO\StructType\CT_Arbeitnehmeranteil $arbeitnehmeranteil = null)
    {
        $this->Arbeitnehmeranteil = $arbeitnehmeranteil;
        return $this;
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_ArtVermoegenswirksameLeistung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtVermoegenswirksameLeistung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_VermoegenswirksameLeistung
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtVermoegenswirksameLeistung::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtVermoegenswirksameLeistung', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_ArtVermoegenswirksameLeistung::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
}
