<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vermittlerrolle StructType
 * Meta information extracted from the WSDL
 * - documentation: Rolle(n) des Vermittlers innerhalb des Geschaeftsvorgangs.
 * @subpackage Structs
 */
class CT_Vermittlerrolle extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - documentation: Angaben zur möglichen Anteilsverteilung von Untervermittlern.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Wert;
    /**
     * The Wertschluessel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_VermittlerrolleSchluessel
     */
    public $Wertschluessel;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * The Vermittlertyp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vermittlertyp;
    /**
     * Constructor method for CT_Vermittlerrolle
     * @uses CT_Vermittlerrolle::setArtID()
     * @uses CT_Vermittlerrolle::setWert()
     * @uses CT_Vermittlerrolle::setWertschluessel()
     * @uses CT_Vermittlerrolle::setWerteinheit()
     * @uses CT_Vermittlerrolle::setVermittlertyp()
     * @param string $artID
     * @param float $wert
     * @param \BiPRO\StructType\STE_VermittlerrolleSchluessel $wertschluessel
     * @param string $werteinheit
     * @param string $vermittlertyp
     */
    public function __construct($artID = null, $wert = null, \BiPRO\StructType\STE_VermittlerrolleSchluessel $wertschluessel = null, $werteinheit = null, $vermittlertyp = null)
    {
        $this
            ->setArtID($artID)
            ->setWert($wert)
            ->setWertschluessel($wertschluessel)
            ->setWerteinheit($werteinheit)
            ->setVermittlertyp($vermittlertyp);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Vermittlerrolle::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vermittlerrolle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Vermittlerrolle
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vermittlerrolle::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vermittlerrolle', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Vermittlerrolle::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Wert value
     * @return float|null
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_Vermittlerrolle
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get Wertschluessel value
     * @return \BiPRO\StructType\STE_VermittlerrolleSchluessel|null
     */
    public function getWertschluessel()
    {
        return $this->Wertschluessel;
    }
    /**
     * Set Wertschluessel value
     * @param \BiPRO\StructType\STE_VermittlerrolleSchluessel $wertschluessel
     * @return \BiPRO\StructType\CT_Vermittlerrolle
     */
    public function setWertschluessel(\BiPRO\StructType\STE_VermittlerrolleSchluessel $wertschluessel = null)
    {
        $this->Wertschluessel = $wertschluessel;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Berechnungseinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Berechnungseinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Vermittlerrolle
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Berechnungseinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Berechnungseinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Berechnungseinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get Vermittlertyp value
     * @return string|null
     */
    public function getVermittlertyp()
    {
        return $this->Vermittlertyp;
    }
    /**
     * Set Vermittlertyp value
     * @uses \BiPRO\EnumType\ST_Vermittlertyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vermittlertyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vermittlertyp
     * @return \BiPRO\StructType\CT_Vermittlerrolle
     */
    public function setVermittlertyp($vermittlertyp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vermittlertyp::valueIsValid($vermittlertyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vermittlertyp', is_array($vermittlertyp) ? implode(', ', $vermittlertyp) : var_export($vermittlertyp, true), implode(', ', \BiPRO\EnumType\ST_Vermittlertyp::getValidValues())), __LINE__);
        }
        $this->Vermittlertyp = $vermittlertyp;
        return $this;
    }
}
