<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vermittler StructType
 * Meta information extracted from the WSDL
 * - documentation: Daten des fuer den Geschaeftsvorgang verantwortlichen Vermittlers.
 * @subpackage Structs
 */
class CT_Vermittler extends CT_Objekt
{
    /**
     * The Vermittlernummer
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifzierung des Vermittlers beim produktgebenden Unternehmen.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vermittlernummer;
    /**
     * The VermittlernummerVM
     * Meta information extracted from the WSDL
     * - documentation: Vermittlernummer beim Vermittler: Eindeutige Identifzierung des Vermittlers beim Vermittler selbst.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $VermittlernummerVM;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf die Partnerdaten zum Vermittler | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The IHKRegistrierungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Offizielle Nummer des Vermittlers bei der Industrie- und Handelskammer
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $IHKRegistrierungsnummer;
    /**
     * The Art
     * Meta information extracted from the WSDL
     * - documentation: Art der Vermittlungstätigkeit. Verwendung z. B. im Kontext Beratungsprotokoll bei unterschiedlichen Anforderungen je nach Vermittlungstätigkeit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Art;
    /**
     * The Vermittlerrolle
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vermittlerrolle[]
     */
    public $Vermittlerrolle;
    /**
     * The Vermittler
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vermittler[]
     */
    public $Vermittler;
    /**
     * The Vertriebskanal
     * Meta information extracted from the WSDL
     * - documentation: Abbildung des Vertriebskanals für Vermittlerorganisationen, die als Vermittler übergeben werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vertriebskanal;
    /**
     * Constructor method for CT_Vermittler
     * @uses CT_Vermittler::setVermittlernummer()
     * @uses CT_Vermittler::setVermittlernummerVM()
     * @uses CT_Vermittler::setPartnerID()
     * @uses CT_Vermittler::setIHKRegistrierungsnummer()
     * @uses CT_Vermittler::setArt()
     * @uses CT_Vermittler::setVermittlerrolle()
     * @uses CT_Vermittler::setVermittler()
     * @uses CT_Vermittler::setVertriebskanal()
     * @param string $vermittlernummer
     * @param string $vermittlernummerVM
     * @param string $partnerID
     * @param string $iHKRegistrierungsnummer
     * @param string $art
     * @param \BiPRO\StructType\CT_Vermittlerrolle[] $vermittlerrolle
     * @param \BiPRO\StructType\CT_Vermittler[] $vermittler
     * @param string $vertriebskanal
     */
    public function __construct($vermittlernummer = null, $vermittlernummerVM = null, $partnerID = null, $iHKRegistrierungsnummer = null, $art = null, array $vermittlerrolle = array(), array $vermittler = array(), $vertriebskanal = null)
    {
        $this
            ->setVermittlernummer($vermittlernummer)
            ->setVermittlernummerVM($vermittlernummerVM)
            ->setPartnerID($partnerID)
            ->setIHKRegistrierungsnummer($iHKRegistrierungsnummer)
            ->setArt($art)
            ->setVermittlerrolle($vermittlerrolle)
            ->setVermittler($vermittler)
            ->setVertriebskanal($vertriebskanal);
    }
    /**
     * Get Vermittlernummer value
     * @return string|null
     */
    public function getVermittlernummer()
    {
        return $this->Vermittlernummer;
    }
    /**
     * Set Vermittlernummer value
     * @param string $vermittlernummer
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setVermittlernummer($vermittlernummer = null)
    {
        // validation for constraint: string
        if (!is_null($vermittlernummer) && !is_string($vermittlernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vermittlernummer, true), gettype($vermittlernummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vermittlernummer) && mb_strlen($vermittlernummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vermittlernummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vermittlernummer) && mb_strlen($vermittlernummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vermittlernummer)), __LINE__);
        }
        $this->Vermittlernummer = $vermittlernummer;
        return $this;
    }
    /**
     * Get VermittlernummerVM value
     * @return string|null
     */
    public function getVermittlernummerVM()
    {
        return $this->VermittlernummerVM;
    }
    /**
     * Set VermittlernummerVM value
     * @param string $vermittlernummerVM
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setVermittlernummerVM($vermittlernummerVM = null)
    {
        // validation for constraint: string
        if (!is_null($vermittlernummerVM) && !is_string($vermittlernummerVM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vermittlernummerVM, true), gettype($vermittlernummerVM)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vermittlernummerVM) && mb_strlen($vermittlernummerVM) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vermittlernummerVM)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vermittlernummerVM) && mb_strlen($vermittlernummerVM) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vermittlernummerVM)), __LINE__);
        }
        $this->VermittlernummerVM = $vermittlernummerVM;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partnerID) && mb_strlen($partnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get IHKRegistrierungsnummer value
     * @return string|null
     */
    public function getIHKRegistrierungsnummer()
    {
        return $this->IHKRegistrierungsnummer;
    }
    /**
     * Set IHKRegistrierungsnummer value
     * @param string $iHKRegistrierungsnummer
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setIHKRegistrierungsnummer($iHKRegistrierungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($iHKRegistrierungsnummer) && !is_string($iHKRegistrierungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iHKRegistrierungsnummer, true), gettype($iHKRegistrierungsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($iHKRegistrierungsnummer) && mb_strlen($iHKRegistrierungsnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($iHKRegistrierungsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($iHKRegistrierungsnummer) && mb_strlen($iHKRegistrierungsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($iHKRegistrierungsnummer)), __LINE__);
        }
        $this->IHKRegistrierungsnummer = $iHKRegistrierungsnummer;
        return $this;
    }
    /**
     * Get Art value
     * @return string|null
     */
    public function getArt()
    {
        return $this->Art;
    }
    /**
     * Set Art value
     * @uses \BiPRO\EnumType\ST_Vermittlerart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vermittlerart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $art
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setArt($art = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vermittlerart::valueIsValid($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vermittlerart', is_array($art) ? implode(', ', $art) : var_export($art, true), implode(', ', \BiPRO\EnumType\ST_Vermittlerart::getValidValues())), __LINE__);
        }
        $this->Art = $art;
        return $this;
    }
    /**
     * Get Vermittlerrolle value
     * @return \BiPRO\StructType\CT_Vermittlerrolle[]|null
     */
    public function getVermittlerrolle()
    {
        return $this->Vermittlerrolle;
    }
    /**
     * This method is responsible for validating the values passed to the setVermittlerrolle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermittlerrolle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermittlerrolleForArrayConstraintsFromSetVermittlerrolle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VermittlerVermittlerrolleItem) {
            // validation for constraint: itemType
            if (!$cT_VermittlerVermittlerrolleItem instanceof \BiPRO\StructType\CT_Vermittlerrolle) {
                $invalidValues[] = is_object($cT_VermittlerVermittlerrolleItem) ? get_class($cT_VermittlerVermittlerrolleItem) : sprintf('%s(%s)', gettype($cT_VermittlerVermittlerrolleItem), var_export($cT_VermittlerVermittlerrolleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vermittlerrolle property can only contain items of type \BiPRO\StructType\CT_Vermittlerrolle, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vermittlerrolle value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittlerrolle[] $vermittlerrolle
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setVermittlerrolle(array $vermittlerrolle = array())
    {
        // validation for constraint: array
        if ('' !== ($vermittlerrolleArrayErrorMessage = self::validateVermittlerrolleForArrayConstraintsFromSetVermittlerrolle($vermittlerrolle))) {
            throw new \InvalidArgumentException($vermittlerrolleArrayErrorMessage, __LINE__);
        }
        $this->Vermittlerrolle = $vermittlerrolle;
        return $this;
    }
    /**
     * Add item to Vermittlerrolle value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittlerrolle $item
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function addToVermittlerrolle(\BiPRO\StructType\CT_Vermittlerrolle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vermittlerrolle) {
            throw new \InvalidArgumentException(sprintf('The Vermittlerrolle property can only contain items of type \BiPRO\StructType\CT_Vermittlerrolle, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vermittlerrolle[] = $item;
        return $this;
    }
    /**
     * Get Vermittler value
     * @return \BiPRO\StructType\CT_Vermittler[]|null
     */
    public function getVermittler()
    {
        return $this->Vermittler;
    }
    /**
     * This method is responsible for validating the values passed to the setVermittler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermittler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermittlerForArrayConstraintsFromSetVermittler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VermittlerVermittlerItem) {
            // validation for constraint: itemType
            if (!$cT_VermittlerVermittlerItem instanceof \BiPRO\StructType\CT_Vermittler) {
                $invalidValues[] = is_object($cT_VermittlerVermittlerItem) ? get_class($cT_VermittlerVermittlerItem) : sprintf('%s(%s)', gettype($cT_VermittlerVermittlerItem), var_export($cT_VermittlerVermittlerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vermittler property can only contain items of type \BiPRO\StructType\CT_Vermittler, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vermittler value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittler[] $vermittler
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setVermittler(array $vermittler = array())
    {
        // validation for constraint: array
        if ('' !== ($vermittlerArrayErrorMessage = self::validateVermittlerForArrayConstraintsFromSetVermittler($vermittler))) {
            throw new \InvalidArgumentException($vermittlerArrayErrorMessage, __LINE__);
        }
        $this->Vermittler = $vermittler;
        return $this;
    }
    /**
     * Add item to Vermittler value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermittler $item
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function addToVermittler(\BiPRO\StructType\CT_Vermittler $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vermittler) {
            throw new \InvalidArgumentException(sprintf('The Vermittler property can only contain items of type \BiPRO\StructType\CT_Vermittler, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vermittler[] = $item;
        return $this;
    }
    /**
     * Get Vertriebskanal value
     * @return string|null
     */
    public function getVertriebskanal()
    {
        return $this->Vertriebskanal;
    }
    /**
     * Set Vertriebskanal value
     * @param string $vertriebskanal
     * @return \BiPRO\StructType\CT_Vermittler
     */
    public function setVertriebskanal($vertriebskanal = null)
    {
        // validation for constraint: string
        if (!is_null($vertriebskanal) && !is_string($vertriebskanal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vertriebskanal, true), gettype($vertriebskanal)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($vertriebskanal) && mb_strlen($vertriebskanal) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($vertriebskanal)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vertriebskanal) && mb_strlen($vertriebskanal) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vertriebskanal)), __LINE__);
        }
        $this->Vertriebskanal = $vertriebskanal;
        return $this;
    }
}
