<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Verkehrstraeger StructType
 * Meta information extracted from the WSDL
 * - documentation: Partner in der Rolle eines Verkehrsträgers.Verkehrsträger = Aufgabenträger bzw. Verantwortungsträger für die Erstellung von Verkehrsdienstleistungen (z.B. eine Spedition, ein Bahnunternehmen, ein Schifffahrtsunternehmen, eine
 * Fluggesellschaft).
 * @subpackage Structs
 */
class CT_Verkehrstraeger extends CT_Partnerrolle
{
    /**
     * The Regressanspruch
     * Meta information extracted from the WSDL
     * - documentation: Wurden Regressansprüche gegen den Verkehrsträger erhoben?
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Regressanspruch;
    /**
     * The RegressanspruecheDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem die Regressansprüche gegen den Verkehrsträger gestellt wurden. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $RegressanspruecheDatum;
    /**
     * The AnspruchsschreibenBeigefuegt
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Anspruchsschreiben ist beigefügt.NEIN = Das Anspruchsschreiben wird nachgereicht.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AnspruchsschreibenBeigefuegt;
    /**
     * Constructor method for CT_Verkehrstraeger
     * @uses CT_Verkehrstraeger::setRegressanspruch()
     * @uses CT_Verkehrstraeger::setRegressanspruecheDatum()
     * @uses CT_Verkehrstraeger::setAnspruchsschreibenBeigefuegt()
     * @param string $regressanspruch
     * @param string $regressanspruecheDatum
     * @param bool $anspruchsschreibenBeigefuegt
     */
    public function __construct($regressanspruch = null, $regressanspruecheDatum = null, $anspruchsschreibenBeigefuegt = null)
    {
        $this
            ->setRegressanspruch($regressanspruch)
            ->setRegressanspruecheDatum($regressanspruecheDatum)
            ->setAnspruchsschreibenBeigefuegt($anspruchsschreibenBeigefuegt);
    }
    /**
     * Get Regressanspruch value
     * @return string|null
     */
    public function getRegressanspruch()
    {
        return $this->Regressanspruch;
    }
    /**
     * Set Regressanspruch value
     * @uses \BiPRO\EnumType\ST_AnspruchErhoben::valueIsValid()
     * @uses \BiPRO\EnumType\ST_AnspruchErhoben::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regressanspruch
     * @return \BiPRO\StructType\CT_Verkehrstraeger
     */
    public function setRegressanspruch($regressanspruch = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_AnspruchErhoben::valueIsValid($regressanspruch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_AnspruchErhoben', is_array($regressanspruch) ? implode(', ', $regressanspruch) : var_export($regressanspruch, true), implode(', ', \BiPRO\EnumType\ST_AnspruchErhoben::getValidValues())), __LINE__);
        }
        $this->Regressanspruch = $regressanspruch;
        return $this;
    }
    /**
     * Get RegressanspruecheDatum value
     * @return string|null
     */
    public function getRegressanspruecheDatum()
    {
        return $this->RegressanspruecheDatum;
    }
    /**
     * Set RegressanspruecheDatum value
     * @param string $regressanspruecheDatum
     * @return \BiPRO\StructType\CT_Verkehrstraeger
     */
    public function setRegressanspruecheDatum($regressanspruecheDatum = null)
    {
        // validation for constraint: string
        if (!is_null($regressanspruecheDatum) && !is_string($regressanspruecheDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regressanspruecheDatum, true), gettype($regressanspruecheDatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($regressanspruecheDatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $regressanspruecheDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($regressanspruecheDatum, true)), __LINE__);
        }
        $this->RegressanspruecheDatum = $regressanspruecheDatum;
        return $this;
    }
    /**
     * Get AnspruchsschreibenBeigefuegt value
     * @return bool|null
     */
    public function getAnspruchsschreibenBeigefuegt()
    {
        return $this->AnspruchsschreibenBeigefuegt;
    }
    /**
     * Set AnspruchsschreibenBeigefuegt value
     * @param bool $anspruchsschreibenBeigefuegt
     * @return \BiPRO\StructType\CT_Verkehrstraeger
     */
    public function setAnspruchsschreibenBeigefuegt($anspruchsschreibenBeigefuegt = null)
    {
        // validation for constraint: boolean
        if (!is_null($anspruchsschreibenBeigefuegt) && !is_bool($anspruchsschreibenBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anspruchsschreibenBeigefuegt, true), gettype($anspruchsschreibenBeigefuegt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($anspruchsschreibenBeigefuegt) && !preg_match('/true|false/', $anspruchsschreibenBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($anspruchsschreibenBeigefuegt, true)), __LINE__);
        }
        $this->AnspruchsschreibenBeigefuegt = $anspruchsschreibenBeigefuegt;
        return $this;
    }
}
