<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Verkaufsprodukt StructType
 * Meta information extracted from the WSDL
 * - documentation: Oberste Ebene der Produkthierarchie gemaess VAA-Modell. Buendelt Produkte und Verkaufsprodukte zu einer verkaufbaren Einheit. Darf nicht spartenspezifisch abgeleitet werden, da ansonsten die spartenuebergreifende Buendelung von
 * Produkten innerhalb des Verkaufsproduktes nicht funktionieren kann.
 * @subpackage Structs
 */
class CT_Verkaufsprodukt extends CT_Produktbaustein
{
    /**
     * The Produkt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Produkt[]
     */
    public $Produkt;
    /**
     * The Kennung
     * Meta information extracted from the WSDL
     * - documentation: Erfolgt die Identifizierung eines Verkaufsproduktes mittels einer technischen Kennung (=technische Bezeichnung des Verkaufsprodukts), MUSS hierfür das Attribut Kennung benutzt werden. | Datentyp um die technische Kennung des
     * Verkaufsproduktes als String im Datenmodell abzulegen. Hier dürfen Tarifgenerationen abgelegt werden. Da es sich um einen String handelt werden keine vollständigen Listen von Verkaufsproduktkennungen veröffentlicht.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kennung;
    /**
     * Constructor method for CT_Verkaufsprodukt
     * @uses CT_Verkaufsprodukt::setProdukt()
     * @uses CT_Verkaufsprodukt::setKennung()
     * @param \BiPRO\StructType\CT_Produkt[] $produkt
     * @param string $kennung
     */
    public function __construct(array $produkt = array(), $kennung = null)
    {
        $this
            ->setProdukt($produkt)
            ->setKennung($kennung);
    }
    /**
     * Get Produkt value
     * @return \BiPRO\StructType\CT_Produkt[]
     */
    public function getProdukt()
    {
        return $this->Produkt;
    }
    /**
     * This method is responsible for validating the values passed to the setProdukt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProdukt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProduktForArrayConstraintsFromSetProdukt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_VerkaufsproduktProduktItem) {
            // validation for constraint: itemType
            if (!$cT_VerkaufsproduktProduktItem instanceof \BiPRO\StructType\CT_Produkt) {
                $invalidValues[] = is_object($cT_VerkaufsproduktProduktItem) ? get_class($cT_VerkaufsproduktProduktItem) : sprintf('%s(%s)', gettype($cT_VerkaufsproduktProduktItem), var_export($cT_VerkaufsproduktProduktItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Produkt property can only contain items of type \BiPRO\StructType\CT_Produkt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Produkt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Produkt[] $produkt
     * @return \BiPRO\StructType\CT_Verkaufsprodukt
     */
    public function setProdukt(array $produkt = array())
    {
        // validation for constraint: array
        if ('' !== ($produktArrayErrorMessage = self::validateProduktForArrayConstraintsFromSetProdukt($produkt))) {
            throw new \InvalidArgumentException($produktArrayErrorMessage, __LINE__);
        }
        $this->Produkt = $produkt;
        return $this;
    }
    /**
     * Add item to Produkt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Produkt $item
     * @return \BiPRO\StructType\CT_Verkaufsprodukt
     */
    public function addToProdukt(\BiPRO\StructType\CT_Produkt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Produkt) {
            throw new \InvalidArgumentException(sprintf('The Produkt property can only contain items of type \BiPRO\StructType\CT_Produkt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Produkt[] = $item;
        return $this;
    }
    /**
     * Get Kennung value
     * @return string|null
     */
    public function getKennung()
    {
        return $this->Kennung;
    }
    /**
     * Set Kennung value
     * @param string $kennung
     * @return \BiPRO\StructType\CT_Verkaufsprodukt
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kennung) && mb_strlen($kennung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kennung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kennung) && mb_strlen($kennung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kennung)), __LINE__);
        }
        $this->Kennung = $kennung;
        return $this;
    }
}
