<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vereinbarung StructType
 * Meta information extracted from the WSDL
 * - documentation: Vereinbarung der Vertragspartner über Erträge und Kosten einer Kapitalanlage (z. B. Zins, Gebühr, Bonus).
 * @subpackage Structs
 */
class CT_Vereinbarung extends CT_Objekt
{
    /**
     * The KategorieID
     * Meta information extracted from the WSDL
     * - documentation: Kategorie der Vereinbarung (z. B. Zins, Gebühr, Bonus).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KategorieID;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - documentation: Wert der Vereinbarung, z.B. Zinssatz, Gebührenbetrag.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Wert;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - documentation: z.B. Prozent, Betrag
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Werteinheit;
    /**
     * The Zahlungsweise
     * Meta information extracted from the WSDL
     * - documentation: Grundlage des Werts, z.B. Zinssatz pro Monat, pro Jahr etc., Betrag pro Monat, pro Jahr etc.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zahlungsweise;
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Vereinbarung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Waehrung
     * Meta information extracted from the WSDL
     * - documentation: Währung, falls der Wert ein Betrag ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Waehrung;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung der Vereinbarung.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The Bedingung
     * Meta information extracted from the WSDL
     * - documentation: Bedingung, für die die Vereinbarung gilt (z.B. für Bestand, für Zuzahlung).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bedingung;
    /**
     * The UntererGrenzwert
     * Meta information extracted from the WSDL
     * - documentation: Der untere Grenzwert definiert den Wert, ab dem (der Wert eingeschlossen) die Vereinbarung gilt (also &gt;=).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Grenzwert
     */
    public $UntererGrenzwert;
    /**
     * The Zeitraum
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum, für den die Vereinbarung gilt. Der Zeitraum MUSS konkret angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Zeitraum;
    /**
     * The ObererGrenzwert
     * Meta information extracted from the WSDL
     * - documentation: Der obere Grenzwert definiert den Wert, bis zu dem (der Wert nicht eingeschlossen) die Bedingung gilt (also &lt;).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Grenzwert
     */
    public $ObererGrenzwert;
    /**
     * Constructor method for CT_Vereinbarung
     * @uses CT_Vereinbarung::setKategorieID()
     * @uses CT_Vereinbarung::setWert()
     * @uses CT_Vereinbarung::setWerteinheit()
     * @uses CT_Vereinbarung::setZahlungsweise()
     * @uses CT_Vereinbarung::setArtID()
     * @uses CT_Vereinbarung::setWaehrung()
     * @uses CT_Vereinbarung::setBezeichnung()
     * @uses CT_Vereinbarung::setBedingung()
     * @uses CT_Vereinbarung::setUntererGrenzwert()
     * @uses CT_Vereinbarung::setZeitraum()
     * @uses CT_Vereinbarung::setObererGrenzwert()
     * @param string $kategorieID
     * @param float $wert
     * @param string $werteinheit
     * @param string $zahlungsweise
     * @param string $artID
     * @param string $waehrung
     * @param string $bezeichnung
     * @param string $bedingung
     * @param \BiPRO\StructType\CT_Grenzwert $untererGrenzwert
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @param \BiPRO\StructType\CT_Grenzwert $obererGrenzwert
     */
    public function __construct($kategorieID = null, $wert = null, $werteinheit = null, $zahlungsweise = null, $artID = null, $waehrung = null, $bezeichnung = null, $bedingung = null, \BiPRO\StructType\CT_Grenzwert $untererGrenzwert = null, \BiPRO\StructType\CT_Zeitraum $zeitraum = null, \BiPRO\StructType\CT_Grenzwert $obererGrenzwert = null)
    {
        $this
            ->setKategorieID($kategorieID)
            ->setWert($wert)
            ->setWerteinheit($werteinheit)
            ->setZahlungsweise($zahlungsweise)
            ->setArtID($artID)
            ->setWaehrung($waehrung)
            ->setBezeichnung($bezeichnung)
            ->setBedingung($bedingung)
            ->setUntererGrenzwert($untererGrenzwert)
            ->setZeitraum($zeitraum)
            ->setObererGrenzwert($obererGrenzwert);
    }
    /**
     * Get KategorieID value
     * @return string
     */
    public function getKategorieID()
    {
        return $this->KategorieID;
    }
    /**
     * Set KategorieID value
     * @uses \BiPRO\EnumType\ST_VereinbarungKategorieID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_VereinbarungKategorieID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kategorieID
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setKategorieID($kategorieID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_VereinbarungKategorieID::valueIsValid($kategorieID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_VereinbarungKategorieID', is_array($kategorieID) ? implode(', ', $kategorieID) : var_export($kategorieID, true), implode(', ', \BiPRO\EnumType\ST_VereinbarungKategorieID::getValidValues())), __LINE__);
        }
        $this->KategorieID = $kategorieID;
        return $this;
    }
    /**
     * Get Wert value
     * @return float
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get Zahlungsweise value
     * @return string
     */
    public function getZahlungsweise()
    {
        return $this->Zahlungsweise;
    }
    /**
     * Set Zahlungsweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsweise
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setZahlungsweise($zahlungsweise = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($zahlungsweise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($zahlungsweise) ? implode(', ', $zahlungsweise) : var_export($zahlungsweise, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues())), __LINE__);
        }
        $this->Zahlungsweise = $zahlungsweise;
        return $this;
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Vereinbarung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vereinbarung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vereinbarung::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vereinbarung', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Vereinbarung::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waehrung
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($waehrung) ? implode(', ', $waehrung) : var_export($waehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get Bedingung value
     * @return string|null
     */
    public function getBedingung()
    {
        return $this->Bedingung;
    }
    /**
     * Set Bedingung value
     * @uses \BiPRO\EnumType\ST_Vereinbarungsbedingung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vereinbarungsbedingung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bedingung
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setBedingung($bedingung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vereinbarungsbedingung::valueIsValid($bedingung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vereinbarungsbedingung', is_array($bedingung) ? implode(', ', $bedingung) : var_export($bedingung, true), implode(', ', \BiPRO\EnumType\ST_Vereinbarungsbedingung::getValidValues())), __LINE__);
        }
        $this->Bedingung = $bedingung;
        return $this;
    }
    /**
     * Get UntererGrenzwert value
     * @return \BiPRO\StructType\CT_Grenzwert|null
     */
    public function getUntererGrenzwert()
    {
        return $this->UntererGrenzwert;
    }
    /**
     * Set UntererGrenzwert value
     * @param \BiPRO\StructType\CT_Grenzwert $untererGrenzwert
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setUntererGrenzwert(\BiPRO\StructType\CT_Grenzwert $untererGrenzwert = null)
    {
        $this->UntererGrenzwert = $untererGrenzwert;
        return $this;
    }
    /**
     * Get Zeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getZeitraum()
    {
        return $this->Zeitraum;
    }
    /**
     * Set Zeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setZeitraum(\BiPRO\StructType\CT_Zeitraum $zeitraum = null)
    {
        $this->Zeitraum = $zeitraum;
        return $this;
    }
    /**
     * Get ObererGrenzwert value
     * @return \BiPRO\StructType\CT_Grenzwert|null
     */
    public function getObererGrenzwert()
    {
        return $this->ObererGrenzwert;
    }
    /**
     * Set ObererGrenzwert value
     * @param \BiPRO\StructType\CT_Grenzwert $obererGrenzwert
     * @return \BiPRO\StructType\CT_Vereinbarung
     */
    public function setObererGrenzwert(\BiPRO\StructType\CT_Grenzwert $obererGrenzwert = null)
    {
        $this->ObererGrenzwert = $obererGrenzwert;
        return $this;
    }
}
