<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_VerbundenesFahrzeug StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Fahrzeug, das mit einem anderen Fahrzeug verbunden ist.
 * @subpackage Structs
 */
class CT_VerbundenesFahrzeug extends CT_Gegenstandsrolle
{
    /**
     * The ZiehendesFahrzeug
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Fahrzeug mit dieser Rolle ist das ziehende Fahrzeug, somit ist das Fahrzeug mit der Referenz auf diese Klasse das gezogene Fahrzeug.NEIN = Das Fahrzeug mit dieser Rolle ist das gezogene Fahrzeug, somit ist das Fahrzeug mit
     * der Referenz auf diese Klasse das ziehende Fahrzeug.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $ZiehendesFahrzeug;
    /**
     * Constructor method for CT_VerbundenesFahrzeug
     * @uses CT_VerbundenesFahrzeug::setZiehendesFahrzeug()
     * @param bool $ziehendesFahrzeug
     */
    public function __construct($ziehendesFahrzeug = null)
    {
        $this
            ->setZiehendesFahrzeug($ziehendesFahrzeug);
    }
    /**
     * Get ZiehendesFahrzeug value
     * @return bool
     */
    public function getZiehendesFahrzeug()
    {
        return $this->ZiehendesFahrzeug;
    }
    /**
     * Set ZiehendesFahrzeug value
     * @param bool $ziehendesFahrzeug
     * @return \BiPRO\StructType\CT_VerbundenesFahrzeug
     */
    public function setZiehendesFahrzeug($ziehendesFahrzeug = null)
    {
        // validation for constraint: boolean
        if (!is_null($ziehendesFahrzeug) && !is_bool($ziehendesFahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ziehendesFahrzeug, true), gettype($ziehendesFahrzeug)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($ziehendesFahrzeug) && !preg_match('/true|false/', $ziehendesFahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($ziehendesFahrzeug, true)), __LINE__);
        }
        $this->ZiehendesFahrzeug = $ziehendesFahrzeug;
        return $this;
    }
}
