<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Unterschrift StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Übermittlung von Informationen, wann, wo und ob eine Unterschrift geleistet wurde.
 * @subpackage Structs
 */
class CT_Unterschrift extends CT_Objekt
{
    /**
     * The Ort
     * Meta information extracted from the WSDL
     * - documentation: Ort, an dem die Unterschrift geleistet wurde.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Ort;
    /**
     * The Datum
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem die Unterschrift geleistet wurde. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Datum;
    /**
     * The UnterschriftLiegtVor
     * Meta information extracted from the WSDL
     * - documentation: Information, ob die Unterschrift vorliegt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $UnterschriftLiegtVor;
    /**
     * Constructor method for CT_Unterschrift
     * @uses CT_Unterschrift::setOrt()
     * @uses CT_Unterschrift::setDatum()
     * @uses CT_Unterschrift::setUnterschriftLiegtVor()
     * @param string $ort
     * @param string $datum
     * @param bool $unterschriftLiegtVor
     */
    public function __construct($ort = null, $datum = null, $unterschriftLiegtVor = null)
    {
        $this
            ->setOrt($ort)
            ->setDatum($datum)
            ->setUnterschriftLiegtVor($unterschriftLiegtVor);
    }
    /**
     * Get Ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->Ort;
    }
    /**
     * Set Ort value
     * @param string $ort
     * @return \BiPRO\StructType\CT_Unterschrift
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ort) && mb_strlen($ort) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($ort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ort) && mb_strlen($ort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ort)), __LINE__);
        }
        $this->Ort = $ort;
        return $this;
    }
    /**
     * Get Datum value
     * @return string|null
     */
    public function getDatum()
    {
        return $this->Datum;
    }
    /**
     * Set Datum value
     * @param string $datum
     * @return \BiPRO\StructType\CT_Unterschrift
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($datum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($datum, true)), __LINE__);
        }
        $this->Datum = $datum;
        return $this;
    }
    /**
     * Get UnterschriftLiegtVor value
     * @return bool|null
     */
    public function getUnterschriftLiegtVor()
    {
        return $this->UnterschriftLiegtVor;
    }
    /**
     * Set UnterschriftLiegtVor value
     * @param bool $unterschriftLiegtVor
     * @return \BiPRO\StructType\CT_Unterschrift
     */
    public function setUnterschriftLiegtVor($unterschriftLiegtVor = null)
    {
        // validation for constraint: boolean
        if (!is_null($unterschriftLiegtVor) && !is_bool($unterschriftLiegtVor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unterschriftLiegtVor, true), gettype($unterschriftLiegtVor)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($unterschriftLiegtVor) && !preg_match('/true|false/', $unterschriftLiegtVor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($unterschriftLiegtVor, true)), __LINE__);
        }
        $this->UnterschriftLiegtVor = $unterschriftLiegtVor;
        return $this;
    }
}
