<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Und StructType
 * Meta information extracted from the WSDL
 * - documentation: Mit der Klasse UND können logische UND-Verknüpfungen von zwei oder mehr Bedingungen abgebildet werden. Das Ergebnis ist true, wenn alle so verknüpften Bedingungen true sind, ansonsten ist das Ergebnis false.
 * @subpackage Structs
 */
class CT_Und extends CT_Bedingung
{
    /**
     * The Bedingung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \BiPRO\StructType\CT_Bedingung[]
     */
    public $Bedingung;
    /**
     * Constructor method for CT_Und
     * @uses CT_Und::setBedingung()
     * @param \BiPRO\StructType\CT_Bedingung[] $bedingung
     */
    public function __construct(array $bedingung = array())
    {
        $this
            ->setBedingung($bedingung);
    }
    /**
     * Get Bedingung value
     * @return \BiPRO\StructType\CT_Bedingung[]
     */
    public function getBedingung()
    {
        return $this->Bedingung;
    }
    /**
     * This method is responsible for validating the values passed to the setBedingung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedingung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedingungForArrayConstraintsFromSetBedingung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_UndBedingungItem) {
            // validation for constraint: itemType
            if (!$cT_UndBedingungItem instanceof \BiPRO\StructType\CT_Bedingung) {
                $invalidValues[] = is_object($cT_UndBedingungItem) ? get_class($cT_UndBedingungItem) : sprintf('%s(%s)', gettype($cT_UndBedingungItem), var_export($cT_UndBedingungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bedingung property can only contain items of type \BiPRO\StructType\CT_Bedingung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bedingung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Bedingung[] $bedingung
     * @return \BiPRO\StructType\CT_Und
     */
    public function setBedingung(array $bedingung = array())
    {
        // validation for constraint: array
        if ('' !== ($bedingungArrayErrorMessage = self::validateBedingungForArrayConstraintsFromSetBedingung($bedingung))) {
            throw new \InvalidArgumentException($bedingungArrayErrorMessage, __LINE__);
        }
        $this->Bedingung = $bedingung;
        return $this;
    }
    /**
     * Add item to Bedingung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Bedingung $item
     * @return \BiPRO\StructType\CT_Und
     */
    public function addToBedingung(\BiPRO\StructType\CT_Bedingung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Bedingung) {
            throw new \InvalidArgumentException(sprintf('The Bedingung property can only contain items of type \BiPRO\StructType\CT_Bedingung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bedingung[] = $item;
        return $this;
    }
}
