<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Teilzeit StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zur Abbildung der Teilzeit.
 * @subpackage Structs
 */
class CT_Teilzeit extends CT_Objekt
{
    /**
     * The Anteil
     * Meta information extracted from the WSDL
     * - documentation: Gibt das Verhältnis von Teilzeit zur Vollzeit in Prozent an. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Anteil;
    /**
     * The Wochenstunden
     * Meta information extracted from the WSDL
     * - documentation: Angabe der zu leistenden Wochenstunden.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Wochenstunden;
    /**
     * The Vollzeitstunden
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Wochenstunden einer Vollzeitstelle.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Vollzeitstunden;
    /**
     * Constructor method for CT_Teilzeit
     * @uses CT_Teilzeit::setAnteil()
     * @uses CT_Teilzeit::setWochenstunden()
     * @uses CT_Teilzeit::setVollzeitstunden()
     * @param float $anteil
     * @param float $wochenstunden
     * @param float $vollzeitstunden
     */
    public function __construct($anteil = null, $wochenstunden = null, $vollzeitstunden = null)
    {
        $this
            ->setAnteil($anteil)
            ->setWochenstunden($wochenstunden)
            ->setVollzeitstunden($vollzeitstunden);
    }
    /**
     * Get Anteil value
     * @return float|null
     */
    public function getAnteil()
    {
        return $this->Anteil;
    }
    /**
     * Set Anteil value
     * @param float $anteil
     * @return \BiPRO\StructType\CT_Teilzeit
     */
    public function setAnteil($anteil = null)
    {
        // validation for constraint: float
        if (!is_null($anteil) && !(is_float($anteil) || is_numeric($anteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteil, true), gettype($anteil)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anteil) && $anteil < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anteil, true)), __LINE__);
        }
        $this->Anteil = $anteil;
        return $this;
    }
    /**
     * Get Wochenstunden value
     * @return float|null
     */
    public function getWochenstunden()
    {
        return $this->Wochenstunden;
    }
    /**
     * Set Wochenstunden value
     * @param float $wochenstunden
     * @return \BiPRO\StructType\CT_Teilzeit
     */
    public function setWochenstunden($wochenstunden = null)
    {
        // validation for constraint: float
        if (!is_null($wochenstunden) && !(is_float($wochenstunden) || is_numeric($wochenstunden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wochenstunden, true), gettype($wochenstunden)), __LINE__);
        }
        $this->Wochenstunden = $wochenstunden;
        return $this;
    }
    /**
     * Get Vollzeitstunden value
     * @return float|null
     */
    public function getVollzeitstunden()
    {
        return $this->Vollzeitstunden;
    }
    /**
     * Set Vollzeitstunden value
     * @param float $vollzeitstunden
     * @return \BiPRO\StructType\CT_Teilzeit
     */
    public function setVollzeitstunden($vollzeitstunden = null)
    {
        // validation for constraint: float
        if (!is_null($vollzeitstunden) && !(is_float($vollzeitstunden) || is_numeric($vollzeitstunden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vollzeitstunden, true), gettype($vollzeitstunden)), __LINE__);
        }
        $this->Vollzeitstunden = $vollzeitstunden;
        return $this;
    }
}
