<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Teilbeitrag StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Abbildung von Teilbeiträgen.
 * @subpackage Structs
 */
class CT_Teilbeitrag extends CT_Objekt
{
    /**
     * The Anteil
     * Meta information extracted from the WSDL
     * - documentation: Anteil des Teilbeitrags an der Gesamtsumme. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Anteil;
    /**
     * The Betrag
     * Meta information extracted from the WSDL
     * - documentation: Betrag des Teilbeitrags.Erfolgt die Bestimmung des Beitragsanteil mittels dem Attribut Anteil, MUSS der Betrag angegeben werden, sobald er erstmalig berechnet wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Betrag
     */
    public $Betrag;
    /**
     * The Beitragsfoerderung
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Förderung des entsprechenden Teilbeitrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitragsfoerderung
     */
    public $Beitragsfoerderung;
    /**
     * The Beitragsschuldner
     * Meta information extracted from the WSDL
     * - documentation: Beitragsschuldner des Teilbeitrags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitragsschuldner
     */
    public $Beitragsschuldner;
    /**
     * Constructor method for CT_Teilbeitrag
     * @uses CT_Teilbeitrag::setAnteil()
     * @uses CT_Teilbeitrag::setBetrag()
     * @uses CT_Teilbeitrag::setBeitragsfoerderung()
     * @uses CT_Teilbeitrag::setBeitragsschuldner()
     * @param float $anteil
     * @param \BiPRO\StructType\CT_Betrag $betrag
     * @param \BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung
     * @param \BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner
     */
    public function __construct($anteil = null, \BiPRO\StructType\CT_Betrag $betrag = null, \BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung = null, \BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner = null)
    {
        $this
            ->setAnteil($anteil)
            ->setBetrag($betrag)
            ->setBeitragsfoerderung($beitragsfoerderung)
            ->setBeitragsschuldner($beitragsschuldner);
    }
    /**
     * Get Anteil value
     * @return float|null
     */
    public function getAnteil()
    {
        return $this->Anteil;
    }
    /**
     * Set Anteil value
     * @param float $anteil
     * @return \BiPRO\StructType\CT_Teilbeitrag
     */
    public function setAnteil($anteil = null)
    {
        // validation for constraint: float
        if (!is_null($anteil) && !(is_float($anteil) || is_numeric($anteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteil, true), gettype($anteil)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anteil) && $anteil < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anteil, true)), __LINE__);
        }
        $this->Anteil = $anteil;
        return $this;
    }
    /**
     * Get Betrag value
     * @return \BiPRO\StructType\CT_Betrag|null
     */
    public function getBetrag()
    {
        return $this->Betrag;
    }
    /**
     * Set Betrag value
     * @param \BiPRO\StructType\CT_Betrag $betrag
     * @return \BiPRO\StructType\CT_Teilbeitrag
     */
    public function setBetrag(\BiPRO\StructType\CT_Betrag $betrag = null)
    {
        $this->Betrag = $betrag;
        return $this;
    }
    /**
     * Get Beitragsfoerderung value
     * @return \BiPRO\StructType\CT_Beitragsfoerderung|null
     */
    public function getBeitragsfoerderung()
    {
        return $this->Beitragsfoerderung;
    }
    /**
     * Set Beitragsfoerderung value
     * @param \BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung
     * @return \BiPRO\StructType\CT_Teilbeitrag
     */
    public function setBeitragsfoerderung(\BiPRO\StructType\CT_Beitragsfoerderung $beitragsfoerderung = null)
    {
        $this->Beitragsfoerderung = $beitragsfoerderung;
        return $this;
    }
    /**
     * Get Beitragsschuldner value
     * @return \BiPRO\StructType\CT_Beitragsschuldner|null
     */
    public function getBeitragsschuldner()
    {
        return $this->Beitragsschuldner;
    }
    /**
     * Set Beitragsschuldner value
     * @param \BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner
     * @return \BiPRO\StructType\CT_Teilbeitrag
     */
    public function setBeitragsschuldner(\BiPRO\StructType\CT_Beitragsschuldner $beitragsschuldner = null)
    {
        $this->Beitragsschuldner = $beitragsschuldner;
        return $this;
    }
}
