<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Stichtagsbetrag StructType
 * Meta information extracted from the WSDL
 * - documentation: Beschreibt einen Geldwert, der zu einem bestimmten Zeitpunkt gültig ist.Garantierte Leistungen verstehen sich ohne zukünftige Überschussbeteiligungen aber inklusive bereits verdienter Überschussanteile. Gesamte Leistungen
 * verstehen sich inklusive bereits verdienter und noch zu erwartender Überschussanteile.Renten und Kapitalleistungen schließen sich wechselseitig aus, die gemeinsame Angabe ist nur bei Tarifen mit Renten-/Kapitalwahlrecht zulässig.Summenwerte gelten
 * sofern nicht anders angegeben vom Vertragsbeginn bis zum angegebenen Stichtag.
 * @subpackage Structs
 */
class CT_Stichtagsbetrag extends CT_Geldwert
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Stichtagsbetrags.Garantierte Leistungen verstehen sich ohne zukünftige Überschussbeteiligungen aber inklusive bereits verdienter Überschussanteile. Gesamte Leistungen verstehen sich inklusive bereits verdienter und noch zu
     * erwartender Überschussanteile.Renten und Kapitalleistungen schließen sich wechselseitig aus, die gemeinsame Angabe ist nur bei Tarifen mit Renten-/Kapitalwahlrecht zulässig.Summenwerte gelten sofern nicht anders angegeben vom Vertragsbeginn bis
     * zum angegebenen Stichtag.an der KlasseÜber das Objekt Berechnungsgrundlage können Angaben dazu erfolgen, ob bestimmte Faktoren in die Bestimmung des Werts eingeflossen sind. Erfolgt eine solche Angabe nicht, so gelten folgende
     * Standardannahmen:(Letzte/Summe)ErhalteneZulagen:Zulagen berücksichtigt - jaGezahlteBeitragssumme: Zulagen berücksichtigt - neinGarantierteRente/Erlebensfallleistung:Zulagen berücksichtigt - jaSteuern berücksichtigt - jaGesamte/Beitragsfreie
     * Rente/Erlebens-/Todesfallleistung:Zulagen berücksichtigt - jaHochrechnungszins - Pflichtangabe (bei fondsgebundenen)Wertentwicklung gem. Hochrechnungszins nach Fondskosten - jaSteuern berücksichtigt - neinGarantierteTodesfallleistung:Zulagen
     * berücksichtigt - jaRückkaufswert:Zulagen berücksichtigt - jaStornokosten berücksichtigt - jaSteuern berücksichtigt - jaVertragswert:Zulagen berücksichtigt - jaSteuern berücksichtigt - ja
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The Berechnungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum an dem die Berechnung des Wertes erfolgt ist. technisches Berechnungsdatum. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Berechnungsdatum;
    /**
     * The Berechnungsgrundlage
     * Meta information extracted from the WSDL
     * - documentation: Berechnungsgrundlage sofern abweichend von Standardannahmen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Berechnungsgrundlage
     */
    public $Berechnungsgrundlage;
    /**
     * Constructor method for CT_Stichtagsbetrag
     * @uses CT_Stichtagsbetrag::setArtID()
     * @uses CT_Stichtagsbetrag::setBerechnungsdatum()
     * @uses CT_Stichtagsbetrag::setBerechnungsgrundlage()
     * @param string $artID
     * @param string $berechnungsdatum
     * @param \BiPRO\StructType\CT_Berechnungsgrundlage $berechnungsgrundlage
     */
    public function __construct($artID = null, $berechnungsdatum = null, \BiPRO\StructType\CT_Berechnungsgrundlage $berechnungsgrundlage = null)
    {
        $this
            ->setArtID($artID)
            ->setBerechnungsdatum($berechnungsdatum)
            ->setBerechnungsgrundlage($berechnungsgrundlage);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Stichtagswert::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Stichtagswert::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Stichtagsbetrag
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Stichtagswert::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Stichtagswert', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Stichtagswert::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Berechnungsdatum value
     * @return string|null
     */
    public function getBerechnungsdatum()
    {
        return $this->Berechnungsdatum;
    }
    /**
     * Set Berechnungsdatum value
     * @param string $berechnungsdatum
     * @return \BiPRO\StructType\CT_Stichtagsbetrag
     */
    public function setBerechnungsdatum($berechnungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($berechnungsdatum) && !is_string($berechnungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($berechnungsdatum, true), gettype($berechnungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($berechnungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $berechnungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($berechnungsdatum, true)), __LINE__);
        }
        $this->Berechnungsdatum = $berechnungsdatum;
        return $this;
    }
    /**
     * Get Berechnungsgrundlage value
     * @return \BiPRO\StructType\CT_Berechnungsgrundlage|null
     */
    public function getBerechnungsgrundlage()
    {
        return $this->Berechnungsgrundlage;
    }
    /**
     * Set Berechnungsgrundlage value
     * @param \BiPRO\StructType\CT_Berechnungsgrundlage $berechnungsgrundlage
     * @return \BiPRO\StructType\CT_Stichtagsbetrag
     */
    public function setBerechnungsgrundlage(\BiPRO\StructType\CT_Berechnungsgrundlage $berechnungsgrundlage = null)
    {
        $this->Berechnungsgrundlage = $berechnungsgrundlage;
        return $this;
    }
}
