<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Steuer StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einer Steuer (z.B. Versicherungsteuer, Umsatzsteuer).
 * @subpackage Structs
 */
class CT_Steuer extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Steuer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Satz
     * Meta information extracted from the WSDL
     * - documentation: Prozentsatz der Steuer
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Satz;
    /**
     * The Land
     * Meta information extracted from the WSDL
     * - documentation: Land in dem die Steuer abgeführt werden muss
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Land;
    /**
     * The Versicherungsteuerabfuehrung
     * Meta information extracted from the WSDL
     * - documentation: Information, wer die Versicherungsteuer abführt.Bei Versicherungsteuerfreiheit (Leben, Kranken etc.) DARF dieses Attribut nicht verwendet werden. Ist die Steuer ungleich Null und fehlt dieses Attribut, MUSS das Attribut als mit "1"
     * (VU) belegt interpretiert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Versicherungsteuerabfuehrung;
    /**
     * The Betrag
     * Meta information extracted from the WSDL
     * - documentation: Steuerbetrag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Betrag
     */
    public $Betrag;
    /**
     * Constructor method for CT_Steuer
     * @uses CT_Steuer::setArtID()
     * @uses CT_Steuer::setSatz()
     * @uses CT_Steuer::setLand()
     * @uses CT_Steuer::setVersicherungsteuerabfuehrung()
     * @uses CT_Steuer::setBetrag()
     * @param string $artID
     * @param float $satz
     * @param string $land
     * @param string $versicherungsteuerabfuehrung
     * @param \BiPRO\StructType\CT_Betrag $betrag
     */
    public function __construct($artID = null, $satz = null, $land = null, $versicherungsteuerabfuehrung = null, \BiPRO\StructType\CT_Betrag $betrag = null)
    {
        $this
            ->setArtID($artID)
            ->setSatz($satz)
            ->setLand($land)
            ->setVersicherungsteuerabfuehrung($versicherungsteuerabfuehrung)
            ->setBetrag($betrag);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Steuerart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Steuerart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Steuer
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Steuerart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Steuerart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Steuerart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Satz value
     * @return float|null
     */
    public function getSatz()
    {
        return $this->Satz;
    }
    /**
     * Set Satz value
     * @param float $satz
     * @return \BiPRO\StructType\CT_Steuer
     */
    public function setSatz($satz = null)
    {
        // validation for constraint: float
        if (!is_null($satz) && !(is_float($satz) || is_numeric($satz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($satz, true), gettype($satz)), __LINE__);
        }
        $this->Satz = $satz;
        return $this;
    }
    /**
     * Get Land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->Land;
    }
    /**
     * Set Land value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $land
     * @return \BiPRO\StructType\CT_Steuer
     */
    public function setLand($land = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($land) ? implode(', ', $land) : var_export($land, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->Land = $land;
        return $this;
    }
    /**
     * Get Versicherungsteuerabfuehrung value
     * @return string|null
     */
    public function getVersicherungsteuerabfuehrung()
    {
        return $this->Versicherungsteuerabfuehrung;
    }
    /**
     * Set Versicherungsteuerabfuehrung value
     * @uses \BiPRO\EnumType\ST_Versicherungsteuerabfuehrung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Versicherungsteuerabfuehrung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $versicherungsteuerabfuehrung
     * @return \BiPRO\StructType\CT_Steuer
     */
    public function setVersicherungsteuerabfuehrung($versicherungsteuerabfuehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Versicherungsteuerabfuehrung::valueIsValid($versicherungsteuerabfuehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Versicherungsteuerabfuehrung', is_array($versicherungsteuerabfuehrung) ? implode(', ', $versicherungsteuerabfuehrung) : var_export($versicherungsteuerabfuehrung, true), implode(', ', \BiPRO\EnumType\ST_Versicherungsteuerabfuehrung::getValidValues())), __LINE__);
        }
        $this->Versicherungsteuerabfuehrung = $versicherungsteuerabfuehrung;
        return $this;
    }
    /**
     * Get Betrag value
     * @return \BiPRO\StructType\CT_Betrag|null
     */
    public function getBetrag()
    {
        return $this->Betrag;
    }
    /**
     * Set Betrag value
     * @param \BiPRO\StructType\CT_Betrag $betrag
     * @return \BiPRO\StructType\CT_Steuer
     */
    public function setBetrag(\BiPRO\StructType\CT_Betrag $betrag = null)
    {
        $this->Betrag = $betrag;
        return $this;
    }
}
