<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Status StructType
 * Meta information extracted from the WSDL
 * - documentation: Dient der Abfrage oder Uebermittlung des Status eines laufenden oder abgeschlossenen Prozesses.
 * @subpackage Structs
 */
class CT_Status extends CT_Objekt
{
    /**
     * The ProzessID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung des fachlichen Prozesses beim Provider. | wird technisch belegt
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ProzessID;
    /**
     * The Zeitstempel
     * Meta information extracted from the WSDL
     * - documentation: Aktuelles Datum und Uhrzeit zum Bearbeitungszeitpunkt. | wie ST_DatumZeit ergänzt um Sekunden
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]
     * @var string
     */
    public $Zeitstempel;
    /**
     * The StatusID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung der Statusmeldung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusID;
    /**
     * The Schwebe
     * Meta information extracted from the WSDL
     * - documentation: Ein Teilprozess wird regelmäßig technisch synchron durchlaufen. Nach einem Request des Service Consumers folgt ein Response des Service Providers. Damit ist dieser Prozess abgeschlossen. Ein technisch synchron übermittelter
     * Geschäftsvorgang kann jedoch nicht immer fallabschließend bearbeitet werden. Das Ende der Bearbeitung stimmt entsprechend nicht immer mit dem Ende des Teilprozesses überein. In diesem Fall handelt es sich um einen schwebenden Vorgang. Zur
     * Kennzeichnung, dass der Vorgang schwebend ist, MUSS das Atttribut Schwebe mit dem Wert true gefüllt werden. Dies ist für den Service Consumer zugleich ein Indikator, an dem er erkennen kann, dass möglicherweise ein Tracking des Vorgangs über
     * einen dritten Business Service (z. B. N430) erfolgen kann.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $Schwebe;
    /**
     * The Meldung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Meldung[]
     */
    public $Meldung;
    /**
     * The Gueltigkeitsende
     * Meta information extracted from the WSDL
     * - documentation: Zeitpunkt bis zu dem die zum Vorgang gehoerigen Daten beim Anbieter vorgehalten werden. | wie ST_DatumZeit ergänzt um Sekunden
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]
     * @var string
     */
    public $Gueltigkeitsende;
    /**
     * Constructor method for CT_Status
     * @uses CT_Status::setProzessID()
     * @uses CT_Status::setZeitstempel()
     * @uses CT_Status::setStatusID()
     * @uses CT_Status::setSchwebe()
     * @uses CT_Status::setMeldung()
     * @uses CT_Status::setGueltigkeitsende()
     * @param string $prozessID
     * @param string $zeitstempel
     * @param string $statusID
     * @param bool $schwebe
     * @param \BiPRO\StructType\CT_Meldung[] $meldung
     * @param string $gueltigkeitsende
     */
    public function __construct($prozessID = null, $zeitstempel = null, $statusID = null, $schwebe = null, array $meldung = array(), $gueltigkeitsende = null)
    {
        $this
            ->setProzessID($prozessID)
            ->setZeitstempel($zeitstempel)
            ->setStatusID($statusID)
            ->setSchwebe($schwebe)
            ->setMeldung($meldung)
            ->setGueltigkeitsende($gueltigkeitsende);
    }
    /**
     * Get ProzessID value
     * @return string
     */
    public function getProzessID()
    {
        return $this->ProzessID;
    }
    /**
     * Set ProzessID value
     * @param string $prozessID
     * @return \BiPRO\StructType\CT_Status
     */
    public function setProzessID($prozessID = null)
    {
        // validation for constraint: string
        if (!is_null($prozessID) && !is_string($prozessID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prozessID, true), gettype($prozessID)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($prozessID) && mb_strlen($prozessID) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($prozessID)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($prozessID) && mb_strlen($prozessID) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($prozessID)), __LINE__);
        }
        $this->ProzessID = $prozessID;
        return $this;
    }
    /**
     * Get Zeitstempel value
     * @return string
     */
    public function getZeitstempel()
    {
        return $this->Zeitstempel;
    }
    /**
     * Set Zeitstempel value
     * @param string $zeitstempel
     * @return \BiPRO\StructType\CT_Status
     */
    public function setZeitstempel($zeitstempel = null)
    {
        // validation for constraint: string
        if (!is_null($zeitstempel) && !is_string($zeitstempel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zeitstempel, true), gettype($zeitstempel)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9])
        if (!is_null($zeitstempel) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]/', $zeitstempel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]', var_export($zeitstempel, true)), __LINE__);
        }
        $this->Zeitstempel = $zeitstempel;
        return $this;
    }
    /**
     * Get StatusID value
     * @return string
     */
    public function getStatusID()
    {
        return $this->StatusID;
    }
    /**
     * Set StatusID value
     * @uses \BiPRO\EnumType\ST_Status::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusID
     * @return \BiPRO\StructType\CT_Status
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Status::valueIsValid($statusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Status', is_array($statusID) ? implode(', ', $statusID) : var_export($statusID, true), implode(', ', \BiPRO\EnumType\ST_Status::getValidValues())), __LINE__);
        }
        $this->StatusID = $statusID;
        return $this;
    }
    /**
     * Get Schwebe value
     * @return bool
     */
    public function getSchwebe()
    {
        return $this->Schwebe;
    }
    /**
     * Set Schwebe value
     * @param bool $schwebe
     * @return \BiPRO\StructType\CT_Status
     */
    public function setSchwebe($schwebe = null)
    {
        // validation for constraint: boolean
        if (!is_null($schwebe) && !is_bool($schwebe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schwebe, true), gettype($schwebe)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($schwebe) && !preg_match('/true|false/', $schwebe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($schwebe, true)), __LINE__);
        }
        $this->Schwebe = $schwebe;
        return $this;
    }
    /**
     * Get Meldung value
     * @return \BiPRO\StructType\CT_Meldung[]
     */
    public function getMeldung()
    {
        return $this->Meldung;
    }
    /**
     * This method is responsible for validating the values passed to the setMeldung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeldung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeldungForArrayConstraintsFromSetMeldung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_StatusMeldungItem) {
            // validation for constraint: itemType
            if (!$cT_StatusMeldungItem instanceof \BiPRO\StructType\CT_Meldung) {
                $invalidValues[] = is_object($cT_StatusMeldungItem) ? get_class($cT_StatusMeldungItem) : sprintf('%s(%s)', gettype($cT_StatusMeldungItem), var_export($cT_StatusMeldungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Meldung property can only contain items of type \BiPRO\StructType\CT_Meldung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Meldung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Meldung[] $meldung
     * @return \BiPRO\StructType\CT_Status
     */
    public function setMeldung(array $meldung = array())
    {
        // validation for constraint: array
        if ('' !== ($meldungArrayErrorMessage = self::validateMeldungForArrayConstraintsFromSetMeldung($meldung))) {
            throw new \InvalidArgumentException($meldungArrayErrorMessage, __LINE__);
        }
        $this->Meldung = $meldung;
        return $this;
    }
    /**
     * Add item to Meldung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Meldung $item
     * @return \BiPRO\StructType\CT_Status
     */
    public function addToMeldung(\BiPRO\StructType\CT_Meldung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Meldung) {
            throw new \InvalidArgumentException(sprintf('The Meldung property can only contain items of type \BiPRO\StructType\CT_Meldung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Meldung[] = $item;
        return $this;
    }
    /**
     * Get Gueltigkeitsende value
     * @return string|null
     */
    public function getGueltigkeitsende()
    {
        return $this->Gueltigkeitsende;
    }
    /**
     * Set Gueltigkeitsende value
     * @param string $gueltigkeitsende
     * @return \BiPRO\StructType\CT_Status
     */
    public function setGueltigkeitsende($gueltigkeitsende = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigkeitsende) && !is_string($gueltigkeitsende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigkeitsende, true), gettype($gueltigkeitsende)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9])
        if (!is_null($gueltigkeitsende) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]/', $gueltigkeitsende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]', var_export($gueltigkeitsende, true)), __LINE__);
        }
        $this->Gueltigkeitsende = $gueltigkeitsende;
        return $this;
    }
}
