<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Sportboot StructType
 * @subpackage Structs
 */
class CT_Sportboot extends CT_Gegenstand
{
    /**
     * The Bootsname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bootsname;
    /**
     * The Registriernummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 17
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Registriernummer;
    /**
     * The Motornummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 17
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Motornummer;
    /**
     * Constructor method for CT_Sportboot
     * @uses CT_Sportboot::setBootsname()
     * @uses CT_Sportboot::setRegistriernummer()
     * @uses CT_Sportboot::setMotornummer()
     * @param string $bootsname
     * @param string $registriernummer
     * @param string $motornummer
     */
    public function __construct($bootsname = null, $registriernummer = null, $motornummer = null)
    {
        $this
            ->setBootsname($bootsname)
            ->setRegistriernummer($registriernummer)
            ->setMotornummer($motornummer);
    }
    /**
     * Get Bootsname value
     * @return string|null
     */
    public function getBootsname()
    {
        return $this->Bootsname;
    }
    /**
     * Set Bootsname value
     * @param string $bootsname
     * @return \BiPRO\StructType\CT_Sportboot
     */
    public function setBootsname($bootsname = null)
    {
        // validation for constraint: string
        if (!is_null($bootsname) && !is_string($bootsname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bootsname, true), gettype($bootsname)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bootsname) && mb_strlen($bootsname) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($bootsname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bootsname) && mb_strlen($bootsname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bootsname)), __LINE__);
        }
        $this->Bootsname = $bootsname;
        return $this;
    }
    /**
     * Get Registriernummer value
     * @return string|null
     */
    public function getRegistriernummer()
    {
        return $this->Registriernummer;
    }
    /**
     * Set Registriernummer value
     * @param string $registriernummer
     * @return \BiPRO\StructType\CT_Sportboot
     */
    public function setRegistriernummer($registriernummer = null)
    {
        // validation for constraint: string
        if (!is_null($registriernummer) && !is_string($registriernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registriernummer, true), gettype($registriernummer)), __LINE__);
        }
        // validation for constraint: length(17)
        if (!is_null($registriernummer) && mb_strlen($registriernummer) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 17', mb_strlen($registriernummer)), __LINE__);
        }
        $this->Registriernummer = $registriernummer;
        return $this;
    }
    /**
     * Get Motornummer value
     * @return string|null
     */
    public function getMotornummer()
    {
        return $this->Motornummer;
    }
    /**
     * Set Motornummer value
     * @param string $motornummer
     * @return \BiPRO\StructType\CT_Sportboot
     */
    public function setMotornummer($motornummer = null)
    {
        // validation for constraint: string
        if (!is_null($motornummer) && !is_string($motornummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motornummer, true), gettype($motornummer)), __LINE__);
        }
        // validation for constraint: length(17)
        if (!is_null($motornummer) && mb_strlen($motornummer) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 17', mb_strlen($motornummer)), __LINE__);
        }
        $this->Motornummer = $motornummer;
        return $this;
    }
}
