<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Sonderausstattung StructType
 * @subpackage Structs
 */
class CT_Sonderausstattung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Sonderausstattung
     */
    public $ArtID;
    /**
     * The Beschreibung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschreibung;
    /**
     * The Betrag
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Betrag;
    /**
     * Constructor method for CT_Sonderausstattung
     * @uses CT_Sonderausstattung::setArtID()
     * @uses CT_Sonderausstattung::setBeschreibung()
     * @uses CT_Sonderausstattung::setBetrag()
     * @param \BiPRO\StructType\STE_Sonderausstattung $artID
     * @param string $beschreibung
     * @param float $betrag
     */
    public function __construct(\BiPRO\StructType\STE_Sonderausstattung $artID = null, $beschreibung = null, $betrag = null)
    {
        $this
            ->setArtID($artID)
            ->setBeschreibung($beschreibung)
            ->setBetrag($betrag);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Sonderausstattung|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Sonderausstattung $artID
     * @return \BiPRO\StructType\CT_Sonderausstattung
     */
    public function setArtID(\BiPRO\StructType\STE_Sonderausstattung $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->Beschreibung;
    }
    /**
     * Set Beschreibung value
     * @param string $beschreibung
     * @return \BiPRO\StructType\CT_Sonderausstattung
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibung)), __LINE__);
        }
        $this->Beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get Betrag value
     * @return float|null
     */
    public function getBetrag()
    {
        return $this->Betrag;
    }
    /**
     * Set Betrag value
     * @param float $betrag
     * @return \BiPRO\StructType\CT_Sonderausstattung
     */
    public function setBetrag($betrag = null)
    {
        // validation for constraint: float
        if (!is_null($betrag) && !(is_float($betrag) || is_numeric($betrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betrag, true), gettype($betrag)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($betrag) && mb_strlen(mb_substr($betrag, false !== mb_strpos($betrag, '.') ? mb_strpos($betrag, '.') + 1 : mb_strlen($betrag))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($betrag, true), mb_strlen(mb_substr($betrag, mb_strpos($betrag, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($betrag) && mb_strlen(preg_replace('/(\D)/', '', $betrag)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($betrag, true), mb_strlen(preg_replace('/(\D)/', '', $betrag))), __LINE__);
        }
        $this->Betrag = $betrag;
        return $this;
    }
}
