<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Sicherungsglaeubiger StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Sicherungsgläubiger ist ein Gläubiger, der seine Forderung besichert hat, etwa durch ein Pfand oder eine Bürgschaft. Sicherungsgläubiger erhalten deshalb ihre Forderungen vorrangig zurück („vorrangige Gläubiger“).
 * @subpackage Structs
 */
class CT_Sicherungsglaeubiger extends CT_Partnerrolle
{
    /**
     * The Aktenzeichen
     * Meta information extracted from the WSDL
     * - documentation: Aktenzeichen, das der Sicherungsgläubiger zu diesem Vorgang hat (Jeder Vorgang hat ein eigenes Aktenzeichen)
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Aktenzeichen;
    /**
     * Constructor method for CT_Sicherungsglaeubiger
     * @uses CT_Sicherungsglaeubiger::setAktenzeichen()
     * @param string $aktenzeichen
     */
    public function __construct($aktenzeichen = null)
    {
        $this
            ->setAktenzeichen($aktenzeichen);
    }
    /**
     * Get Aktenzeichen value
     * @return string|null
     */
    public function getAktenzeichen()
    {
        return $this->Aktenzeichen;
    }
    /**
     * Set Aktenzeichen value
     * @param string $aktenzeichen
     * @return \BiPRO\StructType\CT_Sicherungsglaeubiger
     */
    public function setAktenzeichen($aktenzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($aktenzeichen) && !is_string($aktenzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktenzeichen, true), gettype($aktenzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aktenzeichen) && mb_strlen($aktenzeichen) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aktenzeichen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aktenzeichen) && mb_strlen($aktenzeichen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aktenzeichen)), __LINE__);
        }
        $this->Aktenzeichen = $aktenzeichen;
        return $this;
    }
}
