<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Selbstbeteiligung StructType
 * @subpackage Structs
 */
class CT_Selbstbeteiligung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Selbstbeteiligung
     */
    public $ArtID;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Wert;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * The Minimum
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Minimum;
    /**
     * The Maximum
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Maximum;
    /**
     * The Waehrung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Waehrung;
    /**
     * The SBGiltFuer
     * Meta information extracted from the WSDL
     * - documentation: Zur Einschränkung der Selbstbeteiligung innherhalb einer Deckung, Gefahr oder Leistung (z.B. Brillenschäden innerhalb einer Betriebshaftpflichtversicherung eines Augenarztes).Falls es sich um eine in der Werteliste befindlichen
     * Ausprägung zu einer Deckung, Gefahr oder Leistung handelt MUSS diese über die jeweilige Klasse abgebildet werden (z.B. Für eine Deckung mit den Gefahren Feuer, Leitungswasser und Sturm bezieht sich der Selbstbehelt nur auf die Gefahr
     * Leitungswasser).Wenn das Attribut nicht geliefert wird, MUSS die Selbstbeteiligung als uneingeschränkt im Sinne von SBGiltFuer interpretiert werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SBGiltFuer;
    /**
     * Constructor method for CT_Selbstbeteiligung
     * @uses CT_Selbstbeteiligung::setArtID()
     * @uses CT_Selbstbeteiligung::setWert()
     * @uses CT_Selbstbeteiligung::setWerteinheit()
     * @uses CT_Selbstbeteiligung::setMinimum()
     * @uses CT_Selbstbeteiligung::setMaximum()
     * @uses CT_Selbstbeteiligung::setWaehrung()
     * @uses CT_Selbstbeteiligung::setSBGiltFuer()
     * @param \BiPRO\StructType\STE_Selbstbeteiligung $artID
     * @param float $wert
     * @param string $werteinheit
     * @param float $minimum
     * @param float $maximum
     * @param string $waehrung
     * @param string[] $sBGiltFuer
     */
    public function __construct(\BiPRO\StructType\STE_Selbstbeteiligung $artID = null, $wert = null, $werteinheit = null, $minimum = null, $maximum = null, $waehrung = null, array $sBGiltFuer = array())
    {
        $this
            ->setArtID($artID)
            ->setWert($wert)
            ->setWerteinheit($werteinheit)
            ->setMinimum($minimum)
            ->setMaximum($maximum)
            ->setWaehrung($waehrung)
            ->setSBGiltFuer($sBGiltFuer);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Selbstbeteiligung|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Selbstbeteiligung $artID
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function setArtID(\BiPRO\StructType\STE_Selbstbeteiligung $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Wert value
     * @return float|null
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get Minimum value
     * @return float|null
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param float $minimum
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: float
        if (!is_null($minimum) && !(is_float($minimum) || is_numeric($minimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum, true), gettype($minimum)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($minimum) && mb_strlen(mb_substr($minimum, false !== mb_strpos($minimum, '.') ? mb_strpos($minimum, '.') + 1 : mb_strlen($minimum))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($minimum, true), mb_strlen(mb_substr($minimum, mb_strpos($minimum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($minimum) && mb_strlen(preg_replace('/(\D)/', '', $minimum)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($minimum, true), mb_strlen(preg_replace('/(\D)/', '', $minimum))), __LINE__);
        }
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get Maximum value
     * @return float|null
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param float $maximum
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: float
        if (!is_null($maximum) && !(is_float($maximum) || is_numeric($maximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum, true), gettype($maximum)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($maximum) && mb_strlen(mb_substr($maximum, false !== mb_strpos($maximum, '.') ? mb_strpos($maximum, '.') + 1 : mb_strlen($maximum))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($maximum, true), mb_strlen(mb_substr($maximum, mb_strpos($maximum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($maximum) && mb_strlen(preg_replace('/(\D)/', '', $maximum)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($maximum, true), mb_strlen(preg_replace('/(\D)/', '', $maximum))), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waehrung
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($waehrung) ? implode(', ', $waehrung) : var_export($waehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get SBGiltFuer value
     * @return string[]|null
     */
    public function getSBGiltFuer()
    {
        return $this->SBGiltFuer;
    }
    /**
     * This method is responsible for validating the values passed to the setSBGiltFuer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSBGiltFuer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSBGiltFuerForArrayConstraintsFromSetSBGiltFuer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SelbstbeteiligungSBGiltFuerItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_SBGiltFuer::valueIsValid($cT_SelbstbeteiligungSBGiltFuerItem)) {
                $invalidValues[] = is_object($cT_SelbstbeteiligungSBGiltFuerItem) ? get_class($cT_SelbstbeteiligungSBGiltFuerItem) : sprintf('%s(%s)', gettype($cT_SelbstbeteiligungSBGiltFuerItem), var_export($cT_SelbstbeteiligungSBGiltFuerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_SBGiltFuer', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_SBGiltFuer::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SBGiltFuer value
     * @uses \BiPRO\EnumType\ST_SBGiltFuer::valueIsValid()
     * @uses \BiPRO\EnumType\ST_SBGiltFuer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $sBGiltFuer
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function setSBGiltFuer(array $sBGiltFuer = array())
    {
        // validation for constraint: array
        if ('' !== ($sBGiltFuerArrayErrorMessage = self::validateSBGiltFuerForArrayConstraintsFromSetSBGiltFuer($sBGiltFuer))) {
            throw new \InvalidArgumentException($sBGiltFuerArrayErrorMessage, __LINE__);
        }
        $this->SBGiltFuer = $sBGiltFuer;
        return $this;
    }
    /**
     * Add item to SBGiltFuer value
     * @uses \BiPRO\EnumType\ST_SBGiltFuer::valueIsValid()
     * @uses \BiPRO\EnumType\ST_SBGiltFuer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Selbstbeteiligung
     */
    public function addToSBGiltFuer($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_SBGiltFuer::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_SBGiltFuer', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_SBGiltFuer::getValidValues())), __LINE__);
        }
        $this->SBGiltFuer[] = $item;
        return $this;
    }
}
