<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SchadenobjektKfz StructType
 * Meta information extracted from the WSDL
 * - documentation: Kraftfahrzeug, das in einen Schaden involviert ist.
 * @subpackage Structs
 */
class CT_SchadenobjektKfz extends CT_Schadenobjekt
{
    /**
     * The AusgeloesteAirbags
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der beim Schadenereignis ausgelösten Airbags.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AusgeloesteAirbags;
    /**
     * The Fahrbereit
     * Meta information extracted from the WSDL
     * - documentation: JA = Fahrzeug ist fahrbereit.NEIN = Fahrzeug ist nicht fahrbereit. Ev. ist eine Notreparatur erforderlich, um die Fahrbereitschaft wieder herzustellen (siehe Attribute NotreparaturErforderlich und NotreparaturMoeglich).
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Fahrbereit;
    /**
     * The Verkehrssicher
     * Meta information extracted from the WSDL
     * - documentation: JA = Fahrzeug ist verkehrssicher.NEIN = Fahrzeug ist nicht verkehrssicher. Ev. ist eine Notreparatur erforderlich, um die Verkehrssicherheit wieder herzustellen (siehe Attribute NotreparaturErforderlich und NotreparaturMoeglich).
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Verkehrssicher;
    /**
     * The NotreparaturErforderlich
     * Meta information extracted from the WSDL
     * - documentation: JA = Notreparatur ist erforderlich, um die Fahrbereitschaft und/oder die Verkehrssicherheit wieder herzustellen.NEIN = Notreparatur ist nicht erforderlich.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $NotreparaturErforderlich;
    /**
     * The NotreparaturMoeglich
     * Meta information extracted from the WSDL
     * - documentation: JA = Notreparatur ist möglich, um die Fahrbereitschaft und/oder die Verkehrssicherheit wieder herzustellen.NEIN = Notreparatur ist nicht möglich.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $NotreparaturMoeglich;
    /**
     * The Totalschaden
     * Meta information extracted from the WSDL
     * - documentation: Ist der Schaden am Fahrzeug ein Totalschaden? Mögliche Antworten: Ja, Nein, Vermutlich.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Totalschaden;
    /**
     * The Zerlegung
     * Meta information extracted from the WSDL
     * - documentation: Zustand der Zerlegung des Fahrzeugs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zerlegung;
    /**
     * The Reparaturstatus
     * Meta information extracted from the WSDL
     * - documentation: Status der Reparatur des Fahrzeugs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reparaturstatus;
    /**
     * The Freigelegt
     * Meta information extracted from the WSDL
     * - documentation: JA = Die Beschädigungen des Fahrzeugs wurden so freigelegt, damit ein Sachverständiger das Fahrzeug ausreichend begutachten kann.NEIN = Die Beschädigungen des Fahrzeugs wurden nicht freigelegt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Freigelegt;
    /**
     * The NutzungsausfallGruppe
     * Meta information extracted from the WSDL
     * - documentation: Zuordnungsgruppe zum Nutzungsausfall gemäß Einstufungsliste "Sanden-Danner-Küppersbusch". | Zuordnungsgruppe zum Nutzungsausfall gemäß Einstufungsliste "Sanden-Danner-Küppersbusch".Stand 12/2014 - mit den zulässigen Werten "A"
     * bis "L".
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NutzungsausfallGruppe;
    /**
     * The BeschaedigungKfz
     * Meta information extracted from the WSDL
     * - documentation: Beschädigungen am Schadenobjekt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_BeschaedigungKfz[]
     */
    public $BeschaedigungKfz;
    /**
     * The VerbundenesFahrzeug
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf ein Fahrzeug, das mit dem Schadenobjekt zum Zeitpunkt des Schadenereignisses verbunden war.VerbundenesFahrzeug.ZiehendesFahrzeug =JA = Das Schadenobjekt war das gezogene Fahrzeug.NEIN = Das Schadenobjekt war das ziehende
     * Fahrzeug.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VerbundenesFahrzeug
     */
    public $VerbundenesFahrzeug;
    /**
     * The AnstossbereichKfz
     * Meta information extracted from the WSDL
     * - documentation: Bereiche am Schadenobjekt, an dem ein Anstoß erfolgte oder nicht erfolgte.Es werden nur die bekannten Anstoßbereiche übermittelt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AnstossbereichKfz[]
     */
    public $AnstossbereichKfz;
    /**
     * Constructor method for CT_SchadenobjektKfz
     * @uses CT_SchadenobjektKfz::setAusgeloesteAirbags()
     * @uses CT_SchadenobjektKfz::setFahrbereit()
     * @uses CT_SchadenobjektKfz::setVerkehrssicher()
     * @uses CT_SchadenobjektKfz::setNotreparaturErforderlich()
     * @uses CT_SchadenobjektKfz::setNotreparaturMoeglich()
     * @uses CT_SchadenobjektKfz::setTotalschaden()
     * @uses CT_SchadenobjektKfz::setZerlegung()
     * @uses CT_SchadenobjektKfz::setReparaturstatus()
     * @uses CT_SchadenobjektKfz::setFreigelegt()
     * @uses CT_SchadenobjektKfz::setNutzungsausfallGruppe()
     * @uses CT_SchadenobjektKfz::setBeschaedigungKfz()
     * @uses CT_SchadenobjektKfz::setVerbundenesFahrzeug()
     * @uses CT_SchadenobjektKfz::setAnstossbereichKfz()
     * @param int $ausgeloesteAirbags
     * @param bool $fahrbereit
     * @param bool $verkehrssicher
     * @param bool $notreparaturErforderlich
     * @param bool $notreparaturMoeglich
     * @param string $totalschaden
     * @param string $zerlegung
     * @param string $reparaturstatus
     * @param bool $freigelegt
     * @param string $nutzungsausfallGruppe
     * @param \BiPRO\StructType\CT_BeschaedigungKfz[] $beschaedigungKfz
     * @param \BiPRO\StructType\CT_VerbundenesFahrzeug $verbundenesFahrzeug
     * @param \BiPRO\StructType\CT_AnstossbereichKfz[] $anstossbereichKfz
     */
    public function __construct($ausgeloesteAirbags = null, $fahrbereit = null, $verkehrssicher = null, $notreparaturErforderlich = null, $notreparaturMoeglich = null, $totalschaden = null, $zerlegung = null, $reparaturstatus = null, $freigelegt = null, $nutzungsausfallGruppe = null, array $beschaedigungKfz = array(), \BiPRO\StructType\CT_VerbundenesFahrzeug $verbundenesFahrzeug = null, array $anstossbereichKfz = array())
    {
        $this
            ->setAusgeloesteAirbags($ausgeloesteAirbags)
            ->setFahrbereit($fahrbereit)
            ->setVerkehrssicher($verkehrssicher)
            ->setNotreparaturErforderlich($notreparaturErforderlich)
            ->setNotreparaturMoeglich($notreparaturMoeglich)
            ->setTotalschaden($totalschaden)
            ->setZerlegung($zerlegung)
            ->setReparaturstatus($reparaturstatus)
            ->setFreigelegt($freigelegt)
            ->setNutzungsausfallGruppe($nutzungsausfallGruppe)
            ->setBeschaedigungKfz($beschaedigungKfz)
            ->setVerbundenesFahrzeug($verbundenesFahrzeug)
            ->setAnstossbereichKfz($anstossbereichKfz);
    }
    /**
     * Get AusgeloesteAirbags value
     * @return int|null
     */
    public function getAusgeloesteAirbags()
    {
        return $this->AusgeloesteAirbags;
    }
    /**
     * Set AusgeloesteAirbags value
     * @param int $ausgeloesteAirbags
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setAusgeloesteAirbags($ausgeloesteAirbags = null)
    {
        // validation for constraint: int
        if (!is_null($ausgeloesteAirbags) && !(is_int($ausgeloesteAirbags) || ctype_digit($ausgeloesteAirbags))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ausgeloesteAirbags, true), gettype($ausgeloesteAirbags)), __LINE__);
        }
        $this->AusgeloesteAirbags = $ausgeloesteAirbags;
        return $this;
    }
    /**
     * Get Fahrbereit value
     * @return bool|null
     */
    public function getFahrbereit()
    {
        return $this->Fahrbereit;
    }
    /**
     * Set Fahrbereit value
     * @param bool $fahrbereit
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setFahrbereit($fahrbereit = null)
    {
        // validation for constraint: boolean
        if (!is_null($fahrbereit) && !is_bool($fahrbereit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fahrbereit, true), gettype($fahrbereit)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($fahrbereit) && !preg_match('/true|false/', $fahrbereit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($fahrbereit, true)), __LINE__);
        }
        $this->Fahrbereit = $fahrbereit;
        return $this;
    }
    /**
     * Get Verkehrssicher value
     * @return bool|null
     */
    public function getVerkehrssicher()
    {
        return $this->Verkehrssicher;
    }
    /**
     * Set Verkehrssicher value
     * @param bool $verkehrssicher
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setVerkehrssicher($verkehrssicher = null)
    {
        // validation for constraint: boolean
        if (!is_null($verkehrssicher) && !is_bool($verkehrssicher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verkehrssicher, true), gettype($verkehrssicher)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($verkehrssicher) && !preg_match('/true|false/', $verkehrssicher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($verkehrssicher, true)), __LINE__);
        }
        $this->Verkehrssicher = $verkehrssicher;
        return $this;
    }
    /**
     * Get NotreparaturErforderlich value
     * @return bool|null
     */
    public function getNotreparaturErforderlich()
    {
        return $this->NotreparaturErforderlich;
    }
    /**
     * Set NotreparaturErforderlich value
     * @param bool $notreparaturErforderlich
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setNotreparaturErforderlich($notreparaturErforderlich = null)
    {
        // validation for constraint: boolean
        if (!is_null($notreparaturErforderlich) && !is_bool($notreparaturErforderlich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notreparaturErforderlich, true), gettype($notreparaturErforderlich)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($notreparaturErforderlich) && !preg_match('/true|false/', $notreparaturErforderlich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($notreparaturErforderlich, true)), __LINE__);
        }
        $this->NotreparaturErforderlich = $notreparaturErforderlich;
        return $this;
    }
    /**
     * Get NotreparaturMoeglich value
     * @return bool|null
     */
    public function getNotreparaturMoeglich()
    {
        return $this->NotreparaturMoeglich;
    }
    /**
     * Set NotreparaturMoeglich value
     * @param bool $notreparaturMoeglich
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setNotreparaturMoeglich($notreparaturMoeglich = null)
    {
        // validation for constraint: boolean
        if (!is_null($notreparaturMoeglich) && !is_bool($notreparaturMoeglich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notreparaturMoeglich, true), gettype($notreparaturMoeglich)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($notreparaturMoeglich) && !preg_match('/true|false/', $notreparaturMoeglich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($notreparaturMoeglich, true)), __LINE__);
        }
        $this->NotreparaturMoeglich = $notreparaturMoeglich;
        return $this;
    }
    /**
     * Get Totalschaden value
     * @return string|null
     */
    public function getTotalschaden()
    {
        return $this->Totalschaden;
    }
    /**
     * Set Totalschaden value
     * @uses \BiPRO\EnumType\ST_JaNeinKeineAntwort::valueIsValid()
     * @uses \BiPRO\EnumType\ST_JaNeinKeineAntwort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $totalschaden
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setTotalschaden($totalschaden = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_JaNeinKeineAntwort::valueIsValid($totalschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_JaNeinKeineAntwort', is_array($totalschaden) ? implode(', ', $totalschaden) : var_export($totalschaden, true), implode(', ', \BiPRO\EnumType\ST_JaNeinKeineAntwort::getValidValues())), __LINE__);
        }
        $this->Totalschaden = $totalschaden;
        return $this;
    }
    /**
     * Get Zerlegung value
     * @return string|null
     */
    public function getZerlegung()
    {
        return $this->Zerlegung;
    }
    /**
     * Set Zerlegung value
     * @uses \BiPRO\EnumType\ST_Zerlegung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zerlegung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zerlegung
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setZerlegung($zerlegung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zerlegung::valueIsValid($zerlegung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zerlegung', is_array($zerlegung) ? implode(', ', $zerlegung) : var_export($zerlegung, true), implode(', ', \BiPRO\EnumType\ST_Zerlegung::getValidValues())), __LINE__);
        }
        $this->Zerlegung = $zerlegung;
        return $this;
    }
    /**
     * Get Reparaturstatus value
     * @return string|null
     */
    public function getReparaturstatus()
    {
        return $this->Reparaturstatus;
    }
    /**
     * Set Reparaturstatus value
     * @uses \BiPRO\EnumType\ST_Reparaturstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Reparaturstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reparaturstatus
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setReparaturstatus($reparaturstatus = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Reparaturstatus::valueIsValid($reparaturstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Reparaturstatus', is_array($reparaturstatus) ? implode(', ', $reparaturstatus) : var_export($reparaturstatus, true), implode(', ', \BiPRO\EnumType\ST_Reparaturstatus::getValidValues())), __LINE__);
        }
        $this->Reparaturstatus = $reparaturstatus;
        return $this;
    }
    /**
     * Get Freigelegt value
     * @return bool|null
     */
    public function getFreigelegt()
    {
        return $this->Freigelegt;
    }
    /**
     * Set Freigelegt value
     * @param bool $freigelegt
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setFreigelegt($freigelegt = null)
    {
        // validation for constraint: boolean
        if (!is_null($freigelegt) && !is_bool($freigelegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($freigelegt, true), gettype($freigelegt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($freigelegt) && !preg_match('/true|false/', $freigelegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($freigelegt, true)), __LINE__);
        }
        $this->Freigelegt = $freigelegt;
        return $this;
    }
    /**
     * Get NutzungsausfallGruppe value
     * @return string|null
     */
    public function getNutzungsausfallGruppe()
    {
        return $this->NutzungsausfallGruppe;
    }
    /**
     * Set NutzungsausfallGruppe value
     * @param string $nutzungsausfallGruppe
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setNutzungsausfallGruppe($nutzungsausfallGruppe = null)
    {
        // validation for constraint: string
        if (!is_null($nutzungsausfallGruppe) && !is_string($nutzungsausfallGruppe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nutzungsausfallGruppe, true), gettype($nutzungsausfallGruppe)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($nutzungsausfallGruppe) && mb_strlen($nutzungsausfallGruppe) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($nutzungsausfallGruppe)), __LINE__);
        }
        $this->NutzungsausfallGruppe = $nutzungsausfallGruppe;
        return $this;
    }
    /**
     * Get BeschaedigungKfz value
     * @return \BiPRO\StructType\CT_BeschaedigungKfz[]|null
     */
    public function getBeschaedigungKfz()
    {
        return $this->BeschaedigungKfz;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschaedigungKfz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschaedigungKfz method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschaedigungKfzForArrayConstraintsFromSetBeschaedigungKfz(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenobjektKfzBeschaedigungKfzItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenobjektKfzBeschaedigungKfzItem instanceof \BiPRO\StructType\CT_BeschaedigungKfz) {
                $invalidValues[] = is_object($cT_SchadenobjektKfzBeschaedigungKfzItem) ? get_class($cT_SchadenobjektKfzBeschaedigungKfzItem) : sprintf('%s(%s)', gettype($cT_SchadenobjektKfzBeschaedigungKfzItem), var_export($cT_SchadenobjektKfzBeschaedigungKfzItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BeschaedigungKfz property can only contain items of type \BiPRO\StructType\CT_BeschaedigungKfz, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BeschaedigungKfz value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_BeschaedigungKfz[] $beschaedigungKfz
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setBeschaedigungKfz(array $beschaedigungKfz = array())
    {
        // validation for constraint: array
        if ('' !== ($beschaedigungKfzArrayErrorMessage = self::validateBeschaedigungKfzForArrayConstraintsFromSetBeschaedigungKfz($beschaedigungKfz))) {
            throw new \InvalidArgumentException($beschaedigungKfzArrayErrorMessage, __LINE__);
        }
        $this->BeschaedigungKfz = $beschaedigungKfz;
        return $this;
    }
    /**
     * Add item to BeschaedigungKfz value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_BeschaedigungKfz $item
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function addToBeschaedigungKfz(\BiPRO\StructType\CT_BeschaedigungKfz $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_BeschaedigungKfz) {
            throw new \InvalidArgumentException(sprintf('The BeschaedigungKfz property can only contain items of type \BiPRO\StructType\CT_BeschaedigungKfz, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BeschaedigungKfz[] = $item;
        return $this;
    }
    /**
     * Get VerbundenesFahrzeug value
     * @return \BiPRO\StructType\CT_VerbundenesFahrzeug|null
     */
    public function getVerbundenesFahrzeug()
    {
        return $this->VerbundenesFahrzeug;
    }
    /**
     * Set VerbundenesFahrzeug value
     * @param \BiPRO\StructType\CT_VerbundenesFahrzeug $verbundenesFahrzeug
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setVerbundenesFahrzeug(\BiPRO\StructType\CT_VerbundenesFahrzeug $verbundenesFahrzeug = null)
    {
        $this->VerbundenesFahrzeug = $verbundenesFahrzeug;
        return $this;
    }
    /**
     * Get AnstossbereichKfz value
     * @return \BiPRO\StructType\CT_AnstossbereichKfz[]|null
     */
    public function getAnstossbereichKfz()
    {
        return $this->AnstossbereichKfz;
    }
    /**
     * This method is responsible for validating the values passed to the setAnstossbereichKfz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnstossbereichKfz method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnstossbereichKfzForArrayConstraintsFromSetAnstossbereichKfz(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenobjektKfzAnstossbereichKfzItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenobjektKfzAnstossbereichKfzItem instanceof \BiPRO\StructType\CT_AnstossbereichKfz) {
                $invalidValues[] = is_object($cT_SchadenobjektKfzAnstossbereichKfzItem) ? get_class($cT_SchadenobjektKfzAnstossbereichKfzItem) : sprintf('%s(%s)', gettype($cT_SchadenobjektKfzAnstossbereichKfzItem), var_export($cT_SchadenobjektKfzAnstossbereichKfzItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnstossbereichKfz property can only contain items of type \BiPRO\StructType\CT_AnstossbereichKfz, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnstossbereichKfz value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_AnstossbereichKfz[] $anstossbereichKfz
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function setAnstossbereichKfz(array $anstossbereichKfz = array())
    {
        // validation for constraint: array
        if ('' !== ($anstossbereichKfzArrayErrorMessage = self::validateAnstossbereichKfzForArrayConstraintsFromSetAnstossbereichKfz($anstossbereichKfz))) {
            throw new \InvalidArgumentException($anstossbereichKfzArrayErrorMessage, __LINE__);
        }
        $this->AnstossbereichKfz = $anstossbereichKfz;
        return $this;
    }
    /**
     * Add item to AnstossbereichKfz value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_AnstossbereichKfz $item
     * @return \BiPRO\StructType\CT_SchadenobjektKfz
     */
    public function addToAnstossbereichKfz(\BiPRO\StructType\CT_AnstossbereichKfz $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_AnstossbereichKfz) {
            throw new \InvalidArgumentException(sprintf('The AnstossbereichKfz property can only contain items of type \BiPRO\StructType\CT_AnstossbereichKfz, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnstossbereichKfz[] = $item;
        return $this;
    }
}
