<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadenmeldung StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Schadenmeldung ist ein Geschäftsvorgang, mit dem ein Schadenmelder (z.B. Vermittler) Information über einen Schaden an einen Empfänger (z.B. Versicherungsunternehmen) übermittelt.
 * @subpackage Structs
 */
class CT_Schadenmeldung extends CT_Geschaeftsvorgang
{
    /**
     * The EingangsdatumBeiSchadenmelder
     * Meta information extracted from the WSDL
     * - documentation: Datum mit optionaler Zeitangabe des Eingangs der Schadenmeldung beim Schadenmelder, z.B. Eingang der Schadenmeldung (z.B. Anruf) des Versicherungsnehmers beim Vermittler.Es MUSS mindestens ein Datum übermittelt werden. Wird eine
     * Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. | Datentyp zur Angabe eines
     * Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die
     * Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5 Stunden.Gültige Werte sind zum
     * Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $EingangsdatumBeiSchadenmelder;
    /**
     * The RegulierungsvollmachtWirdGenutzt
     * Meta information extracted from the WSDL
     * - documentation: Hat der Schadenmelder eine Regulierungsvollmacht, MUSS dieses Attribut verwendet werden.JA = Schadenmelder nutzt seine Regulierungsvollmacht für diesen Schaden.NEIN = Regulierung soll durch Empfänger durchgeführt werden (z. B.
     * wegen Überschreitung der Höhe der Vollmacht).
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $RegulierungsvollmachtWirdGenutzt;
    /**
     * The Parallelschaden
     * Meta information extracted from the WSDL
     * - documentation: Hinweis auf einen möglichen Parallelschaden z.B. dass es zu dem gemeldeten Gebäudeschaden auch noch eine Schadenmeldung zu einem Hausratschaden gibt. Freitext, z.B. "Habe auch einen Hausratschaden zu Vertrag 4711 gemeldet."
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Parallelschaden;
    /**
     * The AnAndererStelleGemeldet
     * Meta information extracted from the WSDL
     * - documentation: Erläuterung, ob der Schaden an anderer Stelle gemeldet wurde (z.B. Hotel, Reiseleitung).
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AnAndererStelleGemeldet;
    /**
     * The KlageAnhaengig
     * Meta information extracted from the WSDL
     * - documentation: Ja = Klage anhängig (daher bevorzugte Bearbeitung erforderlich).Nein = keine Klage anhängig.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $KlageAnhaengig;
    /**
     * The VorgangsnummerSchadenmeldung
     * Meta information extracted from the WSDL
     * - documentation: Die Vorgangsnummer einer Schadenmeldung. MUSS bei einer Nachmeldung mit der Vorgangsnummer belegt werden, die der Provider für die initiale Schadenmeldung vergeben hat.Dieses Attribut DARF NUR bei einer Nachmeldung gefüllt werden.
     * | Datentyp zur Identifizierung von Geschäftsvorgängen.Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen; ab da erfolgt eine Anpassung auf 35 Stellen.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $VorgangsnummerSchadenmeldung;
    /**
     * The VorgangsnummerRueckfrage
     * Meta information extracted from the WSDL
     * - documentation: Die Vorgangsnummer der Rückfrage, auf die sich eine Antwort bezieht. MUSS bei einer Antwort auf eine Rückfrage zur Schadenmeldung mit der Vorgangsnummer belegt werden, die der Provider für die Rückfrage vergeben hat.Dieses
     * Attribut DARF NUR bei einer Antwort auf eine Rückfrage gefüllt werden. | Datentyp zur Identifizierung von Geschäftsvorgängen.Hinweis: In allen GDV-Releases bis einschließlich 2015 hat dieser Datentyp nur 17 Stellen; ab da erfolgt eine Anpassung
     * auf 35 Stellen.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $VorgangsnummerRueckfrage;
    /**
     * The AusschlussDunkelverarbeitung
     * Meta information extracted from the WSDL
     * - documentation: Attribut zur Beschreibung der Dunkelverarbeitung beim Provider. JA = Dunkelverarbeitung beim Provider MUSS ausgeschlossen sein. Der Grund MUSS im Attribut Freitext der Klasse Schadenmeldung (Parent Geschäftsvorgang) spezifiziert
     * werden. Beispiele für den Ausschluss der Dunkelverarbeitung sind z. B. Person mit Sondervertrag, Mitarbeitervertrag (nur durch bestimmte Personen zu bearbeiten) oder der Vermittler ist sich fachlich unsicher und will keine finale Entscheidung
     * treffen oder der Vertragsstand ist unklar
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AusschlussDunkelverarbeitung;
    /**
     * The Schadenmelder
     * Meta information extracted from the WSDL
     * - documentation: Der Sender der Schadenmeldung. Typischer Schadenmelder sind: Kunde (Versicherungsnehmer, Anspruchsteller), Vermittler, Dienstleister, Versicherer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenmelder
     */
    public $Schadenmelder;
    /**
     * The Ereignis
     * Meta information extracted from the WSDL
     * - documentation: Das Schadenereignis, das mit der Schadenmeldung gemeldet wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Ereignis
     */
    public $Ereignis;
    /**
     * The Kommentar
     * Meta information extracted from the WSDL
     * - documentation: Freitext zur Schadenmeldung. Fehlt die Quelle zum Freitext, dann ist der Schadenmelder die Quelle für den Freitext.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Freitext[]
     */
    public $Kommentar;
    /**
     * The Partner
     * Meta information extracted from the WSDL
     * - documentation: Partnerliste. Diese Verknüpfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Partner in Form einer Liste innerhalb der konkreten Schadenmeldung. Referenziert werden diese Partner mit Hilfe der von
     * Partnerrolle abgeleiteten Rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partner[]
     */
    public $Partner;
    /**
     * The Gegenstand
     * Meta information extracted from the WSDL
     * - documentation: Gegenstandsliste. Diese Verknüpfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Gegenstände in Form einer Liste innerhalb der konkreten Schadenmeldung. Referenziert werden diese Gegenstände mit Hilfe
     * der von Gegenstandsrolle abgeleiteten Rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Gegenstand[]
     */
    public $Gegenstand;
    /**
     * Constructor method for CT_Schadenmeldung
     * @uses CT_Schadenmeldung::setEingangsdatumBeiSchadenmelder()
     * @uses CT_Schadenmeldung::setRegulierungsvollmachtWirdGenutzt()
     * @uses CT_Schadenmeldung::setParallelschaden()
     * @uses CT_Schadenmeldung::setAnAndererStelleGemeldet()
     * @uses CT_Schadenmeldung::setKlageAnhaengig()
     * @uses CT_Schadenmeldung::setVorgangsnummerSchadenmeldung()
     * @uses CT_Schadenmeldung::setVorgangsnummerRueckfrage()
     * @uses CT_Schadenmeldung::setAusschlussDunkelverarbeitung()
     * @uses CT_Schadenmeldung::setSchadenmelder()
     * @uses CT_Schadenmeldung::setEreignis()
     * @uses CT_Schadenmeldung::setKommentar()
     * @uses CT_Schadenmeldung::setPartner()
     * @uses CT_Schadenmeldung::setGegenstand()
     * @param string $eingangsdatumBeiSchadenmelder
     * @param bool $regulierungsvollmachtWirdGenutzt
     * @param string $parallelschaden
     * @param string $anAndererStelleGemeldet
     * @param bool $klageAnhaengig
     * @param string $vorgangsnummerSchadenmeldung
     * @param string $vorgangsnummerRueckfrage
     * @param bool $ausschlussDunkelverarbeitung
     * @param \BiPRO\StructType\CT_Schadenmelder $schadenmelder
     * @param \BiPRO\StructType\CT_Ereignis $ereignis
     * @param \BiPRO\StructType\CT_Freitext[] $kommentar
     * @param \BiPRO\StructType\CT_Partner[] $partner
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     */
    public function __construct($eingangsdatumBeiSchadenmelder = null, $regulierungsvollmachtWirdGenutzt = null, $parallelschaden = null, $anAndererStelleGemeldet = null, $klageAnhaengig = null, $vorgangsnummerSchadenmeldung = null, $vorgangsnummerRueckfrage = null, $ausschlussDunkelverarbeitung = null, \BiPRO\StructType\CT_Schadenmelder $schadenmelder = null, \BiPRO\StructType\CT_Ereignis $ereignis = null, array $kommentar = array(), array $partner = array(), array $gegenstand = array())
    {
        $this
            ->setEingangsdatumBeiSchadenmelder($eingangsdatumBeiSchadenmelder)
            ->setRegulierungsvollmachtWirdGenutzt($regulierungsvollmachtWirdGenutzt)
            ->setParallelschaden($parallelschaden)
            ->setAnAndererStelleGemeldet($anAndererStelleGemeldet)
            ->setKlageAnhaengig($klageAnhaengig)
            ->setVorgangsnummerSchadenmeldung($vorgangsnummerSchadenmeldung)
            ->setVorgangsnummerRueckfrage($vorgangsnummerRueckfrage)
            ->setAusschlussDunkelverarbeitung($ausschlussDunkelverarbeitung)
            ->setSchadenmelder($schadenmelder)
            ->setEreignis($ereignis)
            ->setKommentar($kommentar)
            ->setPartner($partner)
            ->setGegenstand($gegenstand);
    }
    /**
     * Get EingangsdatumBeiSchadenmelder value
     * @return string|null
     */
    public function getEingangsdatumBeiSchadenmelder()
    {
        return $this->EingangsdatumBeiSchadenmelder;
    }
    /**
     * Set EingangsdatumBeiSchadenmelder value
     * @param string $eingangsdatumBeiSchadenmelder
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setEingangsdatumBeiSchadenmelder($eingangsdatumBeiSchadenmelder = null)
    {
        // validation for constraint: string
        if (!is_null($eingangsdatumBeiSchadenmelder) && !is_string($eingangsdatumBeiSchadenmelder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eingangsdatumBeiSchadenmelder, true), gettype($eingangsdatumBeiSchadenmelder)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($eingangsdatumBeiSchadenmelder) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $eingangsdatumBeiSchadenmelder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($eingangsdatumBeiSchadenmelder, true)), __LINE__);
        }
        $this->EingangsdatumBeiSchadenmelder = $eingangsdatumBeiSchadenmelder;
        return $this;
    }
    /**
     * Get RegulierungsvollmachtWirdGenutzt value
     * @return bool|null
     */
    public function getRegulierungsvollmachtWirdGenutzt()
    {
        return $this->RegulierungsvollmachtWirdGenutzt;
    }
    /**
     * Set RegulierungsvollmachtWirdGenutzt value
     * @param bool $regulierungsvollmachtWirdGenutzt
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setRegulierungsvollmachtWirdGenutzt($regulierungsvollmachtWirdGenutzt = null)
    {
        // validation for constraint: boolean
        if (!is_null($regulierungsvollmachtWirdGenutzt) && !is_bool($regulierungsvollmachtWirdGenutzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($regulierungsvollmachtWirdGenutzt, true), gettype($regulierungsvollmachtWirdGenutzt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($regulierungsvollmachtWirdGenutzt) && !preg_match('/true|false/', $regulierungsvollmachtWirdGenutzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($regulierungsvollmachtWirdGenutzt, true)), __LINE__);
        }
        $this->RegulierungsvollmachtWirdGenutzt = $regulierungsvollmachtWirdGenutzt;
        return $this;
    }
    /**
     * Get Parallelschaden value
     * @return string|null
     */
    public function getParallelschaden()
    {
        return $this->Parallelschaden;
    }
    /**
     * Set Parallelschaden value
     * @param string $parallelschaden
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setParallelschaden($parallelschaden = null)
    {
        // validation for constraint: string
        if (!is_null($parallelschaden) && !is_string($parallelschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parallelschaden, true), gettype($parallelschaden)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($parallelschaden) && mb_strlen($parallelschaden) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($parallelschaden)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($parallelschaden) && mb_strlen($parallelschaden) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($parallelschaden)), __LINE__);
        }
        $this->Parallelschaden = $parallelschaden;
        return $this;
    }
    /**
     * Get AnAndererStelleGemeldet value
     * @return string|null
     */
    public function getAnAndererStelleGemeldet()
    {
        return $this->AnAndererStelleGemeldet;
    }
    /**
     * Set AnAndererStelleGemeldet value
     * @param string $anAndererStelleGemeldet
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setAnAndererStelleGemeldet($anAndererStelleGemeldet = null)
    {
        // validation for constraint: string
        if (!is_null($anAndererStelleGemeldet) && !is_string($anAndererStelleGemeldet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anAndererStelleGemeldet, true), gettype($anAndererStelleGemeldet)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($anAndererStelleGemeldet) && mb_strlen($anAndererStelleGemeldet) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($anAndererStelleGemeldet)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($anAndererStelleGemeldet) && mb_strlen($anAndererStelleGemeldet) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($anAndererStelleGemeldet)), __LINE__);
        }
        $this->AnAndererStelleGemeldet = $anAndererStelleGemeldet;
        return $this;
    }
    /**
     * Get KlageAnhaengig value
     * @return bool|null
     */
    public function getKlageAnhaengig()
    {
        return $this->KlageAnhaengig;
    }
    /**
     * Set KlageAnhaengig value
     * @param bool $klageAnhaengig
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setKlageAnhaengig($klageAnhaengig = null)
    {
        // validation for constraint: boolean
        if (!is_null($klageAnhaengig) && !is_bool($klageAnhaengig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klageAnhaengig, true), gettype($klageAnhaengig)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($klageAnhaengig) && !preg_match('/true|false/', $klageAnhaengig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($klageAnhaengig, true)), __LINE__);
        }
        $this->KlageAnhaengig = $klageAnhaengig;
        return $this;
    }
    /**
     * Get VorgangsnummerSchadenmeldung value
     * @return string|null
     */
    public function getVorgangsnummerSchadenmeldung()
    {
        return $this->VorgangsnummerSchadenmeldung;
    }
    /**
     * Set VorgangsnummerSchadenmeldung value
     * @param string $vorgangsnummerSchadenmeldung
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setVorgangsnummerSchadenmeldung($vorgangsnummerSchadenmeldung = null)
    {
        // validation for constraint: string
        if (!is_null($vorgangsnummerSchadenmeldung) && !is_string($vorgangsnummerSchadenmeldung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorgangsnummerSchadenmeldung, true), gettype($vorgangsnummerSchadenmeldung)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($vorgangsnummerSchadenmeldung) && mb_strlen($vorgangsnummerSchadenmeldung) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($vorgangsnummerSchadenmeldung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorgangsnummerSchadenmeldung) && mb_strlen($vorgangsnummerSchadenmeldung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorgangsnummerSchadenmeldung)), __LINE__);
        }
        $this->VorgangsnummerSchadenmeldung = $vorgangsnummerSchadenmeldung;
        return $this;
    }
    /**
     * Get VorgangsnummerRueckfrage value
     * @return string|null
     */
    public function getVorgangsnummerRueckfrage()
    {
        return $this->VorgangsnummerRueckfrage;
    }
    /**
     * Set VorgangsnummerRueckfrage value
     * @param string $vorgangsnummerRueckfrage
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setVorgangsnummerRueckfrage($vorgangsnummerRueckfrage = null)
    {
        // validation for constraint: string
        if (!is_null($vorgangsnummerRueckfrage) && !is_string($vorgangsnummerRueckfrage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorgangsnummerRueckfrage, true), gettype($vorgangsnummerRueckfrage)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($vorgangsnummerRueckfrage) && mb_strlen($vorgangsnummerRueckfrage) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($vorgangsnummerRueckfrage)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorgangsnummerRueckfrage) && mb_strlen($vorgangsnummerRueckfrage) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorgangsnummerRueckfrage)), __LINE__);
        }
        $this->VorgangsnummerRueckfrage = $vorgangsnummerRueckfrage;
        return $this;
    }
    /**
     * Get AusschlussDunkelverarbeitung value
     * @return bool|null
     */
    public function getAusschlussDunkelverarbeitung()
    {
        return $this->AusschlussDunkelverarbeitung;
    }
    /**
     * Set AusschlussDunkelverarbeitung value
     * @param bool $ausschlussDunkelverarbeitung
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setAusschlussDunkelverarbeitung($ausschlussDunkelverarbeitung = null)
    {
        // validation for constraint: boolean
        if (!is_null($ausschlussDunkelverarbeitung) && !is_bool($ausschlussDunkelverarbeitung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ausschlussDunkelverarbeitung, true), gettype($ausschlussDunkelverarbeitung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($ausschlussDunkelverarbeitung) && !preg_match('/true|false/', $ausschlussDunkelverarbeitung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($ausschlussDunkelverarbeitung, true)), __LINE__);
        }
        $this->AusschlussDunkelverarbeitung = $ausschlussDunkelverarbeitung;
        return $this;
    }
    /**
     * Get Schadenmelder value
     * @return \BiPRO\StructType\CT_Schadenmelder|null
     */
    public function getSchadenmelder()
    {
        return $this->Schadenmelder;
    }
    /**
     * Set Schadenmelder value
     * @param \BiPRO\StructType\CT_Schadenmelder $schadenmelder
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setSchadenmelder(\BiPRO\StructType\CT_Schadenmelder $schadenmelder = null)
    {
        $this->Schadenmelder = $schadenmelder;
        return $this;
    }
    /**
     * Get Ereignis value
     * @return \BiPRO\StructType\CT_Ereignis|null
     */
    public function getEreignis()
    {
        return $this->Ereignis;
    }
    /**
     * Set Ereignis value
     * @param \BiPRO\StructType\CT_Ereignis $ereignis
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setEreignis(\BiPRO\StructType\CT_Ereignis $ereignis = null)
    {
        $this->Ereignis = $ereignis;
        return $this;
    }
    /**
     * Get Kommentar value
     * @return \BiPRO\StructType\CT_Freitext[]|null
     */
    public function getKommentar()
    {
        return $this->Kommentar;
    }
    /**
     * This method is responsible for validating the values passed to the setKommentar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKommentar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKommentarForArrayConstraintsFromSetKommentar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenmeldungKommentarItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenmeldungKommentarItem instanceof \BiPRO\StructType\CT_Freitext) {
                $invalidValues[] = is_object($cT_SchadenmeldungKommentarItem) ? get_class($cT_SchadenmeldungKommentarItem) : sprintf('%s(%s)', gettype($cT_SchadenmeldungKommentarItem), var_export($cT_SchadenmeldungKommentarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kommentar property can only contain items of type \BiPRO\StructType\CT_Freitext, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kommentar value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Freitext[] $kommentar
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setKommentar(array $kommentar = array())
    {
        // validation for constraint: array
        if ('' !== ($kommentarArrayErrorMessage = self::validateKommentarForArrayConstraintsFromSetKommentar($kommentar))) {
            throw new \InvalidArgumentException($kommentarArrayErrorMessage, __LINE__);
        }
        $this->Kommentar = $kommentar;
        return $this;
    }
    /**
     * Add item to Kommentar value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Freitext $item
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function addToKommentar(\BiPRO\StructType\CT_Freitext $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Freitext) {
            throw new \InvalidArgumentException(sprintf('The Kommentar property can only contain items of type \BiPRO\StructType\CT_Freitext, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Kommentar[] = $item;
        return $this;
    }
    /**
     * Get Partner value
     * @return \BiPRO\StructType\CT_Partner[]|null
     */
    public function getPartner()
    {
        return $this->Partner;
    }
    /**
     * This method is responsible for validating the values passed to the setPartner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerForArrayConstraintsFromSetPartner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenmeldungPartnerItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenmeldungPartnerItem instanceof \BiPRO\StructType\CT_Partner) {
                $invalidValues[] = is_object($cT_SchadenmeldungPartnerItem) ? get_class($cT_SchadenmeldungPartnerItem) : sprintf('%s(%s)', gettype($cT_SchadenmeldungPartnerItem), var_export($cT_SchadenmeldungPartnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner[] $partner
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setPartner(array $partner = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerArrayErrorMessage = self::validatePartnerForArrayConstraintsFromSetPartner($partner))) {
            throw new \InvalidArgumentException($partnerArrayErrorMessage, __LINE__);
        }
        $this->Partner = $partner;
        return $this;
    }
    /**
     * Add item to Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner $item
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function addToPartner(\BiPRO\StructType\CT_Partner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Partner) {
            throw new \InvalidArgumentException(sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Partner[] = $item;
        return $this;
    }
    /**
     * Get Gegenstand value
     * @return \BiPRO\StructType\CT_Gegenstand[]|null
     */
    public function getGegenstand()
    {
        return $this->Gegenstand;
    }
    /**
     * This method is responsible for validating the values passed to the setGegenstand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGegenstand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGegenstandForArrayConstraintsFromSetGegenstand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenmeldungGegenstandItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenmeldungGegenstandItem instanceof \BiPRO\StructType\CT_Gegenstand) {
                $invalidValues[] = is_object($cT_SchadenmeldungGegenstandItem) ? get_class($cT_SchadenmeldungGegenstandItem) : sprintf('%s(%s)', gettype($cT_SchadenmeldungGegenstandItem), var_export($cT_SchadenmeldungGegenstandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function setGegenstand(array $gegenstand = array())
    {
        // validation for constraint: array
        if ('' !== ($gegenstandArrayErrorMessage = self::validateGegenstandForArrayConstraintsFromSetGegenstand($gegenstand))) {
            throw new \InvalidArgumentException($gegenstandArrayErrorMessage, __LINE__);
        }
        $this->Gegenstand = $gegenstand;
        return $this;
    }
    /**
     * Add item to Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand $item
     * @return \BiPRO\StructType\CT_Schadenmeldung
     */
    public function addToGegenstand(\BiPRO\StructType\CT_Gegenstand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Gegenstand) {
            throw new \InvalidArgumentException(sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Gegenstand[] = $item;
        return $this;
    }
}
