<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadenhoehe StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zur Höhe eines Schadens dargestellt als Geldwert.
 * @subpackage Structs
 */
class CT_Schadenhoehe extends CT_Geldwert
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Schadenhöhe.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\STE_ArtDerSchadenhoehe
     */
    public $ArtID;
    /**
     * The SteuerEnthalten
     * Meta information extracted from the WSDL
     * - documentation: JA = Im Betrag ist die Steuer enthalten (Bruttobetrag)NEIN = Im Betrag ist die Steuer nicht enthalten (Nettobetrag)Fehlt das Attribut MUSS der Betrag als Nettobetrag interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SteuerEnthalten;
    /**
     * The Kalkulationsart
     * Meta information extracted from the WSDL
     * - documentation: Grundlage der Kalkulation der Schadenhöhe.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kalkulationsart;
    /**
     * The Ermittler
     * Meta information extracted from the WSDL
     * - documentation: Ermittler der Schadenhöhe
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ermittler;
    /**
     * The Bewertungsschluessel
     * Meta information extracted from the WSDL
     * - documentation: Bewertungsschlüssel gemäß Art des Bewertungsschlüssels. Ist dieses Attribut belegt, MUSS das Attribut Bewertungsschluesselart entsprechend belegt werden.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bewertungsschluessel;
    /**
     * The Bewertungsschluesselart
     * Meta information extracted from the WSDL
     * - documentation: Art des Bewertungsschlüssels.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bewertungsschluesselart;
    /**
     * The Zeitwertprozent
     * Meta information extracted from the WSDL
     * - documentation: Schadenhöhe als Prozentsatz vom Neuwert des Schadenobjekts. Dieses Attribut DARF NUR verwendet werden, wenn Schadenhoehe.ArtID = 04 (Zeitwert) ist. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Zeitwertprozent;
    /**
     * The Besteuerungsart
     * Meta information extracted from the WSDL
     * - documentation: Besteuerungsart des Wiederbeschaffungswerts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Besteuerungsart;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Ursprung der Angabe zur Schadenhöhe.Fehlt die Quelle MUSS der Schadenmelder als Quelle der Schadenhöhe interpretiert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Quelle
     */
    public $Quelle;
    /**
     * The Steuer
     * Meta information extracted from the WSDL
     * - documentation: Steuer, die auf die Schadenhöhe berechnet wird. Z. B. Mehrwertsteuer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Steuer
     */
    public $Steuer;
    /**
     * Constructor method for CT_Schadenhoehe
     * @uses CT_Schadenhoehe::setArtID()
     * @uses CT_Schadenhoehe::setSteuerEnthalten()
     * @uses CT_Schadenhoehe::setKalkulationsart()
     * @uses CT_Schadenhoehe::setErmittler()
     * @uses CT_Schadenhoehe::setBewertungsschluessel()
     * @uses CT_Schadenhoehe::setBewertungsschluesselart()
     * @uses CT_Schadenhoehe::setZeitwertprozent()
     * @uses CT_Schadenhoehe::setBesteuerungsart()
     * @uses CT_Schadenhoehe::setQuelle()
     * @uses CT_Schadenhoehe::setSteuer()
     * @param \BiPRO\StructType\STE_ArtDerSchadenhoehe $artID
     * @param bool $steuerEnthalten
     * @param string $kalkulationsart
     * @param string $ermittler
     * @param string $bewertungsschluessel
     * @param string $bewertungsschluesselart
     * @param float $zeitwertprozent
     * @param string $besteuerungsart
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @param \BiPRO\StructType\CT_Steuer $steuer
     */
    public function __construct(\BiPRO\StructType\STE_ArtDerSchadenhoehe $artID = null, $steuerEnthalten = null, $kalkulationsart = null, $ermittler = null, $bewertungsschluessel = null, $bewertungsschluesselart = null, $zeitwertprozent = null, $besteuerungsart = null, \BiPRO\StructType\CT_Quelle $quelle = null, \BiPRO\StructType\CT_Steuer $steuer = null)
    {
        $this
            ->setArtID($artID)
            ->setSteuerEnthalten($steuerEnthalten)
            ->setKalkulationsart($kalkulationsart)
            ->setErmittler($ermittler)
            ->setBewertungsschluessel($bewertungsschluessel)
            ->setBewertungsschluesselart($bewertungsschluesselart)
            ->setZeitwertprozent($zeitwertprozent)
            ->setBesteuerungsart($besteuerungsart)
            ->setQuelle($quelle)
            ->setSteuer($steuer);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_ArtDerSchadenhoehe
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_ArtDerSchadenhoehe $artID
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setArtID(\BiPRO\StructType\STE_ArtDerSchadenhoehe $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get SteuerEnthalten value
     * @return bool|null
     */
    public function getSteuerEnthalten()
    {
        return $this->SteuerEnthalten;
    }
    /**
     * Set SteuerEnthalten value
     * @param bool $steuerEnthalten
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setSteuerEnthalten($steuerEnthalten = null)
    {
        // validation for constraint: boolean
        if (!is_null($steuerEnthalten) && !is_bool($steuerEnthalten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($steuerEnthalten, true), gettype($steuerEnthalten)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($steuerEnthalten) && !preg_match('/true|false/', $steuerEnthalten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($steuerEnthalten, true)), __LINE__);
        }
        $this->SteuerEnthalten = $steuerEnthalten;
        return $this;
    }
    /**
     * Get Kalkulationsart value
     * @return string|null
     */
    public function getKalkulationsart()
    {
        return $this->Kalkulationsart;
    }
    /**
     * Set Kalkulationsart value
     * @uses \BiPRO\EnumType\ST_Kalkulationsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Kalkulationsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kalkulationsart
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setKalkulationsart($kalkulationsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Kalkulationsart::valueIsValid($kalkulationsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Kalkulationsart', is_array($kalkulationsart) ? implode(', ', $kalkulationsart) : var_export($kalkulationsart, true), implode(', ', \BiPRO\EnumType\ST_Kalkulationsart::getValidValues())), __LINE__);
        }
        $this->Kalkulationsart = $kalkulationsart;
        return $this;
    }
    /**
     * Get Ermittler value
     * @return string|null
     */
    public function getErmittler()
    {
        return $this->Ermittler;
    }
    /**
     * Set Ermittler value
     * @uses \BiPRO\EnumType\ST_ErmittlerSchadenkalkulation::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ErmittlerSchadenkalkulation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ermittler
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setErmittler($ermittler = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ErmittlerSchadenkalkulation::valueIsValid($ermittler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ErmittlerSchadenkalkulation', is_array($ermittler) ? implode(', ', $ermittler) : var_export($ermittler, true), implode(', ', \BiPRO\EnumType\ST_ErmittlerSchadenkalkulation::getValidValues())), __LINE__);
        }
        $this->Ermittler = $ermittler;
        return $this;
    }
    /**
     * Get Bewertungsschluessel value
     * @return string|null
     */
    public function getBewertungsschluessel()
    {
        return $this->Bewertungsschluessel;
    }
    /**
     * Set Bewertungsschluessel value
     * @param string $bewertungsschluessel
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setBewertungsschluessel($bewertungsschluessel = null)
    {
        // validation for constraint: string
        if (!is_null($bewertungsschluessel) && !is_string($bewertungsschluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bewertungsschluessel, true), gettype($bewertungsschluessel)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($bewertungsschluessel) && mb_strlen($bewertungsschluessel) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($bewertungsschluessel)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bewertungsschluessel) && mb_strlen($bewertungsschluessel) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bewertungsschluessel)), __LINE__);
        }
        $this->Bewertungsschluessel = $bewertungsschluessel;
        return $this;
    }
    /**
     * Get Bewertungsschluesselart value
     * @return string|null
     */
    public function getBewertungsschluesselart()
    {
        return $this->Bewertungsschluesselart;
    }
    /**
     * Set Bewertungsschluesselart value
     * @uses \BiPRO\EnumType\ST_Bewertungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Bewertungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bewertungsschluesselart
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setBewertungsschluesselart($bewertungsschluesselart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Bewertungsschluessel::valueIsValid($bewertungsschluesselart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Bewertungsschluessel', is_array($bewertungsschluesselart) ? implode(', ', $bewertungsschluesselart) : var_export($bewertungsschluesselart, true), implode(', ', \BiPRO\EnumType\ST_Bewertungsschluessel::getValidValues())), __LINE__);
        }
        $this->Bewertungsschluesselart = $bewertungsschluesselart;
        return $this;
    }
    /**
     * Get Zeitwertprozent value
     * @return float|null
     */
    public function getZeitwertprozent()
    {
        return $this->Zeitwertprozent;
    }
    /**
     * Set Zeitwertprozent value
     * @param float $zeitwertprozent
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setZeitwertprozent($zeitwertprozent = null)
    {
        // validation for constraint: float
        if (!is_null($zeitwertprozent) && !(is_float($zeitwertprozent) || is_numeric($zeitwertprozent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zeitwertprozent, true), gettype($zeitwertprozent)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($zeitwertprozent) && $zeitwertprozent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($zeitwertprozent, true)), __LINE__);
        }
        $this->Zeitwertprozent = $zeitwertprozent;
        return $this;
    }
    /**
     * Get Besteuerungsart value
     * @return string|null
     */
    public function getBesteuerungsart()
    {
        return $this->Besteuerungsart;
    }
    /**
     * Set Besteuerungsart value
     * @uses \BiPRO\EnumType\ST_ArtDerUmsatzbesteuerung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDerUmsatzbesteuerung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $besteuerungsart
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setBesteuerungsart($besteuerungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDerUmsatzbesteuerung::valueIsValid($besteuerungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDerUmsatzbesteuerung', is_array($besteuerungsart) ? implode(', ', $besteuerungsart) : var_export($besteuerungsart, true), implode(', ', \BiPRO\EnumType\ST_ArtDerUmsatzbesteuerung::getValidValues())), __LINE__);
        }
        $this->Besteuerungsart = $besteuerungsart;
        return $this;
    }
    /**
     * Get Quelle value
     * @return \BiPRO\StructType\CT_Quelle|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setQuelle(\BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this->Quelle = $quelle;
        return $this;
    }
    /**
     * Get Steuer value
     * @return \BiPRO\StructType\CT_Steuer|null
     */
    public function getSteuer()
    {
        return $this->Steuer;
    }
    /**
     * Set Steuer value
     * @param \BiPRO\StructType\CT_Steuer $steuer
     * @return \BiPRO\StructType\CT_Schadenhoehe
     */
    public function setSteuer(\BiPRO\StructType\CT_Steuer $steuer = null)
    {
        $this->Steuer = $steuer;
        return $this;
    }
}
