<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadenhergang StructType
 * Meta information extracted from the WSDL
 * - documentation: Hergang eines Schadenereignisses.
 * @subpackage Structs
 */
class CT_Schadenhergang extends CT_Objekt
{
    /**
     * The Hergang
     * Meta information extracted from the WSDL
     * - documentation: Hergang des Schadenereignisses gemäß GDV-Anlage 114, aber VU-spezifisch erweiterbar.DARF bei Ereignissen zu Unfallversicherungen NICHT verwendet werden (siehe UrsacheUnfallversicherung).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Schadenhergang
     */
    public $Hergang;
    /**
     * The HergangBeiUnfallversicherung
     * Meta information extracted from the WSDL
     * - documentation: Hergang bei einem Unfall gemäß GDV-Anlage 158. DARF NUR für Ereignisse zur Unfallversicherung verwendet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HergangBeiUnfallversicherung;
    /**
     * The Beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Hergangs des Schadenereignisses.
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschreibung;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Ursprung der Informationen zum Schadenhergang.Fehlt die Quelle, MUSS der Schadenmelder als Quelle für den Schadenhergang angenommen werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Quelle
     */
    public $Quelle;
    /**
     * Constructor method for CT_Schadenhergang
     * @uses CT_Schadenhergang::setHergang()
     * @uses CT_Schadenhergang::setHergangBeiUnfallversicherung()
     * @uses CT_Schadenhergang::setBeschreibung()
     * @uses CT_Schadenhergang::setQuelle()
     * @param \BiPRO\StructType\STE_Schadenhergang $hergang
     * @param string $hergangBeiUnfallversicherung
     * @param string $beschreibung
     * @param \BiPRO\StructType\CT_Quelle $quelle
     */
    public function __construct(\BiPRO\StructType\STE_Schadenhergang $hergang = null, $hergangBeiUnfallversicherung = null, $beschreibung = null, \BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this
            ->setHergang($hergang)
            ->setHergangBeiUnfallversicherung($hergangBeiUnfallversicherung)
            ->setBeschreibung($beschreibung)
            ->setQuelle($quelle);
    }
    /**
     * Get Hergang value
     * @return \BiPRO\StructType\STE_Schadenhergang|null
     */
    public function getHergang()
    {
        return $this->Hergang;
    }
    /**
     * Set Hergang value
     * @param \BiPRO\StructType\STE_Schadenhergang $hergang
     * @return \BiPRO\StructType\CT_Schadenhergang
     */
    public function setHergang(\BiPRO\StructType\STE_Schadenhergang $hergang = null)
    {
        $this->Hergang = $hergang;
        return $this;
    }
    /**
     * Get HergangBeiUnfallversicherung value
     * @return string|null
     */
    public function getHergangBeiUnfallversicherung()
    {
        return $this->HergangBeiUnfallversicherung;
    }
    /**
     * Set HergangBeiUnfallversicherung value
     * @uses \BiPRO\EnumType\ST_Unfallursache::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Unfallursache::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hergangBeiUnfallversicherung
     * @return \BiPRO\StructType\CT_Schadenhergang
     */
    public function setHergangBeiUnfallversicherung($hergangBeiUnfallversicherung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Unfallursache::valueIsValid($hergangBeiUnfallversicherung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Unfallursache', is_array($hergangBeiUnfallversicherung) ? implode(', ', $hergangBeiUnfallversicherung) : var_export($hergangBeiUnfallversicherung, true), implode(', ', \BiPRO\EnumType\ST_Unfallursache::getValidValues())), __LINE__);
        }
        $this->HergangBeiUnfallversicherung = $hergangBeiUnfallversicherung;
        return $this;
    }
    /**
     * Get Beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->Beschreibung;
    }
    /**
     * Set Beschreibung value
     * @param string $beschreibung
     * @return \BiPRO\StructType\CT_Schadenhergang
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibung)), __LINE__);
        }
        $this->Beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get Quelle value
     * @return \BiPRO\StructType\CT_Quelle|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @return \BiPRO\StructType\CT_Schadenhergang
     */
    public function setQuelle(\BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this->Quelle = $quelle;
        return $this;
    }
}
