<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SchadenfallLeistungsfall StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Schadenfall bzw. Leistungsfall beschreibt einen durch ein Versicherungsunternehmen oder einen Dritten zu bearbeitenden Schaden.
 * @subpackage Structs
 */
class CT_SchadenfallLeistungsfall extends CT_Objekt
{
    /**
     * The Schadenstatus
     * Meta information extracted from the WSDL
     * - documentation: Status des Schadenfalls bzw. des Leistungsfalls (offen oder geschlossen).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schadenstatus;
    /**
     * The Bearbeitungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der aktuellsten Bearbeitung des Schadenfalls bzw. des Leistungsfalls. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Bearbeitungsdatum;
    /**
     * The Schadenmeldedatum
     * Meta information extracted from the WSDL
     * - documentation: Datum mit optionaler Zeitangabe, an dem das Schadenereignis dem Unternehmen, das den Schadenfall bzw. Leistungsfall bearbeitet, bekannt wurde.Es MUSS mindestens ein Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS
     * diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger
     * Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone
     * explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5 Stunden.Gültige Werte sind zum
     * Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $Schadenmeldedatum;
    /**
     * The Schliessungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Schließung des Schadenfalls bzw. des Leistungsfalls. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Schliessungsdatum;
    /**
     * The Schliessungsart
     * Meta information extracted from the WSDL
     * - documentation: Art der Schließung des Schadenfalls oder des Leistungsfalls (z.B. Schließung mit Zahlung, Ablehnung, Schließung ohne Zahlung (z.B. unterhalb Selbstbehalt)).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schliessungsart;
    /**
     * The BeginnZeichnungsjahr
     * Meta information extracted from the WSDL
     * - documentation: Beginndatum desjenigen Zeichnungsjahres des Versicherungsvertrages, in dem sich der Schaden ereignete bzw. dem der Schaden statistisch zugeordnet wird. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $BeginnZeichnungsjahr;
    /**
     * The Vertragssparte
     * Meta information extracted from the WSDL
     * - documentation: Sparte des Produktes, zu dem der Schadenfall angelegt wurde (z. B. 130 = Hausrat, wenn es sich um einen Feuerschaden zum Hausratvertrag handelt).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vertragssparte;
    /**
     * The Schadensparte
     * Meta information extracted from the WSDL
     * - documentation: Sparte der Gefahr/Deckung, zu der der Schadenfall angelegt wurde (z. B. 080 = Feuer, wenn es sich um einen Feuerschaden zum Hausratvertrag handelt).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schadensparte;
    /**
     * The Schadenursache
     * Meta information extracted from the WSDL
     * - documentation: Ursache des Schadens. Verwendet wird das Schlüsselverzeichnis gemäß GDV-Anlage 132. | Ausprägungen gemäß GDV-Satz Anlage 132.Die gültigen Werte der Schadenursache MÜSSEN dem Katalog ST_KatalogSchadenursache entnommen werden.
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: unbounded
     * - minLength: 4
     * - minOccurs: 0
     * @var string[]
     */
    public $Schadenursache;
    /**
     * The Teilungsabkommen
     * Meta information extracted from the WSDL
     * - documentation: Teilungsabkommen mit Sozialversicherungsträgern, relevant für Schadenquotenermittlung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Teilungsabkommen;
    /**
     * The Beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Kurze Beschreibung des Schadenfalls z.B. "verlorene Container".
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschreibung;
    /**
     * The Schadenart
     * Meta information extracted from the WSDL
     * - documentation: Schadenart gemäß GDV-Anlage 115. Dieses Attribut DARF für Schädenfälle zu Unfallversicherungen NICHT verwendet werden (siehe SchadenartUnfall).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schadenart;
    /**
     * The SchadenartUnfall
     * Meta information extracted from the WSDL
     * - documentation: Schadenart-Unfall gemäß GDV-Anlage 157. Dieses Attribut DARF NUR für Schäden zu Unfallversicherungen verwendet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SchadenartUnfall;
    /**
     * The RegulierungAlsSammelschaden
     * Meta information extracted from the WSDL
     * - documentation: JA = Dieser Schadenfall wird als Sammelschaden reguliert.NEIN = Dieser Schadenfall wird als Einzelschaden reguliert.Fehlt das Attribut MUSS der Schadenfall als ein Einzelschaden interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $RegulierungAlsSammelschaden;
    /**
     * The AnspruecheErhoben
     * Meta information extracted from the WSDL
     * - documentation: Antwort auf die Frage:Wurden Schadenersatzansprüche erhoben?
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnspruecheErhoben;
    /**
     * The VNEinverstandenMitZahlungAnAST
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Versicherungsnehmer (VN) ist mit Zahlung an Anspruchsteller (AST) einverstanden.NEIN = Der Versicherungsnehmer (VN) ist mit Zahlung an Anspruchsteller (AST) nicht einverstanden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VNEinverstandenMitZahlungAnAST;
    /**
     * The VNNichtEinverstandenMitZahlungAnASTBegruendung
     * Meta information extracted from the WSDL
     * - documentation: Begründung, wenn kein Einverständnis zur Zahlung an den Anspruchsteller (AST) vorliegt.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $VNNichtEinverstandenMitZahlungAnASTBegruendung;
    /**
     * The Aktenzeichen
     * Meta information extracted from the WSDL
     * - documentation: Ordnungsbegriff (Aktenzeichen, Auftragsnummer etc.) unter dem der Schadenfall / der Leistungsfall bei der Quelle (z.B. Vermittler, Dienstleister, Anwalt) der Schadennummer geführt wird.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadennummer[]
     */
    public $Aktenzeichen;
    /**
     * The Beteiligungsverhaeltnis
     * Meta information extracted from the WSDL
     * - documentation: Ist der Versicherungsvertrag, zu dem der Schaden- bzw. Leistungsanspruch geltend gemacht wird, ein Vertrag mit mehreren risikotragenden Versicherungsunternehmen (Beteiligungsvertrag), wird mit dieser Referenz das
     * Beteiligungsverhältnis spezifiziert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beteiligungsverhaeltnis
     */
    public $Beteiligungsverhaeltnis;
    /**
     * The AltesVersicherungsunternehmen
     * Meta information extracted from the WSDL
     * - documentation: Diese Referenz ist nur bei Nutzung der Norm 430.5 relevant.Bei allen Anwendungsfällen MUSS ein Schadenfall/Leistungsfall mit aktueller Unternehmensnummer und Hinweis auf die alte (abweichende) Unternehmensnummer zumindest bei der
     * ersten Lieferung nach der Nummernänderung geliefert werden. Dabei MUSS die Gevo-Art 130019001 = Änderung der Unternehmensnummerverwendet werden. Die alte Unternehmensnummer MUSS mit dieser Referenz spezifiziert werden. Siehe auch Norm 430.5
     * Abschnitt "Änderung von Ordnungsbegriffen".
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $AltesVersicherungsunternehmen;
    /**
     * The BearbeitendeStelle
     * Meta information extracted from the WSDL
     * - documentation: Stelle, die den Schadenfall bzw. Leistungsfall bearbeitet (z.B. Zweigniederlassung des Versicherers, Assekuradeur, bevollmächtigter Dienstleister).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_BearbeitendeStelle
     */
    public $BearbeitendeStelle;
    /**
     * The ExterneBearbeitungskosten
     * Meta information extracted from the WSDL
     * - documentation: Gesamte externe Kosten zur Bearbeitung eines Schadens bzw. einer Leistung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ExterneBearbeitungskosten
     */
    public $ExterneBearbeitungskosten;
    /**
     * The Anspruchsteller
     * Meta information extracted from the WSDL
     * - documentation: Partner, die zu diesem Schadenfall/Leistungsfall Ansprüche stellen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Anspruchsteller[]
     */
    public $Anspruchsteller;
    /**
     * The Versicherungsunternehmen
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsunternehmen, gegen das der Schaden- bzw. Leistungsanspruch geltend gemacht wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $Versicherungsunternehmen;
    /**
     * The AlteSchadennummer
     * Meta information extracted from the WSDL
     * - documentation: Diese Referenz ist nur bei Nutzung der Norm 430.5 relevant.Bei allen Anwendungsfällen MUSS ein Schadenfall/Leistungsfall mit aktueller Schadennummer und Hinweis auf die alte (abweichende) Schadennummer zumindest bei der ersten
     * Lieferung nach der Nummernänderung mit der Gevo-Art 150000001 (Änderung der Schaden/Leistungs-Nummer) geliefert werden.Die alte Schadennummer MUSS mit dieser Referenz spezifiziert werden. Siehe auch Norm 430.5 Abschnitt "Änderung von
     * Ordnungsbegriffen".
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadennummer
     */
    public $AlteSchadennummer;
    /**
     * The AnderweitigerVersicherungsschutz
     * Meta information extracted from the WSDL
     * - documentation: Informationen zu einem Versicherungsschutz für den Schaden, der durch einen anderen Versicherungvertrag besteht als der Vertrag, gegen den der Anspruch geltend gemacht wird.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz[]
     */
    public $AnderweitigerVersicherungsschutz;
    /**
     * The Entschaedigungsbetrag
     * Meta information extracted from the WSDL
     * - documentation: Gesamter Geldwert, der zur Entschädigung des Schadens bzw. der Leistung aufgewendet wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Entschaedigungsbetrag
     */
    public $Entschaedigungsbetrag;
    /**
     * The Schadennummer
     * Meta information extracted from the WSDL
     * - documentation: Ordnungsbegriff unter dem der Schadenfall / der Leistungsfall bei dem Partner geführt wird, der den Schadenfall / den Leistungsfall bearbeitet (üblicherweise ein Versicherungsunternehmen, aber auch ein Assekuradeur oder ein
     * bevollmächtigter Dienstleister).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadennummer
     */
    public $Schadennummer;
    /**
     * The Vertrag
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsvertrag, zu dem der Schaden- bzw. Leistungsanspruch geltend gemacht wird.Die Vertragsdaten sollten nur mit den notwendigen Daten (insbesondere Vertragsnummer, Vertragspartner und Vermittler) übermittelt werden und
     * MÜSSEN den Vertragsstand zum Schadendatum wiederspiegeln. Die Partner- und Gegenstandslisten am Vertrag DÜRFEN NICHT verwendet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertrag
     */
    public $Vertrag;
    /**
     * The Regulierung
     * Meta information extracted from the WSDL
     * - documentation: Regulierungen zu einem Schaden oder einer Leistung
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Regulierung[]
     */
    public $Regulierung;
    /**
     * The Selbstbehaltsbetrag
     * Meta information extracted from the WSDL
     * - documentation: Gesamter Selbstbehaltsbetrag, der bei dem Schadenfall/Leistungsfall berücksichtigt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Selbstbehaltsbetrag
     */
    public $Selbstbehaltsbetrag;
    /**
     * The Schadenmelder
     * Meta information extracted from the WSDL
     * - documentation: Partner, der den Schaden als erster gemeldet hat: Versicherungnehmer, Anspruchsteller, Dritter (z. B. Dienstleister, Werkstatt, Rechtsanwalt, Sachverständiger).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beteiligter
     */
    public $Schadenmelder;
    /**
     * The Reserve
     * Meta information extracted from the WSDL
     * - documentation: Aktuelle, laufende Reserve zu dem Schadenfall/Leistungsfall.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Reserve
     */
    public $Reserve;
    /**
     * Constructor method for CT_SchadenfallLeistungsfall
     * @uses CT_SchadenfallLeistungsfall::setSchadenstatus()
     * @uses CT_SchadenfallLeistungsfall::setBearbeitungsdatum()
     * @uses CT_SchadenfallLeistungsfall::setSchadenmeldedatum()
     * @uses CT_SchadenfallLeistungsfall::setSchliessungsdatum()
     * @uses CT_SchadenfallLeistungsfall::setSchliessungsart()
     * @uses CT_SchadenfallLeistungsfall::setBeginnZeichnungsjahr()
     * @uses CT_SchadenfallLeistungsfall::setVertragssparte()
     * @uses CT_SchadenfallLeistungsfall::setSchadensparte()
     * @uses CT_SchadenfallLeistungsfall::setSchadenursache()
     * @uses CT_SchadenfallLeistungsfall::setTeilungsabkommen()
     * @uses CT_SchadenfallLeistungsfall::setBeschreibung()
     * @uses CT_SchadenfallLeistungsfall::setSchadenart()
     * @uses CT_SchadenfallLeistungsfall::setSchadenartUnfall()
     * @uses CT_SchadenfallLeistungsfall::setRegulierungAlsSammelschaden()
     * @uses CT_SchadenfallLeistungsfall::setAnspruecheErhoben()
     * @uses CT_SchadenfallLeistungsfall::setVNEinverstandenMitZahlungAnAST()
     * @uses CT_SchadenfallLeistungsfall::setVNNichtEinverstandenMitZahlungAnASTBegruendung()
     * @uses CT_SchadenfallLeistungsfall::setAktenzeichen()
     * @uses CT_SchadenfallLeistungsfall::setBeteiligungsverhaeltnis()
     * @uses CT_SchadenfallLeistungsfall::setAltesVersicherungsunternehmen()
     * @uses CT_SchadenfallLeistungsfall::setBearbeitendeStelle()
     * @uses CT_SchadenfallLeistungsfall::setExterneBearbeitungskosten()
     * @uses CT_SchadenfallLeistungsfall::setAnspruchsteller()
     * @uses CT_SchadenfallLeistungsfall::setVersicherungsunternehmen()
     * @uses CT_SchadenfallLeistungsfall::setAlteSchadennummer()
     * @uses CT_SchadenfallLeistungsfall::setAnderweitigerVersicherungsschutz()
     * @uses CT_SchadenfallLeistungsfall::setEntschaedigungsbetrag()
     * @uses CT_SchadenfallLeistungsfall::setSchadennummer()
     * @uses CT_SchadenfallLeistungsfall::setVertrag()
     * @uses CT_SchadenfallLeistungsfall::setRegulierung()
     * @uses CT_SchadenfallLeistungsfall::setSelbstbehaltsbetrag()
     * @uses CT_SchadenfallLeistungsfall::setSchadenmelder()
     * @uses CT_SchadenfallLeistungsfall::setReserve()
     * @param string $schadenstatus
     * @param string $bearbeitungsdatum
     * @param string $schadenmeldedatum
     * @param string $schliessungsdatum
     * @param string $schliessungsart
     * @param string $beginnZeichnungsjahr
     * @param string $vertragssparte
     * @param string $schadensparte
     * @param string[] $schadenursache
     * @param string $teilungsabkommen
     * @param string $beschreibung
     * @param string $schadenart
     * @param string $schadenartUnfall
     * @param bool $regulierungAlsSammelschaden
     * @param string $anspruecheErhoben
     * @param bool $vNEinverstandenMitZahlungAnAST
     * @param string $vNNichtEinverstandenMitZahlungAnASTBegruendung
     * @param \BiPRO\StructType\CT_Schadennummer[] $aktenzeichen
     * @param \BiPRO\StructType\CT_Beteiligungsverhaeltnis $beteiligungsverhaeltnis
     * @param \BiPRO\StructType\CT_Unternehmen $altesVersicherungsunternehmen
     * @param \BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle
     * @param \BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten
     * @param \BiPRO\StructType\CT_Anspruchsteller[] $anspruchsteller
     * @param \BiPRO\StructType\CT_Unternehmen $versicherungsunternehmen
     * @param \BiPRO\StructType\CT_Schadennummer $alteSchadennummer
     * @param \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz[] $anderweitigerVersicherungsschutz
     * @param \BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag
     * @param \BiPRO\StructType\CT_Schadennummer $schadennummer
     * @param \BiPRO\StructType\CT_Vertrag $vertrag
     * @param \BiPRO\StructType\CT_Regulierung[] $regulierung
     * @param \BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag
     * @param \BiPRO\StructType\CT_Beteiligter $schadenmelder
     * @param \BiPRO\StructType\CT_Reserve $reserve
     */
    public function __construct($schadenstatus = null, $bearbeitungsdatum = null, $schadenmeldedatum = null, $schliessungsdatum = null, $schliessungsart = null, $beginnZeichnungsjahr = null, $vertragssparte = null, $schadensparte = null, array $schadenursache = array(), $teilungsabkommen = null, $beschreibung = null, $schadenart = null, $schadenartUnfall = null, $regulierungAlsSammelschaden = null, $anspruecheErhoben = null, $vNEinverstandenMitZahlungAnAST = null, $vNNichtEinverstandenMitZahlungAnASTBegruendung = null, array $aktenzeichen = array(), \BiPRO\StructType\CT_Beteiligungsverhaeltnis $beteiligungsverhaeltnis = null, \BiPRO\StructType\CT_Unternehmen $altesVersicherungsunternehmen = null, \BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle = null, \BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten = null, array $anspruchsteller = array(), \BiPRO\StructType\CT_Unternehmen $versicherungsunternehmen = null, \BiPRO\StructType\CT_Schadennummer $alteSchadennummer = null, array $anderweitigerVersicherungsschutz = array(), \BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag = null, \BiPRO\StructType\CT_Schadennummer $schadennummer = null, \BiPRO\StructType\CT_Vertrag $vertrag = null, array $regulierung = array(), \BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag = null, \BiPRO\StructType\CT_Beteiligter $schadenmelder = null, \BiPRO\StructType\CT_Reserve $reserve = null)
    {
        $this
            ->setSchadenstatus($schadenstatus)
            ->setBearbeitungsdatum($bearbeitungsdatum)
            ->setSchadenmeldedatum($schadenmeldedatum)
            ->setSchliessungsdatum($schliessungsdatum)
            ->setSchliessungsart($schliessungsart)
            ->setBeginnZeichnungsjahr($beginnZeichnungsjahr)
            ->setVertragssparte($vertragssparte)
            ->setSchadensparte($schadensparte)
            ->setSchadenursache($schadenursache)
            ->setTeilungsabkommen($teilungsabkommen)
            ->setBeschreibung($beschreibung)
            ->setSchadenart($schadenart)
            ->setSchadenartUnfall($schadenartUnfall)
            ->setRegulierungAlsSammelschaden($regulierungAlsSammelschaden)
            ->setAnspruecheErhoben($anspruecheErhoben)
            ->setVNEinverstandenMitZahlungAnAST($vNEinverstandenMitZahlungAnAST)
            ->setVNNichtEinverstandenMitZahlungAnASTBegruendung($vNNichtEinverstandenMitZahlungAnASTBegruendung)
            ->setAktenzeichen($aktenzeichen)
            ->setBeteiligungsverhaeltnis($beteiligungsverhaeltnis)
            ->setAltesVersicherungsunternehmen($altesVersicherungsunternehmen)
            ->setBearbeitendeStelle($bearbeitendeStelle)
            ->setExterneBearbeitungskosten($externeBearbeitungskosten)
            ->setAnspruchsteller($anspruchsteller)
            ->setVersicherungsunternehmen($versicherungsunternehmen)
            ->setAlteSchadennummer($alteSchadennummer)
            ->setAnderweitigerVersicherungsschutz($anderweitigerVersicherungsschutz)
            ->setEntschaedigungsbetrag($entschaedigungsbetrag)
            ->setSchadennummer($schadennummer)
            ->setVertrag($vertrag)
            ->setRegulierung($regulierung)
            ->setSelbstbehaltsbetrag($selbstbehaltsbetrag)
            ->setSchadenmelder($schadenmelder)
            ->setReserve($reserve);
    }
    /**
     * Get Schadenstatus value
     * @return string|null
     */
    public function getSchadenstatus()
    {
        return $this->Schadenstatus;
    }
    /**
     * Set Schadenstatus value
     * @uses \BiPRO\EnumType\ST_Schadenstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schadenstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadenstatus
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadenstatus($schadenstatus = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Schadenstatus::valueIsValid($schadenstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schadenstatus', is_array($schadenstatus) ? implode(', ', $schadenstatus) : var_export($schadenstatus, true), implode(', ', \BiPRO\EnumType\ST_Schadenstatus::getValidValues())), __LINE__);
        }
        $this->Schadenstatus = $schadenstatus;
        return $this;
    }
    /**
     * Get Bearbeitungsdatum value
     * @return string|null
     */
    public function getBearbeitungsdatum()
    {
        return $this->Bearbeitungsdatum;
    }
    /**
     * Set Bearbeitungsdatum value
     * @param string $bearbeitungsdatum
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setBearbeitungsdatum($bearbeitungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($bearbeitungsdatum) && !is_string($bearbeitungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bearbeitungsdatum, true), gettype($bearbeitungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($bearbeitungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $bearbeitungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($bearbeitungsdatum, true)), __LINE__);
        }
        $this->Bearbeitungsdatum = $bearbeitungsdatum;
        return $this;
    }
    /**
     * Get Schadenmeldedatum value
     * @return string|null
     */
    public function getSchadenmeldedatum()
    {
        return $this->Schadenmeldedatum;
    }
    /**
     * Set Schadenmeldedatum value
     * @param string $schadenmeldedatum
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadenmeldedatum($schadenmeldedatum = null)
    {
        // validation for constraint: string
        if (!is_null($schadenmeldedatum) && !is_string($schadenmeldedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schadenmeldedatum, true), gettype($schadenmeldedatum)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($schadenmeldedatum) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $schadenmeldedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($schadenmeldedatum, true)), __LINE__);
        }
        $this->Schadenmeldedatum = $schadenmeldedatum;
        return $this;
    }
    /**
     * Get Schliessungsdatum value
     * @return string|null
     */
    public function getSchliessungsdatum()
    {
        return $this->Schliessungsdatum;
    }
    /**
     * Set Schliessungsdatum value
     * @param string $schliessungsdatum
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchliessungsdatum($schliessungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($schliessungsdatum) && !is_string($schliessungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schliessungsdatum, true), gettype($schliessungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($schliessungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $schliessungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($schliessungsdatum, true)), __LINE__);
        }
        $this->Schliessungsdatum = $schliessungsdatum;
        return $this;
    }
    /**
     * Get Schliessungsart value
     * @return string|null
     */
    public function getSchliessungsart()
    {
        return $this->Schliessungsart;
    }
    /**
     * Set Schliessungsart value
     * @uses \BiPRO\EnumType\ST_Schliessungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schliessungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schliessungsart
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchliessungsart($schliessungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Schliessungsart::valueIsValid($schliessungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schliessungsart', is_array($schliessungsart) ? implode(', ', $schliessungsart) : var_export($schliessungsart, true), implode(', ', \BiPRO\EnumType\ST_Schliessungsart::getValidValues())), __LINE__);
        }
        $this->Schliessungsart = $schliessungsart;
        return $this;
    }
    /**
     * Get BeginnZeichnungsjahr value
     * @return string|null
     */
    public function getBeginnZeichnungsjahr()
    {
        return $this->BeginnZeichnungsjahr;
    }
    /**
     * Set BeginnZeichnungsjahr value
     * @param string $beginnZeichnungsjahr
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setBeginnZeichnungsjahr($beginnZeichnungsjahr = null)
    {
        // validation for constraint: string
        if (!is_null($beginnZeichnungsjahr) && !is_string($beginnZeichnungsjahr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginnZeichnungsjahr, true), gettype($beginnZeichnungsjahr)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($beginnZeichnungsjahr) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $beginnZeichnungsjahr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($beginnZeichnungsjahr, true)), __LINE__);
        }
        $this->BeginnZeichnungsjahr = $beginnZeichnungsjahr;
        return $this;
    }
    /**
     * Get Vertragssparte value
     * @return string|null
     */
    public function getVertragssparte()
    {
        return $this->Vertragssparte;
    }
    /**
     * Set Vertragssparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vertragssparte
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setVertragssparte($vertragssparte = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($vertragssparte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($vertragssparte) ? implode(', ', $vertragssparte) : var_export($vertragssparte, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues())), __LINE__);
        }
        $this->Vertragssparte = $vertragssparte;
        return $this;
    }
    /**
     * Get Schadensparte value
     * @return string|null
     */
    public function getSchadensparte()
    {
        return $this->Schadensparte;
    }
    /**
     * Set Schadensparte value
     * @uses \BiPRO\EnumType\ST_Sparte::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sparte::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadensparte
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadensparte($schadensparte = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sparte::valueIsValid($schadensparte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sparte', is_array($schadensparte) ? implode(', ', $schadensparte) : var_export($schadensparte, true), implode(', ', \BiPRO\EnumType\ST_Sparte::getValidValues())), __LINE__);
        }
        $this->Schadensparte = $schadensparte;
        return $this;
    }
    /**
     * Get Schadenursache value
     * @return string[]|null
     */
    public function getSchadenursache()
    {
        return $this->Schadenursache;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenursache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenursache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenursacheForArrayConstraintsFromSetSchadenursache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenfallLeistungsfallSchadenursacheItem) {
            // validation for constraint: itemType
            if (!is_string($cT_SchadenfallLeistungsfallSchadenursacheItem)) {
                $invalidValues[] = is_object($cT_SchadenfallLeistungsfallSchadenursacheItem) ? get_class($cT_SchadenfallLeistungsfallSchadenursacheItem) : sprintf('%s(%s)', gettype($cT_SchadenfallLeistungsfallSchadenursacheItem), var_export($cT_SchadenfallLeistungsfallSchadenursacheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schadenursache property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSchadenursache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenursache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenursacheForMaxLengthConstraintFromSetSchadenursache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenfallLeistungsfallSchadenursacheItem) {
            // validation for constraint: maxLength(4)
            if (mb_strlen($cT_SchadenfallLeistungsfallSchadenursacheItem) > 4) {
                $invalidValues[] = var_export($cT_SchadenfallLeistungsfallSchadenursacheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 4', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSchadenursache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenursache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenursacheForMinLengthConstraintFromSetSchadenursache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenfallLeistungsfallSchadenursacheItem) {
            // validation for constraint: minLength(4)
            if (mb_strlen($cT_SchadenfallLeistungsfallSchadenursacheItem) < 4) {
                $invalidValues[] = var_export($cT_SchadenfallLeistungsfallSchadenursacheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 4', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schadenursache value
     * @throws \InvalidArgumentException
     * @param string[] $schadenursache
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadenursache(array $schadenursache = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenursacheArrayErrorMessage = self::validateSchadenursacheForArrayConstraintsFromSetSchadenursache($schadenursache))) {
            throw new \InvalidArgumentException($schadenursacheArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(4)
        if ('' !== ($schadenursacheMaxLengthErrorMessage = self::validateSchadenursacheForMaxLengthConstraintFromSetSchadenursache($schadenursache))) {
            throw new \InvalidArgumentException($schadenursacheMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(4)
        if ('' !== ($schadenursacheMinLengthErrorMessage = self::validateSchadenursacheForMinLengthConstraintFromSetSchadenursache($schadenursache))) {
            throw new \InvalidArgumentException($schadenursacheMinLengthErrorMessage, __LINE__);
        }
        $this->Schadenursache = $schadenursache;
        return $this;
    }
    /**
     * Add item to Schadenursache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function addToSchadenursache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Schadenursache property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (mb_strlen($item) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(4)
        if (mb_strlen($item) < 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 4', mb_strlen($item)), __LINE__);
        }
        $this->Schadenursache[] = $item;
        return $this;
    }
    /**
     * Get Teilungsabkommen value
     * @return string|null
     */
    public function getTeilungsabkommen()
    {
        return $this->Teilungsabkommen;
    }
    /**
     * Set Teilungsabkommen value
     * @uses \BiPRO\EnumType\ST_Teilungsabkommen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Teilungsabkommen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $teilungsabkommen
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setTeilungsabkommen($teilungsabkommen = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Teilungsabkommen::valueIsValid($teilungsabkommen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Teilungsabkommen', is_array($teilungsabkommen) ? implode(', ', $teilungsabkommen) : var_export($teilungsabkommen, true), implode(', ', \BiPRO\EnumType\ST_Teilungsabkommen::getValidValues())), __LINE__);
        }
        $this->Teilungsabkommen = $teilungsabkommen;
        return $this;
    }
    /**
     * Get Beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->Beschreibung;
    }
    /**
     * Set Beschreibung value
     * @param string $beschreibung
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibung)), __LINE__);
        }
        $this->Beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get Schadenart value
     * @return string|null
     */
    public function getSchadenart()
    {
        return $this->Schadenart;
    }
    /**
     * Set Schadenart value
     * @uses \BiPRO\EnumType\ST_Schadenart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schadenart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadenart
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadenart($schadenart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Schadenart::valueIsValid($schadenart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schadenart', is_array($schadenart) ? implode(', ', $schadenart) : var_export($schadenart, true), implode(', ', \BiPRO\EnumType\ST_Schadenart::getValidValues())), __LINE__);
        }
        $this->Schadenart = $schadenart;
        return $this;
    }
    /**
     * Get SchadenartUnfall value
     * @return string|null
     */
    public function getSchadenartUnfall()
    {
        return $this->SchadenartUnfall;
    }
    /**
     * Set SchadenartUnfall value
     * @uses \BiPRO\EnumType\ST_SchadenartUnfall::valueIsValid()
     * @uses \BiPRO\EnumType\ST_SchadenartUnfall::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadenartUnfall
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadenartUnfall($schadenartUnfall = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_SchadenartUnfall::valueIsValid($schadenartUnfall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_SchadenartUnfall', is_array($schadenartUnfall) ? implode(', ', $schadenartUnfall) : var_export($schadenartUnfall, true), implode(', ', \BiPRO\EnumType\ST_SchadenartUnfall::getValidValues())), __LINE__);
        }
        $this->SchadenartUnfall = $schadenartUnfall;
        return $this;
    }
    /**
     * Get RegulierungAlsSammelschaden value
     * @return bool|null
     */
    public function getRegulierungAlsSammelschaden()
    {
        return $this->RegulierungAlsSammelschaden;
    }
    /**
     * Set RegulierungAlsSammelschaden value
     * @param bool $regulierungAlsSammelschaden
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setRegulierungAlsSammelschaden($regulierungAlsSammelschaden = null)
    {
        // validation for constraint: boolean
        if (!is_null($regulierungAlsSammelschaden) && !is_bool($regulierungAlsSammelschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($regulierungAlsSammelschaden, true), gettype($regulierungAlsSammelschaden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($regulierungAlsSammelschaden) && !preg_match('/true|false/', $regulierungAlsSammelschaden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($regulierungAlsSammelschaden, true)), __LINE__);
        }
        $this->RegulierungAlsSammelschaden = $regulierungAlsSammelschaden;
        return $this;
    }
    /**
     * Get AnspruecheErhoben value
     * @return string|null
     */
    public function getAnspruecheErhoben()
    {
        return $this->AnspruecheErhoben;
    }
    /**
     * Set AnspruecheErhoben value
     * @uses \BiPRO\EnumType\ST_AnspruchErhoben::valueIsValid()
     * @uses \BiPRO\EnumType\ST_AnspruchErhoben::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anspruecheErhoben
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setAnspruecheErhoben($anspruecheErhoben = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_AnspruchErhoben::valueIsValid($anspruecheErhoben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_AnspruchErhoben', is_array($anspruecheErhoben) ? implode(', ', $anspruecheErhoben) : var_export($anspruecheErhoben, true), implode(', ', \BiPRO\EnumType\ST_AnspruchErhoben::getValidValues())), __LINE__);
        }
        $this->AnspruecheErhoben = $anspruecheErhoben;
        return $this;
    }
    /**
     * Get VNEinverstandenMitZahlungAnAST value
     * @return bool|null
     */
    public function getVNEinverstandenMitZahlungAnAST()
    {
        return $this->VNEinverstandenMitZahlungAnAST;
    }
    /**
     * Set VNEinverstandenMitZahlungAnAST value
     * @param bool $vNEinverstandenMitZahlungAnAST
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setVNEinverstandenMitZahlungAnAST($vNEinverstandenMitZahlungAnAST = null)
    {
        // validation for constraint: boolean
        if (!is_null($vNEinverstandenMitZahlungAnAST) && !is_bool($vNEinverstandenMitZahlungAnAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vNEinverstandenMitZahlungAnAST, true), gettype($vNEinverstandenMitZahlungAnAST)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vNEinverstandenMitZahlungAnAST) && !preg_match('/true|false/', $vNEinverstandenMitZahlungAnAST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vNEinverstandenMitZahlungAnAST, true)), __LINE__);
        }
        $this->VNEinverstandenMitZahlungAnAST = $vNEinverstandenMitZahlungAnAST;
        return $this;
    }
    /**
     * Get VNNichtEinverstandenMitZahlungAnASTBegruendung value
     * @return string|null
     */
    public function getVNNichtEinverstandenMitZahlungAnASTBegruendung()
    {
        return $this->VNNichtEinverstandenMitZahlungAnASTBegruendung;
    }
    /**
     * Set VNNichtEinverstandenMitZahlungAnASTBegruendung value
     * @param string $vNNichtEinverstandenMitZahlungAnASTBegruendung
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setVNNichtEinverstandenMitZahlungAnASTBegruendung($vNNichtEinverstandenMitZahlungAnASTBegruendung = null)
    {
        // validation for constraint: string
        if (!is_null($vNNichtEinverstandenMitZahlungAnASTBegruendung) && !is_string($vNNichtEinverstandenMitZahlungAnASTBegruendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vNNichtEinverstandenMitZahlungAnASTBegruendung, true), gettype($vNNichtEinverstandenMitZahlungAnASTBegruendung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($vNNichtEinverstandenMitZahlungAnASTBegruendung) && mb_strlen($vNNichtEinverstandenMitZahlungAnASTBegruendung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($vNNichtEinverstandenMitZahlungAnASTBegruendung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vNNichtEinverstandenMitZahlungAnASTBegruendung) && mb_strlen($vNNichtEinverstandenMitZahlungAnASTBegruendung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vNNichtEinverstandenMitZahlungAnASTBegruendung)), __LINE__);
        }
        $this->VNNichtEinverstandenMitZahlungAnASTBegruendung = $vNNichtEinverstandenMitZahlungAnASTBegruendung;
        return $this;
    }
    /**
     * Get Aktenzeichen value
     * @return \BiPRO\StructType\CT_Schadennummer[]|null
     */
    public function getAktenzeichen()
    {
        return $this->Aktenzeichen;
    }
    /**
     * This method is responsible for validating the values passed to the setAktenzeichen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAktenzeichen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAktenzeichenForArrayConstraintsFromSetAktenzeichen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenfallLeistungsfallAktenzeichenItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenfallLeistungsfallAktenzeichenItem instanceof \BiPRO\StructType\CT_Schadennummer) {
                $invalidValues[] = is_object($cT_SchadenfallLeistungsfallAktenzeichenItem) ? get_class($cT_SchadenfallLeistungsfallAktenzeichenItem) : sprintf('%s(%s)', gettype($cT_SchadenfallLeistungsfallAktenzeichenItem), var_export($cT_SchadenfallLeistungsfallAktenzeichenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Aktenzeichen property can only contain items of type \BiPRO\StructType\CT_Schadennummer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Aktenzeichen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadennummer[] $aktenzeichen
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setAktenzeichen(array $aktenzeichen = array())
    {
        // validation for constraint: array
        if ('' !== ($aktenzeichenArrayErrorMessage = self::validateAktenzeichenForArrayConstraintsFromSetAktenzeichen($aktenzeichen))) {
            throw new \InvalidArgumentException($aktenzeichenArrayErrorMessage, __LINE__);
        }
        $this->Aktenzeichen = $aktenzeichen;
        return $this;
    }
    /**
     * Add item to Aktenzeichen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadennummer $item
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function addToAktenzeichen(\BiPRO\StructType\CT_Schadennummer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Schadennummer) {
            throw new \InvalidArgumentException(sprintf('The Aktenzeichen property can only contain items of type \BiPRO\StructType\CT_Schadennummer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Aktenzeichen[] = $item;
        return $this;
    }
    /**
     * Get Beteiligungsverhaeltnis value
     * @return \BiPRO\StructType\CT_Beteiligungsverhaeltnis|null
     */
    public function getBeteiligungsverhaeltnis()
    {
        return $this->Beteiligungsverhaeltnis;
    }
    /**
     * Set Beteiligungsverhaeltnis value
     * @param \BiPRO\StructType\CT_Beteiligungsverhaeltnis $beteiligungsverhaeltnis
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setBeteiligungsverhaeltnis(\BiPRO\StructType\CT_Beteiligungsverhaeltnis $beteiligungsverhaeltnis = null)
    {
        $this->Beteiligungsverhaeltnis = $beteiligungsverhaeltnis;
        return $this;
    }
    /**
     * Get AltesVersicherungsunternehmen value
     * @return \BiPRO\StructType\CT_Unternehmen|null
     */
    public function getAltesVersicherungsunternehmen()
    {
        return $this->AltesVersicherungsunternehmen;
    }
    /**
     * Set AltesVersicherungsunternehmen value
     * @param \BiPRO\StructType\CT_Unternehmen $altesVersicherungsunternehmen
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setAltesVersicherungsunternehmen(\BiPRO\StructType\CT_Unternehmen $altesVersicherungsunternehmen = null)
    {
        $this->AltesVersicherungsunternehmen = $altesVersicherungsunternehmen;
        return $this;
    }
    /**
     * Get BearbeitendeStelle value
     * @return \BiPRO\StructType\CT_BearbeitendeStelle|null
     */
    public function getBearbeitendeStelle()
    {
        return $this->BearbeitendeStelle;
    }
    /**
     * Set BearbeitendeStelle value
     * @param \BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setBearbeitendeStelle(\BiPRO\StructType\CT_BearbeitendeStelle $bearbeitendeStelle = null)
    {
        $this->BearbeitendeStelle = $bearbeitendeStelle;
        return $this;
    }
    /**
     * Get ExterneBearbeitungskosten value
     * @return \BiPRO\StructType\CT_ExterneBearbeitungskosten|null
     */
    public function getExterneBearbeitungskosten()
    {
        return $this->ExterneBearbeitungskosten;
    }
    /**
     * Set ExterneBearbeitungskosten value
     * @param \BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setExterneBearbeitungskosten(\BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten = null)
    {
        $this->ExterneBearbeitungskosten = $externeBearbeitungskosten;
        return $this;
    }
    /**
     * Get Anspruchsteller value
     * @return \BiPRO\StructType\CT_Anspruchsteller[]|null
     */
    public function getAnspruchsteller()
    {
        return $this->Anspruchsteller;
    }
    /**
     * This method is responsible for validating the values passed to the setAnspruchsteller method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnspruchsteller method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnspruchstellerForArrayConstraintsFromSetAnspruchsteller(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenfallLeistungsfallAnspruchstellerItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenfallLeistungsfallAnspruchstellerItem instanceof \BiPRO\StructType\CT_Anspruchsteller) {
                $invalidValues[] = is_object($cT_SchadenfallLeistungsfallAnspruchstellerItem) ? get_class($cT_SchadenfallLeistungsfallAnspruchstellerItem) : sprintf('%s(%s)', gettype($cT_SchadenfallLeistungsfallAnspruchstellerItem), var_export($cT_SchadenfallLeistungsfallAnspruchstellerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Anspruchsteller property can only contain items of type \BiPRO\StructType\CT_Anspruchsteller, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Anspruchsteller value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Anspruchsteller[] $anspruchsteller
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setAnspruchsteller(array $anspruchsteller = array())
    {
        // validation for constraint: array
        if ('' !== ($anspruchstellerArrayErrorMessage = self::validateAnspruchstellerForArrayConstraintsFromSetAnspruchsteller($anspruchsteller))) {
            throw new \InvalidArgumentException($anspruchstellerArrayErrorMessage, __LINE__);
        }
        $this->Anspruchsteller = $anspruchsteller;
        return $this;
    }
    /**
     * Add item to Anspruchsteller value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Anspruchsteller $item
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function addToAnspruchsteller(\BiPRO\StructType\CT_Anspruchsteller $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Anspruchsteller) {
            throw new \InvalidArgumentException(sprintf('The Anspruchsteller property can only contain items of type \BiPRO\StructType\CT_Anspruchsteller, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Anspruchsteller[] = $item;
        return $this;
    }
    /**
     * Get Versicherungsunternehmen value
     * @return \BiPRO\StructType\CT_Unternehmen|null
     */
    public function getVersicherungsunternehmen()
    {
        return $this->Versicherungsunternehmen;
    }
    /**
     * Set Versicherungsunternehmen value
     * @param \BiPRO\StructType\CT_Unternehmen $versicherungsunternehmen
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setVersicherungsunternehmen(\BiPRO\StructType\CT_Unternehmen $versicherungsunternehmen = null)
    {
        $this->Versicherungsunternehmen = $versicherungsunternehmen;
        return $this;
    }
    /**
     * Get AlteSchadennummer value
     * @return \BiPRO\StructType\CT_Schadennummer|null
     */
    public function getAlteSchadennummer()
    {
        return $this->AlteSchadennummer;
    }
    /**
     * Set AlteSchadennummer value
     * @param \BiPRO\StructType\CT_Schadennummer $alteSchadennummer
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setAlteSchadennummer(\BiPRO\StructType\CT_Schadennummer $alteSchadennummer = null)
    {
        $this->AlteSchadennummer = $alteSchadennummer;
        return $this;
    }
    /**
     * Get AnderweitigerVersicherungsschutz value
     * @return \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz[]|null
     */
    public function getAnderweitigerVersicherungsschutz()
    {
        return $this->AnderweitigerVersicherungsschutz;
    }
    /**
     * This method is responsible for validating the values passed to the setAnderweitigerVersicherungsschutz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnderweitigerVersicherungsschutz method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnderweitigerVersicherungsschutzForArrayConstraintsFromSetAnderweitigerVersicherungsschutz(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenfallLeistungsfallAnderweitigerVersicherungsschutzItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenfallLeistungsfallAnderweitigerVersicherungsschutzItem instanceof \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz) {
                $invalidValues[] = is_object($cT_SchadenfallLeistungsfallAnderweitigerVersicherungsschutzItem) ? get_class($cT_SchadenfallLeistungsfallAnderweitigerVersicherungsschutzItem) : sprintf('%s(%s)', gettype($cT_SchadenfallLeistungsfallAnderweitigerVersicherungsschutzItem), var_export($cT_SchadenfallLeistungsfallAnderweitigerVersicherungsschutzItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnderweitigerVersicherungsschutz property can only contain items of type \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnderweitigerVersicherungsschutz value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz[] $anderweitigerVersicherungsschutz
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setAnderweitigerVersicherungsschutz(array $anderweitigerVersicherungsschutz = array())
    {
        // validation for constraint: array
        if ('' !== ($anderweitigerVersicherungsschutzArrayErrorMessage = self::validateAnderweitigerVersicherungsschutzForArrayConstraintsFromSetAnderweitigerVersicherungsschutz($anderweitigerVersicherungsschutz))) {
            throw new \InvalidArgumentException($anderweitigerVersicherungsschutzArrayErrorMessage, __LINE__);
        }
        $this->AnderweitigerVersicherungsschutz = $anderweitigerVersicherungsschutz;
        return $this;
    }
    /**
     * Add item to AnderweitigerVersicherungsschutz value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz $item
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function addToAnderweitigerVersicherungsschutz(\BiPRO\StructType\CT_AnderweitigerVersicherungsschutz $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz) {
            throw new \InvalidArgumentException(sprintf('The AnderweitigerVersicherungsschutz property can only contain items of type \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnderweitigerVersicherungsschutz[] = $item;
        return $this;
    }
    /**
     * Get Entschaedigungsbetrag value
     * @return \BiPRO\StructType\CT_Entschaedigungsbetrag|null
     */
    public function getEntschaedigungsbetrag()
    {
        return $this->Entschaedigungsbetrag;
    }
    /**
     * Set Entschaedigungsbetrag value
     * @param \BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setEntschaedigungsbetrag(\BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag = null)
    {
        $this->Entschaedigungsbetrag = $entschaedigungsbetrag;
        return $this;
    }
    /**
     * Get Schadennummer value
     * @return \BiPRO\StructType\CT_Schadennummer|null
     */
    public function getSchadennummer()
    {
        return $this->Schadennummer;
    }
    /**
     * Set Schadennummer value
     * @param \BiPRO\StructType\CT_Schadennummer $schadennummer
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadennummer(\BiPRO\StructType\CT_Schadennummer $schadennummer = null)
    {
        $this->Schadennummer = $schadennummer;
        return $this;
    }
    /**
     * Get Vertrag value
     * @return \BiPRO\StructType\CT_Vertrag|null
     */
    public function getVertrag()
    {
        return $this->Vertrag;
    }
    /**
     * Set Vertrag value
     * @param \BiPRO\StructType\CT_Vertrag $vertrag
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setVertrag(\BiPRO\StructType\CT_Vertrag $vertrag = null)
    {
        $this->Vertrag = $vertrag;
        return $this;
    }
    /**
     * Get Regulierung value
     * @return \BiPRO\StructType\CT_Regulierung[]|null
     */
    public function getRegulierung()
    {
        return $this->Regulierung;
    }
    /**
     * This method is responsible for validating the values passed to the setRegulierung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegulierung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegulierungForArrayConstraintsFromSetRegulierung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenfallLeistungsfallRegulierungItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenfallLeistungsfallRegulierungItem instanceof \BiPRO\StructType\CT_Regulierung) {
                $invalidValues[] = is_object($cT_SchadenfallLeistungsfallRegulierungItem) ? get_class($cT_SchadenfallLeistungsfallRegulierungItem) : sprintf('%s(%s)', gettype($cT_SchadenfallLeistungsfallRegulierungItem), var_export($cT_SchadenfallLeistungsfallRegulierungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Regulierung property can only contain items of type \BiPRO\StructType\CT_Regulierung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Regulierung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Regulierung[] $regulierung
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setRegulierung(array $regulierung = array())
    {
        // validation for constraint: array
        if ('' !== ($regulierungArrayErrorMessage = self::validateRegulierungForArrayConstraintsFromSetRegulierung($regulierung))) {
            throw new \InvalidArgumentException($regulierungArrayErrorMessage, __LINE__);
        }
        $this->Regulierung = $regulierung;
        return $this;
    }
    /**
     * Add item to Regulierung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Regulierung $item
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function addToRegulierung(\BiPRO\StructType\CT_Regulierung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Regulierung) {
            throw new \InvalidArgumentException(sprintf('The Regulierung property can only contain items of type \BiPRO\StructType\CT_Regulierung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Regulierung[] = $item;
        return $this;
    }
    /**
     * Get Selbstbehaltsbetrag value
     * @return \BiPRO\StructType\CT_Selbstbehaltsbetrag|null
     */
    public function getSelbstbehaltsbetrag()
    {
        return $this->Selbstbehaltsbetrag;
    }
    /**
     * Set Selbstbehaltsbetrag value
     * @param \BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSelbstbehaltsbetrag(\BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag = null)
    {
        $this->Selbstbehaltsbetrag = $selbstbehaltsbetrag;
        return $this;
    }
    /**
     * Get Schadenmelder value
     * @return \BiPRO\StructType\CT_Beteiligter|null
     */
    public function getSchadenmelder()
    {
        return $this->Schadenmelder;
    }
    /**
     * Set Schadenmelder value
     * @param \BiPRO\StructType\CT_Beteiligter $schadenmelder
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setSchadenmelder(\BiPRO\StructType\CT_Beteiligter $schadenmelder = null)
    {
        $this->Schadenmelder = $schadenmelder;
        return $this;
    }
    /**
     * Get Reserve value
     * @return \BiPRO\StructType\CT_Reserve|null
     */
    public function getReserve()
    {
        return $this->Reserve;
    }
    /**
     * Set Reserve value
     * @param \BiPRO\StructType\CT_Reserve $reserve
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall
     */
    public function setReserve(\BiPRO\StructType\CT_Reserve $reserve = null)
    {
        $this->Reserve = $reserve;
        return $this;
    }
}
