<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Sanierung StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur genauen Ermittlung der Sanierungskriterien, sowie Kernsanierungen.
 * @subpackage Structs
 */
class CT_Sanierung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Gibt an welche Maßnahme zur Sanierung / Kernsanierung durchgeführt wurde.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The Anteil
     * Meta information extracted from the WSDL
     * - documentation: Prozentualer Anteil der Sanierung. 0 Prozent bedeutet keine Sanierung; 100% bedeutet vollständige Sanierung der Sanierungsart (z.B. Dach) | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Anteil;
    /**
     * The Jahr
     * Meta information extracted from the WSDL
     * - documentation: Jahreszahl in der die beschriebene Sanierung / Kernsanierung (ArtID) durchgeführt wurde.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Jahr;
    /**
     * Constructor method for CT_Sanierung
     * @uses CT_Sanierung::setArtID()
     * @uses CT_Sanierung::setAnteil()
     * @uses CT_Sanierung::setJahr()
     * @param string $artID
     * @param float $anteil
     * @param int $jahr
     */
    public function __construct($artID = null, $anteil = null, $jahr = null)
    {
        $this
            ->setArtID($artID)
            ->setAnteil($anteil)
            ->setJahr($jahr);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Sanierungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sanierungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Sanierung
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sanierungsart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sanierungsart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Sanierungsart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Anteil value
     * @return float|null
     */
    public function getAnteil()
    {
        return $this->Anteil;
    }
    /**
     * Set Anteil value
     * @param float $anteil
     * @return \BiPRO\StructType\CT_Sanierung
     */
    public function setAnteil($anteil = null)
    {
        // validation for constraint: float
        if (!is_null($anteil) && !(is_float($anteil) || is_numeric($anteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteil, true), gettype($anteil)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anteil) && $anteil < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anteil, true)), __LINE__);
        }
        $this->Anteil = $anteil;
        return $this;
    }
    /**
     * Get Jahr value
     * @return int|null
     */
    public function getJahr()
    {
        return $this->Jahr;
    }
    /**
     * Set Jahr value
     * @param int $jahr
     * @return \BiPRO\StructType\CT_Sanierung
     */
    public function setJahr($jahr = null)
    {
        // validation for constraint: int
        if (!is_null($jahr) && !(is_int($jahr) || ctype_digit($jahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jahr, true), gettype($jahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($jahr) && mb_strlen(preg_replace('/(\D)/', '', $jahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($jahr, true), mb_strlen(preg_replace('/(\D)/', '', $jahr))), __LINE__);
        }
        $this->Jahr = $jahr;
        return $this;
    }
}
