<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Reifen StructType
 * Meta information extracted from the WSDL
 * - documentation: Der äußere Teil eines Rades, auf dem es abrollt.
 * @subpackage Structs
 */
class CT_Reifen extends CT_Objekt
{
    /**
     * The Achse
     * Meta information extracted from the WSDL
     * - documentation: Achse, auf der das Rad montiert ist. Die Achsen werden von vorne nach hinten durchnummeriert. Bei einem PKW also:Achse 1 = VorderachseAchse 2 = Hinterachse
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Achse;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - documentation: Position des Rades auf der Achse bzw. als Reserverad.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Position;
    /**
     * The Profiltiefe
     * Meta information extracted from the WSDL
     * - documentation: Profiltiefe des Reifens in Millimeter (mm).
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Profiltiefe;
    /**
     * Constructor method for CT_Reifen
     * @uses CT_Reifen::setAchse()
     * @uses CT_Reifen::setPosition()
     * @uses CT_Reifen::setProfiltiefe()
     * @param int $achse
     * @param string $position
     * @param float $profiltiefe
     */
    public function __construct($achse = null, $position = null, $profiltiefe = null)
    {
        $this
            ->setAchse($achse)
            ->setPosition($position)
            ->setProfiltiefe($profiltiefe);
    }
    /**
     * Get Achse value
     * @return int|null
     */
    public function getAchse()
    {
        return $this->Achse;
    }
    /**
     * Set Achse value
     * @param int $achse
     * @return \BiPRO\StructType\CT_Reifen
     */
    public function setAchse($achse = null)
    {
        // validation for constraint: int
        if (!is_null($achse) && !(is_int($achse) || ctype_digit($achse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($achse, true), gettype($achse)), __LINE__);
        }
        $this->Achse = $achse;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @uses \BiPRO\EnumType\ST_Radposition::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Radposition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $position
     * @return \BiPRO\StructType\CT_Reifen
     */
    public function setPosition($position = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Radposition::valueIsValid($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Radposition', is_array($position) ? implode(', ', $position) : var_export($position, true), implode(', ', \BiPRO\EnumType\ST_Radposition::getValidValues())), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Profiltiefe value
     * @return float|null
     */
    public function getProfiltiefe()
    {
        return $this->Profiltiefe;
    }
    /**
     * Set Profiltiefe value
     * @param float $profiltiefe
     * @return \BiPRO\StructType\CT_Reifen
     */
    public function setProfiltiefe($profiltiefe = null)
    {
        // validation for constraint: float
        if (!is_null($profiltiefe) && !(is_float($profiltiefe) || is_numeric($profiltiefe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($profiltiefe, true), gettype($profiltiefe)), __LINE__);
        }
        $this->Profiltiefe = $profiltiefe;
        return $this;
    }
}
