<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Regulierung StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einer Regulierung zu einem Schaden oder einer Leistung.
 * @subpackage Structs
 */
class CT_Regulierung extends CT_Objekt
{
    /**
     * The Aufwandsart
     * Meta information extracted from the WSDL
     * - documentation: Art des Schaden- bzw. Leistungsaufwandes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aufwandsart;
    /**
     * The Zahlungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Regulierungszahlung | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Zahlungsdatum;
    /**
     * The Zahlungsempfaenger
     * Meta information extracted from the WSDL
     * - documentation: Partner, der diese Zahlung erhalten hat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beteiligter
     */
    public $Zahlungsempfaenger;
    /**
     * The Entschaedigungsbetrag
     * Meta information extracted from the WSDL
     * - documentation: Geldwert der Entschädigung, der bei dieser Regulierung aufgewendet wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Entschaedigungsbetrag
     */
    public $Entschaedigungsbetrag;
    /**
     * The Selbstbehaltsbetrag
     * Meta information extracted from the WSDL
     * - documentation: Selbstbehaltsbetrag, der bei dieser Regulierung berücksichtigt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Selbstbehaltsbetrag
     */
    public $Selbstbehaltsbetrag;
    /**
     * The Regulierungsart
     * Meta information extracted from the WSDL
     * - documentation: Ausführender der Regulierung (Versicherungsunternehmen, Vermittler oder bevollmächtigter Dienstleister).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Regulierungsart;
    /**
     * The SelbstbehaltBeruecksichtigt
     * Meta information extracted from the WSDL
     * - documentation: JA = Es wurde bei der Regulierung ein Selbstbehalt berücksichtigt.NEIN = Es wurde bei der Regulierung kein Selbstbehalt berücksichtigt.Ist das Feld nicht belegt, MUSS es als mit 'NEIN' belegt interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SelbstbehaltBeruecksichtigt;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status der Regulierung (z.B. bereits erfolgt, gewünscht).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Abrechnungsform
     * Meta information extracted from the WSDL
     * - documentation: Abrechnungsform der Regulierung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Abrechnungsform;
    /**
     * The Zahlungsart
     * Meta information extracted from the WSDL
     * - documentation: Art der Regulierungszahlung (z.B. Überweisung, Scheck, Barzahlung).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungsart;
    /**
     * The SteuerEnthalten
     * Meta information extracted from the WSDL
     * - documentation: JA = Im Regulierungsbetrag ist die Steuer enthalten (Bruttobetrag)NEIN = Im Regulierungsbetrag ist die Steuer nicht enthalten(Nettobetrag)Der Regulierungsbetrag ergibt sich aus dem Entschaedigungsbetrag und/oder den
     * Bearbeitungskosten.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SteuerEnthalten;
    /**
     * The ExterneBearbeitungskosten
     * Meta information extracted from the WSDL
     * - documentation: Externe Kosten zur Bearbeitung eines Schadens bzw. einer Leistung, die bei dieser Regulierung aufgewendet wurden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ExterneBearbeitungskosten
     */
    public $ExterneBearbeitungskosten;
    /**
     * The Zahlungsfreigebender
     * Meta information extracted from the WSDL
     * - documentation: Person, die diese Zahlung freigegeben hat. Wird insbesondere bei einer Regulierungsvollmacht benötigt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zahlungsfreigebender[]
     */
    public $Zahlungsfreigebender;
    /**
     * Constructor method for CT_Regulierung
     * @uses CT_Regulierung::setAufwandsart()
     * @uses CT_Regulierung::setZahlungsdatum()
     * @uses CT_Regulierung::setZahlungsempfaenger()
     * @uses CT_Regulierung::setEntschaedigungsbetrag()
     * @uses CT_Regulierung::setSelbstbehaltsbetrag()
     * @uses CT_Regulierung::setRegulierungsart()
     * @uses CT_Regulierung::setSelbstbehaltBeruecksichtigt()
     * @uses CT_Regulierung::setStatus()
     * @uses CT_Regulierung::setAbrechnungsform()
     * @uses CT_Regulierung::setZahlungsart()
     * @uses CT_Regulierung::setSteuerEnthalten()
     * @uses CT_Regulierung::setExterneBearbeitungskosten()
     * @uses CT_Regulierung::setZahlungsfreigebender()
     * @param string $aufwandsart
     * @param string $zahlungsdatum
     * @param \BiPRO\StructType\CT_Beteiligter $zahlungsempfaenger
     * @param \BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag
     * @param \BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag
     * @param string $regulierungsart
     * @param bool $selbstbehaltBeruecksichtigt
     * @param string $status
     * @param string $abrechnungsform
     * @param string $zahlungsart
     * @param bool $steuerEnthalten
     * @param \BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten
     * @param \BiPRO\StructType\CT_Zahlungsfreigebender[] $zahlungsfreigebender
     */
    public function __construct($aufwandsart = null, $zahlungsdatum = null, \BiPRO\StructType\CT_Beteiligter $zahlungsempfaenger = null, \BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag = null, \BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag = null, $regulierungsart = null, $selbstbehaltBeruecksichtigt = null, $status = null, $abrechnungsform = null, $zahlungsart = null, $steuerEnthalten = null, \BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten = null, array $zahlungsfreigebender = array())
    {
        $this
            ->setAufwandsart($aufwandsart)
            ->setZahlungsdatum($zahlungsdatum)
            ->setZahlungsempfaenger($zahlungsempfaenger)
            ->setEntschaedigungsbetrag($entschaedigungsbetrag)
            ->setSelbstbehaltsbetrag($selbstbehaltsbetrag)
            ->setRegulierungsart($regulierungsart)
            ->setSelbstbehaltBeruecksichtigt($selbstbehaltBeruecksichtigt)
            ->setStatus($status)
            ->setAbrechnungsform($abrechnungsform)
            ->setZahlungsart($zahlungsart)
            ->setSteuerEnthalten($steuerEnthalten)
            ->setExterneBearbeitungskosten($externeBearbeitungskosten)
            ->setZahlungsfreigebender($zahlungsfreigebender);
    }
    /**
     * Get Aufwandsart value
     * @return string|null
     */
    public function getAufwandsart()
    {
        return $this->Aufwandsart;
    }
    /**
     * Set Aufwandsart value
     * @uses \BiPRO\EnumType\ST_Aufwandsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Aufwandsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aufwandsart
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setAufwandsart($aufwandsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Aufwandsart::valueIsValid($aufwandsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Aufwandsart', is_array($aufwandsart) ? implode(', ', $aufwandsart) : var_export($aufwandsart, true), implode(', ', \BiPRO\EnumType\ST_Aufwandsart::getValidValues())), __LINE__);
        }
        $this->Aufwandsart = $aufwandsart;
        return $this;
    }
    /**
     * Get Zahlungsdatum value
     * @return string|null
     */
    public function getZahlungsdatum()
    {
        return $this->Zahlungsdatum;
    }
    /**
     * Set Zahlungsdatum value
     * @param string $zahlungsdatum
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setZahlungsdatum($zahlungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($zahlungsdatum) && !is_string($zahlungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zahlungsdatum, true), gettype($zahlungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($zahlungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $zahlungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($zahlungsdatum, true)), __LINE__);
        }
        $this->Zahlungsdatum = $zahlungsdatum;
        return $this;
    }
    /**
     * Get Zahlungsempfaenger value
     * @return \BiPRO\StructType\CT_Beteiligter|null
     */
    public function getZahlungsempfaenger()
    {
        return $this->Zahlungsempfaenger;
    }
    /**
     * Set Zahlungsempfaenger value
     * @param \BiPRO\StructType\CT_Beteiligter $zahlungsempfaenger
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setZahlungsempfaenger(\BiPRO\StructType\CT_Beteiligter $zahlungsempfaenger = null)
    {
        $this->Zahlungsempfaenger = $zahlungsempfaenger;
        return $this;
    }
    /**
     * Get Entschaedigungsbetrag value
     * @return \BiPRO\StructType\CT_Entschaedigungsbetrag|null
     */
    public function getEntschaedigungsbetrag()
    {
        return $this->Entschaedigungsbetrag;
    }
    /**
     * Set Entschaedigungsbetrag value
     * @param \BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setEntschaedigungsbetrag(\BiPRO\StructType\CT_Entschaedigungsbetrag $entschaedigungsbetrag = null)
    {
        $this->Entschaedigungsbetrag = $entschaedigungsbetrag;
        return $this;
    }
    /**
     * Get Selbstbehaltsbetrag value
     * @return \BiPRO\StructType\CT_Selbstbehaltsbetrag|null
     */
    public function getSelbstbehaltsbetrag()
    {
        return $this->Selbstbehaltsbetrag;
    }
    /**
     * Set Selbstbehaltsbetrag value
     * @param \BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setSelbstbehaltsbetrag(\BiPRO\StructType\CT_Selbstbehaltsbetrag $selbstbehaltsbetrag = null)
    {
        $this->Selbstbehaltsbetrag = $selbstbehaltsbetrag;
        return $this;
    }
    /**
     * Get Regulierungsart value
     * @return string|null
     */
    public function getRegulierungsart()
    {
        return $this->Regulierungsart;
    }
    /**
     * Set Regulierungsart value
     * @uses \BiPRO\EnumType\ST_Regulierungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Regulierungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regulierungsart
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setRegulierungsart($regulierungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Regulierungsart::valueIsValid($regulierungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Regulierungsart', is_array($regulierungsart) ? implode(', ', $regulierungsart) : var_export($regulierungsart, true), implode(', ', \BiPRO\EnumType\ST_Regulierungsart::getValidValues())), __LINE__);
        }
        $this->Regulierungsart = $regulierungsart;
        return $this;
    }
    /**
     * Get SelbstbehaltBeruecksichtigt value
     * @return bool|null
     */
    public function getSelbstbehaltBeruecksichtigt()
    {
        return $this->SelbstbehaltBeruecksichtigt;
    }
    /**
     * Set SelbstbehaltBeruecksichtigt value
     * @param bool $selbstbehaltBeruecksichtigt
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setSelbstbehaltBeruecksichtigt($selbstbehaltBeruecksichtigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($selbstbehaltBeruecksichtigt) && !is_bool($selbstbehaltBeruecksichtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selbstbehaltBeruecksichtigt, true), gettype($selbstbehaltBeruecksichtigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($selbstbehaltBeruecksichtigt) && !preg_match('/true|false/', $selbstbehaltBeruecksichtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($selbstbehaltBeruecksichtigt, true)), __LINE__);
        }
        $this->SelbstbehaltBeruecksichtigt = $selbstbehaltBeruecksichtigt;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \BiPRO\EnumType\ST_Regulierungsstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Regulierungsstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Regulierungsstatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Regulierungsstatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \BiPRO\EnumType\ST_Regulierungsstatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Abrechnungsform value
     * @return string|null
     */
    public function getAbrechnungsform()
    {
        return $this->Abrechnungsform;
    }
    /**
     * Set Abrechnungsform value
     * @uses \BiPRO\EnumType\ST_Schadenabrechnungsform::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schadenabrechnungsform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abrechnungsform
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setAbrechnungsform($abrechnungsform = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Schadenabrechnungsform::valueIsValid($abrechnungsform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schadenabrechnungsform', is_array($abrechnungsform) ? implode(', ', $abrechnungsform) : var_export($abrechnungsform, true), implode(', ', \BiPRO\EnumType\ST_Schadenabrechnungsform::getValidValues())), __LINE__);
        }
        $this->Abrechnungsform = $abrechnungsform;
        return $this;
    }
    /**
     * Get Zahlungsart value
     * @return string|null
     */
    public function getZahlungsart()
    {
        return $this->Zahlungsart;
    }
    /**
     * Set Zahlungsart value
     * @uses \BiPRO\EnumType\ST_Zahlungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsart
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setZahlungsart($zahlungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsart::valueIsValid($zahlungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsart', is_array($zahlungsart) ? implode(', ', $zahlungsart) : var_export($zahlungsart, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsart::getValidValues())), __LINE__);
        }
        $this->Zahlungsart = $zahlungsart;
        return $this;
    }
    /**
     * Get SteuerEnthalten value
     * @return bool|null
     */
    public function getSteuerEnthalten()
    {
        return $this->SteuerEnthalten;
    }
    /**
     * Set SteuerEnthalten value
     * @param bool $steuerEnthalten
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setSteuerEnthalten($steuerEnthalten = null)
    {
        // validation for constraint: boolean
        if (!is_null($steuerEnthalten) && !is_bool($steuerEnthalten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($steuerEnthalten, true), gettype($steuerEnthalten)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($steuerEnthalten) && !preg_match('/true|false/', $steuerEnthalten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($steuerEnthalten, true)), __LINE__);
        }
        $this->SteuerEnthalten = $steuerEnthalten;
        return $this;
    }
    /**
     * Get ExterneBearbeitungskosten value
     * @return \BiPRO\StructType\CT_ExterneBearbeitungskosten|null
     */
    public function getExterneBearbeitungskosten()
    {
        return $this->ExterneBearbeitungskosten;
    }
    /**
     * Set ExterneBearbeitungskosten value
     * @param \BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setExterneBearbeitungskosten(\BiPRO\StructType\CT_ExterneBearbeitungskosten $externeBearbeitungskosten = null)
    {
        $this->ExterneBearbeitungskosten = $externeBearbeitungskosten;
        return $this;
    }
    /**
     * Get Zahlungsfreigebender value
     * @return \BiPRO\StructType\CT_Zahlungsfreigebender[]|null
     */
    public function getZahlungsfreigebender()
    {
        return $this->Zahlungsfreigebender;
    }
    /**
     * This method is responsible for validating the values passed to the setZahlungsfreigebender method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZahlungsfreigebender method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZahlungsfreigebenderForArrayConstraintsFromSetZahlungsfreigebender(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_RegulierungZahlungsfreigebenderItem) {
            // validation for constraint: itemType
            if (!$cT_RegulierungZahlungsfreigebenderItem instanceof \BiPRO\StructType\CT_Zahlungsfreigebender) {
                $invalidValues[] = is_object($cT_RegulierungZahlungsfreigebenderItem) ? get_class($cT_RegulierungZahlungsfreigebenderItem) : sprintf('%s(%s)', gettype($cT_RegulierungZahlungsfreigebenderItem), var_export($cT_RegulierungZahlungsfreigebenderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Zahlungsfreigebender property can only contain items of type \BiPRO\StructType\CT_Zahlungsfreigebender, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Zahlungsfreigebender value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Zahlungsfreigebender[] $zahlungsfreigebender
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function setZahlungsfreigebender(array $zahlungsfreigebender = array())
    {
        // validation for constraint: array
        if ('' !== ($zahlungsfreigebenderArrayErrorMessage = self::validateZahlungsfreigebenderForArrayConstraintsFromSetZahlungsfreigebender($zahlungsfreigebender))) {
            throw new \InvalidArgumentException($zahlungsfreigebenderArrayErrorMessage, __LINE__);
        }
        $this->Zahlungsfreigebender = $zahlungsfreigebender;
        return $this;
    }
    /**
     * Add item to Zahlungsfreigebender value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Zahlungsfreigebender $item
     * @return \BiPRO\StructType\CT_Regulierung
     */
    public function addToZahlungsfreigebender(\BiPRO\StructType\CT_Zahlungsfreigebender $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Zahlungsfreigebender) {
            throw new \InvalidArgumentException(sprintf('The Zahlungsfreigebender property can only contain items of type \BiPRO\StructType\CT_Zahlungsfreigebender, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Zahlungsfreigebender[] = $item;
        return $this;
    }
}
