<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Rechtsschutzschaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Schaden, der durch eine Rechtsschutzversicherung reguliert werden soll oder wurde.
 * @subpackage Structs
 */
class CT_Rechtsschutzschaden extends CT_SchadenZuPerson
{
    /**
     * The LeistungsartBereich
     * Meta information extracted from the WSDL
     * - documentation: Leistungsart-Bereich, dem der Schaden zuzuordnen ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LeistungsartBereich;
    /**
     * The Leistungsart
     * Meta information extracted from the WSDL
     * - documentation: Leistungsart, der der Schaden zuzuordnen ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Leistungsart
     */
    public $Leistungsart;
    /**
     * The EigenschaftVN
     * Meta information extracted from the WSDL
     * - documentation: Eigenschaft des Versicherungsnehmers in Bezug auf das versicherte Interesse.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EigenschaftVN;
    /**
     * The AnzahlWohnungen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Wohnungen im versicherten Gebäude.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlWohnungen;
    /**
     * The BereitsVorGericht
     * Meta information extracted from the WSDL
     * - documentation: JA = Rechtsstreit ist bereits vor Gericht.NEIN = Rechtsstreit ist noch nicht vor Gericht.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BereitsVorGericht;
    /**
     * The MitErstberatungAbgeschlossen
     * Meta information extracted from the WSDL
     * - documentation: JA = Vorgang mit Erstberatung abgeschlossen.NEIN = Vorgang mit Erstberatung nicht abgeschlossen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $MitErstberatungAbgeschlossen;
    /**
     * The Rechtslageaenderung
     * Meta information extracted from the WSDL
     * - documentation: JA = Versicherungsfall im familien- und erbrechtlichen Beratungs-Rechtsschutz aufgrund einer RechtslageänderungNEIN = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Rechtslageaenderung;
    /**
     * The VerhaltensbedingteKuendigung
     * Meta information extracted from the WSDL
     * - documentation: JA = Rechtsstreit aufgrund verhaltensbedingter Kündigung im Arbeitsrechtsschutz. NEIN = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VerhaltensbedingteKuendigung;
    /**
     * The Vorsatzvorwurf
     * Meta information extracted from the WSDL
     * - documentation: JA = Es besteht der Vorwurf auf Vorsatz.NEIN = Es besteht kein Vorwurf auf Vorsatz.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Vorsatzvorwurf;
    /**
     * The ArtDesVorwurfs
     * Meta information extracted from the WSDL
     * - documentation: Art des Vorwurfs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDesVorwurfs;
    /**
     * The Vorwurf
     * Meta information extracted from the WSDL
     * - documentation: Erläuterung zum Vorwurf.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vorwurf;
    /**
     * The Verfahrensstadium
     * Meta information extracted from the WSDL
     * - documentation: Stadium des Verfahrens gemäß GDV-Anlage 155.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Verfahrensstadium;
    /**
     * The Klagefaehig
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Rechtsstreit ist klagefähig.NEIN = Der Rechtsstreit ist nicht klagefähig.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Klagefaehig;
    /**
     * The BetroffeneSteuer
     * Meta information extracted from the WSDL
     * - documentation: Betroffene Steuer bei einem Steuerrechtsfall.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $BetroffeneSteuer;
    /**
     * The Gerichtstyp
     * Meta information extracted from the WSDL
     * - documentation: Typ des Gerichts für den Steuerrechtsfall.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gerichtstyp;
    /**
     * The Zuordnung
     * Meta information extracted from the WSDL
     * - documentation: Zuordnung des Schadens zum gewerblichen oder privaten Bereich
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zuordnung;
    /**
     * The Gebuehrengrundlage
     * Meta information extracted from the WSDL
     * - documentation: Grundlage der Gebühren für diesen Rechtsschutzschaden (z.B. RVG2004, RVG2013).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gebuehrengrundlage;
    /**
     * The Rechtsstreitgegner
     * Meta information extracted from the WSDL
     * - documentation: Rechtsstreitgegner des Versicherungsnehmers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Rechtsstreitgegner
     */
    public $Rechtsstreitgegner;
    /**
     * The Schadenhoehe
     * Meta information extracted from the WSDL
     * - documentation: Schadenhöhe des Rechtsschutzschadens. Diese DARF auf allen Ebenen angegeben werden. Es gibt keine Summierungsregel. Normalerweise erfolgt die Angabe auf der größtmöglichen Detailtiefe.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenhoehe[]
     */
    public $Schadenhoehe;
    /**
     * The Veranlagungszeitraum
     * Meta information extracted from the WSDL
     * - documentation: Veranlagungszeitraum bei einem Steuerrechtsfall.Der Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und Ende MÜSSEN mit einem vollständigen Datum definiert sein. Die Angabe einer Zeit oder einer
     * Zeitzone DARF NICHT erfolgen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $Veranlagungszeitraum;
    /**
     * Constructor method for CT_Rechtsschutzschaden
     * @uses CT_Rechtsschutzschaden::setLeistungsartBereich()
     * @uses CT_Rechtsschutzschaden::setLeistungsart()
     * @uses CT_Rechtsschutzschaden::setEigenschaftVN()
     * @uses CT_Rechtsschutzschaden::setAnzahlWohnungen()
     * @uses CT_Rechtsschutzschaden::setBereitsVorGericht()
     * @uses CT_Rechtsschutzschaden::setMitErstberatungAbgeschlossen()
     * @uses CT_Rechtsschutzschaden::setRechtslageaenderung()
     * @uses CT_Rechtsschutzschaden::setVerhaltensbedingteKuendigung()
     * @uses CT_Rechtsschutzschaden::setVorsatzvorwurf()
     * @uses CT_Rechtsschutzschaden::setArtDesVorwurfs()
     * @uses CT_Rechtsschutzschaden::setVorwurf()
     * @uses CT_Rechtsschutzschaden::setVerfahrensstadium()
     * @uses CT_Rechtsschutzschaden::setKlagefaehig()
     * @uses CT_Rechtsschutzschaden::setBetroffeneSteuer()
     * @uses CT_Rechtsschutzschaden::setGerichtstyp()
     * @uses CT_Rechtsschutzschaden::setZuordnung()
     * @uses CT_Rechtsschutzschaden::setGebuehrengrundlage()
     * @uses CT_Rechtsschutzschaden::setRechtsstreitgegner()
     * @uses CT_Rechtsschutzschaden::setSchadenhoehe()
     * @uses CT_Rechtsschutzschaden::setVeranlagungszeitraum()
     * @param string $leistungsartBereich
     * @param \BiPRO\StructType\STE_Leistungsart $leistungsart
     * @param string $eigenschaftVN
     * @param int $anzahlWohnungen
     * @param bool $bereitsVorGericht
     * @param bool $mitErstberatungAbgeschlossen
     * @param bool $rechtslageaenderung
     * @param bool $verhaltensbedingteKuendigung
     * @param bool $vorsatzvorwurf
     * @param string $artDesVorwurfs
     * @param string $vorwurf
     * @param string $verfahrensstadium
     * @param bool $klagefaehig
     * @param string $betroffeneSteuer
     * @param string $gerichtstyp
     * @param string $zuordnung
     * @param string $gebuehrengrundlage
     * @param \BiPRO\StructType\CT_Rechtsstreitgegner $rechtsstreitgegner
     * @param \BiPRO\StructType\CT_Schadenhoehe[] $schadenhoehe
     * @param \BiPRO\StructType\CT_Zeitraum2 $veranlagungszeitraum
     */
    public function __construct($leistungsartBereich = null, \BiPRO\StructType\STE_Leistungsart $leistungsart = null, $eigenschaftVN = null, $anzahlWohnungen = null, $bereitsVorGericht = null, $mitErstberatungAbgeschlossen = null, $rechtslageaenderung = null, $verhaltensbedingteKuendigung = null, $vorsatzvorwurf = null, $artDesVorwurfs = null, $vorwurf = null, $verfahrensstadium = null, $klagefaehig = null, $betroffeneSteuer = null, $gerichtstyp = null, $zuordnung = null, $gebuehrengrundlage = null, \BiPRO\StructType\CT_Rechtsstreitgegner $rechtsstreitgegner = null, array $schadenhoehe = array(), \BiPRO\StructType\CT_Zeitraum2 $veranlagungszeitraum = null)
    {
        $this
            ->setLeistungsartBereich($leistungsartBereich)
            ->setLeistungsart($leistungsart)
            ->setEigenschaftVN($eigenschaftVN)
            ->setAnzahlWohnungen($anzahlWohnungen)
            ->setBereitsVorGericht($bereitsVorGericht)
            ->setMitErstberatungAbgeschlossen($mitErstberatungAbgeschlossen)
            ->setRechtslageaenderung($rechtslageaenderung)
            ->setVerhaltensbedingteKuendigung($verhaltensbedingteKuendigung)
            ->setVorsatzvorwurf($vorsatzvorwurf)
            ->setArtDesVorwurfs($artDesVorwurfs)
            ->setVorwurf($vorwurf)
            ->setVerfahrensstadium($verfahrensstadium)
            ->setKlagefaehig($klagefaehig)
            ->setBetroffeneSteuer($betroffeneSteuer)
            ->setGerichtstyp($gerichtstyp)
            ->setZuordnung($zuordnung)
            ->setGebuehrengrundlage($gebuehrengrundlage)
            ->setRechtsstreitgegner($rechtsstreitgegner)
            ->setSchadenhoehe($schadenhoehe)
            ->setVeranlagungszeitraum($veranlagungszeitraum);
    }
    /**
     * Get LeistungsartBereich value
     * @return string|null
     */
    public function getLeistungsartBereich()
    {
        return $this->LeistungsartBereich;
    }
    /**
     * Set LeistungsartBereich value
     * @uses \BiPRO\EnumType\ST_LeistungsartBereich::valueIsValid()
     * @uses \BiPRO\EnumType\ST_LeistungsartBereich::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $leistungsartBereich
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setLeistungsartBereich($leistungsartBereich = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_LeistungsartBereich::valueIsValid($leistungsartBereich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_LeistungsartBereich', is_array($leistungsartBereich) ? implode(', ', $leistungsartBereich) : var_export($leistungsartBereich, true), implode(', ', \BiPRO\EnumType\ST_LeistungsartBereich::getValidValues())), __LINE__);
        }
        $this->LeistungsartBereich = $leistungsartBereich;
        return $this;
    }
    /**
     * Get Leistungsart value
     * @return \BiPRO\StructType\STE_Leistungsart|null
     */
    public function getLeistungsart()
    {
        return $this->Leistungsart;
    }
    /**
     * Set Leistungsart value
     * @param \BiPRO\StructType\STE_Leistungsart $leistungsart
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setLeistungsart(\BiPRO\StructType\STE_Leistungsart $leistungsart = null)
    {
        $this->Leistungsart = $leistungsart;
        return $this;
    }
    /**
     * Get EigenschaftVN value
     * @return string|null
     */
    public function getEigenschaftVN()
    {
        return $this->EigenschaftVN;
    }
    /**
     * Set EigenschaftVN value
     * @uses \BiPRO\EnumType\ST_EigenschaftVN::valueIsValid()
     * @uses \BiPRO\EnumType\ST_EigenschaftVN::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eigenschaftVN
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setEigenschaftVN($eigenschaftVN = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_EigenschaftVN::valueIsValid($eigenschaftVN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_EigenschaftVN', is_array($eigenschaftVN) ? implode(', ', $eigenschaftVN) : var_export($eigenschaftVN, true), implode(', ', \BiPRO\EnumType\ST_EigenschaftVN::getValidValues())), __LINE__);
        }
        $this->EigenschaftVN = $eigenschaftVN;
        return $this;
    }
    /**
     * Get AnzahlWohnungen value
     * @return int|null
     */
    public function getAnzahlWohnungen()
    {
        return $this->AnzahlWohnungen;
    }
    /**
     * Set AnzahlWohnungen value
     * @param int $anzahlWohnungen
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setAnzahlWohnungen($anzahlWohnungen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlWohnungen) && !(is_int($anzahlWohnungen) || ctype_digit($anzahlWohnungen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlWohnungen, true), gettype($anzahlWohnungen)), __LINE__);
        }
        $this->AnzahlWohnungen = $anzahlWohnungen;
        return $this;
    }
    /**
     * Get BereitsVorGericht value
     * @return bool|null
     */
    public function getBereitsVorGericht()
    {
        return $this->BereitsVorGericht;
    }
    /**
     * Set BereitsVorGericht value
     * @param bool $bereitsVorGericht
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setBereitsVorGericht($bereitsVorGericht = null)
    {
        // validation for constraint: boolean
        if (!is_null($bereitsVorGericht) && !is_bool($bereitsVorGericht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bereitsVorGericht, true), gettype($bereitsVorGericht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($bereitsVorGericht) && !preg_match('/true|false/', $bereitsVorGericht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($bereitsVorGericht, true)), __LINE__);
        }
        $this->BereitsVorGericht = $bereitsVorGericht;
        return $this;
    }
    /**
     * Get MitErstberatungAbgeschlossen value
     * @return bool|null
     */
    public function getMitErstberatungAbgeschlossen()
    {
        return $this->MitErstberatungAbgeschlossen;
    }
    /**
     * Set MitErstberatungAbgeschlossen value
     * @param bool $mitErstberatungAbgeschlossen
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setMitErstberatungAbgeschlossen($mitErstberatungAbgeschlossen = null)
    {
        // validation for constraint: boolean
        if (!is_null($mitErstberatungAbgeschlossen) && !is_bool($mitErstberatungAbgeschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mitErstberatungAbgeschlossen, true), gettype($mitErstberatungAbgeschlossen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($mitErstberatungAbgeschlossen) && !preg_match('/true|false/', $mitErstberatungAbgeschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($mitErstberatungAbgeschlossen, true)), __LINE__);
        }
        $this->MitErstberatungAbgeschlossen = $mitErstberatungAbgeschlossen;
        return $this;
    }
    /**
     * Get Rechtslageaenderung value
     * @return bool|null
     */
    public function getRechtslageaenderung()
    {
        return $this->Rechtslageaenderung;
    }
    /**
     * Set Rechtslageaenderung value
     * @param bool $rechtslageaenderung
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setRechtslageaenderung($rechtslageaenderung = null)
    {
        // validation for constraint: boolean
        if (!is_null($rechtslageaenderung) && !is_bool($rechtslageaenderung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rechtslageaenderung, true), gettype($rechtslageaenderung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($rechtslageaenderung) && !preg_match('/true|false/', $rechtslageaenderung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($rechtslageaenderung, true)), __LINE__);
        }
        $this->Rechtslageaenderung = $rechtslageaenderung;
        return $this;
    }
    /**
     * Get VerhaltensbedingteKuendigung value
     * @return bool|null
     */
    public function getVerhaltensbedingteKuendigung()
    {
        return $this->VerhaltensbedingteKuendigung;
    }
    /**
     * Set VerhaltensbedingteKuendigung value
     * @param bool $verhaltensbedingteKuendigung
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setVerhaltensbedingteKuendigung($verhaltensbedingteKuendigung = null)
    {
        // validation for constraint: boolean
        if (!is_null($verhaltensbedingteKuendigung) && !is_bool($verhaltensbedingteKuendigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verhaltensbedingteKuendigung, true), gettype($verhaltensbedingteKuendigung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($verhaltensbedingteKuendigung) && !preg_match('/true|false/', $verhaltensbedingteKuendigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($verhaltensbedingteKuendigung, true)), __LINE__);
        }
        $this->VerhaltensbedingteKuendigung = $verhaltensbedingteKuendigung;
        return $this;
    }
    /**
     * Get Vorsatzvorwurf value
     * @return bool|null
     */
    public function getVorsatzvorwurf()
    {
        return $this->Vorsatzvorwurf;
    }
    /**
     * Set Vorsatzvorwurf value
     * @param bool $vorsatzvorwurf
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setVorsatzvorwurf($vorsatzvorwurf = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorsatzvorwurf) && !is_bool($vorsatzvorwurf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorsatzvorwurf, true), gettype($vorsatzvorwurf)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorsatzvorwurf) && !preg_match('/true|false/', $vorsatzvorwurf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorsatzvorwurf, true)), __LINE__);
        }
        $this->Vorsatzvorwurf = $vorsatzvorwurf;
        return $this;
    }
    /**
     * Get ArtDesVorwurfs value
     * @return string|null
     */
    public function getArtDesVorwurfs()
    {
        return $this->ArtDesVorwurfs;
    }
    /**
     * Set ArtDesVorwurfs value
     * @uses \BiPRO\EnumType\ST_ArtDesVorwurfs::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDesVorwurfs::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDesVorwurfs
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setArtDesVorwurfs($artDesVorwurfs = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDesVorwurfs::valueIsValid($artDesVorwurfs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDesVorwurfs', is_array($artDesVorwurfs) ? implode(', ', $artDesVorwurfs) : var_export($artDesVorwurfs, true), implode(', ', \BiPRO\EnumType\ST_ArtDesVorwurfs::getValidValues())), __LINE__);
        }
        $this->ArtDesVorwurfs = $artDesVorwurfs;
        return $this;
    }
    /**
     * Get Vorwurf value
     * @return string|null
     */
    public function getVorwurf()
    {
        return $this->Vorwurf;
    }
    /**
     * Set Vorwurf value
     * @param string $vorwurf
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setVorwurf($vorwurf = null)
    {
        // validation for constraint: string
        if (!is_null($vorwurf) && !is_string($vorwurf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorwurf, true), gettype($vorwurf)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($vorwurf) && mb_strlen($vorwurf) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($vorwurf)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorwurf) && mb_strlen($vorwurf) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorwurf)), __LINE__);
        }
        $this->Vorwurf = $vorwurf;
        return $this;
    }
    /**
     * Get Verfahrensstadium value
     * @return string|null
     */
    public function getVerfahrensstadium()
    {
        return $this->Verfahrensstadium;
    }
    /**
     * Set Verfahrensstadium value
     * @uses \BiPRO\EnumType\ST_Verfahrensstadium::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Verfahrensstadium::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verfahrensstadium
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setVerfahrensstadium($verfahrensstadium = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Verfahrensstadium::valueIsValid($verfahrensstadium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Verfahrensstadium', is_array($verfahrensstadium) ? implode(', ', $verfahrensstadium) : var_export($verfahrensstadium, true), implode(', ', \BiPRO\EnumType\ST_Verfahrensstadium::getValidValues())), __LINE__);
        }
        $this->Verfahrensstadium = $verfahrensstadium;
        return $this;
    }
    /**
     * Get Klagefaehig value
     * @return bool|null
     */
    public function getKlagefaehig()
    {
        return $this->Klagefaehig;
    }
    /**
     * Set Klagefaehig value
     * @param bool $klagefaehig
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setKlagefaehig($klagefaehig = null)
    {
        // validation for constraint: boolean
        if (!is_null($klagefaehig) && !is_bool($klagefaehig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klagefaehig, true), gettype($klagefaehig)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($klagefaehig) && !preg_match('/true|false/', $klagefaehig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($klagefaehig, true)), __LINE__);
        }
        $this->Klagefaehig = $klagefaehig;
        return $this;
    }
    /**
     * Get BetroffeneSteuer value
     * @return string|null
     */
    public function getBetroffeneSteuer()
    {
        return $this->BetroffeneSteuer;
    }
    /**
     * Set BetroffeneSteuer value
     * @param string $betroffeneSteuer
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setBetroffeneSteuer($betroffeneSteuer = null)
    {
        // validation for constraint: string
        if (!is_null($betroffeneSteuer) && !is_string($betroffeneSteuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betroffeneSteuer, true), gettype($betroffeneSteuer)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($betroffeneSteuer) && mb_strlen($betroffeneSteuer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($betroffeneSteuer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($betroffeneSteuer) && mb_strlen($betroffeneSteuer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($betroffeneSteuer)), __LINE__);
        }
        $this->BetroffeneSteuer = $betroffeneSteuer;
        return $this;
    }
    /**
     * Get Gerichtstyp value
     * @return string|null
     */
    public function getGerichtstyp()
    {
        return $this->Gerichtstyp;
    }
    /**
     * Set Gerichtstyp value
     * @uses \BiPRO\EnumType\ST_Gerichtstyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Gerichtstyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gerichtstyp
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setGerichtstyp($gerichtstyp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Gerichtstyp::valueIsValid($gerichtstyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Gerichtstyp', is_array($gerichtstyp) ? implode(', ', $gerichtstyp) : var_export($gerichtstyp, true), implode(', ', \BiPRO\EnumType\ST_Gerichtstyp::getValidValues())), __LINE__);
        }
        $this->Gerichtstyp = $gerichtstyp;
        return $this;
    }
    /**
     * Get Zuordnung value
     * @return string|null
     */
    public function getZuordnung()
    {
        return $this->Zuordnung;
    }
    /**
     * Set Zuordnung value
     * @uses \BiPRO\EnumType\ST_GewerblichPrivat::valueIsValid()
     * @uses \BiPRO\EnumType\ST_GewerblichPrivat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zuordnung
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setZuordnung($zuordnung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_GewerblichPrivat::valueIsValid($zuordnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_GewerblichPrivat', is_array($zuordnung) ? implode(', ', $zuordnung) : var_export($zuordnung, true), implode(', ', \BiPRO\EnumType\ST_GewerblichPrivat::getValidValues())), __LINE__);
        }
        $this->Zuordnung = $zuordnung;
        return $this;
    }
    /**
     * Get Gebuehrengrundlage value
     * @return string|null
     */
    public function getGebuehrengrundlage()
    {
        return $this->Gebuehrengrundlage;
    }
    /**
     * Set Gebuehrengrundlage value
     * @uses \BiPRO\EnumType\ST_Gebuehrengrundlage::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Gebuehrengrundlage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gebuehrengrundlage
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setGebuehrengrundlage($gebuehrengrundlage = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Gebuehrengrundlage::valueIsValid($gebuehrengrundlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Gebuehrengrundlage', is_array($gebuehrengrundlage) ? implode(', ', $gebuehrengrundlage) : var_export($gebuehrengrundlage, true), implode(', ', \BiPRO\EnumType\ST_Gebuehrengrundlage::getValidValues())), __LINE__);
        }
        $this->Gebuehrengrundlage = $gebuehrengrundlage;
        return $this;
    }
    /**
     * Get Rechtsstreitgegner value
     * @return \BiPRO\StructType\CT_Rechtsstreitgegner|null
     */
    public function getRechtsstreitgegner()
    {
        return $this->Rechtsstreitgegner;
    }
    /**
     * Set Rechtsstreitgegner value
     * @param \BiPRO\StructType\CT_Rechtsstreitgegner $rechtsstreitgegner
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setRechtsstreitgegner(\BiPRO\StructType\CT_Rechtsstreitgegner $rechtsstreitgegner = null)
    {
        $this->Rechtsstreitgegner = $rechtsstreitgegner;
        return $this;
    }
    /**
     * Get Schadenhoehe value
     * @return \BiPRO\StructType\CT_Schadenhoehe[]|null
     */
    public function getSchadenhoehe()
    {
        return $this->Schadenhoehe;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenhoehe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenhoehe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenhoeheForArrayConstraintsFromSetSchadenhoehe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_RechtsschutzschadenSchadenhoeheItem) {
            // validation for constraint: itemType
            if (!$cT_RechtsschutzschadenSchadenhoeheItem instanceof \BiPRO\StructType\CT_Schadenhoehe) {
                $invalidValues[] = is_object($cT_RechtsschutzschadenSchadenhoeheItem) ? get_class($cT_RechtsschutzschadenSchadenhoeheItem) : sprintf('%s(%s)', gettype($cT_RechtsschutzschadenSchadenhoeheItem), var_export($cT_RechtsschutzschadenSchadenhoeheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schadenhoehe property can only contain items of type \BiPRO\StructType\CT_Schadenhoehe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schadenhoehe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhoehe[] $schadenhoehe
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setSchadenhoehe(array $schadenhoehe = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenhoeheArrayErrorMessage = self::validateSchadenhoeheForArrayConstraintsFromSetSchadenhoehe($schadenhoehe))) {
            throw new \InvalidArgumentException($schadenhoeheArrayErrorMessage, __LINE__);
        }
        $this->Schadenhoehe = $schadenhoehe;
        return $this;
    }
    /**
     * Add item to Schadenhoehe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhoehe $item
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function addToSchadenhoehe(\BiPRO\StructType\CT_Schadenhoehe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Schadenhoehe) {
            throw new \InvalidArgumentException(sprintf('The Schadenhoehe property can only contain items of type \BiPRO\StructType\CT_Schadenhoehe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schadenhoehe[] = $item;
        return $this;
    }
    /**
     * Get Veranlagungszeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getVeranlagungszeitraum()
    {
        return $this->Veranlagungszeitraum;
    }
    /**
     * Set Veranlagungszeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum2 $veranlagungszeitraum
     * @return \BiPRO\StructType\CT_Rechtsschutzschaden
     */
    public function setVeranlagungszeitraum(\BiPRO\StructType\CT_Zeitraum2 $veranlagungszeitraum = null)
    {
        $this->Veranlagungszeitraum = $veranlagungszeitraum;
        return $this;
    }
}
