<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Quelle StructType
 * Meta information extracted from the WSDL
 * - documentation: Partner, der der Ursprung einer Information ist.
 * @subpackage Structs
 */
class CT_Quelle extends CT_Objekt
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Referenz auf einen Partner in der Partnerliste. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PartnerID;
    /**
     * Constructor method for CT_Quelle
     * @uses CT_Quelle::setPartnerID()
     * @param string $partnerID
     */
    public function __construct($partnerID = null)
    {
        $this
            ->setPartnerID($partnerID);
    }
    /**
     * Get PartnerID value
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \BiPRO\StructType\CT_Quelle
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partnerID) && mb_strlen($partnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
}
