<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Pruefsumme StructType
 * Meta information extracted from the WSDL
 * - documentation: Dient der Uebertragung von Pruefsummen zur automatischen Verifikation, dass die angeforderte Datei fehlerfrei uebertragen wurde.
 * @subpackage Structs
 */
class CT_Pruefsumme extends CT_Objekt
{
    /**
     * The Typ
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Typ;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Wert;
    /**
     * Constructor method for CT_Pruefsumme
     * @uses CT_Pruefsumme::setTyp()
     * @uses CT_Pruefsumme::setWert()
     * @param string $typ
     * @param string $wert
     */
    public function __construct($typ = null, $wert = null)
    {
        $this
            ->setTyp($typ)
            ->setWert($wert);
    }
    /**
     * Get Typ value
     * @return string
     */
    public function getTyp()
    {
        return $this->Typ;
    }
    /**
     * Set Typ value
     * @uses \BiPRO\EnumType\ST_Pruefsummetyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Pruefsummetyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typ
     * @return \BiPRO\StructType\CT_Pruefsumme
     */
    public function setTyp($typ = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Pruefsummetyp::valueIsValid($typ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Pruefsummetyp', is_array($typ) ? implode(', ', $typ) : var_export($typ, true), implode(', ', \BiPRO\EnumType\ST_Pruefsummetyp::getValidValues())), __LINE__);
        }
        $this->Typ = $typ;
        return $this;
    }
    /**
     * Get Wert value
     * @return string
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param string $wert
     * @return \BiPRO\StructType\CT_Pruefsumme
     */
    public function setWert($wert = null)
    {
        // validation for constraint: string
        if (!is_null($wert) && !is_string($wert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($wert) && mb_strlen($wert) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($wert)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wert) && mb_strlen($wert) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
}
