<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_ProzessAnfrage StructType
 * Meta information extracted from the WSDL
 * - documentation: Prozess-Objekt. Alle Anfrage-Nachrichten innerhalb der von der BiPRO definierten Prozesse werden von diesem Datentypen abgeleitet.
 * @subpackage Structs
 */
abstract class CT_ProzessAnfrage extends CT_Objekt
{
    /**
     * The BiPROVersion
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}
     * @var string
     */
    public $BiPROVersion;
    /**
     * The ConsumerID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige (providerspezifische) Identifizierung des anfragenden Systems (bzw. des Service Consumers).
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $ConsumerID;
    /**
     * Constructor method for CT_ProzessAnfrage
     * @uses CT_ProzessAnfrage::setBiPROVersion()
     * @uses CT_ProzessAnfrage::setConsumerID()
     * @param string $biPROVersion
     * @param string $consumerID
     */
    public function __construct($biPROVersion = null, $consumerID = null)
    {
        $this
            ->setBiPROVersion($biPROVersion)
            ->setConsumerID($consumerID);
    }
    /**
     * Get BiPROVersion value
     * @return string
     */
    public function getBiPROVersion()
    {
        return $this->BiPROVersion;
    }
    /**
     * Set BiPROVersion value
     * @param string $biPROVersion
     * @return \BiPRO\StructType\CT_ProzessAnfrage
     */
    public function setBiPROVersion($biPROVersion = null)
    {
        // validation for constraint: string
        if (!is_null($biPROVersion) && !is_string($biPROVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($biPROVersion, true), gettype($biPROVersion)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})
        if (!is_null($biPROVersion) && !preg_match('/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}/', $biPROVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}', var_export($biPROVersion, true)), __LINE__);
        }
        $this->BiPROVersion = $biPROVersion;
        return $this;
    }
    /**
     * Get ConsumerID value
     * @return string|null
     */
    public function getConsumerID()
    {
        return $this->ConsumerID;
    }
    /**
     * Set ConsumerID value
     * @param string $consumerID
     * @return \BiPRO\StructType\CT_ProzessAnfrage
     */
    public function setConsumerID($consumerID = null)
    {
        // validation for constraint: string
        if (!is_null($consumerID) && !is_string($consumerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumerID, true), gettype($consumerID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($consumerID) && mb_strlen($consumerID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($consumerID)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($consumerID) && mb_strlen($consumerID) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($consumerID)), __LINE__);
        }
        $this->ConsumerID = $consumerID;
        return $this;
    }
}
