<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Produktbaustein StructType
 * Meta information extracted from the WSDL
 * - documentation: Basisklasse aller Produktbausteine (Verkaufsprodukt, Produkt, Elementarprodukt) gemaess VAA-Modell.Das Attribut Tarifgeneration (ST_Tarifgeneration) fehlt, da der entsprechende einfache Datentyp nicht spezifiziert ist.
 * @subpackage Structs
 */
abstract class CT_Produktbaustein extends CT_Objekt
{
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Eine für Menschen verständliche Bezeichnung des Elementarproduktes, Produktes oder Verkaufsproduktes. Das Attribut Bezeichnung DARF NICHT als Tarifkennung benutzt werden.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The GewuenschteZahlungsweise
     * Meta information extracted from the WSDL
     * - documentation: Gewünschte Zahlungsweise DARF NUR auf der Produktebene genutzt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $GewuenschteZahlungsweise;
    /**
     * The Kurzbeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Natürlichsprachliche Erläuterung des Bausteins. Wird beispielsweise im Response für die Bildschirmausgabe verwendet.
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kurzbeschreibung;
    /**
     * The Bedingungen
     * Meta information extracted from the WSDL
     * - documentation: Bedingungen und Klauseln DÜRFEN NUR in dem für sie vorgesehenen Kontext angegeben werden. So MÜSSEN Bedingungen auf Verkaufsebene im Verkaufsprodukt oder Produkt erscheinen (z.B. VGB2005) und Klauseln zur Deckung am
     * Elementarprodukt (z.B. Fahrradklausel). Das Attribut kann n-fach vorkommen, weil ein Produkt mehrere Bedingungswerke haben kann. Je Attribut wird eine Bedingung inkl. Bedingungsversion (z. B. VHB2005) geschlüsselt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Bedingungen[]
     */
    public $Bedingungen;
    /**
     * The Unternehmen
     * Meta information extracted from the WSDL
     * - documentation: DARF NUR auf Produktebene verwendet werden. Ausnahme bei mehreren Risikoträgern in einem Vertrag: der Hauptrisikoträger MUSS auf Produktebene und ein abweichender Risikoträger MUSS auf Elementarproduktebene angegeben.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $Unternehmen;
    /**
     * The Kondition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kondition[]
     */
    public $Kondition;
    /**
     * The Beitrag
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitrag[]
     */
    public $Beitrag;
    /**
     * The ZusaetzlicheProduktbausteinDaten
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten[]
     */
    public $ZusaetzlicheProduktbausteinDaten;
    /**
     * The Aenderungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Termin, zu dem der Zustand wirksam wird/wurde (Gültig-ab-/Wirksam-ab-Datum). | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Aenderungsdatum;
    /**
     * The Aenderungsgrund
     * Meta information extracted from the WSDL
     * - documentation: Grund der Änderung, die zu dem Zustand geführt hat. | Art des Geschäftsvorgang. Konkrete Werte und deren Bedeutung im Kontext der BiPRO-Normen sind in BiPRO allg. Anlage 1 Gesamtliste GeVo-Arten.xlsx definiert.
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: \d{9}
     * @var string[]
     */
    public $Aenderungsgrund;
    /**
     * The Vertragsform
     * Meta information extracted from the WSDL
     * - documentation: DARF NUR auf den Ebenen Produkt und Elementarprodukt genutzt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vertragsform;
    /**
     * The Abgangsgrund
     * Meta information extracted from the WSDL
     * - documentation: DARF NUR auf den Ebenen Produkt und Elementarprodukt genutzt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Abgangsgrund;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status des Verkaufproduktes, Produktes oder Elementarproduktes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Vertriebsname
     * Meta information extracted from the WSDL
     * - documentation: DARF nur gefüllt werden, wenn der Vertriebsname von Bezeichnung abweicht
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vertriebsname;
    /**
     * The Stichtagswert
     * Meta information extracted from the WSDL
     * - documentation: Beschreibt (im Rahmen von Bestandsprozessen) einen Geldwert, der zu einem bestimmten Zeitpunkt gültig ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Stichtagsbetrag[]
     */
    public $Stichtagswert;
    /**
     * The Beitragszahler
     * Meta information extracted from the WSDL
     * - documentation: Beitragszahler DARF NUR DANN auf den Ebenen Elementarprodukt/Produkt referenziert werden, wenn Produkte oder Elementarprodukte unterschiedliche Beitragszahler haben. Am Verkaufsprodukt DARF diese Referenz NICHT verwendet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beitragszahler
     */
    public $Beitragszahler;
    /**
     * The Versicherungsdauer
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsdauer dieses Produktbausteins.Es MÜSSEN die konkreten Zeitpunkte angegeben werden, sofern dies fachlich möglich ist (Ausnahme: z.B. Ende = Tod der VP o.Ä.). Insbesondere wenn der anzugebende Zeitraum mit der Dauer des
     * übergeordneten Produktbausteins übereinstimmt, MUSS er nochmals explizit angegeben werden.Der Beginn bezeichnet hierbei den<b> Technischen Versicherungsbeginn</b>, also den Zeitpunkt, von dem an die Prämie zu zahlen ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Versicherungsdauer;
    /**
     * The Zertifizierungsdaten
     * Meta information extracted from the WSDL
     * - documentation: Zertifizierungsdaten DÜRFEN NICHT auf Verkaufsproduktebene verwendet werden. Sie MÜSSEN auf der höchstmöglichen Ebene spezifiziert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zertifizierungsdaten
     */
    public $Zertifizierungsdaten;
    /**
     * Constructor method for CT_Produktbaustein
     * @uses CT_Produktbaustein::setBezeichnung()
     * @uses CT_Produktbaustein::setGewuenschteZahlungsweise()
     * @uses CT_Produktbaustein::setKurzbeschreibung()
     * @uses CT_Produktbaustein::setBedingungen()
     * @uses CT_Produktbaustein::setUnternehmen()
     * @uses CT_Produktbaustein::setKondition()
     * @uses CT_Produktbaustein::setBeitrag()
     * @uses CT_Produktbaustein::setZusaetzlicheProduktbausteinDaten()
     * @uses CT_Produktbaustein::setAenderungsdatum()
     * @uses CT_Produktbaustein::setAenderungsgrund()
     * @uses CT_Produktbaustein::setVertragsform()
     * @uses CT_Produktbaustein::setAbgangsgrund()
     * @uses CT_Produktbaustein::setStatus()
     * @uses CT_Produktbaustein::setVertriebsname()
     * @uses CT_Produktbaustein::setStichtagswert()
     * @uses CT_Produktbaustein::setBeitragszahler()
     * @uses CT_Produktbaustein::setVersicherungsdauer()
     * @uses CT_Produktbaustein::setZertifizierungsdaten()
     * @param string $bezeichnung
     * @param string[] $gewuenschteZahlungsweise
     * @param string $kurzbeschreibung
     * @param \BiPRO\StructType\STE_Bedingungen[] $bedingungen
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @param \BiPRO\StructType\CT_Kondition[] $kondition
     * @param \BiPRO\StructType\CT_Beitrag[] $beitrag
     * @param \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten[] $zusaetzlicheProduktbausteinDaten
     * @param string $aenderungsdatum
     * @param string[] $aenderungsgrund
     * @param string $vertragsform
     * @param string $abgangsgrund
     * @param string $status
     * @param string $vertriebsname
     * @param \BiPRO\StructType\CT_Stichtagsbetrag[] $stichtagswert
     * @param \BiPRO\StructType\CT_Beitragszahler $beitragszahler
     * @param \BiPRO\StructType\CT_Zeitraum $versicherungsdauer
     * @param \BiPRO\StructType\CT_Zertifizierungsdaten $zertifizierungsdaten
     */
    public function __construct($bezeichnung = null, array $gewuenschteZahlungsweise = array(), $kurzbeschreibung = null, array $bedingungen = array(), \BiPRO\StructType\CT_Unternehmen $unternehmen = null, array $kondition = array(), array $beitrag = array(), array $zusaetzlicheProduktbausteinDaten = array(), $aenderungsdatum = null, array $aenderungsgrund = array(), $vertragsform = null, $abgangsgrund = null, $status = null, $vertriebsname = null, array $stichtagswert = array(), \BiPRO\StructType\CT_Beitragszahler $beitragszahler = null, \BiPRO\StructType\CT_Zeitraum $versicherungsdauer = null, \BiPRO\StructType\CT_Zertifizierungsdaten $zertifizierungsdaten = null)
    {
        $this
            ->setBezeichnung($bezeichnung)
            ->setGewuenschteZahlungsweise($gewuenschteZahlungsweise)
            ->setKurzbeschreibung($kurzbeschreibung)
            ->setBedingungen($bedingungen)
            ->setUnternehmen($unternehmen)
            ->setKondition($kondition)
            ->setBeitrag($beitrag)
            ->setZusaetzlicheProduktbausteinDaten($zusaetzlicheProduktbausteinDaten)
            ->setAenderungsdatum($aenderungsdatum)
            ->setAenderungsgrund($aenderungsgrund)
            ->setVertragsform($vertragsform)
            ->setAbgangsgrund($abgangsgrund)
            ->setStatus($status)
            ->setVertriebsname($vertriebsname)
            ->setStichtagswert($stichtagswert)
            ->setBeitragszahler($beitragszahler)
            ->setVersicherungsdauer($versicherungsdauer)
            ->setZertifizierungsdaten($zertifizierungsdaten);
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get GewuenschteZahlungsweise value
     * @return string[]|null
     */
    public function getGewuenschteZahlungsweise()
    {
        return $this->GewuenschteZahlungsweise;
    }
    /**
     * This method is responsible for validating the values passed to the setGewuenschteZahlungsweise method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGewuenschteZahlungsweise method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGewuenschteZahlungsweiseForArrayConstraintsFromSetGewuenschteZahlungsweise(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktbausteinGewuenschteZahlungsweiseItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($cT_ProduktbausteinGewuenschteZahlungsweiseItem)) {
                $invalidValues[] = is_object($cT_ProduktbausteinGewuenschteZahlungsweiseItem) ? get_class($cT_ProduktbausteinGewuenschteZahlungsweiseItem) : sprintf('%s(%s)', gettype($cT_ProduktbausteinGewuenschteZahlungsweiseItem), var_export($cT_ProduktbausteinGewuenschteZahlungsweiseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GewuenschteZahlungsweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $gewuenschteZahlungsweise
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setGewuenschteZahlungsweise(array $gewuenschteZahlungsweise = array())
    {
        // validation for constraint: array
        if ('' !== ($gewuenschteZahlungsweiseArrayErrorMessage = self::validateGewuenschteZahlungsweiseForArrayConstraintsFromSetGewuenschteZahlungsweise($gewuenschteZahlungsweise))) {
            throw new \InvalidArgumentException($gewuenschteZahlungsweiseArrayErrorMessage, __LINE__);
        }
        $this->GewuenschteZahlungsweise = $gewuenschteZahlungsweise;
        return $this;
    }
    /**
     * Add item to GewuenschteZahlungsweise value
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsweise::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function addToGewuenschteZahlungsweise($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsweise::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsweise', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsweise::getValidValues())), __LINE__);
        }
        $this->GewuenschteZahlungsweise[] = $item;
        return $this;
    }
    /**
     * Get Kurzbeschreibung value
     * @return string|null
     */
    public function getKurzbeschreibung()
    {
        return $this->Kurzbeschreibung;
    }
    /**
     * Set Kurzbeschreibung value
     * @param string $kurzbeschreibung
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setKurzbeschreibung($kurzbeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($kurzbeschreibung) && !is_string($kurzbeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kurzbeschreibung, true), gettype($kurzbeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($kurzbeschreibung) && mb_strlen($kurzbeschreibung) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($kurzbeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kurzbeschreibung) && mb_strlen($kurzbeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kurzbeschreibung)), __LINE__);
        }
        $this->Kurzbeschreibung = $kurzbeschreibung;
        return $this;
    }
    /**
     * Get Bedingungen value
     * @return \BiPRO\StructType\STE_Bedingungen[]|null
     */
    public function getBedingungen()
    {
        return $this->Bedingungen;
    }
    /**
     * This method is responsible for validating the values passed to the setBedingungen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedingungen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedingungenForArrayConstraintsFromSetBedingungen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktbausteinBedingungenItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktbausteinBedingungenItem instanceof \BiPRO\StructType\STE_Bedingungen) {
                $invalidValues[] = is_object($cT_ProduktbausteinBedingungenItem) ? get_class($cT_ProduktbausteinBedingungenItem) : sprintf('%s(%s)', gettype($cT_ProduktbausteinBedingungenItem), var_export($cT_ProduktbausteinBedingungenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bedingungen property can only contain items of type \BiPRO\StructType\STE_Bedingungen, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bedingungen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\STE_Bedingungen[] $bedingungen
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setBedingungen(array $bedingungen = array())
    {
        // validation for constraint: array
        if ('' !== ($bedingungenArrayErrorMessage = self::validateBedingungenForArrayConstraintsFromSetBedingungen($bedingungen))) {
            throw new \InvalidArgumentException($bedingungenArrayErrorMessage, __LINE__);
        }
        $this->Bedingungen = $bedingungen;
        return $this;
    }
    /**
     * Add item to Bedingungen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\STE_Bedingungen $item
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function addToBedingungen(\BiPRO\StructType\STE_Bedingungen $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\STE_Bedingungen) {
            throw new \InvalidArgumentException(sprintf('The Bedingungen property can only contain items of type \BiPRO\StructType\STE_Bedingungen, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bedingungen[] = $item;
        return $this;
    }
    /**
     * Get Unternehmen value
     * @return \BiPRO\StructType\CT_Unternehmen|null
     */
    public function getUnternehmen()
    {
        return $this->Unternehmen;
    }
    /**
     * Set Unternehmen value
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setUnternehmen(\BiPRO\StructType\CT_Unternehmen $unternehmen = null)
    {
        $this->Unternehmen = $unternehmen;
        return $this;
    }
    /**
     * Get Kondition value
     * @return \BiPRO\StructType\CT_Kondition[]|null
     */
    public function getKondition()
    {
        return $this->Kondition;
    }
    /**
     * This method is responsible for validating the values passed to the setKondition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKondition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKonditionForArrayConstraintsFromSetKondition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktbausteinKonditionItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktbausteinKonditionItem instanceof \BiPRO\StructType\CT_Kondition) {
                $invalidValues[] = is_object($cT_ProduktbausteinKonditionItem) ? get_class($cT_ProduktbausteinKonditionItem) : sprintf('%s(%s)', gettype($cT_ProduktbausteinKonditionItem), var_export($cT_ProduktbausteinKonditionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kondition property can only contain items of type \BiPRO\StructType\CT_Kondition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kondition value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kondition[] $kondition
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setKondition(array $kondition = array())
    {
        // validation for constraint: array
        if ('' !== ($konditionArrayErrorMessage = self::validateKonditionForArrayConstraintsFromSetKondition($kondition))) {
            throw new \InvalidArgumentException($konditionArrayErrorMessage, __LINE__);
        }
        $this->Kondition = $kondition;
        return $this;
    }
    /**
     * Add item to Kondition value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kondition $item
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function addToKondition(\BiPRO\StructType\CT_Kondition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Kondition) {
            throw new \InvalidArgumentException(sprintf('The Kondition property can only contain items of type \BiPRO\StructType\CT_Kondition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Kondition[] = $item;
        return $this;
    }
    /**
     * Get Beitrag value
     * @return \BiPRO\StructType\CT_Beitrag[]|null
     */
    public function getBeitrag()
    {
        return $this->Beitrag;
    }
    /**
     * This method is responsible for validating the values passed to the setBeitrag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeitrag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeitragForArrayConstraintsFromSetBeitrag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktbausteinBeitragItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktbausteinBeitragItem instanceof \BiPRO\StructType\CT_Beitrag) {
                $invalidValues[] = is_object($cT_ProduktbausteinBeitragItem) ? get_class($cT_ProduktbausteinBeitragItem) : sprintf('%s(%s)', gettype($cT_ProduktbausteinBeitragItem), var_export($cT_ProduktbausteinBeitragItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Beitrag property can only contain items of type \BiPRO\StructType\CT_Beitrag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Beitrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Beitrag[] $beitrag
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setBeitrag(array $beitrag = array())
    {
        // validation for constraint: array
        if ('' !== ($beitragArrayErrorMessage = self::validateBeitragForArrayConstraintsFromSetBeitrag($beitrag))) {
            throw new \InvalidArgumentException($beitragArrayErrorMessage, __LINE__);
        }
        $this->Beitrag = $beitrag;
        return $this;
    }
    /**
     * Add item to Beitrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Beitrag $item
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function addToBeitrag(\BiPRO\StructType\CT_Beitrag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Beitrag) {
            throw new \InvalidArgumentException(sprintf('The Beitrag property can only contain items of type \BiPRO\StructType\CT_Beitrag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Beitrag[] = $item;
        return $this;
    }
    /**
     * Get ZusaetzlicheProduktbausteinDaten value
     * @return \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten[]|null
     */
    public function getZusaetzlicheProduktbausteinDaten()
    {
        return $this->ZusaetzlicheProduktbausteinDaten;
    }
    /**
     * This method is responsible for validating the values passed to the setZusaetzlicheProduktbausteinDaten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusaetzlicheProduktbausteinDaten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusaetzlicheProduktbausteinDatenForArrayConstraintsFromSetZusaetzlicheProduktbausteinDaten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktbausteinZusaetzlicheProduktbausteinDatenItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktbausteinZusaetzlicheProduktbausteinDatenItem instanceof \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten) {
                $invalidValues[] = is_object($cT_ProduktbausteinZusaetzlicheProduktbausteinDatenItem) ? get_class($cT_ProduktbausteinZusaetzlicheProduktbausteinDatenItem) : sprintf('%s(%s)', gettype($cT_ProduktbausteinZusaetzlicheProduktbausteinDatenItem), var_export($cT_ProduktbausteinZusaetzlicheProduktbausteinDatenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZusaetzlicheProduktbausteinDaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZusaetzlicheProduktbausteinDaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten[] $zusaetzlicheProduktbausteinDaten
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setZusaetzlicheProduktbausteinDaten(array $zusaetzlicheProduktbausteinDaten = array())
    {
        // validation for constraint: array
        if ('' !== ($zusaetzlicheProduktbausteinDatenArrayErrorMessage = self::validateZusaetzlicheProduktbausteinDatenForArrayConstraintsFromSetZusaetzlicheProduktbausteinDaten($zusaetzlicheProduktbausteinDaten))) {
            throw new \InvalidArgumentException($zusaetzlicheProduktbausteinDatenArrayErrorMessage, __LINE__);
        }
        $this->ZusaetzlicheProduktbausteinDaten = $zusaetzlicheProduktbausteinDaten;
        return $this;
    }
    /**
     * Add item to ZusaetzlicheProduktbausteinDaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten $item
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function addToZusaetzlicheProduktbausteinDaten(\BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten) {
            throw new \InvalidArgumentException(sprintf('The ZusaetzlicheProduktbausteinDaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheProduktbausteinDaten, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZusaetzlicheProduktbausteinDaten[] = $item;
        return $this;
    }
    /**
     * Get Aenderungsdatum value
     * @return string|null
     */
    public function getAenderungsdatum()
    {
        return $this->Aenderungsdatum;
    }
    /**
     * Set Aenderungsdatum value
     * @param string $aenderungsdatum
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setAenderungsdatum($aenderungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($aenderungsdatum) && !is_string($aenderungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aenderungsdatum, true), gettype($aenderungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($aenderungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $aenderungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($aenderungsdatum, true)), __LINE__);
        }
        $this->Aenderungsdatum = $aenderungsdatum;
        return $this;
    }
    /**
     * Get Aenderungsgrund value
     * @return string[]|null
     */
    public function getAenderungsgrund()
    {
        return $this->Aenderungsgrund;
    }
    /**
     * This method is responsible for validating the values passed to the setAenderungsgrund method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAenderungsgrund method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAenderungsgrundForArrayConstraintsFromSetAenderungsgrund(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktbausteinAenderungsgrundItem) {
            // validation for constraint: itemType
            if (!is_string($cT_ProduktbausteinAenderungsgrundItem)) {
                $invalidValues[] = is_object($cT_ProduktbausteinAenderungsgrundItem) ? get_class($cT_ProduktbausteinAenderungsgrundItem) : sprintf('%s(%s)', gettype($cT_ProduktbausteinAenderungsgrundItem), var_export($cT_ProduktbausteinAenderungsgrundItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Aenderungsgrund property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Aenderungsgrund value
     * @throws \InvalidArgumentException
     * @param string[] $aenderungsgrund
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setAenderungsgrund(array $aenderungsgrund = array())
    {
        // validation for constraint: array
        if ('' !== ($aenderungsgrundArrayErrorMessage = self::validateAenderungsgrundForArrayConstraintsFromSetAenderungsgrund($aenderungsgrund))) {
            throw new \InvalidArgumentException($aenderungsgrundArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\d{9})
        if (!is_null($aenderungsgrund) && !preg_match('/\\d{9}/', $aenderungsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}', var_export($aenderungsgrund, true)), __LINE__);
        }
        $this->Aenderungsgrund = $aenderungsgrund;
        return $this;
    }
    /**
     * Add item to Aenderungsgrund value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function addToAenderungsgrund($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Aenderungsgrund property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: pattern(\d{9})
        if (!preg_match('/\\d{9}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}', var_export($item, true)), __LINE__);
        }
        $this->Aenderungsgrund[] = $item;
        return $this;
    }
    /**
     * Get Vertragsform value
     * @return string|null
     */
    public function getVertragsform()
    {
        return $this->Vertragsform;
    }
    /**
     * Set Vertragsform value
     * @uses \BiPRO\EnumType\ST_Vertragsform::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vertragsform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vertragsform
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setVertragsform($vertragsform = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vertragsform::valueIsValid($vertragsform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vertragsform', is_array($vertragsform) ? implode(', ', $vertragsform) : var_export($vertragsform, true), implode(', ', \BiPRO\EnumType\ST_Vertragsform::getValidValues())), __LINE__);
        }
        $this->Vertragsform = $vertragsform;
        return $this;
    }
    /**
     * Get Abgangsgrund value
     * @return string|null
     */
    public function getAbgangsgrund()
    {
        return $this->Abgangsgrund;
    }
    /**
     * Set Abgangsgrund value
     * @uses \BiPRO\EnumType\ST_Abgangsgrund::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Abgangsgrund::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abgangsgrund
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setAbgangsgrund($abgangsgrund = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Abgangsgrund::valueIsValid($abgangsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Abgangsgrund', is_array($abgangsgrund) ? implode(', ', $abgangsgrund) : var_export($abgangsgrund, true), implode(', ', \BiPRO\EnumType\ST_Abgangsgrund::getValidValues())), __LINE__);
        }
        $this->Abgangsgrund = $abgangsgrund;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \BiPRO\EnumType\ST_Vertragsstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vertragsstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vertragsstatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vertragsstatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \BiPRO\EnumType\ST_Vertragsstatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Vertriebsname value
     * @return string|null
     */
    public function getVertriebsname()
    {
        return $this->Vertriebsname;
    }
    /**
     * Set Vertriebsname value
     * @param string $vertriebsname
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setVertriebsname($vertriebsname = null)
    {
        // validation for constraint: string
        if (!is_null($vertriebsname) && !is_string($vertriebsname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vertriebsname, true), gettype($vertriebsname)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($vertriebsname) && mb_strlen($vertriebsname) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($vertriebsname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vertriebsname) && mb_strlen($vertriebsname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vertriebsname)), __LINE__);
        }
        $this->Vertriebsname = $vertriebsname;
        return $this;
    }
    /**
     * Get Stichtagswert value
     * @return \BiPRO\StructType\CT_Stichtagsbetrag[]|null
     */
    public function getStichtagswert()
    {
        return $this->Stichtagswert;
    }
    /**
     * This method is responsible for validating the values passed to the setStichtagswert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStichtagswert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStichtagswertForArrayConstraintsFromSetStichtagswert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_ProduktbausteinStichtagswertItem) {
            // validation for constraint: itemType
            if (!$cT_ProduktbausteinStichtagswertItem instanceof \BiPRO\StructType\CT_Stichtagsbetrag) {
                $invalidValues[] = is_object($cT_ProduktbausteinStichtagswertItem) ? get_class($cT_ProduktbausteinStichtagswertItem) : sprintf('%s(%s)', gettype($cT_ProduktbausteinStichtagswertItem), var_export($cT_ProduktbausteinStichtagswertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Stichtagswert property can only contain items of type \BiPRO\StructType\CT_Stichtagsbetrag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Stichtagswert value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Stichtagsbetrag[] $stichtagswert
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setStichtagswert(array $stichtagswert = array())
    {
        // validation for constraint: array
        if ('' !== ($stichtagswertArrayErrorMessage = self::validateStichtagswertForArrayConstraintsFromSetStichtagswert($stichtagswert))) {
            throw new \InvalidArgumentException($stichtagswertArrayErrorMessage, __LINE__);
        }
        $this->Stichtagswert = $stichtagswert;
        return $this;
    }
    /**
     * Add item to Stichtagswert value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Stichtagsbetrag $item
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function addToStichtagswert(\BiPRO\StructType\CT_Stichtagsbetrag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Stichtagsbetrag) {
            throw new \InvalidArgumentException(sprintf('The Stichtagswert property can only contain items of type \BiPRO\StructType\CT_Stichtagsbetrag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Stichtagswert[] = $item;
        return $this;
    }
    /**
     * Get Beitragszahler value
     * @return \BiPRO\StructType\CT_Beitragszahler|null
     */
    public function getBeitragszahler()
    {
        return $this->Beitragszahler;
    }
    /**
     * Set Beitragszahler value
     * @param \BiPRO\StructType\CT_Beitragszahler $beitragszahler
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setBeitragszahler(\BiPRO\StructType\CT_Beitragszahler $beitragszahler = null)
    {
        $this->Beitragszahler = $beitragszahler;
        return $this;
    }
    /**
     * Get Versicherungsdauer value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getVersicherungsdauer()
    {
        return $this->Versicherungsdauer;
    }
    /**
     * Set Versicherungsdauer value
     * @param \BiPRO\StructType\CT_Zeitraum $versicherungsdauer
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setVersicherungsdauer(\BiPRO\StructType\CT_Zeitraum $versicherungsdauer = null)
    {
        $this->Versicherungsdauer = $versicherungsdauer;
        return $this;
    }
    /**
     * Get Zertifizierungsdaten value
     * @return \BiPRO\StructType\CT_Zertifizierungsdaten|null
     */
    public function getZertifizierungsdaten()
    {
        return $this->Zertifizierungsdaten;
    }
    /**
     * Set Zertifizierungsdaten value
     * @param \BiPRO\StructType\CT_Zertifizierungsdaten $zertifizierungsdaten
     * @return \BiPRO\StructType\CT_Produktbaustein
     */
    public function setZertifizierungsdaten(\BiPRO\StructType\CT_Zertifizierungsdaten $zertifizierungsdaten = null)
    {
        $this->Zertifizierungsdaten = $zertifizierungsdaten;
        return $this;
    }
}
